/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.enumerable;

import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.config.Lex;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.rel.rules.FilterCorrelateRule;
import org.apache.calcite.rel.rules.JoinToCorrelateRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.JdbcTest;
import org.junit.Test;

public class EnumerableCorrelateTest {
    @Test
    public void leftOuterJoinCorrelate() {
        this.tester(false, new JdbcTest.HrSchema()).query("select e.empid, e.name, d.name as dept from emps e left outer join depts d on e.deptno=d.deptno").withHook(Hook.PLANNER, planner -> {
            planner.addRule((RelOptRule)JoinToCorrelateRule.INSTANCE);
            planner.removeRule(EnumerableRules.ENUMERABLE_JOIN_RULE);
        }).explainContains("EnumerableCalc(expr#0..4=[{inputs}], empid=[$t0], name=[$t2], dept=[$t4])\n  EnumerableCorrelate(correlation=[$cor0], joinType=[left], requiredColumns=[{1}])\n    EnumerableCalc(expr#0..4=[{inputs}], proj#0..2=[{exprs}])\n      EnumerableTableScan(table=[[s, emps]])\n    EnumerableCalc(expr#0..3=[{inputs}], expr#4=[$cor0], expr#5=[$t4.deptno], expr#6=[=($t5, $t0)], proj#0..1=[{exprs}], $condition=[$t6])\n      EnumerableTableScan(table=[[s, depts]])").returnsUnordered("empid=100; name=Bill; dept=Sales", "empid=110; name=Theodore; dept=Sales", "empid=150; name=Sebastian; dept=Sales", "empid=200; name=Eric; dept=null");
    }

    @Test
    public void simpleCorrelateDecorrelated() {
        this.tester(true, new JdbcTest.HrSchema()).query("select empid, name from emps e where exists (select 1 from depts d where d.deptno=e.deptno)").explainContains("EnumerableCalc(expr#0..2=[{inputs}], empid=[$t0], name=[$t2])\n  EnumerableHashJoin(condition=[=($1, $3)], joinType=[semi])\n    EnumerableCalc(expr#0..4=[{inputs}], proj#0..2=[{exprs}])\n      EnumerableTableScan(table=[[s, emps]])\n    EnumerableTableScan(table=[[s, depts]])").returnsUnordered("empid=100; name=Bill", "empid=110; name=Theodore", "empid=150; name=Sebastian");
    }

    @Test
    public void semiJoinCorrelate() {
        this.tester(false, new JdbcTest.HrSchema()).query("select empid, name from emps e where e.deptno in (select d.deptno from depts d)").withHook(Hook.PLANNER, planner -> {
            planner.addRule((RelOptRule)JoinToCorrelateRule.INSTANCE);
            planner.removeRule(EnumerableRules.ENUMERABLE_JOIN_RULE);
        }).explainContains("EnumerableCalc(expr#0..3=[{inputs}], empid=[$t1], name=[$t3])\n  EnumerableCorrelate(correlation=[$cor2], joinType=[inner], requiredColumns=[{0}])\n    EnumerableAggregate(group=[{0}])\n      EnumerableTableScan(table=[[s, depts]])\n    EnumerableCalc(expr#0..4=[{inputs}], expr#5=[$cor2], expr#6=[$t5.deptno], expr#7=[=($t1, $t6)], proj#0..2=[{exprs}], $condition=[$t7])\n      EnumerableTableScan(table=[[s, emps]])").returnsUnordered("empid=100; name=Bill", "empid=110; name=Theodore", "empid=150; name=Sebastian");
    }

    @Test
    public void semiJoinCorrelateWithFilterCorrelateRule() {
        this.tester(false, new JdbcTest.HrSchema()).query("select empid, name from emps e where e.deptno in (select d.deptno from depts d) and e.empid > 100").withHook(Hook.PLANNER, planner -> {
            planner.addRule((RelOptRule)JoinToCorrelateRule.INSTANCE);
            planner.addRule((RelOptRule)FilterCorrelateRule.INSTANCE);
            planner.removeRule(EnumerableRules.ENUMERABLE_JOIN_RULE);
        }).explainContains("EnumerableCalc(expr#0..3=[{inputs}], empid=[$t1], name=[$t3])\n  EnumerableCorrelate(correlation=[$cor5], joinType=[inner], requiredColumns=[{0}])\n    EnumerableAggregate(group=[{0}])\n      EnumerableTableScan(table=[[s, depts]])\n    EnumerableCalc(expr#0..4=[{inputs}], expr#5=[100], expr#6=[>($t0, $t5)], expr#7=[$cor5], expr#8=[$t7.deptno], expr#9=[=($t1, $t8)], expr#10=[AND($t6, $t9)], proj#0..2=[{exprs}], $condition=[$t10])\n      EnumerableTableScan(table=[[s, emps]])").returnsUnordered("empid=110; name=Theodore", "empid=150; name=Sebastian");
    }

    @Test
    public void simpleCorrelate() {
        this.tester(false, new JdbcTest.HrSchema()).query("select empid, name from emps e where exists (select 1 from depts d where d.deptno=e.deptno)").explainContains("EnumerableCalc(expr#0..3=[{inputs}], empid=[$t0], name=[$t2])\n  EnumerableCorrelate(correlation=[$cor0], joinType=[inner], requiredColumns=[{1}])\n    EnumerableCalc(expr#0..4=[{inputs}], proj#0..2=[{exprs}])\n      EnumerableTableScan(table=[[s, emps]])\n    EnumerableAggregate(group=[{0}])\n      EnumerableCalc(expr#0..3=[{inputs}], expr#4=[true], expr#5=[$cor0], expr#6=[$t5.deptno], expr#7=[=($t0, $t6)], i=[$t4], $condition=[$t7])\n        EnumerableTableScan(table=[[s, depts]])").returnsUnordered("empid=100; name=Bill", "empid=110; name=Theodore", "empid=150; name=Sebastian");
    }

    @Test
    public void simpleCorrelateWithConditionIncludingBoxedPrimitive() {
        String sql = "select empid from emps e where not exists (\n  select 1 from depts d where d.deptno=e.commission)";
        this.tester(false, new JdbcTest.HrSchema()).query("select empid from emps e where not exists (\n  select 1 from depts d where d.deptno=e.commission)").returnsUnordered("empid=100", "empid=110", "empid=150", "empid=200");
    }

    @Test
    public void antiJoinCorrelate() {
        this.tester(false, new JdbcTest.HrSchema()).query("?").withHook(Hook.PLANNER, planner -> {
            planner.addRule((RelOptRule)JoinToCorrelateRule.INSTANCE);
            planner.removeRule(EnumerableRules.ENUMERABLE_JOIN_RULE);
        }).withRel(builder -> builder.scan(new String[]{"s", "depts"}).as("d").scan(new String[]{"s", "emps"}).as("e").antiJoin(new RexNode[]{builder.equals(builder.field(2, "d", "deptno"), builder.field(2, "e", "deptno"))}).project(new RexNode[]{builder.field("deptno"), builder.field("name")}).build()).returnsUnordered("deptno=30; name=Marketing", "deptno=40; name=HR");
    }

    @Test
    public void nonEquiAntiJoinCorrelate() {
        this.tester(false, new JdbcTest.HrSchema()).query("?").withHook(Hook.PLANNER, planner -> {
            planner.addRule((RelOptRule)JoinToCorrelateRule.INSTANCE);
            planner.removeRule(EnumerableRules.ENUMERABLE_JOIN_RULE);
        }).withRel(builder -> builder.scan(new String[]{"s", "emps"}).as("e").scan(new String[]{"s", "emps"}).as("e2").antiJoin(new RexNode[]{builder.and(new RexNode[]{builder.equals(builder.field(2, "e", "deptno"), builder.field(2, "e2", "deptno")), builder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{builder.field(2, "e2", "salary"), builder.field(2, "e", "salary")})})}).project(new RexNode[]{builder.field("name"), builder.field("salary")}).build()).returnsUnordered("name=Theodore; salary=11500.0", "name=Eric; salary=8000.0");
    }

    @Test
    public void antiJoinCorrelateWithNullValues() {
        Integer salesDeptNo = 10;
        this.tester(false, new JdbcTest.HrSchema()).query("?").withHook(Hook.PLANNER, planner -> {
            planner.addRule((RelOptRule)JoinToCorrelateRule.INSTANCE);
            planner.removeRule(EnumerableRules.ENUMERABLE_JOIN_RULE);
        }).withRel(builder -> builder.scan(new String[]{"s", "emps"}).as("empOther").filter(new RexNode[]{builder.notEquals(builder.field("empOther", "deptno"), builder.literal((Object)salesDeptNo))}).scan(new String[]{"s", "emps"}).as("empSales").filter(new RexNode[]{builder.equals(builder.field("empSales", "deptno"), builder.literal((Object)salesDeptNo))}).antiJoin(new RexNode[]{builder.equals(builder.field(2, "empOther", "commission"), builder.field(2, "empSales", "commission"))}).project(new RexNode[]{builder.field("empid"), builder.field("name")}).build()).returnsUnordered("empid=200; name=Eric");
    }

    private CalciteAssert.AssertThat tester(boolean forceDecorrelate, Object schema) {
        return CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.LEX, (Object)Lex.JAVA).with((ConnectionProperty)CalciteConnectionProperty.FORCE_DECORRELATE, (Object)forceDecorrelate).withSchema("s", (Schema)new ReflectiveSchema(schema));
    }
}

