/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.catalog;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.ObjectSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql2rel.InitializerExpressionFactory;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.calcite.test.catalog.CompoundNameColumn;
import org.apache.calcite.test.catalog.CompoundNameColumnResolver;
import org.apache.calcite.test.catalog.CountingFactory;
import org.apache.calcite.test.catalog.EmpInitializerExpressionFactory;
import org.apache.calcite.test.catalog.Fixture;
import org.apache.calcite.test.catalog.MockCatalogReader;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Util;

public class MockCatalogReaderSimple
extends MockCatalogReader {
    private final Fixture fixture;

    public MockCatalogReaderSimple(RelDataTypeFactory typeFactory, boolean caseSensitive) {
        super(typeFactory, caseSensitive);
        this.fixture = new Fixture(typeFactory);
    }

    public RelDataType getNamedType(SqlIdentifier typeName) {
        if (typeName.equalsDeep((SqlNode)this.fixture.addressType.getSqlIdentifier(), Litmus.IGNORE)) {
            return this.fixture.addressType;
        }
        return super.getNamedType(typeName);
    }

    @Override
    public MockCatalogReader init() {
        ObjectSqlType addressType = this.fixture.addressType;
        MockCatalogReader.MockSchema salesSchema = new MockCatalogReader.MockSchema("SALES");
        this.registerSchema(salesSchema);
        CountingFactory countingInitializerExpressionFactory = new CountingFactory((List<String>)ImmutableList.of((Object)"DEPTNO"));
        this.registerType((List<String>)ImmutableList.of((Object)salesSchema.getCatalogName(), (Object)salesSchema.getName(), (Object)"customBigInt"), typeFactory -> typeFactory.createSqlType(SqlTypeName.BIGINT));
        MockCatalogReader.MockTable empTable = MockCatalogReader.MockTable.create(this, salesSchema, "EMP", false, 14.0, null, (InitializerExpressionFactory)countingInitializerExpressionFactory, false);
        empTable.addColumn("EMPNO", this.fixture.intType, true);
        empTable.addColumn("ENAME", this.fixture.varchar20Type);
        empTable.addColumn("JOB", this.fixture.varchar10Type);
        empTable.addColumn("MGR", this.fixture.intTypeNull);
        empTable.addColumn("HIREDATE", this.fixture.timestampType);
        empTable.addColumn("SAL", this.fixture.intType);
        empTable.addColumn("COMM", this.fixture.intType);
        empTable.addColumn("DEPTNO", this.fixture.intType);
        empTable.addColumn("SLACKER", this.fixture.booleanType);
        this.registerTable(empTable);
        MockCatalogReader.MockTable empNullablesTable = MockCatalogReader.MockTable.create(this, salesSchema, "EMPNULLABLES", false, 14.0);
        empNullablesTable.addColumn("EMPNO", this.fixture.intType, true);
        empNullablesTable.addColumn("ENAME", this.fixture.varchar20Type);
        empNullablesTable.addColumn("JOB", this.fixture.varchar10TypeNull);
        empNullablesTable.addColumn("MGR", this.fixture.intTypeNull);
        empNullablesTable.addColumn("HIREDATE", this.fixture.timestampTypeNull);
        empNullablesTable.addColumn("SAL", this.fixture.intTypeNull);
        empNullablesTable.addColumn("COMM", this.fixture.intTypeNull);
        empNullablesTable.addColumn("DEPTNO", this.fixture.intTypeNull);
        empNullablesTable.addColumn("SLACKER", this.fixture.booleanTypeNull);
        this.registerTable(empNullablesTable);
        MockCatalogReader.MockTable empDefaultsTable = MockCatalogReader.MockTable.create(this, salesSchema, "EMPDEFAULTS", false, 14.0, null, (InitializerExpressionFactory)new EmpInitializerExpressionFactory(), false);
        empDefaultsTable.addColumn("EMPNO", this.fixture.intType, true);
        empDefaultsTable.addColumn("ENAME", this.fixture.varchar20Type);
        empDefaultsTable.addColumn("JOB", this.fixture.varchar10TypeNull);
        empDefaultsTable.addColumn("MGR", this.fixture.intTypeNull);
        empDefaultsTable.addColumn("HIREDATE", this.fixture.timestampTypeNull);
        empDefaultsTable.addColumn("SAL", this.fixture.intTypeNull);
        empDefaultsTable.addColumn("COMM", this.fixture.intTypeNull);
        empDefaultsTable.addColumn("DEPTNO", this.fixture.intTypeNull);
        empDefaultsTable.addColumn("SLACKER", this.fixture.booleanTypeNull);
        this.registerTable(empDefaultsTable);
        MockCatalogReader.MockTable empBTable = MockCatalogReader.MockTable.create(this, salesSchema, "EMP_B", false, 14.0);
        empBTable.addColumn("EMPNO", this.fixture.intType, true);
        empBTable.addColumn("ENAME", this.fixture.varchar20Type);
        empBTable.addColumn("JOB", this.fixture.varchar10Type);
        empBTable.addColumn("MGR", this.fixture.intTypeNull);
        empBTable.addColumn("HIREDATE", this.fixture.timestampType);
        empBTable.addColumn("SAL", this.fixture.intType);
        empBTable.addColumn("COMM", this.fixture.intType);
        empBTable.addColumn("DEPTNO", this.fixture.intType);
        empBTable.addColumn("SLACKER", this.fixture.booleanType);
        empBTable.addColumn("BIRTHDATE", this.fixture.dateType);
        this.registerTable(empBTable);
        MockCatalogReader.MockTable deptTable = MockCatalogReader.MockTable.create(this, salesSchema, "DEPT", false, 4.0);
        deptTable.addColumn("DEPTNO", this.fixture.intType, true);
        deptTable.addColumn("NAME", this.fixture.varchar10Type);
        this.registerTable(deptTable);
        MockCatalogReader.MockTable deptNestedTable = MockCatalogReader.MockTable.create(this, salesSchema, "DEPT_NESTED", false, 4.0);
        deptNestedTable.addColumn("DEPTNO", this.fixture.intType, true);
        deptNestedTable.addColumn("NAME", this.fixture.varchar10Type);
        deptNestedTable.addColumn("SKILL", this.fixture.skillRecordType);
        deptNestedTable.addColumn("EMPLOYEES", this.fixture.empListType);
        this.registerTable(deptNestedTable);
        MockCatalogReader.MockTable bonusTable = MockCatalogReader.MockTable.create(this, salesSchema, "BONUS", false, 0.0);
        bonusTable.addColumn("ENAME", this.fixture.varchar20Type);
        bonusTable.addColumn("JOB", this.fixture.varchar10Type);
        bonusTable.addColumn("SAL", this.fixture.intType);
        bonusTable.addColumn("COMM", this.fixture.intType);
        this.registerTable(bonusTable);
        MockCatalogReader.MockTable salgradeTable = MockCatalogReader.MockTable.create(this, salesSchema, "SALGRADE", false, 5.0);
        salgradeTable.addColumn("GRADE", this.fixture.intType, true);
        salgradeTable.addColumn("LOSAL", this.fixture.intType);
        salgradeTable.addColumn("HISAL", this.fixture.intType);
        this.registerTable(salgradeTable);
        MockCatalogReader.MockTable contactAddressTable = MockCatalogReader.MockTable.create(this, salesSchema, "EMP_ADDRESS", false, 26.0);
        contactAddressTable.addColumn("EMPNO", this.fixture.intType, true);
        contactAddressTable.addColumn("HOME_ADDRESS", (RelDataType)addressType);
        contactAddressTable.addColumn("MAILING_ADDRESS", (RelDataType)addressType);
        this.registerTable(contactAddressTable);
        MockCatalogReader.MockSchema customerSchema = new MockCatalogReader.MockSchema("CUSTOMER");
        this.registerSchema(customerSchema);
        MockCatalogReader.MockTable contactTable = MockCatalogReader.MockTable.create(this, customerSchema, "CONTACT", false, 1000.0);
        contactTable.addColumn("CONTACTNO", this.fixture.intType);
        contactTable.addColumn("FNAME", this.fixture.varchar10Type);
        contactTable.addColumn("LNAME", this.fixture.varchar10Type);
        contactTable.addColumn("EMAIL", this.fixture.varchar20Type);
        contactTable.addColumn("COORD", this.fixture.rectilinearCoordType);
        this.registerTable(contactTable);
        MockCatalogReader.MockTable contactPeekTable = MockCatalogReader.MockTable.create(this, customerSchema, "CONTACT_PEEK", false, 1000.0);
        contactPeekTable.addColumn("CONTACTNO", this.fixture.intType);
        contactPeekTable.addColumn("FNAME", this.fixture.varchar10Type);
        contactPeekTable.addColumn("LNAME", this.fixture.varchar10Type);
        contactPeekTable.addColumn("EMAIL", this.fixture.varchar20Type);
        contactPeekTable.addColumn("COORD", this.fixture.rectilinearPeekCoordType);
        contactPeekTable.addColumn("COORD_NE", this.fixture.rectilinearPeekNoExpandCoordType);
        this.registerTable(contactPeekTable);
        MockCatalogReader.MockTable accountTable = MockCatalogReader.MockTable.create(this, customerSchema, "ACCOUNT", false, 457.0);
        accountTable.addColumn("ACCTNO", this.fixture.intType);
        accountTable.addColumn("TYPE", this.fixture.varchar20Type);
        accountTable.addColumn("BALANCE", this.fixture.intType);
        this.registerTable(accountTable);
        MockCatalogReader.MockTable ordersStream = MockCatalogReader.MockTable.create(this, salesSchema, "ORDERS", true, Double.POSITIVE_INFINITY);
        ordersStream.addColumn("ROWTIME", this.fixture.timestampType);
        ordersStream.addMonotonic("ROWTIME");
        ordersStream.addColumn("PRODUCTID", this.fixture.intType);
        ordersStream.addColumn("ORDERID", this.fixture.intType);
        this.registerTable(ordersStream);
        MockCatalogReader.MockTable shipmentsStream = MockCatalogReader.MockTable.create(this, salesSchema, "SHIPMENTS", true, Double.POSITIVE_INFINITY);
        shipmentsStream.addColumn("ORDERID", this.fixture.intType);
        shipmentsStream.addColumn("ROWTIME", this.fixture.timestampType);
        shipmentsStream.addMonotonic("ROWTIME");
        this.registerTable(shipmentsStream);
        MockCatalogReader.MockTable productsTable = MockCatalogReader.MockTable.create(this, salesSchema, "PRODUCTS", false, 200.0);
        productsTable.addColumn("PRODUCTID", this.fixture.intType);
        productsTable.addColumn("NAME", this.fixture.varchar20Type);
        productsTable.addColumn("SUPPLIERID", this.fixture.intType);
        this.registerTable(productsTable);
        MockCatalogReader.MockTable productsTemporalTable = MockCatalogReader.MockTable.create(this, salesSchema, "PRODUCTS_TEMPORAL", false, 200.0, null, NullInitializerExpressionFactory.INSTANCE, true);
        productsTemporalTable.addColumn("PRODUCTID", this.fixture.intType);
        productsTemporalTable.addColumn("NAME", this.fixture.varchar20Type);
        productsTemporalTable.addColumn("SUPPLIERID", this.fixture.intType);
        productsTemporalTable.addColumn("SYS_START", this.fixture.timestampType);
        productsTemporalTable.addColumn("SYS_END", this.fixture.timestampType);
        this.registerTable(productsTemporalTable);
        MockCatalogReader.MockTable suppliersTable = MockCatalogReader.MockTable.create(this, salesSchema, "SUPPLIERS", false, 10.0);
        suppliersTable.addColumn("SUPPLIERID", this.fixture.intType);
        suppliersTable.addColumn("NAME", this.fixture.varchar20Type);
        suppliersTable.addColumn("CITY", this.fixture.intType);
        this.registerTable(suppliersTable);
        ImmutableIntList m0 = ImmutableIntList.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 8});
        MockCatalogReader.MockViewTable emp20View = new MockCatalogReader.MockViewTable(this, salesSchema.getCatalogName(), salesSchema.getName(), "EMP_20", false, 600.0, empTable, m0, null, NullInitializerExpressionFactory.INSTANCE){

            @Override
            public RexNode getConstraint(RexBuilder rexBuilder, RelDataType tableRowType) {
                RelDataTypeField deptnoField = (RelDataTypeField)tableRowType.getFieldList().get(7);
                RelDataTypeField salField = (RelDataTypeField)tableRowType.getFieldList().get(5);
                List<RexNode> nodes = Arrays.asList(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeInputRef(deptnoField.getType(), deptnoField.getIndex()), rexBuilder.makeExactLiteral(BigDecimal.valueOf(20L), deptnoField.getType())}), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{rexBuilder.makeInputRef(salField.getType(), salField.getIndex()), rexBuilder.makeExactLiteral(BigDecimal.valueOf(1000L), salField.getType())}));
                return RexUtil.composeConjunction((RexBuilder)rexBuilder, nodes);
            }
        };
        salesSchema.addTable((String)Util.last(emp20View.getQualifiedName()));
        emp20View.addColumn("EMPNO", this.fixture.intType);
        emp20View.addColumn("ENAME", this.fixture.varchar20Type);
        emp20View.addColumn("JOB", this.fixture.varchar10Type);
        emp20View.addColumn("MGR", this.fixture.intTypeNull);
        emp20View.addColumn("HIREDATE", this.fixture.timestampType);
        emp20View.addColumn("SAL", this.fixture.intType);
        emp20View.addColumn("COMM", this.fixture.intType);
        emp20View.addColumn("SLACKER", this.fixture.booleanType);
        this.registerTable(emp20View);
        MockCatalogReader.MockViewTable empNullables20View = new MockCatalogReader.MockViewTable(this, salesSchema.getCatalogName(), salesSchema.getName(), "EMPNULLABLES_20", false, 600.0, empNullablesTable, m0, null, NullInitializerExpressionFactory.INSTANCE){

            @Override
            public RexNode getConstraint(RexBuilder rexBuilder, RelDataType tableRowType) {
                RelDataTypeField deptnoField = (RelDataTypeField)tableRowType.getFieldList().get(7);
                RelDataTypeField salField = (RelDataTypeField)tableRowType.getFieldList().get(5);
                List<RexNode> nodes = Arrays.asList(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeInputRef(deptnoField.getType(), deptnoField.getIndex()), rexBuilder.makeExactLiteral(BigDecimal.valueOf(20L), deptnoField.getType())}), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{rexBuilder.makeInputRef(salField.getType(), salField.getIndex()), rexBuilder.makeExactLiteral(BigDecimal.valueOf(1000L), salField.getType())}));
                return RexUtil.composeConjunction((RexBuilder)rexBuilder, nodes);
            }
        };
        salesSchema.addTable((String)Util.last(empNullables20View.getQualifiedName()));
        empNullables20View.addColumn("EMPNO", this.fixture.intType);
        empNullables20View.addColumn("ENAME", this.fixture.varchar20Type);
        empNullables20View.addColumn("JOB", this.fixture.varchar10TypeNull);
        empNullables20View.addColumn("MGR", this.fixture.intTypeNull);
        empNullables20View.addColumn("HIREDATE", this.fixture.timestampTypeNull);
        empNullables20View.addColumn("SAL", this.fixture.intTypeNull);
        empNullables20View.addColumn("COMM", this.fixture.intTypeNull);
        empNullables20View.addColumn("SLACKER", this.fixture.booleanTypeNull);
        this.registerTable(empNullables20View);
        MockCatalogReader.MockSchema structTypeSchema = new MockCatalogReader.MockSchema("STRUCT");
        this.registerSchema(structTypeSchema);
        List<CompoundNameColumn> columns = Arrays.asList(new CompoundNameColumn("", "K0", this.fixture.varchar20Type), new CompoundNameColumn("", "C1", this.fixture.varchar20Type), new CompoundNameColumn("F1", "A0", this.fixture.intType), new CompoundNameColumn("F2", "A0", this.fixture.booleanType), new CompoundNameColumn("F0", "C0", this.fixture.intType), new CompoundNameColumn("F1", "C0", this.fixture.intTypeNull), new CompoundNameColumn("F0", "C1", this.fixture.intType), new CompoundNameColumn("F1", "C2", this.fixture.intType), new CompoundNameColumn("F2", "C3", this.fixture.intType));
        CompoundNameColumnResolver structTypeTableResolver = new CompoundNameColumnResolver(columns, "F0");
        MockCatalogReader.MockTable structTypeTable = MockCatalogReader.MockTable.create(this, structTypeSchema, "T", false, 100.0, structTypeTableResolver);
        for (CompoundNameColumn column : columns) {
            structTypeTable.addColumn(column.getName(), column.type);
        }
        this.registerTable(structTypeTable);
        List<CompoundNameColumn> columnsNullable = Arrays.asList(new CompoundNameColumn("", "K0", this.fixture.varchar20TypeNull), new CompoundNameColumn("", "C1", this.fixture.varchar20TypeNull), new CompoundNameColumn("F1", "A0", this.fixture.intTypeNull), new CompoundNameColumn("F2", "A0", this.fixture.booleanTypeNull), new CompoundNameColumn("F0", "C0", this.fixture.intTypeNull), new CompoundNameColumn("F1", "C0", this.fixture.intTypeNull), new CompoundNameColumn("F0", "C1", this.fixture.intTypeNull), new CompoundNameColumn("F1", "C2", this.fixture.intType), new CompoundNameColumn("F2", "C3", this.fixture.intTypeNull));
        MockCatalogReader.MockTable structNullableTypeTable = MockCatalogReader.MockTable.create(this, structTypeSchema, "T_NULLABLES", false, 100.0, structTypeTableResolver);
        for (CompoundNameColumn column : columnsNullable) {
            structNullableTypeTable.addColumn(column.getName(), column.type);
        }
        this.registerTable(structNullableTypeTable);
        ImmutableIntList m1 = ImmutableIntList.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8});
        MockCatalogReader.MockViewTable struct10View = new MockCatalogReader.MockViewTable(this, structTypeSchema.getCatalogName(), structTypeSchema.getName(), "T_10", false, 20.0, structTypeTable, m1, structTypeTableResolver, NullInitializerExpressionFactory.INSTANCE){

            @Override
            public RexNode getConstraint(RexBuilder rexBuilder, RelDataType tableRowType) {
                RelDataTypeField c0Field = (RelDataTypeField)tableRowType.getFieldList().get(4);
                return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeInputRef(c0Field.getType(), c0Field.getIndex()), rexBuilder.makeExactLiteral(BigDecimal.valueOf(10L), c0Field.getType())});
            }
        };
        structTypeSchema.addTable((String)Util.last(struct10View.getQualifiedName()));
        for (CompoundNameColumn column : columns) {
            struct10View.addColumn(column.getName(), column.type);
        }
        this.registerTable(struct10View);
        this.registerTablesWithRollUp(salesSchema, this.fixture);
        return this;
    }
}

