/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.catalog;

import java.util.Arrays;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeComparability;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ObjectSqlType;
import org.apache.calcite.sql.type.SqlTypeName;

final class Fixture {
    final RelDataType intType;
    final RelDataType intTypeNull;
    final RelDataType varchar10Type;
    final RelDataType varchar10TypeNull;
    final RelDataType varchar20Type;
    final RelDataType varchar20TypeNull;
    final RelDataType timestampType;
    final RelDataType timestampTypeNull;
    final RelDataType dateType;
    final RelDataType booleanType;
    final RelDataType booleanTypeNull;
    final RelDataType rectilinearCoordType;
    final RelDataType rectilinearPeekCoordType;
    final RelDataType rectilinearPeekNoExpandCoordType;
    final RelDataType abRecordType;
    final RelDataType skillRecordType;
    final RelDataType empRecordType;
    final RelDataType empListType;
    final ObjectSqlType addressType;

    Fixture(RelDataTypeFactory typeFactory) {
        this.intType = typeFactory.createSqlType(SqlTypeName.INTEGER);
        this.intTypeNull = typeFactory.createTypeWithNullability(this.intType, true);
        this.varchar10Type = typeFactory.createSqlType(SqlTypeName.VARCHAR, 10);
        this.varchar10TypeNull = typeFactory.createTypeWithNullability(this.varchar10Type, true);
        this.varchar20Type = typeFactory.createSqlType(SqlTypeName.VARCHAR, 20);
        this.varchar20TypeNull = typeFactory.createTypeWithNullability(this.varchar20Type, true);
        this.timestampType = typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
        this.timestampTypeNull = typeFactory.createTypeWithNullability(this.timestampType, true);
        this.dateType = typeFactory.createSqlType(SqlTypeName.DATE);
        this.booleanType = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        this.booleanTypeNull = typeFactory.createTypeWithNullability(this.booleanType, true);
        this.rectilinearCoordType = typeFactory.builder().add("X", this.intType).add("Y", this.intType).build();
        this.rectilinearPeekCoordType = typeFactory.builder().add("X", this.intType).add("Y", this.intType).add("unit", this.varchar20Type).kind(StructKind.PEEK_FIELDS).build();
        this.rectilinearPeekNoExpandCoordType = typeFactory.builder().add("M", this.intType).add("SUB", typeFactory.builder().add("A", this.intType).add("B", this.intType).kind(StructKind.PEEK_FIELDS_NO_EXPAND).build()).kind(StructKind.PEEK_FIELDS_NO_EXPAND).build();
        this.abRecordType = typeFactory.builder().add("A", this.varchar10Type).add("B", this.varchar10Type).build();
        this.skillRecordType = typeFactory.builder().add("TYPE", this.varchar10Type).add("DESC", this.varchar20Type).add("OTHERS", this.abRecordType).build();
        this.empRecordType = typeFactory.builder().add("EMPNO", this.intType).add("ENAME", this.varchar10Type).add("DETAIL", typeFactory.builder().add("SKILLS", typeFactory.createArrayType(this.skillRecordType, -1L)).build()).build();
        this.empListType = typeFactory.createArrayType(this.empRecordType, -1L);
        this.addressType = new ObjectSqlType(SqlTypeName.STRUCTURED, new SqlIdentifier("ADDRESS", SqlParserPos.ZERO), false, Arrays.asList(new RelDataTypeFieldImpl("STREET", 0, this.varchar20Type), new RelDataTypeFieldImpl("CITY", 1, this.varchar20Type), new RelDataTypeFieldImpl("ZIP", 2, this.intType), new RelDataTypeFieldImpl("STATE", 3, this.varchar20Type)), RelDataTypeComparability.NONE);
    }
}

