/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import org.apache.calcite.test.CalciteAssert;
import org.junit.Test;

public class UdtTest {
    private CalciteAssert.AssertThat withUdt() {
        String model = "{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'adhoc',\n       types: [\n         {\n           name: 'mytype1',\n           type: 'BIGINT'\n         },\n         {\n           name: 'mytype2',\n           attributes: [\n             {\n               name: 'ii',\n               type: 'INTEGER'\n             },\n             {\n               name: 'jj',\n               type: 'INTEGER'\n             }\n           ]\n         }\n       ]\n     }\n   ]\n}";
        return CalciteAssert.model("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 'adhoc',\n       types: [\n         {\n           name: 'mytype1',\n           type: 'BIGINT'\n         },\n         {\n           name: 'mytype2',\n           attributes: [\n             {\n               name: 'ii',\n               type: 'INTEGER'\n             },\n             {\n               name: 'jj',\n               type: 'INTEGER'\n             }\n           ]\n         }\n       ]\n     }\n   ]\n}");
    }

    @Test
    public void testUdt() {
        String sql = "select CAST(\"id\" AS \"adhoc\".mytype1) as ld from (VALUES ROW(1, 'SameName')) AS \"t\" (\"id\", \"desc\")";
        this.withUdt().query("select CAST(\"id\" AS \"adhoc\".mytype1) as ld from (VALUES ROW(1, 'SameName')) AS \"t\" (\"id\", \"desc\")").returns("LD=1\n");
    }

    @Test
    public void testCastNullLiteralToCompositeUdt() {
        String sql = "select CAST(null AS \"adhoc\".mytype2) as c from (VALUES (1))";
        this.withUdt().query("select CAST(null AS \"adhoc\".mytype2) as c from (VALUES (1))").returns("C=null\n");
    }
}

