/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableFunction;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.TableFunctionImpl;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.ScannableTableTest;
import org.apache.calcite.util.Smalls;
import org.apache.calcite.util.TestUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TableFunctionTest {
    private CalciteAssert.AssertThat with() {
        String c = Smalls.class.getName();
        String m = Smalls.MULTIPLICATION_TABLE_METHOD.getName();
        String m2 = Smalls.FIBONACCI_TABLE_METHOD.getName();
        String m3 = Smalls.FIBONACCI2_TABLE_METHOD.getName();
        return CalciteAssert.model("{\n  version: '1.0',\n   schemas: [\n     {\n       name: 's',\n       functions: [\n         {\n           name: 'multiplication',\n           className: '" + c + "',\n           methodName: '" + m + "'\n         }, {\n           name: 'fibonacci',\n           className: '" + c + "',\n           methodName: '" + m2 + "'\n         }, {\n           name: 'fibonacci2',\n           className: '" + c + "',\n           methodName: '" + m3 + "'\n         }\n       ]\n     }\n   ]\n}").withDefaultSchema("s");
    }

    @Test
    public void testTableFunction() throws SQLException {
        try (Connection connection = DriverManager.getConnection("jdbc:calcite:");){
            CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
            SchemaPlus rootSchema = calciteConnection.getRootSchema();
            SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
            TableFunction table = TableFunctionImpl.create((Method)Smalls.GENERATE_STRINGS_METHOD);
            schema.add("GenerateStrings", (Function)table);
            String sql = "select *\nfrom table(\"s\".\"GenerateStrings\"(5)) as t(n, c)\nwhere char_length(c) > 3";
            ResultSet resultSet = connection.createStatement().executeQuery("select *\nfrom table(\"s\".\"GenerateStrings\"(5)) as t(n, c)\nwhere char_length(c) > 3");
            Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"N=4; C=abcd\n"));
        }
    }

    @Test
    public void testScannableTableFunction() throws SQLException, ClassNotFoundException {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        TableFunction table = TableFunctionImpl.create((Method)Smalls.MAZE_METHOD);
        schema.add("Maze", (Function)table);
        String sql = "select *\nfrom table(\"s\".\"Maze\"(5, 3, 1))";
        ResultSet resultSet = connection.createStatement().executeQuery("select *\nfrom table(\"s\".\"Maze\"(5, 3, 1))");
        String result = "S=abcde\nS=xyz\nS=generate(w=5, h=3, s=1)\n";
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.is((Object)"S=abcde\nS=xyz\nS=generate(w=5, h=3, s=1)\n"));
    }

    @Test
    public void testScannableTableFunctionWithNamedParameters() throws SQLException, ClassNotFoundException {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        TableFunction table = TableFunctionImpl.create((Method)Smalls.MAZE2_METHOD);
        schema.add("Maze", (Function)table);
        String sql = "select *\nfrom table(\"s\".\"Maze\"(5, 3, 1))";
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select *\nfrom table(\"s\".\"Maze\"(5, 3, 1))");
        String result = "S=abcde\nS=xyz\n";
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.is((Object)"S=abcde\nS=xyz\nS=generate2(w=5, h=3, s=1)\n"));
        String sql2 = "select *\nfrom table(\"s\".\"Maze\"(WIDTH => 5, HEIGHT => 3, SEED => 1))";
        resultSet = statement.executeQuery("select *\nfrom table(\"s\".\"Maze\"(WIDTH => 5, HEIGHT => 3, SEED => 1))");
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.is((Object)"S=abcde\nS=xyz\nS=generate2(w=5, h=3, s=1)\n"));
        String sql3 = "select *\nfrom table(\"s\".\"Maze\"(HEIGHT => 3, WIDTH => 5))";
        resultSet = statement.executeQuery("select *\nfrom table(\"s\".\"Maze\"(HEIGHT => 3, WIDTH => 5))");
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.is((Object)"S=abcde\nS=xyz\nS=generate2(w=5, h=3, s=null)\n"));
        connection.close();
    }

    @Test
    public void testMultipleScannableTableFunctionWithNamedParameters() throws SQLException, ClassNotFoundException {
        try (Connection connection = DriverManager.getConnection("jdbc:calcite:");
             Statement statement = connection.createStatement();){
            CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
            SchemaPlus rootSchema = calciteConnection.getRootSchema();
            SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
            TableFunction table1 = TableFunctionImpl.create((Method)Smalls.MAZE_METHOD);
            schema.add("Maze", (Function)table1);
            TableFunction table2 = TableFunctionImpl.create((Method)Smalls.MAZE2_METHOD);
            schema.add("Maze", (Function)table2);
            TableFunction table3 = TableFunctionImpl.create((Method)Smalls.MAZE3_METHOD);
            schema.add("Maze", (Function)table3);
            String sql = "select *\nfrom table(\"s\".\"Maze\"(5, 3, 1))";
            ResultSet resultSet = statement.executeQuery("select *\nfrom table(\"s\".\"Maze\"(5, 3, 1))");
            String result = "S=abcde\nS=xyz\n";
            Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.is((Object)"S=abcde\nS=xyz\nS=generate(w=5, h=3, s=1)\n"));
            String sql2 = "select *\nfrom table(\"s\".\"Maze\"(WIDTH => 5, HEIGHT => 3, SEED => 1))";
            resultSet = statement.executeQuery("select *\nfrom table(\"s\".\"Maze\"(WIDTH => 5, HEIGHT => 3, SEED => 1))");
            Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.is((Object)"S=abcde\nS=xyz\nS=generate2(w=5, h=3, s=1)\n"));
            String sql3 = "select *\nfrom table(\"s\".\"Maze\"(HEIGHT => 3, WIDTH => 5))";
            resultSet = statement.executeQuery("select *\nfrom table(\"s\".\"Maze\"(HEIGHT => 3, WIDTH => 5))");
            Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.is((Object)"S=abcde\nS=xyz\nS=generate2(w=5, h=3, s=null)\n"));
            String sql4 = "select *\nfrom table(\"s\".\"Maze\"(FOO => 'a'))";
            resultSet = statement.executeQuery("select *\nfrom table(\"s\".\"Maze\"(FOO => 'a'))");
            Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.is((Object)"S=abcde\nS=xyz\nS=generate3(foo=a)\n"));
        }
    }

    @Test
    public void testTableFunctionDynamicStructure() throws SQLException, ClassNotFoundException {
        Connection connection = this.getConnectionWithMultiplyFunction();
        PreparedStatement ps = connection.prepareStatement("select *\nfrom table(\"s\".\"multiplication\"(4, 3, ?))\n");
        ps.setInt(1, 100);
        ResultSet resultSet = ps.executeQuery();
        Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"row_name=row 0; c1=101; c2=102; c3=103; c4=104\nrow_name=row 1; c1=102; c2=104; c3=106; c4=108\nrow_name=row 2; c1=103; c2=106; c3=109; c4=112\n"));
    }

    @Ignore(value="SQLException does not include message from nested exception")
    @Test
    public void testTableFunctionNonNullableMustBeLiterals() throws SQLException, ClassNotFoundException {
        Connection connection = this.getConnectionWithMultiplyFunction();
        try {
            PreparedStatement ps = connection.prepareStatement("select *\nfrom table(\"s\".\"multiplication\"(?, 3, 100))\n");
            ps.setInt(1, 100);
            ResultSet resultSet = ps.executeQuery();
            Assert.fail((String)("Should fail, got " + resultSet));
        }
        catch (SQLException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Wrong arguments for table function 'public static org.apache.calcite.schema.QueryableTable org.apache.calcite.test.JdbcTest.multiplicationTable(int,int,java.lang.Integer)' call. Expected '[int, int, classjava.lang.Integer]', actual '[null, 3, 100]'"));
        }
    }

    private Connection getConnectionWithMultiplyFunction() throws ClassNotFoundException, SQLException {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        TableFunction table = TableFunctionImpl.create((Method)Smalls.MULTIPLICATION_TABLE_METHOD);
        schema.add("multiplication", (Function)table);
        return connection;
    }

    @Ignore(value="CannotPlanException: Node [rel#18:Subset#4.ENUMERABLE.[]] could not be implemented")
    @Test
    public void testTableFunctionCursorInputs() throws SQLException, ClassNotFoundException {
        try (Connection connection = DriverManager.getConnection("jdbc:calcite:");){
            CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
            SchemaPlus rootSchema = calciteConnection.getRootSchema();
            SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
            TableFunction table = TableFunctionImpl.create((Method)Smalls.GENERATE_STRINGS_METHOD);
            schema.add("GenerateStrings", (Function)table);
            TableFunction add = TableFunctionImpl.create((Method)Smalls.PROCESS_CURSOR_METHOD);
            schema.add("process", (Function)add);
            PreparedStatement ps = connection.prepareStatement("select *\nfrom table(\"s\".\"process\"(2,\ncursor(select * from table(\"s\".\"GenerateStrings\"(?)))\n)) as t(u)\nwhere u > 3");
            ps.setInt(1, 5);
            ResultSet resultSet = ps.executeQuery();
            Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"u=4\nu=5\nu=6\n"));
        }
    }

    @Ignore(value="CannotPlanException: Node [rel#24:Subset#6.ENUMERABLE.[]] could not be implemented")
    @Test
    public void testTableFunctionCursorsInputs() throws SQLException, ClassNotFoundException {
        try (Connection connection = this.getConnectionWithMultiplyFunction();){
            CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
            SchemaPlus rootSchema = calciteConnection.getRootSchema();
            SchemaPlus schema = rootSchema.getSubSchema("s");
            TableFunction table = TableFunctionImpl.create((Method)Smalls.GENERATE_STRINGS_METHOD);
            schema.add("GenerateStrings", (Function)table);
            TableFunction add = TableFunctionImpl.create((Method)Smalls.PROCESS_CURSORS_METHOD);
            schema.add("process", (Function)add);
            PreparedStatement ps = connection.prepareStatement("select *\nfrom table(\"s\".\"process\"(2,\ncursor(select * from table(\"s\".\"multiplication\"(5,5,0))),\ncursor(select * from table(\"s\".\"GenerateStrings\"(?)))\n)) as t(u)\nwhere u > 3");
            ps.setInt(1, 5);
            ResultSet resultSet = ps.executeQuery();
            Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"u=4\nu=5\nu=6\nu=7\nu=8\nu=9\n"));
        }
    }

    @Test
    public void testUserDefinedTableFunction() {
        String q = "select *\nfrom table(\"s\".\"multiplication\"(2, 3, 100))\n";
        this.with().query("select *\nfrom table(\"s\".\"multiplication\"(2, 3, 100))\n").returnsUnordered("row_name=row 0; c1=101; c2=102", "row_name=row 1; c1=102; c2=104", "row_name=row 2; c1=103; c2=106");
    }

    @Test
    public void testUserDefinedTableFunction2() {
        String q = "select c1\nfrom table(\"s\".\"multiplication\"(2, 3, 100))\nwhere c1 + 2 < c2";
        this.with().query("select c1\nfrom table(\"s\".\"multiplication\"(2, 3, 100))\nwhere c1 + 2 < c2").throws_("Column 'C1' not found in any table; did you mean 'c1'?");
    }

    @Test
    public void testUserDefinedTableFunction3() {
        String q = "select \"c1\"\nfrom table(\"s\".\"multiplication\"(2, 3, 100))\nwhere \"c1\" + 2 < \"c2\"";
        this.with().query("select \"c1\"\nfrom table(\"s\".\"multiplication\"(2, 3, 100))\nwhere \"c1\" + 2 < \"c2\"").returnsUnordered("c1=103");
    }

    @Test
    public void testUserDefinedTableFunction4() {
        String q = "select *\nfrom table(\"s\".\"multiplication\"('2', 3, 100))\nwhere c1 + 2 < c2";
        String e = "No match found for function signature multiplication(<CHARACTER>, <NUMERIC>, <NUMERIC>)";
        this.with().query("select *\nfrom table(\"s\".\"multiplication\"('2', 3, 100))\nwhere c1 + 2 < c2").throws_("No match found for function signature multiplication(<CHARACTER>, <NUMERIC>, <NUMERIC>)");
    }

    @Test
    public void testUserDefinedTableFunction5() {
        String q = "select *\nfrom table(\"s\".\"multiplication\"(3, 100))\nwhere c1 + 2 < c2";
        String e = "No match found for function signature multiplication(<NUMERIC>, <NUMERIC>)";
        this.with().query("select *\nfrom table(\"s\".\"multiplication\"(3, 100))\nwhere c1 + 2 < c2").throws_("No match found for function signature multiplication(<NUMERIC>, <NUMERIC>)");
    }

    @Test
    public void testUserDefinedTableFunction6() {
        String q = "select *\nfrom table(\"s\".\"fibonacci\"())";
        this.with().query("select *\nfrom table(\"s\".\"fibonacci\"())").returns(r -> {
            try {
                ArrayList<Long> numbers = new ArrayList<Long>();
                while (r.next() && numbers.size() < 13) {
                    numbers.add(r.getLong(1));
                }
                Assert.assertThat((Object)((Object)numbers).toString(), (Matcher)CoreMatchers.is((Object)"[1, 1, 2, 3, 5, 8, 13, 21, 34, 55, 89, 144, 233]"));
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        });
    }

    @Test
    public void testUserDefinedTableFunction7() {
        String q = "select *\nfrom table(\"s\".\"fibonacci2\"(20))\nwhere n > 7";
        this.with().query("select *\nfrom table(\"s\".\"fibonacci2\"(20))\nwhere n > 7").returnsUnordered("N=13", "N=8");
    }

    @Test
    public void testUserDefinedTableFunction8() {
        String q = "select count(*) as c\nfrom table(\"s\".\"fibonacci2\"(20))";
        this.with().query("select count(*) as c\nfrom table(\"s\".\"fibonacci2\"(20))").returnsUnordered("C=7");
    }

    @Test
    public void testCrossApply() {
        String q1 = "select *\nfrom (values 2, 5) as t (c)\ncross apply table(\"s\".\"fibonacci2\"(c))";
        String q2 = "select *\nfrom (values 2, 5) as t (c)\ncross apply table(\"s\".\"fibonacci2\"(t.c))";
        for (String q : new String[]{"select *\nfrom (values 2, 5) as t (c)\ncross apply table(\"s\".\"fibonacci2\"(c))", "select *\nfrom (values 2, 5) as t (c)\ncross apply table(\"s\".\"fibonacci2\"(t.c))"}) {
            this.with().with((ConnectionProperty)CalciteConnectionProperty.CONFORMANCE, (Object)SqlConformanceEnum.LENIENT).query(q).returnsUnordered("C=2; N=1", "C=2; N=1", "C=2; N=2", "C=5; N=1", "C=5; N=1", "C=5; N=2", "C=5; N=3", "C=5; N=5");
        }
    }

    @Test
    public void testLeftOuterApply() {
        String sql = "select *\nfrom (values 4) as t (c)\nleft join lateral table(\"s\".\"fibonacci2\"(c)) as R(n) on c=n";
        this.with().with((ConnectionProperty)CalciteConnectionProperty.CONFORMANCE, (Object)SqlConformanceEnum.LENIENT).query("select *\nfrom (values 4) as t (c)\nleft join lateral table(\"s\".\"fibonacci2\"(c)) as R(n) on c=n").returnsUnordered("C=4; N=null");
    }

    @Test
    public void testInlineViewLateralTableFunction() throws SQLException {
        try (Connection connection = DriverManager.getConnection("jdbc:calcite:");){
            CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
            SchemaPlus rootSchema = calciteConnection.getRootSchema();
            SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
            TableFunction table = TableFunctionImpl.create((Method)Smalls.GENERATE_STRINGS_METHOD);
            schema.add("GenerateStrings", (Function)table);
            ScannableTableTest.SimpleTable tbl = new ScannableTableTest.SimpleTable();
            schema.add("t", (Table)tbl);
            String sql = "select *\nfrom (select 5 as f0 from \"s\".\"t\") \"a\",\n  lateral table(\"s\".\"GenerateStrings\"(f0)) as t(n, c)\nwhere char_length(c) > 3";
            ResultSet resultSet = connection.createStatement().executeQuery("select *\nfrom (select 5 as f0 from \"s\".\"t\") \"a\",\n  lateral table(\"s\".\"GenerateStrings\"(f0)) as t(n, c)\nwhere char_length(c) > 3");
            String expected = "F0=5; N=4; C=abcd\nF0=5; N=4; C=abcd\nF0=5; N=4; C=abcd\nF0=5; N=4; C=abcd\n";
            Assert.assertThat((Object)CalciteAssert.toString(resultSet), (Matcher)CoreMatchers.equalTo((Object)"F0=5; N=4; C=abcd\nF0=5; N=4; C=abcd\nF0=5; N=4; C=abcd\nF0=5; N=4; C=abcd\n"));
        }
    }
}

