/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.util.Locale;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.sql.test.SqlValidatorTester;
import org.apache.calcite.test.SqlValidatorTestCase;
import org.apache.calcite.test.catalog.MockCatalogReaderDynamic;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlValidatorDynamicTest
extends SqlValidatorTestCase {
    protected static final boolean TODO = false;
    private static final String ANY = "(?s).*";
    protected static final Logger LOGGER = LoggerFactory.getLogger(SqlValidatorDynamicTest.class);
    private static final String ERR_IN_VALUES_INCOMPATIBLE = "Values in expression list must have compatible types";
    private static final String ERR_IN_OPERANDS_INCOMPATIBLE = "Values passed to IN operator must have compatible types";
    private static final String ERR_AGG_IN_GROUP_BY = "Aggregate expression is illegal in GROUP BY clause";
    private static final String ERR_AGG_IN_ORDER_BY = "Aggregate expression is illegal in ORDER BY clause of non-aggregating SELECT";
    private static final String ERR_NESTED_AGG = "Aggregate expressions cannot be nested";
    private static final String EMP_RECORD_TYPE = "RecordType(INTEGER NOT NULL EMPNO, VARCHAR(20) NOT NULL ENAME, VARCHAR(10) NOT NULL JOB, INTEGER MGR, TIMESTAMP(0) NOT NULL HIREDATE, INTEGER NOT NULL SAL, INTEGER NOT NULL COMM, INTEGER NOT NULL DEPTNO, BOOLEAN NOT NULL SLACKER) NOT NULL";
    private static final String STR_AGG_REQUIRES_MONO = "Streaming aggregation requires at least one monotonic expression in GROUP BY clause";
    private static final String STR_ORDER_REQUIRES_MONO = "Streaming ORDER BY must start with monotonic expression";
    private static final String STR_SET_OP_INCONSISTENT = "Set operator cannot combine streaming and non-streaming inputs";
    private static final String ROW_RANGE_NOT_ALLOWED_WITH_RANK = "ROW/RANGE not allowed with RANK, DENSE_RANK or ROW_NUMBER functions";

    @Override
    public SqlTester getTester() {
        return new SqlValidatorTester(SqlTestFactory.INSTANCE.withCatalogReader(MockCatalogReaderDynamic::new));
    }

    @BeforeClass
    public static void setUSLocale() {
        Locale.setDefault(Locale.US);
    }

    @Test
    public void testAmbiguousDynamicStar() throws Exception {
        String sql = "select ^n_nation^\nfrom (select * from \"SALES\".NATION),\n (select * from \"SALES\".CUSTOMER)";
        this.sql("select ^n_nation^\nfrom (select * from \"SALES\".NATION),\n (select * from \"SALES\".CUSTOMER)").fails("Column 'N_NATION' is ambiguous");
    }

    @Test
    public void testAmbiguousDynamicStar2() throws Exception {
        String sql = "select ^n_nation^\nfrom (select * from \"SALES\".NATION, \"SALES\".CUSTOMER)";
        this.sql("select ^n_nation^\nfrom (select * from \"SALES\".NATION, \"SALES\".CUSTOMER)").fails("Column 'N_NATION' is ambiguous");
    }

    @Test
    public void testAmbiguousDynamicStar3() throws Exception {
        String sql = "select ^nc.n_nation^\nfrom (select * from \"SALES\".NATION, \"SALES\".CUSTOMER) as nc";
        this.sql("select ^nc.n_nation^\nfrom (select * from \"SALES\".NATION, \"SALES\".CUSTOMER) as nc").fails("Column 'N_NATION' is ambiguous");
    }

    @Test
    public void testAmbiguousDynamicStar4() throws Exception {
        String sql = "select n.n_nation\nfrom (select * from \"SALES\".NATION) as n,\n (select * from \"SALES\".CUSTOMER)";
        this.sql("select n.n_nation\nfrom (select * from \"SALES\".NATION) as n,\n (select * from \"SALES\".CUSTOMER)").type("RecordType(ANY N_NATION) NOT NULL");
    }

    @Test
    public void testDynamicStar2() throws Exception {
        String sql = "select newid from (\n  select *, NATION.N_NATION + 100 as newid\n  from \"SALES\".NATION, \"SALES\".CUSTOMER)";
        this.sql("select newid from (\n  select *, NATION.N_NATION + 100 as newid\n  from \"SALES\".NATION, \"SALES\".CUSTOMER)").type("RecordType(ANY NEWID) NOT NULL");
    }
}

