/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.materialize.SqlStatisticProvider;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.statistic.CachingSqlStatisticProvider;
import org.apache.calcite.statistic.MapSqlStatisticProvider;
import org.apache.calcite.statistic.QuerySqlStatisticProvider;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Util;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class SqlStatisticProviderTest {
    public static Frameworks.ConfigBuilder config() {
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
        return Frameworks.newConfigBuilder().parserConfig(SqlParser.Config.DEFAULT).defaultSchema(CalciteAssert.addSchema(rootSchema, CalciteAssert.SchemaSpec.JDBC_FOODMART)).traitDefs((List)null).programs(new Program[]{Programs.heuristicJoinOrder((Iterable)Programs.RULE_SET, (boolean)true, (int)2)});
    }

    @Test
    public void testMapProvider() {
        this.check((SqlStatisticProvider)MapSqlStatisticProvider.INSTANCE);
    }

    @Test
    public void testQueryProvider() {
        boolean debug = (Boolean)CalciteSystemProperty.DEBUG.value();
        Consumer<String> sqlConsumer = debug ? System.out::println : Util::discard;
        this.check((SqlStatisticProvider)new QuerySqlStatisticProvider(sqlConsumer));
    }

    @Test
    public void testQueryProviderWithCache() {
        Cache cache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
        AtomicInteger counter = new AtomicInteger();
        QuerySqlStatisticProvider provider = new QuerySqlStatisticProvider(sql -> counter.incrementAndGet());
        CachingSqlStatisticProvider cachingProvider = new CachingSqlStatisticProvider((SqlStatisticProvider)provider, cache);
        this.check((SqlStatisticProvider)cachingProvider);
        int expectedQueryCount = 6;
        Assert.assertThat((Object)counter.get(), (Matcher)Is.is((Object)6));
        this.check((SqlStatisticProvider)cachingProvider);
        Assert.assertThat((Object)counter.get(), (Matcher)Is.is((Object)6));
    }

    private void check(SqlStatisticProvider provider) {
        RelBuilder relBuilder = RelBuilder.create((FrameworkConfig)SqlStatisticProviderTest.config().build());
        RelNode productScan = relBuilder.scan(new String[]{"product"}).build();
        RelOptTable productTable = productScan.getTable();
        RelNode salesScan = relBuilder.scan(new String[]{"sales_fact_1997"}).build();
        RelOptTable salesTable = salesScan.getTable();
        RelNode employeeScan = relBuilder.scan(new String[]{"employee"}).build();
        RelOptTable employeeTable = employeeScan.getTable();
        Assert.assertThat((Object)provider.tableCardinality(productTable), (Matcher)Is.is((Object)1560.0));
        Assert.assertThat((Object)provider.isKey(productTable, this.columns(productTable, "product_id")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)provider.isKey(salesTable, this.columns(salesTable, "product_id")), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)provider.isForeignKey(salesTable, this.columns(salesTable, "product_id"), productTable, this.columns(productTable, "product_id")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)provider.isForeignKey(productTable, this.columns(productTable, "product_id"), salesTable, this.columns(salesTable, "product_id")), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)provider.isForeignKey(employeeTable, this.columns(employeeTable, "supervisor_id"), employeeTable, this.columns(employeeTable, "employee_id")), (Matcher)Is.is((Object)false));
    }

    private List<Integer> columns(RelOptTable table, String ... columnNames) {
        return Arrays.stream(columnNames).map(columnName -> table.getRowType().getFieldNames().indexOf(columnName)).collect(Collectors.toList());
    }
}

