/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.primitives.Longs;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.PathNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.JsonFunctions;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlJsonExistsErrorBehavior;
import org.apache.calcite.sql.SqlJsonQueryEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import org.apache.calcite.util.BuiltInMethod;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SqlJsonFunctionsTest {
    @Test
    public void testJsonValueExpression() {
        this.assertJsonValueExpression("{}", (Matcher<? super JsonFunctions.JsonValueContext>)CoreMatchers.is((Object)JsonFunctions.JsonValueContext.withJavaObj(Collections.emptyMap())));
    }

    @Test
    public void testJsonApiCommonSyntax() {
        this.assertJsonApiCommonSyntax("{\"foo\": \"bar\"}", "lax $.foo", (Matcher<? super JsonFunctions.JsonPathContext>)this.contextMatches(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, (Object)"bar")));
        this.assertJsonApiCommonSyntax("{\"foo\": \"bar\"}", "strict $.foo", (Matcher<? super JsonFunctions.JsonPathContext>)this.contextMatches(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.STRICT, (Object)"bar")));
        this.assertJsonApiCommonSyntax("{\"foo\": \"bar\"}", "lax $.foo1", (Matcher<? super JsonFunctions.JsonPathContext>)this.contextMatches(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, null)));
        this.assertJsonApiCommonSyntax("{\"foo\": \"bar\"}", "strict $.foo1", (Matcher<? super JsonFunctions.JsonPathContext>)this.contextMatches(JsonFunctions.JsonPathContext.withStrictException((Exception)new PathNotFoundException("No results for path: $['foo1']"))));
        this.assertJsonApiCommonSyntax("{\"foo\": 100}", "lax $.foo", (Matcher<? super JsonFunctions.JsonPathContext>)this.contextMatches(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, (Object)100)));
    }

    @Test
    public void testJsonExists() {
        this.assertJsonExists(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.STRICT, (Object)"bar"), SqlJsonExistsErrorBehavior.FALSE, (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertJsonExists(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.STRICT, (Object)"bar"), SqlJsonExistsErrorBehavior.TRUE, (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertJsonExists(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.STRICT, (Object)"bar"), SqlJsonExistsErrorBehavior.UNKNOWN, (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertJsonExists(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.STRICT, (Object)"bar"), SqlJsonExistsErrorBehavior.ERROR, (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertJsonExists(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, null), SqlJsonExistsErrorBehavior.FALSE, (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertJsonExists(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, null), SqlJsonExistsErrorBehavior.TRUE, (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertJsonExists(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, null), SqlJsonExistsErrorBehavior.UNKNOWN, (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertJsonExists(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, null), SqlJsonExistsErrorBehavior.ERROR, (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertJsonExists(JsonFunctions.JsonPathContext.withStrictException((Exception)new Exception("test message")), SqlJsonExistsErrorBehavior.FALSE, (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertJsonExists(JsonFunctions.JsonPathContext.withStrictException((Exception)new Exception("test message")), SqlJsonExistsErrorBehavior.TRUE, (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertJsonExists(JsonFunctions.JsonPathContext.withStrictException((Exception)new Exception("test message")), SqlJsonExistsErrorBehavior.UNKNOWN, (Matcher<? super Boolean>)CoreMatchers.nullValue());
        this.assertJsonExistsFailed(JsonFunctions.JsonPathContext.withStrictException((Exception)new Exception("test message")), SqlJsonExistsErrorBehavior.ERROR, this.errorMatches(new RuntimeException("java.lang.Exception: test message")));
    }

    @Test
    public void testJsonValueAny() {
        this.assertJsonValueAny(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, (Object)"bar"), SqlJsonValueEmptyOrErrorBehavior.NULL, null, SqlJsonValueEmptyOrErrorBehavior.NULL, null, (Matcher<Object>)CoreMatchers.is((Object)"bar"));
        this.assertJsonValueAny(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, null), SqlJsonValueEmptyOrErrorBehavior.NULL, null, SqlJsonValueEmptyOrErrorBehavior.NULL, null, (Matcher<Object>)CoreMatchers.nullValue());
        this.assertJsonValueAny(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, null), SqlJsonValueEmptyOrErrorBehavior.DEFAULT, "empty", SqlJsonValueEmptyOrErrorBehavior.NULL, null, (Matcher<Object>)CoreMatchers.is((Object)"empty"));
        this.assertJsonValueAnyFailed(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, null), SqlJsonValueEmptyOrErrorBehavior.ERROR, null, SqlJsonValueEmptyOrErrorBehavior.NULL, null, this.errorMatches(new CalciteException("Empty result of JSON_VALUE function is not allowed", null)));
        this.assertJsonValueAny(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, Collections.emptyList()), SqlJsonValueEmptyOrErrorBehavior.NULL, null, SqlJsonValueEmptyOrErrorBehavior.NULL, null, (Matcher<Object>)CoreMatchers.nullValue());
        this.assertJsonValueAny(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, Collections.emptyList()), SqlJsonValueEmptyOrErrorBehavior.DEFAULT, "empty", SqlJsonValueEmptyOrErrorBehavior.NULL, null, (Matcher<Object>)CoreMatchers.is((Object)"empty"));
        this.assertJsonValueAnyFailed(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, Collections.emptyList()), SqlJsonValueEmptyOrErrorBehavior.ERROR, null, SqlJsonValueEmptyOrErrorBehavior.NULL, null, this.errorMatches(new CalciteException("Empty result of JSON_VALUE function is not allowed", null)));
        this.assertJsonValueAny(JsonFunctions.JsonPathContext.withStrictException((Exception)new Exception("test message")), SqlJsonValueEmptyOrErrorBehavior.NULL, null, SqlJsonValueEmptyOrErrorBehavior.NULL, null, (Matcher<Object>)CoreMatchers.nullValue());
        this.assertJsonValueAny(JsonFunctions.JsonPathContext.withStrictException((Exception)new Exception("test message")), SqlJsonValueEmptyOrErrorBehavior.NULL, null, SqlJsonValueEmptyOrErrorBehavior.DEFAULT, "empty", (Matcher<Object>)CoreMatchers.is((Object)"empty"));
        this.assertJsonValueAnyFailed(JsonFunctions.JsonPathContext.withStrictException((Exception)new Exception("test message")), SqlJsonValueEmptyOrErrorBehavior.NULL, null, SqlJsonValueEmptyOrErrorBehavior.ERROR, null, this.errorMatches(new RuntimeException("java.lang.Exception: test message")));
        this.assertJsonValueAny(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.STRICT, Collections.emptyList()), SqlJsonValueEmptyOrErrorBehavior.NULL, null, SqlJsonValueEmptyOrErrorBehavior.NULL, null, (Matcher<Object>)CoreMatchers.nullValue());
        this.assertJsonValueAny(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.STRICT, Collections.emptyList()), SqlJsonValueEmptyOrErrorBehavior.NULL, null, SqlJsonValueEmptyOrErrorBehavior.DEFAULT, "empty", (Matcher<Object>)CoreMatchers.is((Object)"empty"));
        this.assertJsonValueAnyFailed(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.STRICT, Collections.emptyList()), SqlJsonValueEmptyOrErrorBehavior.NULL, null, SqlJsonValueEmptyOrErrorBehavior.ERROR, null, this.errorMatches(new CalciteException("Strict jsonpath mode requires scalar value, and the actual value is: '[]'", null)));
    }

    @Test
    public void testJsonQuery() {
        this.assertJsonQuery(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, Collections.singletonList("bar")), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.is((Object)"[\"bar\"]"));
        this.assertJsonQuery(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, null), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.nullValue());
        this.assertJsonQuery(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, null), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.EMPTY_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.is((Object)"[]"));
        this.assertJsonQuery(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, null), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.EMPTY_OBJECT, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.is((Object)"{}"));
        this.assertJsonQueryFailed(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, null), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.ERROR, SqlJsonQueryEmptyOrErrorBehavior.NULL, this.errorMatches(new CalciteException("Empty result of JSON_QUERY function is not allowed", null)));
        this.assertJsonQuery(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, (Object)"bar"), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.nullValue());
        this.assertJsonQuery(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, (Object)"bar"), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.EMPTY_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.is((Object)"[]"));
        this.assertJsonQuery(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, (Object)"bar"), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.EMPTY_OBJECT, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.is((Object)"{}"));
        this.assertJsonQueryFailed(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, (Object)"bar"), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.ERROR, SqlJsonQueryEmptyOrErrorBehavior.NULL, this.errorMatches(new CalciteException("Empty result of JSON_QUERY function is not allowed", null)));
        this.assertJsonQuery(JsonFunctions.JsonPathContext.withStrictException((Exception)new Exception("test message")), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.EMPTY_ARRAY, (Matcher<? super String>)CoreMatchers.is((Object)"[]"));
        this.assertJsonQuery(JsonFunctions.JsonPathContext.withStrictException((Exception)new Exception("test message")), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.EMPTY_OBJECT, (Matcher<? super String>)CoreMatchers.is((Object)"{}"));
        this.assertJsonQueryFailed(JsonFunctions.JsonPathContext.withStrictException((Exception)new Exception("test message")), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.ERROR, this.errorMatches(new RuntimeException("java.lang.Exception: test message")));
        this.assertJsonQuery(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.STRICT, (Object)"bar"), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.nullValue());
        this.assertJsonQuery(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.STRICT, (Object)"bar"), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.EMPTY_ARRAY, (Matcher<? super String>)CoreMatchers.is((Object)"[]"));
        this.assertJsonQueryFailed(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.STRICT, (Object)"bar"), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.ERROR, this.errorMatches(new CalciteException("Strict jsonpath mode requires array or object value, and the actual value is: 'bar'", null)));
        this.assertJsonQuery(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.STRICT, (Object)"bar"), SqlJsonQueryWrapperBehavior.WITH_UNCONDITIONAL_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.is((Object)"[\"bar\"]"));
        this.assertJsonQuery(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.STRICT, (Object)"bar"), SqlJsonQueryWrapperBehavior.WITH_CONDITIONAL_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.is((Object)"[\"bar\"]"));
        this.assertJsonQuery(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.STRICT, Collections.singletonList("bar")), SqlJsonQueryWrapperBehavior.WITH_UNCONDITIONAL_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.is((Object)"[[\"bar\"]]"));
        this.assertJsonQuery(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.STRICT, Collections.singletonList("bar")), SqlJsonQueryWrapperBehavior.WITH_CONDITIONAL_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.is((Object)"[\"bar\"]"));
    }

    @Test
    public void testJsonize() {
        this.assertJsonize(new HashMap(), (Matcher<? super String>)CoreMatchers.is((Object)"{}"));
    }

    @Test
    public void assertJsonPretty() {
        this.assertJsonPretty(JsonFunctions.JsonValueContext.withJavaObj(new HashMap()), (Matcher<? super String>)CoreMatchers.is((Object)"{ }"));
        this.assertJsonPretty(JsonFunctions.JsonValueContext.withJavaObj((Object)Longs.asList((long[])new long[]{1L, 2L})), (Matcher<? super String>)CoreMatchers.is((Object)"[ 1, 2 ]"));
        Object input = new Object(){
            private final Object self = this;
        };
        CalciteException expected = new CalciteException("Cannot serialize object to JSON: '" + input + "'", null);
        this.assertJsonPrettyFailed(JsonFunctions.JsonValueContext.withJavaObj((Object)input), this.errorMatches(expected));
    }

    @Test
    public void testDejsonize() {
        this.assertDejsonize("{}", (Matcher<Object>)CoreMatchers.is(Collections.emptyMap()));
        this.assertDejsonize("[]", (Matcher<Object>)CoreMatchers.is(Collections.emptyList()));
        String message = "com.fasterxml.jackson.core.JsonParseException: Unexpected close marker '}': expected ']' (for Array starting at [Source: (String)\"[}\"; line: 1, column: 1])\n at [Source: (String)\"[}\"; line: 1, column: 3]";
        this.assertDejsonizeFailed("[}", this.errorMatches((Throwable)new InvalidJsonException("com.fasterxml.jackson.core.JsonParseException: Unexpected close marker '}': expected ']' (for Array starting at [Source: (String)\"[}\"; line: 1, column: 1])\n at [Source: (String)\"[}\"; line: 1, column: 3]")));
    }

    @Test
    public void testJsonObject() {
        this.assertJsonObject((Matcher<? super String>)CoreMatchers.is((Object)"{}"), SqlJsonConstructorNullClause.NULL_ON_NULL, new Object[0]);
        this.assertJsonObject((Matcher<? super String>)CoreMatchers.is((Object)"{\"foo\":\"bar\"}"), SqlJsonConstructorNullClause.NULL_ON_NULL, "foo", "bar");
        this.assertJsonObject((Matcher<? super String>)CoreMatchers.is((Object)"{\"foo\":null}"), SqlJsonConstructorNullClause.NULL_ON_NULL, "foo", null);
        this.assertJsonObject((Matcher<? super String>)CoreMatchers.is((Object)"{}"), SqlJsonConstructorNullClause.ABSENT_ON_NULL, "foo", null);
    }

    @Test
    public void testJsonType() {
        this.assertJsonType((Matcher<? super String>)CoreMatchers.is((Object)"OBJECT"), "{}");
        this.assertJsonType((Matcher<? super String>)CoreMatchers.is((Object)"ARRAY"), "[\"foo\",null]");
        this.assertJsonType((Matcher<? super String>)CoreMatchers.is((Object)"NULL"), "null");
        this.assertJsonType((Matcher<? super String>)CoreMatchers.is((Object)"BOOLEAN"), "false");
        this.assertJsonType((Matcher<? super String>)CoreMatchers.is((Object)"INTEGER"), "12");
        this.assertJsonType((Matcher<? super String>)CoreMatchers.is((Object)"DOUBLE"), "11.22");
    }

    @Test
    public void testJsonDepth() {
        this.assertJsonDepth((Matcher<? super Integer>)CoreMatchers.is((Object)1), "{}");
        this.assertJsonDepth((Matcher<? super Integer>)CoreMatchers.is((Object)1), "false");
        this.assertJsonDepth((Matcher<? super Integer>)CoreMatchers.is((Object)1), "12");
        this.assertJsonDepth((Matcher<? super Integer>)CoreMatchers.is((Object)1), "11.22");
        this.assertJsonDepth((Matcher<? super Integer>)CoreMatchers.is((Object)2), "[\"foo\",null]");
        this.assertJsonDepth((Matcher<? super Integer>)CoreMatchers.is((Object)3), "{\"a\": [10, true]}");
        this.assertJsonDepth((Matcher<? super Integer>)CoreMatchers.nullValue(), "null");
    }

    @Test
    public void testJsonLength() {
        this.assertJsonLength(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, Collections.singletonList("bar")), (Matcher<? super Integer>)CoreMatchers.is((Object)1));
        this.assertJsonLength(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, null), (Matcher<? super Integer>)CoreMatchers.nullValue());
        this.assertJsonLength(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.STRICT, Collections.singletonList("bar")), (Matcher<? super Integer>)CoreMatchers.is((Object)1));
        this.assertJsonLength(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, (Object)"bar"), (Matcher<? super Integer>)CoreMatchers.is((Object)1));
    }

    @Test
    public void testJsonKeys() {
        this.assertJsonKeys(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, Collections.singletonList("bar")), (Matcher<? super String>)CoreMatchers.is((Object)"null"));
        this.assertJsonKeys(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, null), (Matcher<? super String>)CoreMatchers.is((Object)"null"));
        this.assertJsonKeys(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.STRICT, Collections.singletonList("bar")), (Matcher<? super String>)CoreMatchers.is((Object)"null"));
        this.assertJsonKeys(JsonFunctions.JsonPathContext.withJavaObj((JsonFunctions.PathMode)JsonFunctions.PathMode.LAX, (Object)"bar"), (Matcher<? super String>)CoreMatchers.is((Object)"null"));
    }

    @Test
    public void testJsonRemove() {
        this.assertJsonRemove(JsonFunctions.jsonValueExpression((String)"{\"a\": 1, \"b\": [2]}"), new String[]{"$.a"}, (Matcher<? super String>)CoreMatchers.is((Object)"{\"b\":[2]}"));
        this.assertJsonRemove(JsonFunctions.jsonValueExpression((String)"{\"a\": 1, \"b\": [2]}"), new String[]{"$.a", "$.b"}, (Matcher<? super String>)CoreMatchers.is((Object)"{}"));
    }

    @Test
    public void testJsonStorageSize() {
        this.assertJsonStorageSize("[100, \"sakila\", [1, 3, 5], 425.05]", (Matcher<? super Integer>)CoreMatchers.is((Object)29));
        this.assertJsonStorageSize("null", (Matcher<? super Integer>)CoreMatchers.is((Object)4));
        this.assertJsonStorageSize(JsonFunctions.JsonValueContext.withJavaObj(null), (Matcher<? super Integer>)CoreMatchers.is((Object)4));
    }

    @Test
    public void testJsonObjectAggAdd() {
        HashMap map = new HashMap();
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("foo", "bar");
        this.assertJsonObjectAggAdd(map, "foo", "bar", SqlJsonConstructorNullClause.NULL_ON_NULL, (Matcher<? super Map>)CoreMatchers.is(expected));
        expected.put("foo1", null);
        this.assertJsonObjectAggAdd(map, "foo1", null, SqlJsonConstructorNullClause.NULL_ON_NULL, (Matcher<? super Map>)CoreMatchers.is(expected));
        this.assertJsonObjectAggAdd(map, "foo2", null, SqlJsonConstructorNullClause.ABSENT_ON_NULL, (Matcher<? super Map>)CoreMatchers.is(expected));
    }

    @Test
    public void testJsonArray() {
        this.assertJsonArray((Matcher<? super String>)CoreMatchers.is((Object)"[]"), SqlJsonConstructorNullClause.NULL_ON_NULL, new Object[0]);
        this.assertJsonArray((Matcher<? super String>)CoreMatchers.is((Object)"[\"foo\"]"), SqlJsonConstructorNullClause.NULL_ON_NULL, "foo");
        this.assertJsonArray((Matcher<? super String>)CoreMatchers.is((Object)"[\"foo\",null]"), SqlJsonConstructorNullClause.NULL_ON_NULL, "foo", null);
        this.assertJsonArray((Matcher<? super String>)CoreMatchers.is((Object)"[\"foo\"]"), SqlJsonConstructorNullClause.ABSENT_ON_NULL, "foo", null);
    }

    @Test
    public void testJsonArrayAggAdd() {
        ArrayList list = new ArrayList();
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("foo");
        this.assertJsonArrayAggAdd(list, "foo", SqlJsonConstructorNullClause.NULL_ON_NULL, (Matcher<? super List>)CoreMatchers.is(expected));
        expected.add(null);
        this.assertJsonArrayAggAdd(list, null, SqlJsonConstructorNullClause.NULL_ON_NULL, (Matcher<? super List>)CoreMatchers.is(expected));
        this.assertJsonArrayAggAdd(list, null, SqlJsonConstructorNullClause.ABSENT_ON_NULL, (Matcher<? super List>)CoreMatchers.is(expected));
    }

    @Test
    public void testJsonPredicate() {
        this.assertIsJsonValue("[]", (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertIsJsonValue("{}", (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertIsJsonValue("100", (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertIsJsonValue("{]", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertIsJsonObject("[]", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertIsJsonObject("{}", (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertIsJsonObject("100", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertIsJsonObject("{]", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertIsJsonArray("[]", (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertIsJsonArray("{}", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertIsJsonArray("100", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertIsJsonArray("{]", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertIsJsonScalar("[]", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertIsJsonScalar("{}", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertIsJsonScalar("100", (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertIsJsonScalar("{]", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
    }

    private void assertJsonValueExpression(String input, Matcher<? super JsonFunctions.JsonValueContext> matcher) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.JSON_VALUE_EXPRESSION.getMethodName(), input), (Object)JsonFunctions.jsonValueExpression((String)input), matcher);
    }

    private void assertJsonApiCommonSyntax(String input, String pathSpec, Matcher<? super JsonFunctions.JsonPathContext> matcher) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.JSON_API_COMMON_SYNTAX.getMethodName(), input, pathSpec), (Object)JsonFunctions.jsonApiCommonSyntax((String)input, (String)pathSpec), matcher);
    }

    private void assertJsonApiCommonSyntax(JsonFunctions.JsonValueContext input, String pathSpec, Matcher<? super JsonFunctions.JsonPathContext> matcher) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.JSON_API_COMMON_SYNTAX.getMethodName(), input, pathSpec), (Object)JsonFunctions.jsonApiCommonSyntax((JsonFunctions.JsonValueContext)input, (String)pathSpec), matcher);
    }

    private void assertJsonExists(JsonFunctions.JsonPathContext context, SqlJsonExistsErrorBehavior errorBehavior, Matcher<? super Boolean> matcher) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.JSON_EXISTS.getMethodName(), context, errorBehavior), (Object)JsonFunctions.jsonExists((JsonFunctions.JsonPathContext)context, (SqlJsonExistsErrorBehavior)errorBehavior), matcher);
    }

    private void assertJsonExistsFailed(JsonFunctions.JsonPathContext context, SqlJsonExistsErrorBehavior errorBehavior, Matcher<? super Throwable> matcher) {
        this.assertFailed(this.invocationDesc(BuiltInMethod.JSON_EXISTS.getMethodName(), context, errorBehavior), () -> JsonFunctions.jsonExists((JsonFunctions.JsonPathContext)context, (SqlJsonExistsErrorBehavior)errorBehavior), matcher);
    }

    private void assertJsonValueAny(JsonFunctions.JsonPathContext context, SqlJsonValueEmptyOrErrorBehavior emptyBehavior, Object defaultValueOnEmpty, SqlJsonValueEmptyOrErrorBehavior errorBehavior, Object defaultValueOnError, Matcher<Object> matcher) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.JSON_VALUE_ANY.getMethodName(), context, emptyBehavior, defaultValueOnEmpty, errorBehavior, defaultValueOnError), (Object)JsonFunctions.jsonValueAny((JsonFunctions.JsonPathContext)context, (SqlJsonValueEmptyOrErrorBehavior)emptyBehavior, (Object)defaultValueOnEmpty, (SqlJsonValueEmptyOrErrorBehavior)errorBehavior, (Object)defaultValueOnError), matcher);
    }

    private void assertJsonValueAnyFailed(JsonFunctions.JsonPathContext input, SqlJsonValueEmptyOrErrorBehavior emptyBehavior, Object defaultValueOnEmpty, SqlJsonValueEmptyOrErrorBehavior errorBehavior, Object defaultValueOnError, Matcher<? super Throwable> matcher) {
        this.assertFailed(this.invocationDesc(BuiltInMethod.JSON_VALUE_ANY.getMethodName(), input, emptyBehavior, defaultValueOnEmpty, errorBehavior, defaultValueOnError), () -> JsonFunctions.jsonValueAny((JsonFunctions.JsonPathContext)input, (SqlJsonValueEmptyOrErrorBehavior)emptyBehavior, (Object)defaultValueOnEmpty, (SqlJsonValueEmptyOrErrorBehavior)errorBehavior, (Object)defaultValueOnError), matcher);
    }

    private void assertJsonQuery(JsonFunctions.JsonPathContext input, SqlJsonQueryWrapperBehavior wrapperBehavior, SqlJsonQueryEmptyOrErrorBehavior emptyBehavior, SqlJsonQueryEmptyOrErrorBehavior errorBehavior, Matcher<? super String> matcher) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.JSON_QUERY.getMethodName(), input, wrapperBehavior, emptyBehavior, errorBehavior), (Object)JsonFunctions.jsonQuery((JsonFunctions.JsonPathContext)input, (SqlJsonQueryWrapperBehavior)wrapperBehavior, (SqlJsonQueryEmptyOrErrorBehavior)emptyBehavior, (SqlJsonQueryEmptyOrErrorBehavior)errorBehavior), matcher);
    }

    private void assertJsonQueryFailed(JsonFunctions.JsonPathContext input, SqlJsonQueryWrapperBehavior wrapperBehavior, SqlJsonQueryEmptyOrErrorBehavior emptyBehavior, SqlJsonQueryEmptyOrErrorBehavior errorBehavior, Matcher<? super Throwable> matcher) {
        this.assertFailed(this.invocationDesc(BuiltInMethod.JSON_QUERY.getMethodName(), input, wrapperBehavior, emptyBehavior, errorBehavior), () -> JsonFunctions.jsonQuery((JsonFunctions.JsonPathContext)input, (SqlJsonQueryWrapperBehavior)wrapperBehavior, (SqlJsonQueryEmptyOrErrorBehavior)emptyBehavior, (SqlJsonQueryEmptyOrErrorBehavior)errorBehavior), matcher);
    }

    private void assertJsonize(Object input, Matcher<? super String> matcher) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.JSONIZE.getMethodName(), input), (Object)JsonFunctions.jsonize((Object)input), matcher);
    }

    private void assertJsonPretty(JsonFunctions.JsonValueContext input, Matcher<? super String> matcher) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.JSON_PRETTY.getMethodName(), input), (Object)JsonFunctions.jsonPretty((JsonFunctions.JsonValueContext)input), matcher);
    }

    private void assertJsonPrettyFailed(JsonFunctions.JsonValueContext input, Matcher<? super Throwable> matcher) {
        this.assertFailed(this.invocationDesc(BuiltInMethod.JSON_PRETTY.getMethodName(), input), () -> JsonFunctions.jsonPretty((JsonFunctions.JsonValueContext)input), matcher);
    }

    private void assertJsonLength(JsonFunctions.JsonPathContext input, Matcher<? super Integer> matcher) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.JSON_LENGTH.getMethodName(), input), (Object)JsonFunctions.jsonLength((JsonFunctions.JsonPathContext)input), matcher);
    }

    private void assertJsonLengthFailed(JsonFunctions.JsonValueContext input, Matcher<? super Throwable> matcher) {
        this.assertFailed(this.invocationDesc(BuiltInMethod.JSON_LENGTH.getMethodName(), input), () -> JsonFunctions.jsonLength((JsonFunctions.JsonValueContext)input), matcher);
    }

    private void assertJsonKeys(JsonFunctions.JsonPathContext input, Matcher<? super String> matcher) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.JSON_KEYS.getMethodName(), input), (Object)JsonFunctions.jsonKeys((JsonFunctions.JsonPathContext)input), matcher);
    }

    private void assertJsonKeysFailed(JsonFunctions.JsonValueContext input, Matcher<? super Throwable> matcher) {
        this.assertFailed(this.invocationDesc(BuiltInMethod.JSON_KEYS.getMethodName(), input), () -> JsonFunctions.jsonKeys((JsonFunctions.JsonValueContext)input), matcher);
    }

    private void assertJsonRemove(JsonFunctions.JsonValueContext input, String[] pathSpecs, Matcher<? super String> matcher) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.JSON_REMOVE.getMethodName(), input, pathSpecs), (Object)JsonFunctions.jsonRemove((JsonFunctions.JsonValueContext)input, (String[])pathSpecs), matcher);
    }

    private void assertJsonStorageSize(String input, Matcher<? super Integer> matcher) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.JSON_STORAGE_SIZE.getMethodName(), input), (Object)JsonFunctions.jsonStorageSize((String)input), matcher);
    }

    private void assertJsonStorageSize(JsonFunctions.JsonValueContext input, Matcher<? super Integer> matcher) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.JSON_STORAGE_SIZE.getMethodName(), input), (Object)JsonFunctions.jsonStorageSize((JsonFunctions.JsonValueContext)input), matcher);
    }

    private void assertJsonStorageSizeFailed(String input, Matcher<? super Throwable> matcher) {
        this.assertFailed(this.invocationDesc(BuiltInMethod.JSON_STORAGE_SIZE.getMethodName(), input), () -> JsonFunctions.jsonStorageSize((String)input), matcher);
    }

    private void assertDejsonize(String input, Matcher<Object> matcher) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.DEJSONIZE.getMethodName(), input), (Object)JsonFunctions.dejsonize((String)input), matcher);
    }

    private void assertDejsonizeFailed(String input, Matcher<? super Throwable> matcher) {
        this.assertFailed(this.invocationDesc(BuiltInMethod.DEJSONIZE.getMethodName(), input), () -> JsonFunctions.dejsonize((String)input), matcher);
    }

    private void assertJsonObject(Matcher<? super String> matcher, SqlJsonConstructorNullClause nullClause, Object ... kvs) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.JSON_OBJECT.getMethodName(), nullClause, kvs), (Object)JsonFunctions.jsonObject((SqlJsonConstructorNullClause)nullClause, (Object[])kvs), matcher);
    }

    private void assertJsonType(Matcher<? super String> matcher, String input) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.JSON_TYPE.getMethodName(), input), (Object)JsonFunctions.jsonType((String)input), matcher);
    }

    private void assertJsonDepth(Matcher<? super Integer> matcher, String input) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.JSON_DEPTH.getMethodName(), input), (Object)JsonFunctions.jsonDepth((String)input), matcher);
    }

    private void assertJsonObjectAggAdd(Map map, String k, Object v, SqlJsonConstructorNullClause nullClause, Matcher<? super Map> matcher) {
        JsonFunctions.jsonObjectAggAdd((Map)map, (String)k, (Object)v, (SqlJsonConstructorNullClause)nullClause);
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.JSON_ARRAYAGG_ADD.getMethodName(), map, k, v, nullClause), (Object)map, matcher);
    }

    private void assertJsonArray(Matcher<? super String> matcher, SqlJsonConstructorNullClause nullClause, Object ... elements) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.JSON_ARRAY.getMethodName(), nullClause, elements), (Object)JsonFunctions.jsonArray((SqlJsonConstructorNullClause)nullClause, (Object[])elements), matcher);
    }

    private void assertJsonArrayAggAdd(List list, Object element, SqlJsonConstructorNullClause nullClause, Matcher<? super List> matcher) {
        JsonFunctions.jsonArrayAggAdd((List)list, (Object)element, (SqlJsonConstructorNullClause)nullClause);
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.JSON_ARRAYAGG_ADD.getMethodName(), list, element, nullClause), (Object)list, matcher);
    }

    private void assertIsJsonValue(String input, Matcher<? super Boolean> matcher) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.IS_JSON_VALUE.getMethodName(), input), (Object)JsonFunctions.isJsonValue((String)input), matcher);
    }

    private void assertIsJsonScalar(String input, Matcher<? super Boolean> matcher) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.IS_JSON_SCALAR.getMethodName(), input), (Object)JsonFunctions.isJsonScalar((String)input), matcher);
    }

    private void assertIsJsonArray(String input, Matcher<? super Boolean> matcher) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.IS_JSON_ARRAY.getMethodName(), input), (Object)JsonFunctions.isJsonArray((String)input), matcher);
    }

    private void assertIsJsonObject(String input, Matcher<? super Boolean> matcher) {
        Assert.assertThat((String)this.invocationDesc(BuiltInMethod.IS_JSON_OBJECT.getMethodName(), input), (Object)JsonFunctions.isJsonObject((String)input), matcher);
    }

    private String invocationDesc(String methodName, Object ... args) {
        return methodName + "(" + String.join((CharSequence)", ", Arrays.stream(args).map(Objects::toString).collect(Collectors.toList())) + ")";
    }

    private void assertFailed(String invocationDesc, Supplier<?> supplier, Matcher<? super Throwable> matcher) {
        try {
            supplier.get();
            Assert.fail((String)("expect exception, but not: " + invocationDesc));
        }
        catch (Throwable t) {
            Assert.assertThat((String)invocationDesc, (Object)t, matcher);
        }
    }

    private Matcher<? super Throwable> errorMatches(final Throwable expected) {
        return new BaseMatcher<Throwable>(){

            public boolean matches(Object item) {
                if (!(item instanceof Throwable)) {
                    return false;
                }
                Throwable error = (Throwable)item;
                return expected != null && Objects.equals(error.getClass(), expected.getClass()) && Objects.equals(error.getMessage(), expected.getMessage());
            }

            public void describeTo(Description description) {
                description.appendText("is ").appendText(expected.toString());
            }
        };
    }

    @Nonnull
    private BaseMatcher<JsonFunctions.JsonPathContext> contextMatches(final JsonFunctions.JsonPathContext expected) {
        return new BaseMatcher<JsonFunctions.JsonPathContext>(){

            public boolean matches(Object item) {
                if (!(item instanceof JsonFunctions.JsonPathContext)) {
                    return false;
                }
                JsonFunctions.JsonPathContext context = (JsonFunctions.JsonPathContext)item;
                if (Objects.equals(context.mode, expected.mode) && Objects.equals(context.obj, expected.obj)) {
                    if (context.exc == null && expected.exc == null) {
                        return true;
                    }
                    return context.exc != null && expected.exc != null && Objects.equals(context.exc.getClass(), expected.exc.getClass()) && Objects.equals(context.exc.getMessage(), expected.exc.getMessage());
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("is ").appendText(expected.toString());
            }
        };
    }
}

