/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.test.DiffRepository;
import org.apache.calcite.test.SqlToRelTestBase;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Closer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

abstract class RelOptTestBase
extends SqlToRelTestBase {
    RelOptTestBase() {
    }

    @Override
    protected SqlToRelTestBase.Tester createTester() {
        return super.createTester().withDecorrelation(false);
    }

    protected SqlToRelTestBase.Tester createDynamicTester() {
        return this.getTesterWithDynamicTable();
    }

    protected void checkPlanning(RelOptRule rule, String sql) {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addRuleInstance(rule);
        this.checkPlanning(programBuilder.build(), sql);
    }

    protected void checkPlanningDynamic(RelOptRule rule, String sql) {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addRuleInstance(rule);
        this.checkPlanning(this.createDynamicTester(), null, (RelOptPlanner)new HepPlanner(programBuilder.build()), sql);
    }

    protected void checkPlanningDynamic(String sql) {
        this.checkPlanning(this.createDynamicTester(), null, (RelOptPlanner)new HepPlanner(HepProgram.builder().build()), sql);
    }

    protected void checkPlanning(HepProgram program, String sql) {
        this.checkPlanning((RelOptPlanner)new HepPlanner(program), sql);
    }

    protected void checkPlanning(RelOptPlanner planner, String sql) {
        this.checkPlanning(this.tester, null, planner, sql);
    }

    protected void checkPlanUnchanged(RelOptPlanner planner, String sql) {
        this.checkPlanning(this.tester, null, planner, sql, true);
    }

    protected void checkPlanning(SqlToRelTestBase.Tester tester, HepProgram preProgram, RelOptPlanner planner, String sql) {
        this.checkPlanning(tester, preProgram, planner, sql, false);
    }

    protected void checkPlanning(SqlToRelTestBase.Tester tester, HepProgram preProgram, RelOptPlanner planner, String sql, boolean unchanged) {
        RelNode relBefore;
        DiffRepository diffRepos = this.getDiffRepos();
        String sql2 = diffRepos.expand("sql", sql);
        RelRoot root = tester.convertSqlToRel(sql2);
        RelNode relInitial = root.rel;
        Assert.assertTrue((relInitial != null ? 1 : 0) != 0);
        ArrayList<DefaultRelMetadataProvider> list = new ArrayList<DefaultRelMetadataProvider>();
        list.add(DefaultRelMetadataProvider.INSTANCE);
        planner.registerMetadataProviders(list);
        RelMetadataProvider plannerChain = ChainedRelMetadataProvider.of(list);
        RelOptCluster cluster = relInitial.getCluster();
        cluster.setMetadataProvider(plannerChain);
        if (preProgram == null) {
            relBefore = relInitial;
        } else {
            HepPlanner prePlanner = new HepPlanner(preProgram);
            prePlanner.setRoot(relInitial);
            relBefore = prePlanner.findBestExp();
        }
        Assert.assertThat((Object)relBefore, (Matcher)CoreMatchers.notNullValue());
        String planBefore = NL + RelOptUtil.toString((RelNode)relBefore);
        diffRepos.assertEquals("planBefore", "${planBefore}", planBefore);
        SqlToRelTestBase.assertValid(relBefore);
        planner.setRoot(relBefore);
        RelNode r = planner.findBestExp();
        if (tester.isLateDecorrelate()) {
            String planMid = NL + RelOptUtil.toString((RelNode)r);
            diffRepos.assertEquals("planMid", "${planMid}", planMid);
            SqlToRelTestBase.assertValid(r);
            RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(cluster, null);
            r = RelDecorrelator.decorrelateQuery((RelNode)r, (RelBuilder)relBuilder);
        }
        String planAfter = NL + RelOptUtil.toString((RelNode)r);
        if (unchanged) {
            Assert.assertThat((Object)planAfter, (Matcher)CoreMatchers.is((Object)planBefore));
        } else {
            diffRepos.assertEquals("planAfter", "${planAfter}", planAfter);
            if (planBefore.equals(planAfter)) {
                throw new AssertionError((Object)"Expected plan before and after is the same.\nYou must use unchanged=true or call checkUnchanged");
            }
        }
        SqlToRelTestBase.assertValid(r);
    }

    Sql sql(String sql) {
        return new Sql(sql, null, null, (ImmutableMap<Hook, Consumer>)ImmutableMap.of(), (ImmutableList<java.util.function.Function<SqlToRelTestBase.Tester, SqlToRelTestBase.Tester>>)ImmutableList.of());
    }

    class Sql {
        private final String sql;
        private HepProgram preProgram;
        private final HepPlanner hepPlanner;
        private final ImmutableMap<Hook, Consumer> hooks;
        private ImmutableList<java.util.function.Function<SqlToRelTestBase.Tester, SqlToRelTestBase.Tester>> transforms;

        Sql(String sql, HepProgram preProgram, HepPlanner hepPlanner, ImmutableMap<Hook, Consumer> hooks, ImmutableList<java.util.function.Function<SqlToRelTestBase.Tester, SqlToRelTestBase.Tester>> transforms) {
            this.sql = sql;
            this.preProgram = preProgram;
            this.hepPlanner = hepPlanner;
            this.hooks = hooks;
            this.transforms = transforms;
        }

        public Sql withPre(HepProgram preProgram) {
            return new Sql(this.sql, preProgram, this.hepPlanner, this.hooks, this.transforms);
        }

        public Sql with(HepPlanner hepPlanner) {
            return new Sql(this.sql, this.preProgram, hepPlanner, this.hooks, this.transforms);
        }

        public Sql with(HepProgram program) {
            return new Sql(this.sql, this.preProgram, new HepPlanner(program), this.hooks, this.transforms);
        }

        public Sql withRule(RelOptRule rule) {
            return this.with(HepProgram.builder().addRuleInstance(rule).build());
        }

        private Sql withTransform(java.util.function.Function<SqlToRelTestBase.Tester, SqlToRelTestBase.Tester> transform) {
            return new Sql(this.sql, this.preProgram, this.hepPlanner, this.hooks, (ImmutableList<java.util.function.Function<SqlToRelTestBase.Tester, SqlToRelTestBase.Tester>>)FlatLists.append(this.transforms, transform));
        }

        public <T> Sql withHook(Hook hook, Consumer<T> handler) {
            return new Sql(this.sql, this.preProgram, this.hepPlanner, (ImmutableMap<Hook, Consumer>)FlatLists.append(this.hooks, (Object)hook, handler), this.transforms);
        }

        @Deprecated
        public <T> Sql withHook(Hook hook, Function<T, Void> handler) {
            return this.withHook(hook, arg_0 -> handler.apply(arg_0));
        }

        public <V> Sql withProperty(Hook hook, V value) {
            return this.withHook(hook, Hook.propertyJ(value));
        }

        public Sql expand(boolean b) {
            return this.withTransform(tester -> tester.withExpand(b));
        }

        public Sql withLateDecorrelation(boolean b) {
            return this.withTransform(tester -> tester.withLateDecorrelation(b));
        }

        public Sql withDecorrelation(boolean b) {
            return this.withTransform(tester -> tester.withDecorrelation(b));
        }

        public Sql withTrim(boolean b) {
            return this.withTransform(tester -> tester.withTrim(b));
        }

        public Sql withContext(Context context) {
            return this.withTransform(tester -> tester.withContext(context));
        }

        public void check() {
            this.check(false);
        }

        public void checkUnchanged() {
            this.check(true);
        }

        private void check(boolean unchanged) {
            try (Closer closer = new Closer();){
                for (Map.Entry entry : this.hooks.entrySet()) {
                    closer.add((AutoCloseable)((Hook)entry.getKey()).addThread((Consumer)entry.getValue()));
                }
                SqlToRelTestBase.Tester t = RelOptTestBase.this.tester;
                for (java.util.function.Function transform : this.transforms) {
                    t = (SqlToRelTestBase.Tester)transform.apply(t);
                }
                RelOptTestBase.this.checkPlanning(t, this.preProgram, (RelOptPlanner)this.hepPlanner, this.sql, unchanged);
            }
        }
    }
}

