/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.JdbcTest;
import org.apache.calcite.util.TestUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class JdbcFrontLinqBackTest {
    @Test
    public void testSelect() {
        CalciteAssert.hr().query("select *\nfrom \"foodmart\".\"sales_fact_1997\" as s\nwhere s.\"cust_id\" = 100").returns("cust_id=100; prod_id=10\n");
    }

    @Test
    public void testJoin() {
        CalciteAssert.hr().query("select *\nfrom \"foodmart\".\"sales_fact_1997\" as s\njoin \"hr\".\"emps\" as e\non e.\"empid\" = s.\"cust_id\"").returnsUnordered("cust_id=100; prod_id=10; empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000", "cust_id=150; prod_id=20; empid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null");
    }

    @Test
    public void testGroupBy() {
        CalciteAssert.hr().query("select \"deptno\", sum(\"empid\") as s, count(*) as c\nfrom \"hr\".\"emps\" as e\ngroup by \"deptno\"").returns("deptno=20; S=200; C=1\ndeptno=10; S=360; C=3\n");
    }

    @Test
    public void testOrderBy() {
        CalciteAssert.hr().query("select upper(\"name\") as un, \"deptno\"\nfrom \"hr\".\"emps\" as e\norder by \"deptno\", \"name\" desc").explainContains("EnumerableSort(sort0=[$1], sort1=[$2], dir0=[ASC], dir1=[DESC])\n  EnumerableCalc(expr#0..4=[{inputs}], expr#5=[UPPER($t2)], UN=[$t5], deptno=[$t1], name=[$t2])\n    EnumerableTableScan(table=[[hr, emps]])").returns("UN=THEODORE; deptno=10\nUN=SEBASTIAN; deptno=10\nUN=BILL; deptno=10\nUN=ERIC; deptno=20\n");
    }

    @Test
    public void testUnionAllOrderBy() {
        CalciteAssert.hr().query("select \"name\"\nfrom \"hr\".\"emps\" as e\nunion all\nselect \"name\"\nfrom \"hr\".\"depts\"\norder by 1 desc").returns("name=Theodore\nname=Sebastian\nname=Sales\nname=Marketing\nname=HR\nname=Eric\nname=Bill\n");
    }

    @Test
    public void testUnion() {
        CalciteAssert.hr().query("select substring(\"name\" from 1 for 1) as x\nfrom \"hr\".\"emps\" as e\nunion\nselect substring(\"name\" from 1 for 1) as y\nfrom \"hr\".\"depts\"").returnsUnordered("X=T", "X=E", "X=S", "X=B", "X=M", "X=H");
    }

    @Test
    public void testIntersect() {
        CalciteAssert.hr().query("select substring(\"name\" from 1 for 1) as x\nfrom \"hr\".\"emps\" as e\nintersect\nselect substring(\"name\" from 1 for 1) as y\nfrom \"hr\".\"depts\"").returns("X=S\n");
    }

    @Ignore
    @Test
    public void testExcept() {
        CalciteAssert.hr().query("select substring(\"name\" from 1 for 1) as x\nfrom \"hr\".\"emps\" as e\nexcept\nselect substring(\"name\" from 1 for 1) as y\nfrom \"hr\".\"depts\"").returnsUnordered("X=T", "X=E", "X=B");
    }

    @Test
    public void testWhereBad() {
        CalciteAssert.hr().query("select *\nfrom \"foodmart\".\"sales_fact_1997\" as s\nwhere empid > 120").throws_("Column 'EMPID' not found in any table");
    }

    @Test
    public void testWhereOr() {
        CalciteAssert.hr().query("select * from \"hr\".\"emps\"\nwhere (\"empid\" = 100 or \"empid\" = 200)\nand \"deptno\" = 10").returns("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\n");
    }

    @Test
    public void testWhereLike() {
        CalciteAssert.hr().query("select *\nfrom \"hr\".\"emps\" as e\nwhere e.\"empid\" < 120 or e.\"name\" like 'S%'").returns("empid=100; deptno=10; name=Bill; salary=10000.0; commission=1000\nempid=150; deptno=10; name=Sebastian; salary=7000.0; commission=null\nempid=110; deptno=10; name=Theodore; salary=11500.0; commission=250\n");
    }

    @Test
    public void testInsert() {
        ArrayList<JdbcTest.Employee> employees = new ArrayList<JdbcTest.Employee>();
        CalciteAssert.AssertThat with = this.mutable(employees);
        with.query("select * from \"foo\".\"bar\"").returns("empid=0; deptno=0; name=first; salary=0.0; commission=null\n");
        with.query("insert into \"foo\".\"bar\" select * from \"hr\".\"emps\"").updates(4);
        with.query("select count(*) as c from \"foo\".\"bar\"").returns("C=5\n");
        with.query("insert into \"foo\".\"bar\" select * from \"hr\".\"emps\" where \"deptno\" = 10").updates(3);
        with.query("select \"name\", count(*) as c from \"foo\".\"bar\" group by \"name\"").returnsUnordered("name=Bill; C=2", "name=Eric; C=1", "name=Theodore; C=2", "name=first; C=1", "name=Sebastian; C=2");
    }

    @Test
    public void testInsertBind() throws Exception {
        ArrayList<JdbcTest.Employee> employees = new ArrayList<JdbcTest.Employee>();
        CalciteAssert.AssertThat with = this.mutable(employees);
        with.query("select count(*) as c from \"foo\".\"bar\"").returns("C=1\n");
        with.doWithConnection(c -> {
            try {
                String sql = "insert into \"foo\".\"bar\"\nvalues (?, 0, ?, 10.0, null)";
                try (PreparedStatement p = c.prepareStatement("insert into \"foo\".\"bar\"\nvalues (?, 0, ?, 10.0, null)");){
                    p.setInt(1, 1);
                    p.setString(2, "foo");
                    int count = p.executeUpdate();
                    Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Object)1));
                }
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        });
        with.query("select count(*) as c from \"foo\".\"bar\"").returns("C=2\n");
        with.query("select * from \"foo\".\"bar\"").returnsUnordered("empid=0; deptno=0; name=first; salary=0.0; commission=null", "empid=1; deptno=0; name=foo; salary=10.0; commission=null");
    }

    @Test
    public void testDelete() {
        ArrayList<JdbcTest.Employee> employees = new ArrayList<JdbcTest.Employee>();
        CalciteAssert.AssertThat with = this.mutable(employees);
        with.query("select * from \"foo\".\"bar\"").returnsUnordered("empid=0; deptno=0; name=first; salary=0.0; commission=null");
        with.query("insert into \"foo\".\"bar\" select * from \"hr\".\"emps\"").updates(4);
        with.query("select count(*) as c from \"foo\".\"bar\"").returnsUnordered("C=5");
        String deleteSql = "delete from \"foo\".\"bar\" where \"deptno\" = 10";
        with.query("delete from \"foo\".\"bar\" where \"deptno\" = 10").updates(3);
        String sql = "select \"name\", count(*) as c\nfrom \"foo\".\"bar\"\ngroup by \"name\"";
        with.query("select \"name\", count(*) as c\nfrom \"foo\".\"bar\"\ngroup by \"name\"").returnsUnordered("name=Eric; C=1", "name=first; C=1");
    }

    private static CalciteAssert.ConnectionPostProcessor makePostProcessor(List<JdbcTest.Employee> initialData) {
        return connection -> {
            CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
            SchemaPlus rootSchema = calciteConnection.getRootSchema();
            SchemaPlus mapSchema = rootSchema.add("foo", (Schema)new AbstractSchema());
            String tableName = "bar";
            JdbcTest.AbstractModifiableTable table = JdbcFrontLinqBackTest.mutable("bar", initialData);
            mapSchema.add("bar", (Table)table);
            return calciteConnection;
        };
    }

    public static Connection makeConnection(List<JdbcTest.Employee> initialData) throws Exception {
        Properties info = new Properties();
        Connection connection = DriverManager.getConnection("jdbc:calcite:", info);
        connection = JdbcFrontLinqBackTest.makePostProcessor(initialData).apply(connection);
        return connection;
    }

    public static Connection makeConnection() throws Exception {
        return JdbcFrontLinqBackTest.makeConnection(new ArrayList<JdbcTest.Employee>());
    }

    private CalciteAssert.AssertThat mutable(List<JdbcTest.Employee> employees) {
        employees.add(new JdbcTest.Employee(0, 0, "first", 0.0f, null));
        return CalciteAssert.that().with(CalciteAssert.Config.REGULAR).with(JdbcFrontLinqBackTest.makePostProcessor(employees));
    }

    static JdbcTest.AbstractModifiableTable mutable(String tableName, final List<JdbcTest.Employee> employees) {
        return new JdbcTest.AbstractModifiableTable(tableName){

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return ((JavaTypeFactory)typeFactory).createType(JdbcTest.Employee.class);
            }

            public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
                return new AbstractTableQueryable<T>(queryProvider, schema, (QueryableTable)this, tableName){

                    public Enumerator<T> enumerator() {
                        return Linq4j.enumerator((Collection)employees);
                    }
                };
            }

            public Type getElementType() {
                return JdbcTest.Employee.class;
            }

            public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
                return Schemas.tableExpression((SchemaPlus)schema, (Type)this.getElementType(), (String)tableName, (Class)clazz);
            }

            public Collection getModifiableCollection() {
                return employees;
            }
        };
    }

    @Test
    public void testInsert2() {
        ArrayList<JdbcTest.Employee> employees = new ArrayList<JdbcTest.Employee>();
        CalciteAssert.AssertThat with = this.mutable(employees);
        with.query("insert into \"foo\".\"bar\" values (1, 1, 'second', 2, 2)").updates(1);
        with.query("insert into \"foo\".\"bar\"\nvalues (1, 3, 'third', 0, 3), (1, 4, 'fourth', 0, 4), (1, 5, 'fifth ', 0, 3)").updates(3);
        with.query("select count(*) as c from \"foo\".\"bar\"").returns("C=5\n");
        with.query("insert into \"foo\".\"bar\" values (1, 6, null, 0, null)").updates(1);
        with.query("select count(*) as c from \"foo\".\"bar\"").returns("C=6\n");
    }

    @Test
    public void testInsert3() throws Exception {
        Connection connection = JdbcFrontLinqBackTest.makeConnection(new ArrayList<JdbcTest.Employee>());
        String sql = "insert into \"foo\".\"bar\" values (1, 1, 'second', 2, 2)";
        Statement statement = connection.createStatement();
        boolean status = statement.execute(sql);
        Assert.assertFalse((boolean)status);
        ResultSet resultSet = statement.getResultSet();
        Assert.assertTrue((resultSet == null ? 1 : 0) != 0);
        int updateCount = statement.getUpdateCount();
        Assert.assertTrue((updateCount == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testPreparedStatementInsert() throws Exception {
        Connection connection = JdbcFrontLinqBackTest.makeConnection(new ArrayList<JdbcTest.Employee>());
        Assert.assertFalse((boolean)connection.isClosed());
        String sql = "insert into \"foo\".\"bar\" values (1, 1, 'second', 2, 2)";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        Assert.assertFalse((boolean)preparedStatement.isClosed());
        boolean status = preparedStatement.execute();
        Assert.assertFalse((boolean)status);
        ResultSet resultSet = preparedStatement.getResultSet();
        Assert.assertTrue((resultSet == null ? 1 : 0) != 0);
        int updateCount = preparedStatement.getUpdateCount();
        Assert.assertTrue((updateCount == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testPreparedStatementInsert2() throws Exception {
    }

    @Test
    public void testInsertMultipleRowMismatch() {
        ArrayList<JdbcTest.Employee> employees = new ArrayList<JdbcTest.Employee>();
        CalciteAssert.AssertThat with = this.mutable(employees);
        with.query("insert into \"foo\".\"bar\" values\n (1, 3, 'third'),\n (1, 4, 'fourth'),\n (1, 5, 'fifth ', 3)").throws_("Incompatible types");
    }
}

