/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableProject;
import org.apache.calcite.config.Lex;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class LexEscapeTest {
    private static Planner getPlanner(List<RelTraitDef> traitDefs, SqlParser.Config parserConfig, Program ... programs) {
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
        rootSchema.add("TMP", (Table)new AbstractTable(){

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.createStructType((List)ImmutableList.of((Object)typeFactory.createSqlType(SqlTypeName.VARCHAR), (Object)typeFactory.createSqlType(SqlTypeName.INTEGER)), (List)ImmutableList.of((Object)"localtime", (Object)"current_timestamp"));
            }
        });
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(parserConfig).defaultSchema(rootSchema).traitDefs(traitDefs).programs(programs).operatorTable((SqlOperatorTable)SqlStdOperatorTable.instance()).build();
        return Frameworks.getPlanner((FrameworkConfig)config);
    }

    private static void runProjectQueryWithLex(Lex lex, String sql) throws SqlParseException, ValidationException, RelConversionException {
        SqlParser.Config javaLex = SqlParser.configBuilder().setLex(lex).build();
        Planner planner = LexEscapeTest.getPlanner(null, javaLex, Programs.ofRules((Iterable)Programs.RULE_SET));
        SqlNode parse = planner.parse(sql);
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.rel((SqlNode)validate).rel;
        RelTraitSet traitSet = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        Assert.assertThat((Object)transform, (Matcher)CoreMatchers.instanceOf(EnumerableProject.class));
        List fields = transform.getRowType().getFieldList();
        Assert.assertThat((Object)fields.size(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)((RelDataTypeField)fields.get(0)).getType().getSqlTypeName(), (Matcher)Is.is((Object)SqlTypeName.VARCHAR));
        Assert.assertThat((Object)((RelDataTypeField)fields.get(1)).getType().getSqlTypeName(), (Matcher)Is.is((Object)SqlTypeName.TIME));
        Assert.assertThat((Object)((RelDataTypeField)fields.get(2)).getType().getSqlTypeName(), (Matcher)Is.is((Object)SqlTypeName.INTEGER));
        Assert.assertThat((Object)((RelDataTypeField)fields.get(3)).getType().getSqlTypeName(), (Matcher)Is.is((Object)SqlTypeName.TIMESTAMP));
    }

    @Test
    public void testCalciteEscapeOracle() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select \"localtime\", localtime, \"current_timestamp\", current_timestamp from TMP";
        LexEscapeTest.runProjectQueryWithLex(Lex.ORACLE, sql);
    }

    @Test
    public void testCalciteEscapeMySql() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select `localtime`, localtime, `current_timestamp`, current_timestamp from TMP";
        LexEscapeTest.runProjectQueryWithLex(Lex.MYSQL, sql);
    }

    @Test
    public void testCalciteEscapeMySqlAnsi() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select \"localtime\", localtime, \"current_timestamp\", current_timestamp from TMP";
        LexEscapeTest.runProjectQueryWithLex(Lex.MYSQL_ANSI, sql);
    }

    @Test
    public void testCalciteEscapeSqlServer() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select [localtime], localtime, [current_timestamp], current_timestamp from TMP";
        LexEscapeTest.runProjectQueryWithLex(Lex.SQL_SERVER, sql);
    }

    @Test
    public void testCalciteEscapeJava() throws SqlParseException, ValidationException, RelConversionException {
        String sql = "select `localtime`, localtime, `current_timestamp`, current_timestamp from TMP";
        LexEscapeTest.runProjectQueryWithLex(Lex.JAVA, sql);
    }
}

