/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.collect.ImmutableList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeFixture;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SqlTypeUtilTest {
    private final SqlTypeFixture f = new SqlTypeFixture();

    @Test
    public void testTypesIsSameFamilyWithNumberTypes() {
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)this.f.sqlBigInt, (Object)this.f.sqlBigInt)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)this.f.sqlInt, (Object)this.f.sqlBigInt)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)this.f.sqlFloat, (Object)this.f.sqlBigInt)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)this.f.sqlInt, (Object)this.f.sqlBigIntNullable)), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testTypesIsSameFamilyWithCharTypes() {
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)this.f.sqlVarchar, (Object)this.f.sqlVarchar)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)this.f.sqlVarchar, (Object)this.f.sqlChar)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)this.f.sqlVarchar, (Object)this.f.sqlVarcharNullable)), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testTypesIsSameFamilyWithInconvertibleTypes() {
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)this.f.sqlBoolean, (Object)this.f.sqlBigInt)), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)this.f.sqlFloat, (Object)this.f.sqlBoolean)), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)this.f.sqlInt, (Object)this.f.sqlDate)), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testTypesIsSameFamilyWithNumberStructTypes() {
        RelDataType bigIntAndFloat = this.struct(this.f.sqlBigInt, this.f.sqlFloat);
        RelDataType floatAndBigInt = this.struct(this.f.sqlFloat, this.f.sqlBigInt);
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)bigIntAndFloat, (Object)floatAndBigInt)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)bigIntAndFloat, (Object)bigIntAndFloat)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)bigIntAndFloat, (Object)bigIntAndFloat)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)floatAndBigInt, (Object)floatAndBigInt)), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testTypesIsSameFamilyWithCharStructTypes() {
        RelDataType varCharStruct = this.struct(this.f.sqlVarchar);
        RelDataType charStruct = this.struct(this.f.sqlChar);
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)varCharStruct, (Object)charStruct)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)charStruct, (Object)varCharStruct)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)varCharStruct, (Object)varCharStruct)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)charStruct, (Object)charStruct)), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testTypesIsSameFamilyWithInconvertibleStructTypes() {
        RelDataType dateStruct = this.struct(this.f.sqlDate);
        RelDataType boolStruct = this.struct(this.f.sqlBoolean);
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)dateStruct, (Object)boolStruct)), (Matcher)CoreMatchers.is((Object)false));
        RelDataType charIntStruct = this.struct(this.f.sqlChar, this.f.sqlInt);
        RelDataType charDateStruct = this.struct(this.f.sqlChar, this.f.sqlDate);
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)charIntStruct, (Object)charDateStruct)), (Matcher)CoreMatchers.is((Object)false));
        RelDataType boolDateStruct = this.struct(this.f.sqlBoolean, this.f.sqlDate);
        RelDataType floatIntStruct = this.struct(this.f.sqlInt, this.f.sqlFloat);
        Assert.assertThat((Object)SqlTypeUtil.areSameFamily((Iterable)ImmutableList.of((Object)boolDateStruct, (Object)floatIntStruct)), (Matcher)CoreMatchers.is((Object)false));
    }

    private RelDataType struct(RelDataType ... relDataTypes) {
        RelDataTypeFactory.FieldInfoBuilder builder = this.f.typeFactory.builder();
        for (int i = 0; i < relDataTypes.length; ++i) {
            builder.add("field" + i, relDataTypes[i]);
        }
        return builder.build();
    }
}

