/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;

class SqlTypeFixture {
    SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
    final RelDataType sqlBoolean = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.BOOLEAN), false);
    final RelDataType sqlBigInt = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.BIGINT), false);
    final RelDataType sqlBigIntNullable = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.BIGINT), true);
    final RelDataType sqlInt = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.INTEGER), false);
    final RelDataType sqlDate = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.DATE), false);
    final RelDataType sqlVarchar = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), false);
    final RelDataType sqlChar = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.CHAR), false);
    final RelDataType sqlVarcharNullable = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), true);
    final RelDataType sqlNull = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.NULL), false);
    final RelDataType sqlAny = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.ANY), false);
    final RelDataType sqlFloat = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.FLOAT), false);
    final RelDataType arrayFloat = this.typeFactory.createTypeWithNullability(this.typeFactory.createArrayType(this.sqlFloat, -1L), false);
    final RelDataType arrayBigInt = this.typeFactory.createTypeWithNullability(this.typeFactory.createArrayType(this.sqlBigIntNullable, -1L), false);
    final RelDataType multisetFloat = this.typeFactory.createTypeWithNullability(this.typeFactory.createMultisetType(this.sqlFloat, -1L), false);
    final RelDataType multisetBigInt = this.typeFactory.createTypeWithNullability(this.typeFactory.createMultisetType(this.sqlBigIntNullable, -1L), false);
    final RelDataType arrayBigIntNullable = this.typeFactory.createTypeWithNullability(this.typeFactory.createArrayType(this.sqlBigIntNullable, -1L), true);
    final RelDataType arrayOfArrayBigInt = this.typeFactory.createTypeWithNullability(this.typeFactory.createArrayType(this.arrayBigInt, -1L), false);
    final RelDataType arrayOfArrayFloat = this.typeFactory.createTypeWithNullability(this.typeFactory.createArrayType(this.arrayFloat, -1L), false);
    final RelDataType structOfInt = this.typeFactory.createTypeWithNullability(this.typeFactory.createStructType((List)ImmutableList.of((Object)this.sqlInt, (Object)this.sqlInt), (List)ImmutableList.of((Object)"i", (Object)"j")), false);
    final RelDataType structOfIntNullable = this.typeFactory.createTypeWithNullability(this.typeFactory.createStructType((List)ImmutableList.of((Object)this.sqlInt, (Object)this.sqlInt), (List)ImmutableList.of((Object)"i", (Object)"j")), true);

    SqlTypeFixture() {
    }
}

