/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlLibraryOperatorTableFactory;
import org.apache.calcite.sql.fun.SqlOverlapsOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import org.apache.calcite.sql.parser.SqlParserTest;
import org.apache.calcite.test.DiffTestCase;
import org.apache.calcite.util.Sources;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DocumentationTest {
    @Test
    public void testGenerateKeyWords() throws IOException {
        FileFixture f = new FileFixture();
        f.outFile.getParentFile().mkdirs();
        try (BufferedReader r = Util.reader((File)f.inFile);
             FileOutputStream fos = new FileOutputStream(f.outFile);
             PrintWriter w = Util.printWriter((File)f.outFile);){
            String line;
            int stage = 0;
            while ((line = r.readLine()) != null) {
                if (line.equals("{% comment %} end {% endcomment %}")) {
                    ++stage;
                }
                if (stage != 1) {
                    w.println(line);
                }
                if (!line.equals("{% comment %} start {% endcomment %}")) continue;
                ++stage;
                SqlAbstractParserImpl.Metadata metadata = new SqlParserTest().getSqlParser("").getMetadata();
                int z = 0;
                for (String s : metadata.getTokens()) {
                    if (z++ > 0) {
                        w.println(",");
                    }
                    if (!metadata.isKeyword(s)) continue;
                    w.print(metadata.isReservedWord(s) ? "**" + s + "**" : s);
                }
                w.println(".");
            }
            w.flush();
            fos.flush();
            fos.getFD().sync();
        }
        String diff = DiffTestCase.diff(f.outFile, f.inFile);
        if (!diff.isEmpty()) {
            throw new AssertionError((Object)("Mismatch between " + f.outFile + " and " + f.inFile + ":\n" + diff));
        }
    }

    @Test
    public void testAllFunctionsAreDocumented() throws IOException {
        FileFixture f = new FileFixture();
        TreeMap<String, PatternOp> map = new TreeMap<String, PatternOp>();
        this.addOperators(map, "", SqlStdOperatorTable.instance().getOperatorList());
        block12: for (SqlLibrary library : SqlLibrary.values()) {
            switch (library) {
                case STANDARD: 
                case SPATIAL: {
                    continue block12;
                }
                default: {
                    this.addOperators(map, "\\| [^|]*" + library.abbrev + "[^|]* ", SqlLibraryOperatorTableFactory.INSTANCE.getOperatorTable(EnumSet.of(library)).getOperatorList());
                }
            }
        }
        HashSet regexSeen = new HashSet();
        try (LineNumberReader r = new LineNumberReader(Util.reader((File)f.inFile));){
            String line;
            block13: while ((line = r.readLine()) != null) {
                Iterator iterator = map.entrySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block13;
                    Map.Entry entry = iterator.next();
                    if (!((PatternOp)entry.getValue()).pattern.matcher(line).matches()) continue;
                    regexSeen.add(entry.getKey());
                }
                break;
            }
        }
        TreeSet regexNotSeen = new TreeSet(map.keySet());
        regexNotSeen.removeAll(regexSeen);
        Assert.assertThat((String)("some functions are not documented: " + map.entrySet().stream().filter(e -> regexNotSeen.contains(e.getKey())).map(e -> ((PatternOp)e.getValue()).opName + "(" + (String)e.getKey() + ")").collect(Collectors.joining(", "))), (Object)regexNotSeen.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void addOperators(Map<String, PatternOp> map, String prefix, List<SqlOperator> operatorList) {
        for (SqlOperator op : operatorList) {
            String name;
            String string = name = op.getName().equals("TRANSLATE3") ? "TRANSLATE" : op.getName();
            if (op instanceof SqlSpecialOperator || !name.matches("^[a-zA-Z][a-zA-Z0-9_]*$")) continue;
            String regex = op instanceof SqlOverlapsOperator ? "[ ]*<td>period1 " + name + " period2</td>" : (op instanceof SqlFunction && (op.getOperandTypeChecker() == null || op.getOperandTypeChecker().getOperandCountRange().getMin() != 0) ? prefix + "\\| .*" + name + "\\(.*" : prefix + "\\| .*" + name + ".*");
            map.put(regex, new PatternOp(Pattern.compile(regex), name));
        }
    }

    private static class FileFixture {
        final File base;
        final File inFile;
        final File outFile;

        FileFixture() {
            String path = "hsqldb-model.json";
            File hsqlDbModel = Sources.of((URL)SqlParserTest.class.getResource("/" + path)).file();
            assert (hsqlDbModel.getAbsolutePath().endsWith(Paths.get("core", "target", "test-classes", "hsqldb-model.json").toString())) : hsqlDbModel.getAbsolutePath() + " should end with core/target/test-classes/hsqldb-model.json";
            this.base = hsqlDbModel.getAbsoluteFile().getParentFile().getParentFile().getParentFile().getParentFile();
            this.inFile = new File(this.base, "site/_docs/reference.md");
            this.outFile = new File(this.base, "core/target/surefire/reference.md");
        }
    }

    private static class PatternOp {
        final Pattern pattern;
        final String opName;

        private PatternOp(Pattern pattern, String opName) {
            this.pattern = pattern;
            this.opName = opName;
        }
    }
}

