/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutable;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.server.CalciteServerStatement;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlMonotonicBinaryOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.Matchers;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RexExecutorTest {
    private static final SqlBinaryOperator PLUS_RANDOM = new SqlMonotonicBinaryOperator("+", SqlKind.PLUS, 40, true, ReturnTypes.NULLABLE_SUM, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.PLUS_OPERATOR){

        public boolean isDeterministic() {
            return false;
        }
    };

    protected void check(final Action action) throws Exception {
        Frameworks.withPrepare((Frameworks.PrepareAction)new Frameworks.PrepareAction<Void>(){

            public Void apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema, CalciteServerStatement statement) {
                RexBuilder rexBuilder = cluster.getRexBuilder();
                DataContext dataContext = Schemas.createDataContext((Connection)statement.getConnection(), (SchemaPlus)rootSchema);
                RexExecutorImpl executor = new RexExecutorImpl(dataContext);
                action.check(rexBuilder, executor);
                return null;
            }
        });
    }

    @Test
    public void testVariableExecution() throws Exception {
        this.check((rexBuilder, executor) -> {
            Object[] values = new Object[1];
            TestDataContext testContext = new TestDataContext(values);
            RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
            RelDataType varchar = typeFactory.createSqlType(SqlTypeName.VARCHAR);
            RelDataType integer = typeFactory.createSqlType(SqlTypeName.INTEGER);
            RexInputRef input = rexBuilder.makeInputRef(varchar, 0);
            RexNode lengthArg = rexBuilder.makeLiteral((Object)3, integer, true);
            RexNode substr = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.SUBSTRING, new RexNode[]{input, lengthArg});
            ImmutableList constExps = ImmutableList.of((Object)substr);
            RelDataType rowType = typeFactory.builder().add("someStr", varchar).build();
            RexExecutable exec = executor.getExecutable(rexBuilder, (List)constExps, rowType);
            exec.setDataContext((DataContext)testContext);
            values[0] = "Hello World";
            Object[] result = exec.execute();
            Assert.assertTrue((boolean)(result[0] instanceof String));
            Assert.assertThat((Object)((String)result[0]), (Matcher)CoreMatchers.equalTo((Object)"llo World"));
            values[0] = "Calcite";
            result = exec.execute();
            Assert.assertTrue((boolean)(result[0] instanceof String));
            Assert.assertThat((Object)((String)result[0]), (Matcher)CoreMatchers.equalTo((Object)"lcite"));
        });
    }

    @Test
    public void testConstant() throws Exception {
        this.check((rexBuilder, executor) -> {
            ArrayList reducedValues = new ArrayList();
            RexLiteral ten = rexBuilder.makeExactLiteral(BigDecimal.TEN);
            executor.reduce(rexBuilder, (List)ImmutableList.of((Object)ten), reducedValues);
            Assert.assertThat((Object)reducedValues.size(), (Matcher)CoreMatchers.equalTo((Object)1));
            Assert.assertThat(reducedValues.get(0), (Matcher)CoreMatchers.instanceOf(RexLiteral.class));
            Assert.assertThat((Object)((RexLiteral)reducedValues.get(0)).getValue2(), (Matcher)CoreMatchers.equalTo((Object)10L));
        });
    }

    @Test
    public void testConstant2() throws Exception {
        this.checkConstant(10L, rexBuilder -> rexBuilder.makeExactLiteral(BigDecimal.TEN));
        this.checkConstant(11L, rexBuilder -> rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{rexBuilder.makeExactLiteral(BigDecimal.TEN), rexBuilder.makeExactLiteral(BigDecimal.ONE)}));
        this.checkConstant(true, rexBuilder -> {
            DateString d = DateString.fromCalendarFields((Calendar)Util.calendar());
            return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{rexBuilder.makeDateLiteral(d), rexBuilder.makeDateLiteral(d)});
        });
        this.checkConstant(false, rexBuilder -> {
            DateString d = DateString.fromCalendarFields((Calendar)Util.calendar());
            return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{rexBuilder.makeDateLiteral(d), rexBuilder.makeDateLiteral(d)});
        });
    }

    private void checkConstant(Object operand, Function<RexBuilder, RexNode> function) throws Exception {
        this.check((rexBuilder, executor) -> {
            Matcher<Long> matcher;
            ArrayList reducedValues = new ArrayList();
            RexNode expression = (RexNode)function.apply(rexBuilder);
            assert (expression != null);
            executor.reduce(rexBuilder, (List)ImmutableList.of((Object)expression), reducedValues);
            Assert.assertThat((Object)reducedValues.size(), (Matcher)CoreMatchers.equalTo((Object)1));
            RexNode reducedValue = (RexNode)reducedValues.get(0);
            Assert.assertThat((Object)reducedValue, (Matcher)CoreMatchers.instanceOf(RexLiteral.class));
            if (((RexLiteral)reducedValue).getTypeName() == SqlTypeName.TIMESTAMP) {
                long current = System.currentTimeMillis();
                matcher = Matchers.between(Long.valueOf((Long)operand), current);
            } else {
                matcher = CoreMatchers.equalTo((Object)operand);
            }
            Assert.assertThat((Object)((RexLiteral)reducedValue).getValue2(), (Matcher)matcher);
        });
    }

    @Test
    public void testUserFromContext() throws Exception {
        this.testContextLiteral((SqlOperator)SqlStdOperatorTable.USER, DataContext.Variable.USER, "happyCalciteUser");
    }

    @Test
    public void testSystemUserFromContext() throws Exception {
        this.testContextLiteral((SqlOperator)SqlStdOperatorTable.SYSTEM_USER, DataContext.Variable.SYSTEM_USER, "");
    }

    @Test
    public void testTimestampFromContext() throws Exception {
        long val = System.currentTimeMillis() / 1000L * 1000L;
        this.testContextLiteral((SqlOperator)SqlStdOperatorTable.CURRENT_TIMESTAMP, DataContext.Variable.CURRENT_TIMESTAMP, val);
    }

    private void testContextLiteral(final SqlOperator operator, final DataContext.Variable variable, final Object value) {
        Frameworks.withPrepare((Frameworks.PrepareAction)new Frameworks.PrepareAction<Void>(){

            public Void apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema, CalciteServerStatement statement) {
                RexBuilder rexBuilder = cluster.getRexBuilder();
                RexExecutorImpl executor = new RexExecutorImpl((DataContext)new SingleValueDataContext(variable.camelName, value));
                try {
                    RexExecutorTest.this.checkConstant(value, builder -> {
                        ArrayList output = new ArrayList();
                        executor.reduce(rexBuilder, (List)ImmutableList.of((Object)rexBuilder.makeCall(operator, new RexNode[0])), output);
                        return (RexNode)output.get(0);
                    });
                }
                catch (Exception e) {
                    throw TestUtil.rethrow(e);
                }
                return null;
            }
        });
    }

    @Test
    public void testSubstring() throws Exception {
        this.check((rexBuilder, executor) -> {
            ArrayList reducedValues = new ArrayList();
            RexLiteral hello = rexBuilder.makeCharLiteral(new NlsString("Hello world!", null, null));
            RexNode plus = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{rexBuilder.makeExactLiteral(BigDecimal.ONE), rexBuilder.makeExactLiteral(BigDecimal.ONE)});
            RexLiteral four = rexBuilder.makeExactLiteral(BigDecimal.valueOf(4L));
            RexNode substring = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.SUBSTRING, new RexNode[]{hello, plus, four});
            executor.reduce(rexBuilder, (List)ImmutableList.of((Object)substring, (Object)plus), reducedValues);
            Assert.assertThat((Object)reducedValues.size(), (Matcher)CoreMatchers.equalTo((Object)2));
            Assert.assertThat(reducedValues.get(0), (Matcher)CoreMatchers.instanceOf(RexLiteral.class));
            Assert.assertThat((Object)((RexLiteral)reducedValues.get(0)).getValue2(), (Matcher)CoreMatchers.equalTo((Object)"ello"));
            Assert.assertThat(reducedValues.get(1), (Matcher)CoreMatchers.instanceOf(RexLiteral.class));
            Assert.assertThat((Object)((RexLiteral)reducedValues.get(1)).getValue2(), (Matcher)CoreMatchers.equalTo((Object)2L));
        });
    }

    @Test
    public void testBinarySubstring() throws Exception {
        this.check((rexBuilder, executor) -> {
            ArrayList reducedValues = new ArrayList();
            RexLiteral binaryHello = rexBuilder.makeBinaryLiteral(new ByteString("Hello world!".getBytes(StandardCharsets.UTF_8)));
            RexNode plus = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{rexBuilder.makeExactLiteral(BigDecimal.ONE), rexBuilder.makeExactLiteral(BigDecimal.ONE)});
            RexLiteral four = rexBuilder.makeExactLiteral(BigDecimal.valueOf(4L));
            RexNode substring = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.SUBSTRING, new RexNode[]{binaryHello, plus, four});
            executor.reduce(rexBuilder, (List)ImmutableList.of((Object)substring, (Object)plus), reducedValues);
            Assert.assertThat((Object)reducedValues.size(), (Matcher)CoreMatchers.equalTo((Object)2));
            Assert.assertThat(reducedValues.get(0), (Matcher)CoreMatchers.instanceOf(RexLiteral.class));
            Assert.assertThat((Object)((RexLiteral)reducedValues.get(0)).getValue2().toString(), (Matcher)CoreMatchers.equalTo((Object)"656c6c6f"));
            Assert.assertThat(reducedValues.get(1), (Matcher)CoreMatchers.instanceOf(RexLiteral.class));
            Assert.assertThat((Object)((RexLiteral)reducedValues.get(1)).getValue2(), (Matcher)CoreMatchers.equalTo((Object)2L));
        });
    }

    @Test
    public void testDeterministic1() throws Exception {
        this.check((rexBuilder, executor) -> {
            RexNode plus = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{rexBuilder.makeExactLiteral(BigDecimal.ONE), rexBuilder.makeExactLiteral(BigDecimal.ONE)});
            Assert.assertThat((Object)RexUtil.isDeterministic((RexNode)plus), (Matcher)CoreMatchers.equalTo((Object)true));
        });
    }

    @Test
    public void testDeterministic2() throws Exception {
        this.check((rexBuilder, executor) -> {
            RexNode plus = rexBuilder.makeCall((SqlOperator)PLUS_RANDOM, new RexNode[]{rexBuilder.makeExactLiteral(BigDecimal.ONE), rexBuilder.makeExactLiteral(BigDecimal.ONE)});
            Assert.assertThat((Object)RexUtil.isDeterministic((RexNode)plus), (Matcher)CoreMatchers.equalTo((Object)false));
        });
    }

    @Test
    public void testDeterministic3() throws Exception {
        this.check((rexBuilder, executor) -> {
            RexNode plus = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{rexBuilder.makeCall((SqlOperator)PLUS_RANDOM, new RexNode[]{rexBuilder.makeExactLiteral(BigDecimal.ONE), rexBuilder.makeExactLiteral(BigDecimal.ONE)}), rexBuilder.makeExactLiteral(BigDecimal.ONE)});
            Assert.assertThat((Object)RexUtil.isDeterministic((RexNode)plus), (Matcher)CoreMatchers.equalTo((Object)false));
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSelfPopulatingList() {
        void var5_11;
        ArrayList<4> threads = new ArrayList<4>();
        RexSlot.SelfPopulatingList list = new RexSlot.SelfPopulatingList("$", 1);
        final Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            threads.add(new Thread((List)list){
                final /* synthetic */ List val$list;
                {
                    this.val$list = list;
                }

                @Override
                public void run() {
                    for (int j = 0; j < 1000; ++j) {
                        int index = random.nextInt(1234567) >> random.nextInt(16) >> random.nextInt(16);
                        this.val$list.get(index);
                    }
                }
            });
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        int size = list.size();
        boolean bl = false;
        while (var5_11 < size) {
            Assert.assertThat(list.get((int)var5_11), (Matcher)CoreMatchers.is((Object)("$" + (int)var5_11)));
            ++var5_11;
        }
    }

    @Test
    public void testSelfPopulatingList30() {
        RexSlot.SelfPopulatingList list = new RexSlot.SelfPopulatingList("$", 30);
        String s = (String)list.get(30);
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.is((Object)"$30"));
    }

    public static class SingleValueDataContext
    implements DataContext {
        private final String name;
        private final Object value;

        public SingleValueDataContext(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public SchemaPlus getRootSchema() {
            throw new RuntimeException("Unsupported");
        }

        public JavaTypeFactory getTypeFactory() {
            throw new RuntimeException("Unsupported");
        }

        public QueryProvider getQueryProvider() {
            throw new RuntimeException("Unsupported");
        }

        public Object get(String name) {
            if (this.name.equals(name)) {
                return this.value;
            }
            Assert.fail((String)"Wrong DataContext access");
            return null;
        }
    }

    public static class TestDataContext
    extends SingleValueDataContext {
        private TestDataContext(Object[] values) {
            super("inputRecord", values);
        }
    }

    static interface Action {
        public void check(RexBuilder var1, RexExecutorImpl var2);
    }
}

