/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDigestIncludeType;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.TimestampWithTimeZoneString;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class RexBuilderTest {
    private static final int PRECISION = 256;
    private static final long MOON = -14159025000L;
    private static final int MOON_DAY = -164;
    private static final int MOON_TIME = 10575000;

    @Test
    public void testEnsureTypeWithAny() {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)typeFactory);
        RexLiteral node = new RexLiteral((Comparable)Boolean.TRUE, typeFactory.createSqlType(SqlTypeName.BOOLEAN), SqlTypeName.BOOLEAN);
        RexNode ensuredNode = builder.ensureType(typeFactory.createSqlType(SqlTypeName.ANY), (RexNode)node, true);
        Assert.assertEquals((Object)node, (Object)ensuredNode);
    }

    @Test
    public void testEnsureTypeWithItself() {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)typeFactory);
        RexLiteral node = new RexLiteral((Comparable)Boolean.TRUE, typeFactory.createSqlType(SqlTypeName.BOOLEAN), SqlTypeName.BOOLEAN);
        RexNode ensuredNode = builder.ensureType(typeFactory.createSqlType(SqlTypeName.BOOLEAN), (RexNode)node, true);
        Assert.assertEquals((Object)node, (Object)ensuredNode);
    }

    @Test
    public void testEnsureTypeWithDifference() {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)typeFactory);
        RexLiteral node = new RexLiteral((Comparable)Boolean.TRUE, typeFactory.createSqlType(SqlTypeName.BOOLEAN), SqlTypeName.BOOLEAN);
        RexNode ensuredNode = builder.ensureType(typeFactory.createSqlType(SqlTypeName.INTEGER), (RexNode)node, true);
        Assert.assertNotEquals((Object)node, (Object)ensuredNode);
        Assert.assertEquals((Object)ensuredNode.getType(), (Object)typeFactory.createSqlType(SqlTypeName.INTEGER));
    }

    @Test
    public void testTimestampLiteral() {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataType timestampType = typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
        RelDataType timestampType3 = typeFactory.createSqlType(SqlTypeName.TIMESTAMP, 3);
        RelDataType timestampType9 = typeFactory.createSqlType(SqlTypeName.TIMESTAMP, 9);
        RelDataType timestampType18 = typeFactory.createSqlType(SqlTypeName.TIMESTAMP, 18);
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)typeFactory);
        Calendar calendar = Util.calendar();
        calendar.set(1969, 6, 21, 2, 56, 15);
        calendar.set(14, 0);
        this.checkTimestamp(builder.makeLiteral((Object)calendar, timestampType, false));
        this.checkTimestamp(builder.makeLiteral((Object)-14159025000L, timestampType, false));
        TimestampString ts = new TimestampString(1969, 7, 21, 2, 56, 15);
        this.checkTimestamp(builder.makeLiteral((Object)ts, timestampType, false));
        TimestampString ts2 = ts.withMillis(56);
        Assert.assertThat((Object)ts2.toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15.056"));
        RexNode literal2 = builder.makeLiteral((Object)ts2, timestampType3, false);
        Assert.assertThat((Object)((TimestampString)((RexLiteral)literal2).getValueAs(TimestampString.class)).toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15.056"));
        TimestampString ts3 = ts.withNanos(56);
        RexNode literal3 = builder.makeLiteral((Object)ts3, timestampType9, false);
        Assert.assertThat((Object)((TimestampString)((RexLiteral)literal3).getValueAs(TimestampString.class)).toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15"));
        TimestampString ts3b = ts.withNanos(2345678);
        RexNode literal3b = builder.makeLiteral((Object)ts3b, timestampType9, false);
        Assert.assertThat((Object)((TimestampString)((RexLiteral)literal3b).getValueAs(TimestampString.class)).toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15.002"));
        TimestampString ts4 = ts.withFraction("102030405060708090102");
        RexNode literal4 = builder.makeLiteral((Object)ts4, timestampType18, false);
        Assert.assertThat((Object)((TimestampString)((RexLiteral)literal4).getValueAs(TimestampString.class)).toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15.102"));
        Assert.assertThat((Object)ts2.round(1).toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15"));
        Assert.assertThat((Object)ts2.round(2).toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15.05"));
        Assert.assertThat((Object)ts2.round(3).toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15.056"));
        Assert.assertThat((Object)ts2.round(4).toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15.056"));
        Assert.assertThat((Object)ts2.toString(6), (Matcher)Is.is((Object)"1969-07-21 02:56:15.056000"));
        Assert.assertThat((Object)ts2.toString(1), (Matcher)Is.is((Object)"1969-07-21 02:56:15.0"));
        Assert.assertThat((Object)ts2.toString(0), (Matcher)Is.is((Object)"1969-07-21 02:56:15"));
        Assert.assertThat((Object)ts2.round(0).toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15"));
        Assert.assertThat((Object)ts2.round(0).toString(0), (Matcher)Is.is((Object)"1969-07-21 02:56:15"));
        Assert.assertThat((Object)ts2.round(0).toString(1), (Matcher)Is.is((Object)"1969-07-21 02:56:15.0"));
        Assert.assertThat((Object)ts2.round(0).toString(2), (Matcher)Is.is((Object)"1969-07-21 02:56:15.00"));
        Assert.assertThat((Object)TimestampString.fromMillisSinceEpoch((long)1456513560123L).toString(), (Matcher)Is.is((Object)"2016-02-26 19:06:00.123"));
    }

    private void checkTimestamp(RexNode node) {
        Assert.assertThat((Object)node.toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15"));
        RexLiteral literal = (RexLiteral)node;
        Assert.assertThat((Object)(literal.getValue() instanceof Calendar), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)(literal.getValue2() instanceof Long), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)(literal.getValue3() instanceof Long), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((Long)literal.getValue2()), (Matcher)Is.is((Object)-14159025000L));
        Assert.assertThat((Object)literal.getValueAs(Calendar.class), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)literal.getValueAs(TimestampString.class), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testTimestampWithLocalTimeZoneLiteral() {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataType timestampType = typeFactory.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        RelDataType timestampType3 = typeFactory.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, 3);
        RelDataType timestampType9 = typeFactory.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, 9);
        RelDataType timestampType18 = typeFactory.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, 18);
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)typeFactory);
        TimestampWithTimeZoneString ts = new TimestampWithTimeZoneString(1969, 7, 21, 2, 56, 15, TimeZone.getTimeZone("PST").getID());
        this.checkTimestampWithLocalTimeZone(builder.makeLiteral((Object)ts.getLocalTimestampString(), timestampType, false));
        TimestampWithTimeZoneString ts2 = ts.withMillis(56);
        Assert.assertThat((Object)ts2.toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15.056 PST"));
        RexNode literal2 = builder.makeLiteral((Object)ts2.getLocalTimestampString(), timestampType3, false);
        Assert.assertThat((Object)((RexLiteral)literal2).getValue().toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15.056"));
        TimestampWithTimeZoneString ts3 = ts.withNanos(56);
        RexNode literal3 = builder.makeLiteral((Object)ts3.getLocalTimestampString(), timestampType9, false);
        Assert.assertThat((Object)((TimestampString)((RexLiteral)literal3).getValueAs(TimestampString.class)).toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15"));
        TimestampWithTimeZoneString ts3b = ts.withNanos(2345678);
        RexNode literal3b = builder.makeLiteral((Object)ts3b.getLocalTimestampString(), timestampType9, false);
        Assert.assertThat((Object)((TimestampString)((RexLiteral)literal3b).getValueAs(TimestampString.class)).toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15.002"));
        TimestampWithTimeZoneString ts4 = ts.withFraction("102030405060708090102");
        RexNode literal4 = builder.makeLiteral((Object)ts4.getLocalTimestampString(), timestampType18, false);
        Assert.assertThat((Object)((TimestampString)((RexLiteral)literal4).getValueAs(TimestampString.class)).toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15.102"));
        Assert.assertThat((Object)ts2.round(1).toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15 PST"));
        Assert.assertThat((Object)ts2.round(2).toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15.05 PST"));
        Assert.assertThat((Object)ts2.round(3).toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15.056 PST"));
        Assert.assertThat((Object)ts2.round(4).toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15.056 PST"));
        Assert.assertThat((Object)ts2.toString(6), (Matcher)Is.is((Object)"1969-07-21 02:56:15.056000 PST"));
        Assert.assertThat((Object)ts2.toString(1), (Matcher)Is.is((Object)"1969-07-21 02:56:15.0 PST"));
        Assert.assertThat((Object)ts2.toString(0), (Matcher)Is.is((Object)"1969-07-21 02:56:15 PST"));
        Assert.assertThat((Object)ts2.round(0).toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15 PST"));
        Assert.assertThat((Object)ts2.round(0).toString(0), (Matcher)Is.is((Object)"1969-07-21 02:56:15 PST"));
        Assert.assertThat((Object)ts2.round(0).toString(1), (Matcher)Is.is((Object)"1969-07-21 02:56:15.0 PST"));
        Assert.assertThat((Object)ts2.round(0).toString(2), (Matcher)Is.is((Object)"1969-07-21 02:56:15.00 PST"));
    }

    private void checkTimestampWithLocalTimeZone(RexNode node) {
        Assert.assertThat((Object)node.toString(), (Matcher)Is.is((Object)"1969-07-21 02:56:15:TIMESTAMP_WITH_LOCAL_TIME_ZONE(0)"));
        RexLiteral literal = (RexLiteral)node;
        Assert.assertThat((Object)(literal.getValue() instanceof TimestampString), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)(literal.getValue2() instanceof Long), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)(literal.getValue3() instanceof Long), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testTimeLiteral() {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataType timeType = typeFactory.createSqlType(SqlTypeName.TIME);
        RelDataType timeType3 = typeFactory.createSqlType(SqlTypeName.TIME, 3);
        RelDataType timeType9 = typeFactory.createSqlType(SqlTypeName.TIME, 9);
        RelDataType timeType18 = typeFactory.createSqlType(SqlTypeName.TIME, 18);
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)typeFactory);
        Calendar calendar = Util.calendar();
        calendar.set(1969, 6, 21, 2, 56, 15);
        calendar.set(14, 0);
        this.checkTime(builder.makeLiteral((Object)calendar, timeType, false));
        this.checkTime(builder.makeLiteral((Object)10575000, timeType, false));
        TimeString t = new TimeString(2, 56, 15);
        Assert.assertThat((Object)t.getMillisOfDay(), (Matcher)Is.is((Object)10575000));
        this.checkTime(builder.makeLiteral((Object)t, timeType, false));
        TimeString t2 = t.withMillis(56);
        Assert.assertThat((Object)t2.getMillisOfDay(), (Matcher)Is.is((Object)10575056));
        Assert.assertThat((Object)t2.toString(), (Matcher)Is.is((Object)"02:56:15.056"));
        RexNode literal2 = builder.makeLiteral((Object)t2, timeType3, false);
        Assert.assertThat((Object)((TimeString)((RexLiteral)literal2).getValueAs(TimeString.class)).toString(), (Matcher)Is.is((Object)"02:56:15.056"));
        TimeString t3 = t.withNanos(2345678);
        Assert.assertThat((Object)t3.getMillisOfDay(), (Matcher)Is.is((Object)10575002));
        RexNode literal3 = builder.makeLiteral((Object)t3, timeType9, false);
        Assert.assertThat((Object)((TimeString)((RexLiteral)literal3).getValueAs(TimeString.class)).toString(), (Matcher)Is.is((Object)"02:56:15.002"));
        TimeString t4 = t.withFraction("102030405060708090102");
        Assert.assertThat((Object)t4.getMillisOfDay(), (Matcher)Is.is((Object)10575102));
        RexNode literal4 = builder.makeLiteral((Object)t4, timeType18, false);
        Assert.assertThat((Object)((TimeString)((RexLiteral)literal4).getValueAs(TimeString.class)).toString(), (Matcher)Is.is((Object)"02:56:15.102"));
        Assert.assertThat((Object)t2.round(1).toString(), (Matcher)Is.is((Object)"02:56:15"));
        Assert.assertThat((Object)t2.round(2).toString(), (Matcher)Is.is((Object)"02:56:15.05"));
        Assert.assertThat((Object)t2.round(3).toString(), (Matcher)Is.is((Object)"02:56:15.056"));
        Assert.assertThat((Object)t2.round(4).toString(), (Matcher)Is.is((Object)"02:56:15.056"));
        Assert.assertThat((Object)t2.toString(6), (Matcher)Is.is((Object)"02:56:15.056000"));
        Assert.assertThat((Object)t2.toString(1), (Matcher)Is.is((Object)"02:56:15.0"));
        Assert.assertThat((Object)t2.toString(0), (Matcher)Is.is((Object)"02:56:15"));
        Assert.assertThat((Object)t2.round(0).toString(), (Matcher)Is.is((Object)"02:56:15"));
        Assert.assertThat((Object)t2.round(0).toString(0), (Matcher)Is.is((Object)"02:56:15"));
        Assert.assertThat((Object)t2.round(0).toString(1), (Matcher)Is.is((Object)"02:56:15.0"));
        Assert.assertThat((Object)t2.round(0).toString(2), (Matcher)Is.is((Object)"02:56:15.00"));
        Assert.assertThat((Object)TimeString.fromMillisOfDay((int)53560123).toString(), (Matcher)Is.is((Object)"14:52:40.123"));
    }

    private void checkTime(RexNode node) {
        Assert.assertThat((Object)node.toString(), (Matcher)Is.is((Object)"02:56:15"));
        RexLiteral literal = (RexLiteral)node;
        Assert.assertThat((Object)(literal.getValue() instanceof Calendar), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)(literal.getValue2() instanceof Integer), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)(literal.getValue3() instanceof Integer), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((Integer)literal.getValue2()), (Matcher)Is.is((Object)10575000));
        Assert.assertThat((Object)literal.getValueAs(Calendar.class), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)literal.getValueAs(TimeString.class), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testDateLiteral() {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataType dateType = typeFactory.createSqlType(SqlTypeName.DATE);
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)typeFactory);
        Calendar calendar = Util.calendar();
        calendar.set(1969, 6, 21);
        calendar.set(14, 0);
        this.checkDate(builder.makeLiteral((Object)calendar, dateType, false));
        this.checkDate(builder.makeLiteral((Object)-164, dateType, false));
        DateString d = new DateString(1969, 7, 21);
        this.checkDate(builder.makeLiteral((Object)d, dateType, false));
    }

    private void checkDate(RexNode node) {
        Assert.assertThat((Object)node.toString(), (Matcher)Is.is((Object)"1969-07-21"));
        RexLiteral literal = (RexLiteral)node;
        Assert.assertThat((Object)(literal.getValue() instanceof Calendar), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)(literal.getValue2() instanceof Integer), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)(literal.getValue3() instanceof Integer), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((Integer)literal.getValue2()), (Matcher)Is.is((Object)-164));
        Assert.assertThat((Object)literal.getValueAs(Calendar.class), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)literal.getValueAs(DateString.class), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testDecimalLiteral() {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataType type = typeFactory.createSqlType(SqlTypeName.DECIMAL);
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)typeFactory);
        RexLiteral literal = builder.makeExactLiteral(null, type);
        Assert.assertThat((Object)literal.getValue3(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testDateStringYearError() {
        DateString dateString;
        try {
            dateString = new DateString(11969, 7, 21);
            Assert.fail((String)("expected exception, got " + dateString));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Year out of range: [11969]"));
        }
        try {
            dateString = new DateString("12345-01-23");
            Assert.fail((String)("expected exception, got " + dateString));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Invalid date format: [12345-01-23]"));
        }
    }

    @Test
    public void testDateStringMonthError() {
        DateString dateString;
        try {
            dateString = new DateString(1969, 27, 21);
            Assert.fail((String)("expected exception, got " + dateString));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Month out of range: [27]"));
        }
        try {
            dateString = new DateString("1234-13-02");
            Assert.fail((String)("expected exception, got " + dateString));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Month out of range: [13]"));
        }
    }

    @Test
    public void testDateStringDayError() {
        DateString dateString;
        try {
            dateString = new DateString(1969, 7, 41);
            Assert.fail((String)("expected exception, got " + dateString));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Day out of range: [41]"));
        }
        try {
            dateString = new DateString("1234-01-32");
            Assert.fail((String)("expected exception, got " + dateString));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Day out of range: [32]"));
        }
        dateString = new DateString("1234-02-30");
        Assert.assertThat((Object)dateString, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testTimeStringHourError() {
        TimeString timeString;
        try {
            timeString = new TimeString(111, 34, 56);
            Assert.fail((String)("expected exception, got " + timeString));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Hour out of range: [111]"));
        }
        try {
            timeString = new TimeString("24:00:00");
            Assert.fail((String)("expected exception, got " + timeString));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Hour out of range: [24]"));
        }
        try {
            timeString = new TimeString("24:00");
            Assert.fail((String)("expected exception, got " + timeString));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Invalid time format: [24:00]"));
        }
    }

    @Test
    public void testTimeStringMinuteError() {
        TimeString timeString;
        try {
            timeString = new TimeString(12, 334, 56);
            Assert.fail((String)("expected exception, got " + timeString));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Minute out of range: [334]"));
        }
        try {
            timeString = new TimeString("12:60:23");
            Assert.fail((String)("expected exception, got " + timeString));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Minute out of range: [60]"));
        }
    }

    @Test
    public void testTimeStringSecondError() {
        TimeString timeString;
        try {
            timeString = new TimeString(12, 34, 567);
            Assert.fail((String)("expected exception, got " + timeString));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Second out of range: [567]"));
        }
        try {
            timeString = new TimeString(12, 34, -4);
            Assert.fail((String)("expected exception, got " + timeString));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Second out of range: [-4]"));
        }
        try {
            timeString = new TimeString("12:34:60");
            Assert.fail((String)("expected exception, got " + timeString));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Second out of range: [60]"));
        }
    }

    @Test
    public void testStringLiteral() {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataType varchar = typeFactory.createSqlType(SqlTypeName.VARCHAR);
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)typeFactory);
        NlsString latin1 = new NlsString("foobar", "LATIN1", SqlCollation.IMPLICIT);
        NlsString utf8 = new NlsString("foobar", "UTF8", SqlCollation.IMPLICIT);
        RexLiteral literal = builder.makePreciseStringLiteral("foobar");
        Assert.assertEquals((Object)"'foobar'", (Object)literal.toString());
        literal = builder.makePreciseStringLiteral(new ByteString(new byte[]{102, 111, 111, 98, 97, 114}), "UTF8", SqlCollation.IMPLICIT);
        Assert.assertEquals((Object)"_UTF8'foobar'", (Object)literal.toString());
        Assert.assertEquals((Object)"_UTF8'foobar':CHAR(6) CHARACTER SET \"UTF-8\"", (Object)literal.computeDigest(RexDigestIncludeType.ALWAYS));
        literal = builder.makePreciseStringLiteral(new ByteString("\u82f1\u56fd".getBytes(StandardCharsets.UTF_8)), "UTF8", SqlCollation.IMPLICIT);
        Assert.assertEquals((Object)"_UTF8'\u82f1\u56fd'", (Object)literal.toString());
        literal = builder.makePreciseStringLiteral(new ByteString("\u82f1".getBytes(StandardCharsets.UTF_8)), "UTF8", SqlCollation.IMPLICIT);
        Assert.assertEquals((Object)"_UTF8'\u82f1'", (Object)literal.toString());
        try {
            literal = builder.makePreciseStringLiteral(new ByteString("\u82f1\u56fd".getBytes(StandardCharsets.UTF_8)), "GB2312", SqlCollation.IMPLICIT);
            Assert.fail((String)("expected exception, got " + literal));
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Failed to encode"));
        }
        literal = builder.makeLiteral((Object)latin1, varchar, false);
        Assert.assertEquals((Object)"_LATIN1'foobar'", (Object)literal.toString());
        literal = builder.makeLiteral((Object)utf8, varchar, false);
        Assert.assertEquals((Object)"_UTF8'foobar'", (Object)literal.toString());
    }

    @Test
    public void testBigDecimalLiteral() {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)typeFactory);
        this.checkBigDecimalLiteral(builder, "25");
        this.checkBigDecimalLiteral(builder, "9.9");
        this.checkBigDecimalLiteral(builder, "0");
        this.checkBigDecimalLiteral(builder, "-75.5");
        this.checkBigDecimalLiteral(builder, "10000000");
        this.checkBigDecimalLiteral(builder, "100000.111111111111111111");
        this.checkBigDecimalLiteral(builder, "-100000.111111111111111111");
        this.checkBigDecimalLiteral(builder, "73786976294838206464");
        this.checkBigDecimalLiteral(builder, "-73786976294838206464");
    }

    @Test
    public void testCopyOver() {
        SqlTypeFactoryImpl sourceTypeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataType type = sourceTypeFactory.createSqlType(SqlTypeName.VARCHAR, 65536);
        MySqlTypeFactoryImpl targetTypeFactory = new MySqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)targetTypeFactory);
        RexOver node = (RexOver)builder.makeOver(type, SqlStdOperatorTable.COUNT, (List)ImmutableList.of((Object)builder.makeInputRef(type, 0)), (List)ImmutableList.of((Object)builder.makeInputRef(type, 1)), ImmutableList.of((Object)new RexFieldCollation((RexNode)builder.makeInputRef(type, 2), (Set)ImmutableSet.of())), RexWindowBound.create((SqlNode)SqlWindow.createUnboundedPreceding((SqlParserPos)SqlParserPos.ZERO), null), RexWindowBound.create((SqlNode)SqlWindow.createCurrentRow((SqlParserPos)SqlParserPos.ZERO), null), true, true, false, false, false);
        RexNode copy = builder.copy((RexNode)node);
        Assert.assertTrue((boolean)(copy instanceof RexOver));
        RexOver result = (RexOver)copy;
        Assert.assertThat((Object)result.getType().getSqlTypeName(), (Matcher)Is.is((Object)SqlTypeName.VARCHAR));
        Assert.assertThat((Object)result.getType().getPrecision(), (Matcher)Is.is((Object)256));
        Assert.assertThat((Object)result.getWindow(), (Matcher)Is.is((Object)node.getWindow()));
        Assert.assertThat((Object)result.getAggOperator(), (Matcher)Is.is((Object)node.getAggOperator()));
        Assert.assertThat((Object)result.getAggOperator(), (Matcher)Is.is((Object)node.getAggOperator()));
        Assert.assertEquals((Object)node.isDistinct(), (Object)result.isDistinct());
        Assert.assertEquals((Object)node.ignoreNulls(), (Object)result.ignoreNulls());
        for (int i = 0; i < node.getOperands().size(); ++i) {
            Assert.assertThat((Object)((RexNode)result.getOperands().get(i)).getType().getSqlTypeName(), (Matcher)Is.is((Object)((RexNode)node.getOperands().get(i)).getType().getSqlTypeName()));
            Assert.assertThat((Object)((RexNode)result.getOperands().get(i)).getType().getPrecision(), (Matcher)Is.is((Object)256));
        }
    }

    @Test
    public void testCopyCorrelVariable() {
        SqlTypeFactoryImpl sourceTypeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataType type = sourceTypeFactory.createSqlType(SqlTypeName.VARCHAR, 65536);
        MySqlTypeFactoryImpl targetTypeFactory = new MySqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)targetTypeFactory);
        RexCorrelVariable node = (RexCorrelVariable)builder.makeCorrel(type, new CorrelationId(0));
        RexNode copy = builder.copy((RexNode)node);
        Assert.assertTrue((boolean)(copy instanceof RexCorrelVariable));
        RexCorrelVariable result = (RexCorrelVariable)copy;
        Assert.assertThat((Object)result.id, (Matcher)Is.is((Object)node.id));
        Assert.assertThat((Object)result.getType().getSqlTypeName(), (Matcher)Is.is((Object)SqlTypeName.VARCHAR));
        Assert.assertThat((Object)result.getType().getPrecision(), (Matcher)Is.is((Object)256));
    }

    @Test
    public void testCopyLocalRef() {
        SqlTypeFactoryImpl sourceTypeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataType type = sourceTypeFactory.createSqlType(SqlTypeName.VARCHAR, 65536);
        MySqlTypeFactoryImpl targetTypeFactory = new MySqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)targetTypeFactory);
        RexLocalRef node = new RexLocalRef(0, type);
        RexNode copy = builder.copy((RexNode)node);
        Assert.assertTrue((boolean)(copy instanceof RexLocalRef));
        RexLocalRef result = (RexLocalRef)copy;
        Assert.assertThat((Object)result.getIndex(), (Matcher)Is.is((Object)node.getIndex()));
        Assert.assertThat((Object)result.getType().getSqlTypeName(), (Matcher)Is.is((Object)SqlTypeName.VARCHAR));
        Assert.assertThat((Object)result.getType().getPrecision(), (Matcher)Is.is((Object)256));
    }

    @Test
    public void testCopyDynamicParam() {
        SqlTypeFactoryImpl sourceTypeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataType type = sourceTypeFactory.createSqlType(SqlTypeName.VARCHAR, 65536);
        MySqlTypeFactoryImpl targetTypeFactory = new MySqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)targetTypeFactory);
        RexDynamicParam node = builder.makeDynamicParam(type, 0);
        RexNode copy = builder.copy((RexNode)node);
        Assert.assertTrue((boolean)(copy instanceof RexDynamicParam));
        RexDynamicParam result = (RexDynamicParam)copy;
        Assert.assertThat((Object)result.getIndex(), (Matcher)Is.is((Object)node.getIndex()));
        Assert.assertThat((Object)result.getType().getSqlTypeName(), (Matcher)Is.is((Object)SqlTypeName.VARCHAR));
        Assert.assertThat((Object)result.getType().getPrecision(), (Matcher)Is.is((Object)256));
    }

    @Test
    public void testCopyRangeRef() {
        SqlTypeFactoryImpl sourceTypeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataType type = sourceTypeFactory.createSqlType(SqlTypeName.VARCHAR, 65536);
        MySqlTypeFactoryImpl targetTypeFactory = new MySqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RexBuilder builder = new RexBuilder((RelDataTypeFactory)targetTypeFactory);
        RexRangeRef node = builder.makeRangeReference(type, 1, true);
        RexNode copy = builder.copy((RexNode)node);
        Assert.assertTrue((boolean)(copy instanceof RexRangeRef));
        RexRangeRef result = (RexRangeRef)copy;
        Assert.assertThat((Object)result.getOffset(), (Matcher)Is.is((Object)node.getOffset()));
        Assert.assertThat((Object)result.getType().getSqlTypeName(), (Matcher)Is.is((Object)SqlTypeName.VARCHAR));
        Assert.assertThat((Object)result.getType().getPrecision(), (Matcher)Is.is((Object)256));
    }

    private void checkBigDecimalLiteral(RexBuilder builder, String val) {
        RexLiteral literal = builder.makeExactLiteral(new BigDecimal(val));
        Assert.assertThat((String)("builder.makeExactLiteral(new BigDecimal(" + val + ")).getValueAs(BigDecimal.class).toString()"), (Object)((BigDecimal)literal.getValueAs(BigDecimal.class)).toString(), (Matcher)Is.is((Object)val));
    }

    private static class MySqlTypeFactoryImpl
    extends SqlTypeFactoryImpl {
        MySqlTypeFactoryImpl(RelDataTypeSystem typeSystem) {
            super(typeSystem);
        }

        public RelDataType createTypeWithNullability(RelDataType type, boolean nullable) {
            if (type.getSqlTypeName() == SqlTypeName.VARCHAR) {
                return new BasicSqlType(this.typeSystem, type.getSqlTypeName(), 256);
            }
            return super.createTypeWithNullability(type, nullable);
        }
    }
}

