/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.Arrays;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.rules.JoinToCorrelateRule;
import org.apache.calcite.rel.rules.SemiJoinRule;
import org.apache.calcite.rel.rules.SortProjectTransposeRule;
import org.apache.calcite.rel.rules.SortRemoveRule;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schemas.HrClusteredSchema;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.tools.RuleSets;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public final class SortRemoveRuleTest {
    private RelNode transform(String sql, RuleSet prepareRules) throws Exception {
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
        SchemaPlus defSchema = rootSchema.add("hr", (Schema)new HrClusteredSchema());
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(SqlParser.Config.DEFAULT).defaultSchema(defSchema).traitDefs(new RelTraitDef[]{ConventionTraitDef.INSTANCE, RelCollationTraitDef.INSTANCE}).programs(new Program[]{Programs.of((RuleSet)prepareRules), Programs.ofRules((RelOptRule[])new RelOptRule[]{SortRemoveRule.INSTANCE})}).build();
        Planner planner = Frameworks.getPlanner((FrameworkConfig)config);
        SqlNode parse = planner.parse(sql);
        SqlNode validate = planner.validate(parse);
        RelRoot planRoot = planner.rel(validate);
        RelNode planBefore = planRoot.rel;
        RelTraitSet desiredTraits = planBefore.getTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode planAfter = planner.transform(0, desiredTraits, planBefore);
        return planner.transform(1, desiredTraits, planAfter);
    }

    @Test
    public void removeSortOverEnumerableHashJoin() throws Exception {
        RuleSet prepareRules = RuleSets.ofList((RelOptRule[])new RelOptRule[]{SortProjectTransposeRule.INSTANCE, EnumerableRules.ENUMERABLE_JOIN_RULE, EnumerableRules.ENUMERABLE_PROJECT_RULE, EnumerableRules.ENUMERABLE_SORT_RULE, EnumerableRules.ENUMERABLE_TABLE_SCAN_RULE});
        for (String joinType : Arrays.asList("left", "right", "full", "inner")) {
            String sql = "select e.\"deptno\" from \"hr\".\"emps\" e " + joinType + " join \"hr\".\"depts\" d  on e.\"deptno\" = d.\"deptno\" order by e.\"empid\" ";
            RelNode actualPlan = this.transform(sql, prepareRules);
            Assert.assertThat((Object)this.toString(actualPlan), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"EnumerableHashJoin"), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"EnumerableSort"))));
        }
    }

    @Test
    public void removeSortOverEnumerableNestedLoopJoin() throws Exception {
        RuleSet prepareRules = RuleSets.ofList((RelOptRule[])new RelOptRule[]{SortProjectTransposeRule.INSTANCE, EnumerableRules.ENUMERABLE_JOIN_RULE, EnumerableRules.ENUMERABLE_PROJECT_RULE, EnumerableRules.ENUMERABLE_SORT_RULE, EnumerableRules.ENUMERABLE_TABLE_SCAN_RULE});
        for (String joinType : Arrays.asList("left", "right", "full")) {
            String sql = "select e.\"deptno\" from \"hr\".\"emps\" e " + joinType + " join \"hr\".\"depts\" d  on e.\"deptno\" > d.\"deptno\" order by e.\"empid\" ";
            RelNode actualPlan = this.transform(sql, prepareRules);
            Assert.assertThat((Object)this.toString(actualPlan), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"EnumerableNestedLoopJoin"), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"EnumerableSort"))));
        }
    }

    @Test
    public void removeSortOverEnumerableCorrelate() throws Exception {
        RuleSet prepareRules = RuleSets.ofList((RelOptRule[])new RelOptRule[]{SortProjectTransposeRule.INSTANCE, JoinToCorrelateRule.INSTANCE, EnumerableRules.ENUMERABLE_PROJECT_RULE, EnumerableRules.ENUMERABLE_CORRELATE_RULE, EnumerableRules.ENUMERABLE_FILTER_RULE, EnumerableRules.ENUMERABLE_TABLE_SCAN_RULE});
        for (String joinType : Arrays.asList("left", "inner")) {
            String sql = "select e.\"deptno\" from \"hr\".\"emps\" e " + joinType + " join \"hr\".\"depts\" d  on e.\"deptno\" = d.\"deptno\" order by e.\"empid\" ";
            RelNode actualPlan = this.transform(sql, prepareRules);
            Assert.assertThat((Object)this.toString(actualPlan), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"EnumerableCorrelate"), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"EnumerableSort"))));
        }
    }

    @Test
    public void removeSortOverEnumerableSemiJoin() throws Exception {
        RuleSet prepareRules = RuleSets.ofList((RelOptRule[])new RelOptRule[]{SortProjectTransposeRule.INSTANCE, SemiJoinRule.PROJECT, SemiJoinRule.JOIN, EnumerableRules.ENUMERABLE_PROJECT_RULE, EnumerableRules.ENUMERABLE_SORT_RULE, EnumerableRules.ENUMERABLE_JOIN_RULE, EnumerableRules.ENUMERABLE_FILTER_RULE, EnumerableRules.ENUMERABLE_TABLE_SCAN_RULE});
        String sql = "select e.\"deptno\" from \"hr\".\"emps\" e\n where e.\"deptno\" in (select d.\"deptno\" from \"hr\".\"depts\" d)\n order by e.\"empid\"";
        RelNode actualPlan = this.transform(sql, prepareRules);
        Assert.assertThat((Object)this.toString(actualPlan), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"EnumerableHashJoin"), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"EnumerableSort"))));
    }

    private String toString(RelNode rel) {
        return Util.toLinux((String)RelOptUtil.dumpPlan((String)"", (RelNode)rel, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.DIGEST_ATTRIBUTES));
    }
}

