/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schemas.HrClusteredSchema;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.tools.RuleSets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class EnumerableLimitRuleTest {
    @Test
    public void enumerableLimitOnEmptySort() throws Exception {
        RuleSet prepareRules = RuleSets.ofList((RelOptRule[])new RelOptRule[]{EnumerableRules.ENUMERABLE_FILTER_RULE, EnumerableRules.ENUMERABLE_SORT_RULE, EnumerableRules.ENUMERABLE_LIMIT_RULE, EnumerableRules.ENUMERABLE_TABLE_SCAN_RULE});
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
        SchemaPlus defSchema = rootSchema.add("hr", (Schema)new HrClusteredSchema());
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(SqlParser.Config.DEFAULT).defaultSchema(defSchema).traitDefs(new RelTraitDef[]{ConventionTraitDef.INSTANCE, RelCollationTraitDef.INSTANCE}).programs(new Program[]{Programs.of((RuleSet)prepareRules)}).build();
        RelBuilder builder = RelBuilder.create((FrameworkConfig)config);
        RelNode planBefore = builder.scan(new String[]{"hr", "emps"}).sort(new RexNode[]{builder.field(0)}).filter(new RexNode[]{builder.notEquals((RexNode)builder.field(0), builder.literal((Object)100))}).limit(1, 5).build();
        RelTraitSet desiredTraits = planBefore.getTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        Program program = Programs.of((RuleSet)prepareRules);
        RelNode planAfter = program.run(planBefore.getCluster().getPlanner(), planBefore, desiredTraits, (List)ImmutableList.of(), (List)ImmutableList.of());
        RelCollation collation = (RelCollation)planAfter.getTraitSet().getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE);
        Assert.assertThat((Object)collation, (Matcher)CoreMatchers.notNullValue());
        List fieldCollationList = collation.getFieldCollations();
        Assert.assertThat((Object)fieldCollationList, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)fieldCollationList.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((RelFieldCollation)fieldCollationList.get(0)).getFieldIndex(), (Matcher)CoreMatchers.is((Object)0));
    }
}

