/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.calcite.adapter.enumerable.EnumerableTableScan;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptAbstractTable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.SortRemoveRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.server.CalciteServerStatement;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.tools.RuleSets;
import org.apache.calcite.util.ImmutableBitSet;
import org.junit.Assert;
import org.junit.Test;

public class TraitPropagationTest {
    static final Convention PHYSICAL = new Convention.Impl("PHYSICAL", Phys.class);
    static final RelCollation COLLATION = RelCollations.of((RelFieldCollation[])new RelFieldCollation[]{new RelFieldCollation(0, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.FIRST)});
    static final RuleSet RULES = RuleSets.ofList((RelOptRule[])new RelOptRule[]{PhysAggRule.INSTANCE, PhysProjRule.INSTANCE, PhysTableRule.INSTANCE, PhysSortRule.INSTANCE, SortRemoveRule.INSTANCE, AbstractConverter.ExpandConversionRule.INSTANCE});

    @Test
    public void testOne() throws Exception {
        RelNode planned = TraitPropagationTest.run(new PropAction(), RULES);
        if (((Boolean)CalciteSystemProperty.DEBUG.value()).booleanValue()) {
            System.out.println(RelOptUtil.dumpPlan((String)"LOGICAL PLAN", (RelNode)planned, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES));
        }
        RelMetadataQuery mq = RelMetadataQuery.instance();
        Assert.assertEquals((String)"Sortedness was not propagated", (double)3.0, (double)mq.getCumulativeCost(planned).getRows(), (double)0.0);
    }

    public static RelOptRuleOperand anyChild(Class<? extends RelNode> first) {
        return RelOptRule.operand(first, (RelOptRuleOperandChildren)RelOptRule.any());
    }

    private static RelNode run(PropAction action, RuleSet rules) throws Exception {
        FrameworkConfig config = Frameworks.newConfigBuilder().ruleSets(new RuleSet[]{rules}).build();
        Properties info = new Properties();
        Connection connection = DriverManager.getConnection("jdbc:calcite:", info);
        CalciteServerStatement statement = connection.createStatement().unwrap(CalciteServerStatement.class);
        CalcitePrepare.Context prepareContext = statement.createPrepareContext();
        JavaTypeFactory typeFactory = prepareContext.getTypeFactory();
        CalciteCatalogReader catalogReader = new CalciteCatalogReader(prepareContext.getRootSchema(), prepareContext.getDefaultSchemaPath(), (RelDataTypeFactory)typeFactory, prepareContext.config());
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)typeFactory);
        VolcanoPlanner planner = new VolcanoPlanner(config.getCostFactory(), config.getContext());
        planner.clearRelTraitDefs();
        planner.addRelTraitDef((RelTraitDef)RelCollationTraitDef.INSTANCE);
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.clear();
        for (RelOptRule r : rules) {
            planner.addRule(r);
        }
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)rexBuilder);
        return action.apply(cluster, (RelOptSchema)catalogReader, prepareContext.getRootSchema().plus());
    }

    private static class PhysTable
    extends AbstractRelNode
    implements Phys {
        PhysTable(RelOptCluster cluster) {
            super(cluster, cluster.traitSet().replace((RelTrait)PHYSICAL).replace((RelTrait)COLLATION));
            RelDataTypeFactory typeFactory = cluster.getTypeFactory();
            RelDataType stringType = typeFactory.createJavaType(String.class);
            RelDataType integerType = typeFactory.createJavaType(Integer.class);
            this.rowType = typeFactory.builder().add("s", stringType).add("i", integerType).build();
        }

        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeCost(1.0, 1.0, 1.0);
        }
    }

    private static class PhysSort
    extends Sort
    implements Phys {
        PhysSort(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
            super(cluster, traits, child, collation, offset, fetch);
        }

        public PhysSort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
            return new PhysSort(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
        }

        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeCost(1.0, 1.0, 1.0);
        }
    }

    private static class PhysProj
    extends Project
    implements Phys {
        PhysProj(RelOptCluster cluster, RelTraitSet traits, RelNode child, List<RexNode> exps, RelDataType rowType) {
            super(cluster, traits, child, exps, rowType);
        }

        public static PhysProj create(RelNode input, List<RexNode> projects, RelDataType rowType) {
            RelOptCluster cluster = input.getCluster();
            RelMetadataQuery mq = RelMetadataQuery.instance();
            RelTraitSet traitSet = cluster.traitSet().replace((RelTrait)PHYSICAL).replaceIfs((RelTraitDef)RelCollationTraitDef.INSTANCE, () -> RelMdCollation.project((RelMetadataQuery)mq, (RelNode)input, (List)projects));
            return new PhysProj(cluster, traitSet, input, projects, rowType);
        }

        public PhysProj copy(RelTraitSet traitSet, RelNode input, List<RexNode> exps, RelDataType rowType) {
            return new PhysProj(this.getCluster(), traitSet, input, exps, rowType);
        }

        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeCost(1.0, 1.0, 1.0);
        }
    }

    private static class PhysAgg
    extends Aggregate
    implements Phys {
        PhysAgg(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
            super(cluster, traitSet, input, groupSet, groupSets, aggCalls);
        }

        public Aggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
            return new PhysAgg(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls);
        }

        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeCost(1.0, 1.0, 1.0);
        }
    }

    private static interface Phys
    extends RelNode {
    }

    private static class PhysTableRule
    extends RelOptRule {
        static final PhysTableRule INSTANCE = new PhysTableRule();

        private PhysTableRule() {
            super(TraitPropagationTest.anyChild(EnumerableTableScan.class), "PhysScan");
        }

        public void onMatch(RelOptRuleCall call) {
            EnumerableTableScan rel = (EnumerableTableScan)call.rel(0);
            call.transformTo((RelNode)new PhysTable(rel.getCluster()));
        }
    }

    private static class PhysSortRule
    extends ConverterRule {
        static final PhysSortRule INSTANCE = new PhysSortRule();

        PhysSortRule() {
            super(Sort.class, (RelTrait)Convention.NONE, (RelTrait)PHYSICAL, "PhysSortRule");
        }

        public RelNode convert(RelNode rel) {
            Sort sort = (Sort)rel;
            RelNode input = PhysSortRule.convert((RelNode)sort.getInput(), (RelTraitSet)rel.getCluster().traitSetOf((RelTrait)PHYSICAL));
            return new PhysSort(rel.getCluster(), input.getTraitSet().plus((RelTrait)sort.getCollation()), PhysSortRule.convert((RelNode)input, (RelTraitSet)input.getTraitSet().replace((RelTrait)PHYSICAL)), sort.getCollation(), null, null);
        }
    }

    private static class PhysProjRule
    extends RelOptRule {
        static final PhysProjRule INSTANCE = new PhysProjRule(false);
        final boolean subsetHack;

        private PhysProjRule(boolean subsetHack) {
            super(RelOptRule.operand(LogicalProject.class, (RelOptRuleOperand)TraitPropagationTest.anyChild(RelNode.class), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "PhysProj");
            this.subsetHack = subsetHack;
        }

        public void onMatch(RelOptRuleCall call) {
            LogicalProject rel = (LogicalProject)call.rel(0);
            RelNode rawInput = call.rel(1);
            RelNode input = PhysProjRule.convert((RelNode)rawInput, (RelTrait)PHYSICAL);
            if (this.subsetHack && input instanceof RelSubset) {
                RelSubset subset = (RelSubset)input;
                for (RelNode child : subset.getRels()) {
                    if (child.getTraitSet().getTrait((RelTraitDef)ConventionTraitDef.INSTANCE) == Convention.NONE) continue;
                    RelTraitSet outcome = child.getTraitSet().replace((RelTrait)PHYSICAL);
                    call.transformTo((RelNode)new PhysProj(rel.getCluster(), outcome, PhysProjRule.convert((RelNode)child, (RelTraitSet)outcome), rel.getChildExps(), rel.getRowType()));
                }
            } else {
                call.transformTo((RelNode)PhysProj.create(input, rel.getChildExps(), rel.getRowType()));
            }
        }
    }

    private static class PhysAggRule
    extends RelOptRule {
        static final PhysAggRule INSTANCE = new PhysAggRule();

        private PhysAggRule() {
            super(TraitPropagationTest.anyChild(LogicalAggregate.class), "PhysAgg");
        }

        public void onMatch(RelOptRuleCall call) {
            RelTraitSet empty = call.getPlanner().emptyTraitSet();
            LogicalAggregate rel = (LogicalAggregate)call.rel(0);
            assert (rel.getGroupSet().cardinality() == 1);
            int aggIndex = (Integer)rel.getGroupSet().iterator().next();
            RelCollation collation = RelCollations.of((RelFieldCollation[])new RelFieldCollation[]{new RelFieldCollation(aggIndex, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.FIRST)});
            RelTraitSet desiredTraits = empty.replace((RelTrait)PHYSICAL).replace((RelTrait)collation);
            RelNode convertedInput = PhysAggRule.convert((RelNode)rel.getInput(), (RelTraitSet)desiredTraits);
            call.transformTo((RelNode)new PhysAgg(rel.getCluster(), empty.replace((RelTrait)PHYSICAL), convertedInput, rel.getGroupSet(), (List<ImmutableBitSet>)rel.getGroupSets(), rel.getAggCallList()));
        }
    }

    private static class PropAction {
        private PropAction() {
        }

        public RelNode apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema) {
            LogicalAggregate agg;
            RelDataTypeFactory typeFactory = cluster.getTypeFactory();
            RexBuilder rexBuilder = cluster.getRexBuilder();
            RelOptPlanner planner = cluster.getPlanner();
            final RelDataType stringType = typeFactory.createJavaType(String.class);
            final RelDataType integerType = typeFactory.createJavaType(Integer.class);
            RelDataType sqlBigInt = typeFactory.createSqlType(SqlTypeName.BIGINT);
            AbstractTable table = new AbstractTable(){

                public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                    return typeFactory.builder().add("s", stringType).add("i", integerType).build();
                }

                public Statistic getStatistic() {
                    return Statistics.of((double)100.0, (List)ImmutableList.of(), (List)ImmutableList.of((Object)COLLATION));
                }
            };
            RelOptAbstractTable t1 = new RelOptAbstractTable(relOptSchema, "t1", table.getRowType(typeFactory), (Table)table){
                final /* synthetic */ Table val$table;
                {
                    this.val$table = table;
                    super(x0, x1, x2);
                }

                public <T> T unwrap(Class<T> clazz) {
                    return (T)(clazz.isInstance(this.val$table) ? clazz.cast(this.val$table) : super.unwrap(clazz));
                }
            };
            EnumerableTableScan rt1 = EnumerableTableScan.create((RelOptCluster)cluster, (RelOptTable)t1);
            LogicalProject project = LogicalProject.create((RelNode)rt1, (List)ImmutableList.of((Object)rexBuilder.makeInputRef(stringType, 0), (Object)rexBuilder.makeInputRef(integerType, 1)), (RelDataType)typeFactory.builder().add("s", stringType).add("i", integerType).build());
            AggregateCall aggCall = AggregateCall.create((SqlAggFunction)SqlStdOperatorTable.COUNT, (boolean)false, (boolean)false, (boolean)false, Collections.singletonList(1), (int)-1, (RelCollation)RelCollations.EMPTY, (RelDataType)sqlBigInt, (String)"cnt");
            LogicalAggregate rootRel = agg = new LogicalAggregate(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), (RelNode)project, ImmutableBitSet.of((int[])new int[]{0}), null, Collections.singletonList(aggCall));
            RelOptUtil.dumpPlan((String)"LOGICAL PLAN", (RelNode)rootRel, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.DIGEST_ATTRIBUTES);
            RelTraitSet desiredTraits = rootRel.getTraitSet().replace((RelTrait)PHYSICAL);
            RelNode rootRel2 = planner.changeTraits((RelNode)rootRel, desiredTraits);
            planner.setRoot(rootRel2);
            return planner.findBestExp();
        }
    }
}

