/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.externalize.RelJsonReader;
import org.apache.calcite.rel.externalize.RelJsonWriter;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.JdbcTest;
import org.apache.calcite.test.Matchers;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.TestUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RelWriterTest {
    public static final String XX = "{\n  \"rels\": [\n    {\n      \"id\": \"0\",\n      \"relOp\": \"LogicalTableScan\",\n      \"table\": [\n        \"hr\",\n        \"emps\"\n      ],\n      \"inputs\": []\n    },\n    {\n      \"id\": \"1\",\n      \"relOp\": \"LogicalFilter\",\n      \"condition\": {\n        \"op\": \"=\",\n        \"operands\": [\n          {\n            \"input\": 1,\n            \"name\": \"$1\"\n          },\n          {\n            \"literal\": 10,\n            \"type\": {\n              \"type\": \"INTEGER\",\n              \"nullable\": false\n            }\n          }\n        ]\n      }\n    },\n    {\n      \"id\": \"2\",\n      \"relOp\": \"LogicalAggregate\",\n      \"group\": [\n        0\n      ],\n      \"aggs\": [\n        {\n          \"agg\": \"COUNT\",\n          \"type\": {\n            \"type\": \"BIGINT\",\n            \"nullable\": false\n          },\n          \"distinct\": true,\n          \"operands\": [\n            1\n          ]\n        },\n        {\n          \"agg\": \"COUNT\",\n          \"type\": {\n            \"type\": \"BIGINT\",\n            \"nullable\": false\n          },\n          \"distinct\": false,\n          \"operands\": []\n        }\n      ]\n    }\n  ]\n}";
    public static final String XXNULL = "{\n  \"rels\": [\n    {\n      \"id\": \"0\",\n      \"relOp\": \"LogicalTableScan\",\n      \"table\": [\n        \"hr\",\n        \"emps\"\n      ],\n      \"inputs\": []\n    },\n    {\n      \"id\": \"1\",\n      \"relOp\": \"LogicalFilter\",\n      \"condition\": {\n        \"op\": \"=\",\n        \"operands\": [\n          {\n            \"input\": 1,\n            \"name\": \"$1\"\n          },\n          {\n            \"literal\": null,\n            \"type\": \"INTEGER\"\n          }\n        ]\n      }\n    },\n    {\n      \"id\": \"2\",\n      \"relOp\": \"LogicalAggregate\",\n      \"group\": [\n        0\n      ],\n      \"aggs\": [\n        {\n          \"agg\": \"COUNT\",\n          \"type\": {\n            \"type\": \"BIGINT\",\n            \"nullable\": false\n          },\n          \"distinct\": true,\n          \"operands\": [\n            1\n          ]\n        },\n        {\n          \"agg\": \"COUNT\",\n          \"type\": {\n            \"type\": \"BIGINT\",\n            \"nullable\": false\n          },\n          \"distinct\": false,\n          \"operands\": []\n        }\n      ]\n    }\n  ]\n}";
    public static final String XX2 = "{\n  \"rels\": [\n    {\n      \"id\": \"0\",\n      \"relOp\": \"LogicalTableScan\",\n      \"table\": [\n        \"hr\",\n        \"emps\"\n      ],\n      \"inputs\": []\n    },\n    {\n      \"id\": \"1\",\n      \"relOp\": \"LogicalProject\",\n      \"fields\": [\n        \"field0\",\n        \"field1\",\n        \"field2\"\n      ],\n      \"exprs\": [\n        {\n          \"input\": 0,\n          \"name\": \"$0\"\n        },\n        {\n          \"op\": \"COUNT\",\n          \"operands\": [\n            {\n              \"input\": 0,\n              \"name\": \"$0\"\n            }\n          ],\n          \"distinct\": false,\n          \"type\": {\n            \"type\": \"BIGINT\",\n            \"nullable\": false\n          },\n          \"window\": {\n            \"partition\": [\n              {\n                \"input\": 2,\n                \"name\": \"$2\"\n              }\n            ],\n            \"order\": [\n              {\n                \"expr\": {\n                  \"input\": 1,\n                  \"name\": \"$1\"\n                },\n                \"direction\": \"ASCENDING\",\n                \"null-direction\": \"LAST\"\n              }\n            ],\n            \"rows-lower\": {\n              \"type\": \"UNBOUNDED_PRECEDING\"\n            },\n            \"rows-upper\": {\n              \"type\": \"CURRENT_ROW\"\n            }\n          }\n        },\n        {\n          \"op\": \"SUM\",\n          \"operands\": [\n            {\n              \"input\": 0,\n              \"name\": \"$0\"\n            }\n          ],\n          \"distinct\": false,\n          \"type\": {\n            \"type\": \"BIGINT\",\n            \"nullable\": false\n          },\n          \"window\": {\n            \"partition\": [\n              {\n                \"input\": 2,\n                \"name\": \"$2\"\n              }\n            ],\n            \"order\": [\n              {\n                \"expr\": {\n                  \"input\": 1,\n                  \"name\": \"$1\"\n                },\n                \"direction\": \"ASCENDING\",\n                \"null-direction\": \"LAST\"\n              }\n            ],\n            \"range-lower\": {\n              \"type\": \"CURRENT_ROW\"\n            },\n            \"range-upper\": {\n              \"type\": \"FOLLOWING\",\n              \"offset\": {\n                \"literal\": 1,\n                \"type\": {\n                  \"type\": \"INTEGER\",\n                  \"nullable\": false\n                }\n              }\n            }\n          }\n        }\n      ]\n    }\n  ]\n}";

    @Test
    public void testWriter() {
        String s = (String)Frameworks.withPlanner((cluster, relOptSchema, rootSchema) -> {
            rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
            LogicalTableScan scan = LogicalTableScan.create((RelOptCluster)cluster, (RelOptTable)relOptSchema.getTableForMember(Arrays.asList("hr", "emps")));
            RexBuilder rexBuilder = cluster.getRexBuilder();
            LogicalFilter filter = LogicalFilter.create((RelNode)scan, (RexNode)rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeFieldAccess(rexBuilder.makeRangeReference((RelNode)scan), "deptno", true), rexBuilder.makeExactLiteral(BigDecimal.TEN)}));
            RelJsonWriter writer = new RelJsonWriter();
            RelDataType bigIntType = cluster.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
            LogicalAggregate aggregate = LogicalAggregate.create((RelNode)filter, (ImmutableBitSet)ImmutableBitSet.of((int[])new int[]{0}), null, (List)ImmutableList.of((Object)AggregateCall.create((SqlAggFunction)SqlStdOperatorTable.COUNT, (boolean)true, (boolean)false, (boolean)false, (List)ImmutableList.of((Object)1), (int)-1, (RelCollation)RelCollations.EMPTY, (RelDataType)bigIntType, (String)"c"), (Object)AggregateCall.create((SqlAggFunction)SqlStdOperatorTable.COUNT, (boolean)false, (boolean)false, (boolean)false, (List)ImmutableList.of(), (int)-1, (RelCollation)RelCollations.EMPTY, (RelDataType)bigIntType, (String)"d")));
            aggregate.explain((RelWriter)writer);
            return writer.asString();
        });
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.is((Object)XX));
    }

    @Test
    public void testWriter2() {
        String s = (String)Frameworks.withPlanner((cluster, relOptSchema, rootSchema) -> {
            rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
            LogicalTableScan scan = LogicalTableScan.create((RelOptCluster)cluster, (RelOptTable)relOptSchema.getTableForMember(Arrays.asList("hr", "emps")));
            RexBuilder rexBuilder = cluster.getRexBuilder();
            RelDataType bigIntType = cluster.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
            LogicalProject project = LogicalProject.create((RelNode)scan, (List)ImmutableList.of((Object)rexBuilder.makeInputRef((RelNode)scan, 0), (Object)rexBuilder.makeOver(bigIntType, SqlStdOperatorTable.COUNT, (List)ImmutableList.of((Object)rexBuilder.makeInputRef((RelNode)scan, 0)), (List)ImmutableList.of((Object)rexBuilder.makeInputRef((RelNode)scan, 2)), ImmutableList.of((Object)new RexFieldCollation((RexNode)rexBuilder.makeInputRef((RelNode)scan, 1), (Set)ImmutableSet.of())), RexWindowBound.create((SqlNode)SqlWindow.createUnboundedPreceding((SqlParserPos)SqlParserPos.ZERO), null), RexWindowBound.create((SqlNode)SqlWindow.createCurrentRow((SqlParserPos)SqlParserPos.ZERO), null), true, true, false, false, false), (Object)rexBuilder.makeOver(bigIntType, SqlStdOperatorTable.SUM, (List)ImmutableList.of((Object)rexBuilder.makeInputRef((RelNode)scan, 0)), (List)ImmutableList.of((Object)rexBuilder.makeInputRef((RelNode)scan, 2)), ImmutableList.of((Object)new RexFieldCollation((RexNode)rexBuilder.makeInputRef((RelNode)scan, 1), (Set)ImmutableSet.of())), RexWindowBound.create((SqlNode)SqlWindow.createCurrentRow((SqlParserPos)SqlParserPos.ZERO), null), RexWindowBound.create(null, (RexNode)rexBuilder.makeCall((SqlOperator)SqlWindow.FOLLOWING_OPERATOR, new RexNode[]{rexBuilder.makeExactLiteral(BigDecimal.ONE)})), false, true, false, false, false)), (List)ImmutableList.of((Object)"field0", (Object)"field1", (Object)"field2"));
            RelJsonWriter writer = new RelJsonWriter();
            project.explain((RelWriter)writer);
            return writer.asString();
        });
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.is((Object)XX2));
    }

    @Test
    public void testReader() {
        String s = (String)Frameworks.withPlanner((cluster, relOptSchema, rootSchema) -> {
            RelNode node;
            SchemaPlus schema = rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
            RelJsonReader reader = new RelJsonReader(cluster, relOptSchema, (Schema)schema);
            try {
                node = reader.read(XX);
            }
            catch (IOException e) {
                throw TestUtil.rethrow(e);
            }
            return RelOptUtil.dumpPlan((String)"", (RelNode)node, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.EXPPLAN_ATTRIBUTES);
        });
        Assert.assertThat((Object)s, Matchers.isLinux("LogicalAggregate(group=[{0}], agg#0=[COUNT(DISTINCT $1)], agg#1=[COUNT()])\n  LogicalFilter(condition=[=($1, 10)])\n    LogicalTableScan(table=[[hr, emps]])\n"));
    }

    @Test
    public void testReader2() {
        String s = (String)Frameworks.withPlanner((cluster, relOptSchema, rootSchema) -> {
            RelNode node;
            SchemaPlus schema = rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
            RelJsonReader reader = new RelJsonReader(cluster, relOptSchema, (Schema)schema);
            try {
                node = reader.read(XX2);
            }
            catch (IOException e) {
                throw TestUtil.rethrow(e);
            }
            return RelOptUtil.dumpPlan((String)"", (RelNode)node, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.EXPPLAN_ATTRIBUTES);
        });
        Assert.assertThat((Object)s, Matchers.isLinux("LogicalProject(field0=[$0], field1=[COUNT($0) OVER (PARTITION BY $2 ORDER BY $1 NULLS LAST ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)], field2=[SUM($0) OVER (PARTITION BY $2 ORDER BY $1 NULLS LAST RANGE BETWEEN CURRENT ROW AND 1 FOLLOWING)])\n  LogicalTableScan(table=[[hr, emps]])\n"));
    }

    @Test
    public void testReaderNull() {
        String s = (String)Frameworks.withPlanner((cluster, relOptSchema, rootSchema) -> {
            RelNode node;
            SchemaPlus schema = rootSchema.add("hr", (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
            RelJsonReader reader = new RelJsonReader(cluster, relOptSchema, (Schema)schema);
            try {
                node = reader.read(XXNULL);
            }
            catch (IOException e) {
                throw TestUtil.rethrow(e);
            }
            return RelOptUtil.dumpPlan((String)"", (RelNode)node, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.EXPPLAN_ATTRIBUTES);
        });
        Assert.assertThat((Object)s, Matchers.isLinux("LogicalAggregate(group=[{0}], agg#0=[COUNT(DISTINCT $1)], agg#1=[COUNT()])\n  LogicalFilter(condition=[=($1, null:INTEGER)])\n    LogicalTableScan(table=[[hr, emps]])\n"));
    }
}

