/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RelOptUtilTest {
    private RelBuilder relBuilder;
    private RelNode empScan;
    private RelNode deptScan;
    private RelDataType empRow;
    private RelDataType deptRow;
    private List<RelDataTypeField> empDeptJoinRelFields;

    private static Frameworks.ConfigBuilder config() {
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
        return Frameworks.newConfigBuilder().parserConfig(SqlParser.Config.DEFAULT).defaultSchema(CalciteAssert.addSchema(rootSchema, CalciteAssert.SchemaSpec.SCOTT));
    }

    @Before
    public void setUp() {
        this.relBuilder = RelBuilder.create((FrameworkConfig)RelOptUtilTest.config().build());
        this.empScan = this.relBuilder.scan(new String[]{"EMP"}).build();
        this.deptScan = this.relBuilder.scan(new String[]{"DEPT"}).build();
        this.empRow = this.empScan.getRowType();
        this.deptRow = this.deptScan.getRowType();
        this.empDeptJoinRelFields = Lists.newArrayList((Iterable)Iterables.concat((Iterable)this.empRow.getFieldList(), (Iterable)this.deptRow.getFieldList()));
    }

    @Test
    public void testTypeDump() {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataType t1 = typeFactory.builder().add("f0", SqlTypeName.DECIMAL, 5, 2).add("f1", SqlTypeName.VARCHAR, 10).build();
        TestUtil.assertEqualsVerbose(TestUtil.fold("f0 DECIMAL(5, 2) NOT NULL,", "f1 VARCHAR(10) NOT NULL"), Util.toLinux((String)(RelOptUtil.dumpType((RelDataType)t1) + "\n")));
        RelDataType t2 = typeFactory.builder().add("f0", t1).add("f1", typeFactory.createMultisetType(t1, -1L)).build();
        TestUtil.assertEqualsVerbose(TestUtil.fold("f0 RECORD (", "  f0 DECIMAL(5, 2) NOT NULL,", "  f1 VARCHAR(10) NOT NULL) NOT NULL,", "f1 RECORD (", "  f0 DECIMAL(5, 2) NOT NULL,", "  f1 VARCHAR(10) NOT NULL) NOT NULL MULTISET NOT NULL"), Util.toLinux((String)(RelOptUtil.dumpType((RelDataType)t2) + "\n")));
    }

    @Test
    public void testRuleGuessDescription() {
        Assert.assertEquals((Object)"Bar", (Object)RelOptRule.guessDescription((String)"com.foo.Bar"));
        Assert.assertEquals((Object)"Baz", (Object)RelOptRule.guessDescription((String)"com.flatten.Bar$Baz"));
        try {
            Util.discard((Object)RelOptRule.guessDescription((String)"com.foo.Bar$1"));
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Derived description of rule class com.foo.Bar$1 is an integer, not valid. Supply a description manually.", (Object)e.getMessage());
        }
    }

    @Test
    public void testSplitJoinConditionEquals() {
        int leftJoinIndex = this.empScan.getRowType().getFieldNames().indexOf("DEPTNO");
        int rightJoinIndex = this.deptRow.getFieldNames().indexOf("DEPTNO");
        RexNode joinCond = this.relBuilder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{RexInputRef.of((int)leftJoinIndex, this.empDeptJoinRelFields), RexInputRef.of((int)(this.empRow.getFieldCount() + rightJoinIndex), this.empDeptJoinRelFields)});
        this.splitJoinConditionHelper(joinCond, Collections.singletonList(leftJoinIndex), Collections.singletonList(rightJoinIndex), Collections.singletonList(true), this.relBuilder.literal((Object)true));
    }

    @Test
    public void testSplitJoinConditionIsNotDistinctFrom() {
        int leftJoinIndex = this.empScan.getRowType().getFieldNames().indexOf("DEPTNO");
        int rightJoinIndex = this.deptRow.getFieldNames().indexOf("DEPTNO");
        RexNode joinCond = this.relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, new RexNode[]{RexInputRef.of((int)leftJoinIndex, this.empDeptJoinRelFields), RexInputRef.of((int)(this.empRow.getFieldCount() + rightJoinIndex), this.empDeptJoinRelFields)});
        this.splitJoinConditionHelper(joinCond, Collections.singletonList(leftJoinIndex), Collections.singletonList(rightJoinIndex), Collections.singletonList(false), this.relBuilder.literal((Object)true));
    }

    @Test
    public void testSplitJoinConditionExpandedIsNotDistinctFrom() {
        int leftJoinIndex = this.empScan.getRowType().getFieldNames().indexOf("DEPTNO");
        int rightJoinIndex = this.deptRow.getFieldNames().indexOf("DEPTNO");
        RexInputRef leftKeyInputRef = RexInputRef.of((int)leftJoinIndex, this.empDeptJoinRelFields);
        RexInputRef rightKeyInputRef = RexInputRef.of((int)(this.empRow.getFieldCount() + rightJoinIndex), this.empDeptJoinRelFields);
        RexNode joinCond = this.relBuilder.call((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.relBuilder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{leftKeyInputRef, rightKeyInputRef}), this.relBuilder.call((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{leftKeyInputRef}), this.relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{rightKeyInputRef})})});
        this.splitJoinConditionHelper(joinCond, Collections.singletonList(leftJoinIndex), Collections.singletonList(rightJoinIndex), Collections.singletonList(false), this.relBuilder.literal((Object)true));
    }

    @Test
    public void testSplitJoinConditionExpandedIsNotDistinctFromUsingCase() {
        int leftJoinIndex = this.empScan.getRowType().getFieldNames().indexOf("DEPTNO");
        int rightJoinIndex = this.deptRow.getFieldNames().indexOf("DEPTNO");
        RexInputRef leftKeyInputRef = RexInputRef.of((int)leftJoinIndex, this.empDeptJoinRelFields);
        RexInputRef rightKeyInputRef = RexInputRef.of((int)(this.empRow.getFieldCount() + rightJoinIndex), this.empDeptJoinRelFields);
        RexNode joinCond = RelOptUtil.isDistinctFrom((RexBuilder)this.relBuilder.getRexBuilder(), (RexNode)leftKeyInputRef, (RexNode)rightKeyInputRef, (boolean)true);
        this.splitJoinConditionHelper(joinCond, Collections.singletonList(leftJoinIndex), Collections.singletonList(rightJoinIndex), Collections.singletonList(false), this.relBuilder.literal((Object)true));
    }

    @Test
    public void testSplitJoinConditionExpandedIsNotDistinctFromUsingCase2() {
        int leftJoinIndex = this.empScan.getRowType().getFieldNames().indexOf("DEPTNO");
        int rightJoinIndex = this.deptRow.getFieldNames().indexOf("DEPTNO");
        RexInputRef leftKeyInputRef = RexInputRef.of((int)leftJoinIndex, this.empDeptJoinRelFields);
        RexInputRef rightKeyInputRef = RexInputRef.of((int)(this.empRow.getFieldCount() + rightJoinIndex), this.empDeptJoinRelFields);
        RexNode joinCond = this.relBuilder.call((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{this.relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{leftKeyInputRef}), this.relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{rightKeyInputRef}), this.relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{rightKeyInputRef}), this.relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{leftKeyInputRef}), this.relBuilder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{leftKeyInputRef, rightKeyInputRef})});
        this.splitJoinConditionHelper(joinCond, Collections.singletonList(leftJoinIndex), Collections.singletonList(rightJoinIndex), Collections.singletonList(false), this.relBuilder.literal((Object)true));
    }

    private void splitJoinConditionHelper(RexNode joinCond, List<Integer> expLeftKeys, List<Integer> expRightKeys, List<Boolean> expFilterNulls, RexNode expRemaining) {
        ArrayList actLeftKeys = new ArrayList();
        ArrayList actRightKeys = new ArrayList();
        ArrayList actFilterNulls = new ArrayList();
        RexNode actRemaining = RelOptUtil.splitJoinCondition((RelNode)this.empScan, (RelNode)this.deptScan, (RexNode)joinCond, actLeftKeys, actRightKeys, actFilterNulls);
        Assert.assertEquals((Object)expRemaining, (Object)actRemaining);
        Assert.assertEquals(expFilterNulls, actFilterNulls);
        Assert.assertEquals(expLeftKeys, actLeftKeys);
        Assert.assertEquals(expRightKeys, actRightKeys);
    }

    @Test
    public void testPushDownJoinConditions() {
        int leftJoinIndex = this.empScan.getRowType().getFieldNames().indexOf("DEPTNO");
        int rightJoinIndex = this.deptRow.getFieldNames().indexOf("DEPTNO");
        RexInputRef leftKeyInputRef = RexInputRef.of((int)leftJoinIndex, this.empDeptJoinRelFields);
        RexInputRef rightKeyInputRef = RexInputRef.of((int)(this.empRow.getFieldCount() + rightJoinIndex), this.empDeptJoinRelFields);
        RexNode joinCond = this.relBuilder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{leftKeyInputRef, this.relBuilder.literal((Object)1)}), rightKeyInputRef});
        this.relBuilder.push(this.empScan);
        this.relBuilder.push(this.deptScan);
        this.relBuilder.join(JoinRelType.INNER, joinCond);
        Join join = (Join)this.relBuilder.build();
        RelNode transformed = RelOptUtil.pushDownJoinConditions((Join)join, (RelBuilder)this.relBuilder);
        Assert.assertThat((Object)transformed.getRowType(), (Matcher)CoreMatchers.is((Object)join.getRowType()));
        Assert.assertThat((Object)transformed, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Project.class)));
        RelNode transformedInput = transformed.getInput(0);
        Assert.assertThat((Object)transformedInput, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Join.class)));
        Join newJoin = (Join)transformedInput;
        Assert.assertThat((Object)newJoin.getCondition().toString(), (Matcher)CoreMatchers.is((Object)this.relBuilder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{RexInputRef.of((int)this.empRow.getFieldCount(), (RelDataType)join.getRowType()), RexInputRef.of((int)(this.empRow.getFieldCount() + 1 + rightJoinIndex), (RelDataType)join.getRowType())}).toString()));
        Assert.assertThat((Object)newJoin.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Project.class)));
        Project leftInput = (Project)newJoin.getLeft();
        Assert.assertThat((Object)((RexNode)leftInput.getChildExps().get(this.empRow.getFieldCount())).toString(), (Matcher)CoreMatchers.is((Object)this.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{leftKeyInputRef, this.relBuilder.literal((Object)1)}).toString()));
    }

    @Test
    public void testPushDownJoinConditionsWithIsNotDistinct() {
        int leftJoinIndex = this.empScan.getRowType().getFieldNames().indexOf("DEPTNO");
        int rightJoinIndex = this.deptRow.getFieldNames().indexOf("DEPTNO");
        RexInputRef leftKeyInputRef = RexInputRef.of((int)leftJoinIndex, this.empDeptJoinRelFields);
        RexInputRef rightKeyInputRef = RexInputRef.of((int)(this.empRow.getFieldCount() + rightJoinIndex), this.empDeptJoinRelFields);
        RexNode joinCond = this.relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, new RexNode[]{this.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{leftKeyInputRef, this.relBuilder.literal((Object)1)}), rightKeyInputRef});
        this.relBuilder.push(this.empScan);
        this.relBuilder.push(this.deptScan);
        this.relBuilder.join(JoinRelType.INNER, joinCond);
        Join join = (Join)this.relBuilder.build();
        RelNode transformed = RelOptUtil.pushDownJoinConditions((Join)join, (RelBuilder)this.relBuilder);
        Assert.assertThat((Object)transformed.getRowType(), (Matcher)CoreMatchers.is((Object)join.getRowType()));
        Assert.assertThat((Object)transformed, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Project.class)));
        RelNode transformedInput = transformed.getInput(0);
        Assert.assertThat((Object)transformedInput, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Join.class)));
        Join newJoin = (Join)transformedInput;
        Assert.assertThat((Object)newJoin.getCondition().toString(), (Matcher)CoreMatchers.is((Object)this.relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, new RexNode[]{RexInputRef.of((int)this.empRow.getFieldCount(), (RelDataType)join.getRowType()), RexInputRef.of((int)(this.empRow.getFieldCount() + 1 + rightJoinIndex), (RelDataType)join.getRowType())}).toString()));
        Assert.assertThat((Object)newJoin.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Project.class)));
        Project leftInput = (Project)newJoin.getLeft();
        Assert.assertThat((Object)((RexNode)leftInput.getChildExps().get(this.empRow.getFieldCount())).toString(), (Matcher)CoreMatchers.is((Object)this.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{leftKeyInputRef, this.relBuilder.literal((Object)1)}).toString()));
    }

    @Test
    public void testPushDownJoinConditionsWithExpandedIsNotDistinct() {
        int leftJoinIndex = this.empScan.getRowType().getFieldNames().indexOf("DEPTNO");
        int rightJoinIndex = this.deptRow.getFieldNames().indexOf("DEPTNO");
        RexInputRef leftKeyInputRef = RexInputRef.of((int)leftJoinIndex, this.empDeptJoinRelFields);
        RexInputRef rightKeyInputRef = RexInputRef.of((int)(this.empRow.getFieldCount() + rightJoinIndex), this.empDeptJoinRelFields);
        RexNode joinCond = this.relBuilder.call((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{this.relBuilder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{leftKeyInputRef, this.relBuilder.literal((Object)1)}), rightKeyInputRef}), this.relBuilder.call((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{this.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{leftKeyInputRef, this.relBuilder.literal((Object)1)})}), this.relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{rightKeyInputRef})})});
        this.relBuilder.push(this.empScan);
        this.relBuilder.push(this.deptScan);
        this.relBuilder.join(JoinRelType.INNER, joinCond);
        Join join = (Join)this.relBuilder.build();
        RelNode transformed = RelOptUtil.pushDownJoinConditions((Join)join, (RelBuilder)this.relBuilder);
        Assert.assertThat((Object)transformed.getRowType(), (Matcher)CoreMatchers.is((Object)join.getRowType()));
        Assert.assertThat((Object)transformed, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Project.class)));
        RelNode transformedInput = transformed.getInput(0);
        Assert.assertThat((Object)transformedInput, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Join.class)));
        Join newJoin = (Join)transformedInput;
        Assert.assertThat((Object)newJoin.getCondition().toString(), (Matcher)CoreMatchers.is((Object)this.relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, new RexNode[]{RexInputRef.of((int)this.empRow.getFieldCount(), (RelDataType)join.getRowType()), RexInputRef.of((int)(this.empRow.getFieldCount() + 1 + rightJoinIndex), (RelDataType)join.getRowType())}).toString()));
        Assert.assertThat((Object)newJoin.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Project.class)));
        Project leftInput = (Project)newJoin.getLeft();
        Assert.assertThat((Object)((RexNode)leftInput.getChildExps().get(this.empRow.getFieldCount())).toString(), (Matcher)CoreMatchers.is((Object)this.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{leftKeyInputRef, this.relBuilder.literal((Object)1)}).toString()));
    }

    @Test
    public void testPushDownJoinConditionsWithExpandedIsNotDistinctUsingCase() {
        int leftJoinIndex = this.empScan.getRowType().getFieldNames().indexOf("DEPTNO");
        int rightJoinIndex = this.deptRow.getFieldNames().indexOf("DEPTNO");
        RexInputRef leftKeyInputRef = RexInputRef.of((int)leftJoinIndex, this.empDeptJoinRelFields);
        RexInputRef rightKeyInputRef = RexInputRef.of((int)(this.empRow.getFieldCount() + rightJoinIndex), this.empDeptJoinRelFields);
        RexNode joinCond = this.relBuilder.call((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{this.relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{this.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{leftKeyInputRef, this.relBuilder.literal((Object)1)})}), this.relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{rightKeyInputRef}), this.relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{rightKeyInputRef}), this.relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{this.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{leftKeyInputRef, this.relBuilder.literal((Object)1)})}), this.relBuilder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{leftKeyInputRef, this.relBuilder.literal((Object)1)}), rightKeyInputRef})});
        this.relBuilder.push(this.empScan);
        this.relBuilder.push(this.deptScan);
        this.relBuilder.join(JoinRelType.INNER, joinCond);
        Join join = (Join)this.relBuilder.build();
        RelNode transformed = RelOptUtil.pushDownJoinConditions((Join)join, (RelBuilder)this.relBuilder);
        Assert.assertThat((Object)transformed.getRowType(), (Matcher)CoreMatchers.is((Object)join.getRowType()));
        Assert.assertThat((Object)transformed, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Project.class)));
        RelNode transformedInput = transformed.getInput(0);
        Assert.assertThat((Object)transformedInput, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Join.class)));
        Join newJoin = (Join)transformedInput;
        Assert.assertThat((Object)newJoin.getCondition().toString(), (Matcher)CoreMatchers.is((Object)this.relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, new RexNode[]{RexInputRef.of((int)this.empRow.getFieldCount(), (RelDataType)join.getRowType()), RexInputRef.of((int)(this.empRow.getFieldCount() + 1 + rightJoinIndex), (RelDataType)join.getRowType())}).toString()));
        Assert.assertThat((Object)newJoin.getLeft(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Project.class)));
        Project leftInput = (Project)newJoin.getLeft();
        Assert.assertThat((Object)((RexNode)leftInput.getChildExps().get(this.empRow.getFieldCount())).toString(), (Matcher)CoreMatchers.is((Object)this.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{leftKeyInputRef, this.relBuilder.literal((Object)1)}).toString()));
    }
}

