/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.test.SqlTests;
import org.apache.calcite.sql.type.SqlTypeName;
import org.junit.Assert;
import org.junit.Test;

public final class JavaTypeFactoryTest {
    private static final JavaTypeFactoryImpl TYPE_FACTORY = new JavaTypeFactoryImpl();

    @Test
    public void testGetJavaClassWithOneFieldStructDataTypeV1() {
        RelDataType structWithOneField = TYPE_FACTORY.createStructType(OneFieldStruct.class);
        Assert.assertEquals(OneFieldStruct.class, (Object)TYPE_FACTORY.getJavaClass(structWithOneField));
    }

    @Test
    public void testGetJavaClassWithOneFieldStructDataTypeV2() {
        RelDataType structWithOneField = TYPE_FACTORY.createStructType((List)ImmutableList.of((Object)TYPE_FACTORY.createSqlType(SqlTypeName.INTEGER)), (List)ImmutableList.of((Object)"intField"));
        this.assertRecordType(TYPE_FACTORY.getJavaClass(structWithOneField));
    }

    @Test
    public void testGetJavaClassWithTwoFieldsStructDataType() {
        RelDataType structWithTwoFields = TYPE_FACTORY.createStructType(TwoFieldStruct.class);
        Assert.assertEquals(TwoFieldStruct.class, (Object)TYPE_FACTORY.getJavaClass(structWithTwoFields));
    }

    @Test
    public void testGetJavaClassWithTwoFieldsStructDataTypeV2() {
        RelDataType structWithTwoFields = TYPE_FACTORY.createStructType((List)ImmutableList.of((Object)TYPE_FACTORY.createSqlType(SqlTypeName.INTEGER), (Object)TYPE_FACTORY.createSqlType(SqlTypeName.VARCHAR)), (List)ImmutableList.of((Object)"intField", (Object)"strField"));
        this.assertRecordType(TYPE_FACTORY.getJavaClass(structWithTwoFields));
    }

    @Test
    public void testFieldNullabilityAfterConvertingToSqlStructType() {
        RelDataType javaStructType = TYPE_FACTORY.createStructType((List)ImmutableList.of((Object)TYPE_FACTORY.createJavaType(Integer.class), (Object)TYPE_FACTORY.createJavaType(Integer.TYPE)), (List)ImmutableList.of((Object)"a", (Object)"b"));
        RelDataType sqlStructType = TYPE_FACTORY.toSql(javaStructType);
        Assert.assertEquals((Object)"RecordType(INTEGER a, INTEGER NOT NULL b) NOT NULL", (Object)SqlTests.getTypeString(sqlStructType));
    }

    private void assertRecordType(Type actual) {
        String errorMessage = "Type {" + actual.getTypeName() + "} is not a subtype of Types.RecordType";
        Assert.assertTrue((String)errorMessage, (boolean)(actual instanceof Types.RecordType));
    }

    private static class TwoFieldStruct {
        public Integer intField;
        public String strField;

        private TwoFieldStruct() {
        }
    }

    private static class OneFieldStruct {
        public Integer intField;

        private OneFieldStruct() {
        }
    }
}

