/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.FunctionExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.linq4j.tree.Visitor;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TypeFinderTest {
    @Test
    public void testConstantExpression() {
        ConstantExpression expr = Expressions.constant(null, Integer.class);
        this.assertJavaCodeContains("(Integer) null\n", (Node)expr);
        this.assertTypeContains((Type)((Object)Integer.class), (Node)expr);
    }

    @Test
    public void testConvertExpression() {
        UnaryExpression expr = Expressions.convert_((Expression)Expressions.new_(String.class), Object.class);
        this.assertJavaCodeContains("(Object) new String()\n", (Node)expr);
        this.assertTypeContains(Arrays.asList(String.class, Object.class), (Node)expr);
    }

    @Test
    public void testFunctionExpression1() {
        ParameterExpression param = Expressions.parameter(String.class, (String)"input");
        FunctionExpression expr = Expressions.lambda(Function1.class, (BlockStatement)Expressions.block((Statement[])new Statement[]{Expressions.return_(null, (Expression)param)}), (ParameterExpression[])new ParameterExpression[]{param});
        this.assertJavaCodeContains("new org.apache.calcite.linq4j.function.Function1() {\n  public String apply(String input) {\n    return input;\n  }\n  public Object apply(Object input) {\n    return apply(\n      (String) input);\n  }\n}\n", (Node)expr);
        this.assertTypeContains((Type)((Object)String.class), (Node)expr);
    }

    @Test
    public void testFunctionExpression2() {
        FunctionExpression expr = Expressions.lambda(Function1.class, (BlockStatement)Expressions.block((Statement[])new Statement[]{Expressions.return_(null, (Expression)Expressions.constant((Object)1L, Long.class))}), (ParameterExpression[])new ParameterExpression[]{Expressions.parameter(String.class, (String)"input")});
        this.assertJavaCodeContains("new org.apache.calcite.linq4j.function.Function1() {\n  public Long apply(String input) {\n    return Long.valueOf(1L);\n  }\n  public Object apply(Object input) {\n    return apply(\n      (String) input);\n  }\n}\n", (Node)expr);
        this.assertTypeContains(Arrays.asList(String.class, Long.class), (Node)expr);
    }

    private void assertJavaCodeContains(String expected, Node node) {
        this.assertJavaCodeContains(expected, Collections.singletonList(node));
    }

    private void assertJavaCodeContains(String expected, List<Node> nodes) {
        String javaCode = Expressions.toString(nodes, (String)"\n", (boolean)false);
        Assert.assertThat((Object)javaCode, (Matcher)CoreMatchers.containsString((String)expected));
    }

    private void assertTypeContains(Type expectedType, Node node) {
        this.assertTypeContains(Collections.singletonList(expectedType), Collections.singletonList(node));
    }

    private void assertTypeContains(List<Type> expectedType, Node node) {
        this.assertTypeContains(expectedType, Collections.singletonList(node));
    }

    private void assertTypeContains(final List<Type> expectedTypes, List<Node> nodes) {
        HashSet types = new HashSet();
        EnumerableRelImplementor.TypeFinder typeFinder = new EnumerableRelImplementor.TypeFinder(types);
        for (Node node : nodes) {
            node.accept((Visitor)typeFinder);
        }
        Assert.assertThat(types, (Matcher)new BaseMatcher<HashSet<Type>>(){

            public boolean matches(Object o) {
                HashSet actual = (HashSet)o;
                return actual.containsAll(expectedTypes);
            }

            public void describeTo(Description description) {
                description.appendText("Expected a set of types containing all of: ").appendText(Objects.toString(expectedTypes));
            }
        });
    }
}

