/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.junit.Assert;
import org.junit.Test;

public final class PhysTypeTest {
    private static final JavaTypeFactory TYPE_FACTORY = new JavaTypeFactoryImpl();

    @Test
    public void testFieldClassOnColumnOfOneFieldStructType() {
        RelDataType columnType = TYPE_FACTORY.createStructType((List)ImmutableList.of((Object)TYPE_FACTORY.createSqlType(SqlTypeName.INTEGER)), (List)ImmutableList.of((Object)"intField"));
        RelDataType rowType = TYPE_FACTORY.createStructType((List)ImmutableList.of((Object)columnType), (List)ImmutableList.of((Object)"structField"));
        PhysType rowPhysType = PhysTypeImpl.of((JavaTypeFactory)TYPE_FACTORY, (RelDataType)rowType, (JavaRowFormat)JavaRowFormat.ARRAY);
        Assert.assertEquals(Object[].class, (Object)rowPhysType.fieldClass(0));
    }

    @Test
    public void testFieldClassOnColumnOfTwoFieldStructType() {
        RelDataType columnType = TYPE_FACTORY.createStructType((List)ImmutableList.of((Object)TYPE_FACTORY.createSqlType(SqlTypeName.INTEGER), (Object)TYPE_FACTORY.createSqlType(SqlTypeName.VARCHAR)), (List)ImmutableList.of((Object)"intField", (Object)"strField"));
        RelDataType rowType = TYPE_FACTORY.createStructType((List)ImmutableList.of((Object)columnType), (List)ImmutableList.of((Object)"structField"));
        PhysType rowPhysType = PhysTypeImpl.of((JavaTypeFactory)TYPE_FACTORY, (RelDataType)rowType, (JavaRowFormat)JavaRowFormat.ARRAY);
        Assert.assertEquals(Object[].class, (Object)rowPhysType.fieldClass(0));
    }
}

