/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql2rel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.FilterCorrelateRule;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.sql.fun.SqlSingleValueAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.ReflectiveVisitor;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

public class RelDecorrelator
implements ReflectiveVisitor {
    private static final Logger SQL2REL_LOGGER = CalciteTrace.getSqlToRelTracer();
    private final RelBuilder relBuilder;
    private CorelMap cm;
    private final ReflectUtil.MethodDispatcher<Frame> dispatcher = ReflectUtil.createMethodDispatcher(Frame.class, this, "decorrelateRel", RelNode.class, new Class[0]);
    private RelNode currentRel;
    private final Context context;
    private final Map<RelNode, Frame> map = new HashMap<RelNode, Frame>();
    private final HashSet<LogicalCorrelate> generatedCorRels = new HashSet();

    private RelDecorrelator(CorelMap cm, Context context, RelBuilder relBuilder) {
        this.cm = cm;
        this.context = context;
        this.relBuilder = relBuilder;
    }

    @Deprecated
    public static RelNode decorrelateQuery(RelNode rootRel) {
        RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(rootRel.getCluster(), null);
        return RelDecorrelator.decorrelateQuery(rootRel, relBuilder);
    }

    public static RelNode decorrelateQuery(RelNode rootRel, RelBuilder relBuilder) {
        CorelMap corelMap = new CorelMapBuilder().build(rootRel);
        if (!corelMap.hasCorrelation()) {
            return rootRel;
        }
        RelOptCluster cluster = rootRel.getCluster();
        RelDecorrelator decorrelator = new RelDecorrelator(corelMap, cluster.getPlanner().getContext(), relBuilder);
        RelNode newRootRel = decorrelator.removeCorrelationViaRule(rootRel);
        if (SQL2REL_LOGGER.isDebugEnabled()) {
            SQL2REL_LOGGER.debug(RelOptUtil.dumpPlan("Plan after removing Correlator", newRootRel, SqlExplainFormat.TEXT, SqlExplainLevel.EXPPLAN_ATTRIBUTES));
        }
        if (!decorrelator.cm.mapCorToCorRel.isEmpty()) {
            newRootRel = decorrelator.decorrelate(newRootRel);
        }
        return newRootRel;
    }

    private void setCurrent(RelNode root, LogicalCorrelate corRel) {
        this.currentRel = corRel;
        if (corRel != null) {
            this.cm = new CorelMapBuilder().build(Util.first(root, corRel));
        }
    }

    private RelBuilderFactory relBuilderFactory() {
        return RelBuilder.proto(this.relBuilder);
    }

    private RelNode decorrelate(RelNode root) {
        RelBuilderFactory f = this.relBuilderFactory();
        HepProgram program = HepProgram.builder().addRuleInstance(new AdjustProjectForCountAggregateRule(false, f)).addRuleInstance(new AdjustProjectForCountAggregateRule(true, f)).addRuleInstance(new FilterJoinRule.FilterIntoJoinRule(true, f, FilterJoinRule.TRUE_PREDICATE)).addRuleInstance(new FilterProjectTransposeRule(Filter.class, Project.class, true, true, f)).addRuleInstance(new FilterCorrelateRule(f)).build();
        HepPlanner planner = this.createPlanner(program);
        planner.setRoot(root);
        root = planner.findBestExp();
        this.map.clear();
        Frame frame = this.getInvoke(root, null);
        if (frame != null) {
            HepProgram program2 = HepProgram.builder().addRuleInstance(new FilterJoinRule.FilterIntoJoinRule(true, f, FilterJoinRule.TRUE_PREDICATE)).addRuleInstance(new FilterJoinRule.JoinConditionPushRule(f, FilterJoinRule.TRUE_PREDICATE)).build();
            HepPlanner planner2 = this.createPlanner(program2);
            RelNode newRoot = frame.r;
            planner2.setRoot(newRoot);
            return planner2.findBestExp();
        }
        return root;
    }

    private Function2<RelNode, RelNode, Void> createCopyHook() {
        return (oldNode, newNode) -> {
            if (this.cm.mapRefRelToCorRef.containsKey(oldNode)) {
                this.cm.mapRefRelToCorRef.putAll(newNode, (Iterable)this.cm.mapRefRelToCorRef.get(oldNode));
            }
            if (oldNode instanceof LogicalCorrelate && newNode instanceof LogicalCorrelate) {
                LogicalCorrelate oldCor = (LogicalCorrelate)oldNode;
                CorrelationId c = oldCor.getCorrelationId();
                if (this.cm.mapCorToCorRel.get(c) == oldNode) {
                    this.cm.mapCorToCorRel.put(c, newNode);
                }
                if (this.generatedCorRels.contains(oldNode)) {
                    this.generatedCorRels.add((LogicalCorrelate)newNode);
                }
            }
            return null;
        };
    }

    private HepPlanner createPlanner(HepProgram program) {
        return new HepPlanner(program, this.context, true, this.createCopyHook(), RelOptCostImpl.FACTORY);
    }

    public RelNode removeCorrelationViaRule(RelNode root) {
        RelBuilderFactory f = this.relBuilderFactory();
        HepProgram program = HepProgram.builder().addRuleInstance(new RemoveSingleAggregateRule(f)).addRuleInstance(new RemoveCorrelationForScalarProjectRule(f)).addRuleInstance(new RemoveCorrelationForScalarAggregateRule(f)).build();
        HepPlanner planner = this.createPlanner(program);
        planner.setRoot(root);
        return planner.findBestExp();
    }

    protected RexNode decorrelateExpr(RelNode currentRel, Map<RelNode, Frame> map, CorelMap cm, RexNode exp) {
        DecorrelateRexShuttle shuttle = new DecorrelateRexShuttle(currentRel, map, cm);
        return exp.accept(shuttle);
    }

    protected RexNode removeCorrelationExpr(RexNode exp, boolean projectPulledAboveLeftCorrelator) {
        RemoveCorrelationRexShuttle shuttle = new RemoveCorrelationRexShuttle(this.relBuilder.getRexBuilder(), projectPulledAboveLeftCorrelator, null, (Set<Integer>)ImmutableSet.of());
        return exp.accept(shuttle);
    }

    protected RexNode removeCorrelationExpr(RexNode exp, boolean projectPulledAboveLeftCorrelator, RexInputRef nullIndicator) {
        RemoveCorrelationRexShuttle shuttle = new RemoveCorrelationRexShuttle(this.relBuilder.getRexBuilder(), projectPulledAboveLeftCorrelator, nullIndicator, (Set<Integer>)ImmutableSet.of());
        return exp.accept(shuttle);
    }

    protected RexNode removeCorrelationExpr(RexNode exp, boolean projectPulledAboveLeftCorrelator, Set<Integer> isCount) {
        RemoveCorrelationRexShuttle shuttle = new RemoveCorrelationRexShuttle(this.relBuilder.getRexBuilder(), projectPulledAboveLeftCorrelator, null, isCount);
        return exp.accept(shuttle);
    }

    public Frame decorrelateRel(RelNode rel) {
        RelNode newRel = rel.copy(rel.getTraitSet(), rel.getInputs());
        if (rel.getInputs().size() > 0) {
            List<RelNode> oldInputs = rel.getInputs();
            ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
            for (int i = 0; i < oldInputs.size(); ++i) {
                Frame frame = this.getInvoke(oldInputs.get(i), rel);
                if (frame == null || !frame.corDefOutputs.isEmpty()) {
                    return null;
                }
                newInputs.add(frame.r);
                newRel.replaceInput(i, frame.r);
            }
            if (!Util.equalShallow(oldInputs, newInputs)) {
                newRel = rel.copy(rel.getTraitSet(), newInputs);
            }
        }
        return this.register(rel, newRel, RelDecorrelator.identityMap(rel.getRowType().getFieldCount()), (SortedMap<CorDef, Integer>)ImmutableSortedMap.of());
    }

    public Frame decorrelateRel(Sort rel) {
        assert (!this.cm.mapRefRelToCorRef.containsKey((Object)rel));
        RelNode oldInput = rel.getInput();
        Frame frame = this.getInvoke(oldInput, rel);
        if (frame == null) {
            return null;
        }
        RelNode newInput = frame.r;
        Mappings.TargetMapping mapping = Mappings.target(frame.oldToNewOutputs, oldInput.getRowType().getFieldCount(), newInput.getRowType().getFieldCount());
        RelCollation oldCollation = rel.getCollation();
        RelCollation newCollation = RexUtil.apply(mapping, oldCollation);
        LogicalSort newSort = LogicalSort.create(newInput, newCollation, rel.offset, rel.fetch);
        return this.register(rel, newSort, (Map<Integer, Integer>)frame.oldToNewOutputs, (SortedMap<CorDef, Integer>)frame.corDefOutputs);
    }

    public Frame decorrelateRel(Values rel) {
        return null;
    }

    public Frame decorrelateRel(LogicalAggregate rel) {
        if (rel.getGroupType() != Aggregate.Group.SIMPLE) {
            throw new AssertionError(false);
        }
        assert (!this.cm.mapRefRelToCorRef.containsKey((Object)rel));
        RelNode oldInput = rel.getInput();
        Frame frame = this.getInvoke(oldInput, rel);
        if (frame == null) {
            return null;
        }
        RelNode newInput = frame.r;
        HashMap mapNewInputToProjOutputs = new HashMap();
        int oldGroupKeyCount = rel.getGroupSet().cardinality();
        ArrayList<Pair<RexNode, String>> projects = new ArrayList<Pair<RexNode, String>>();
        List<RelDataTypeField> newInputOutput = newInput.getRowType().getFieldList();
        int newPos = 0;
        TreeMap<Integer, RexLiteral> omittedConstants = new TreeMap<Integer, RexLiteral>();
        for (int i = 0; i < oldGroupKeyCount; ++i) {
            RexLiteral constant = RelDecorrelator.projectedLiteral(newInput, i);
            if (constant != null) {
                omittedConstants.put(i, constant);
                continue;
            }
            int newInputPos = (Integer)frame.oldToNewOutputs.get((Object)i);
            projects.add(RexInputRef.of2(newInputPos, newInputOutput));
            mapNewInputToProjOutputs.put(newInputPos, newPos);
            ++newPos;
        }
        TreeMap<CorDef, Integer> corDefOutputs = new TreeMap<CorDef, Integer>();
        if (!frame.corDefOutputs.isEmpty()) {
            for (Map.Entry entry : frame.corDefOutputs.entrySet()) {
                projects.add(RexInputRef.of2((Integer)entry.getValue(), newInputOutput));
                corDefOutputs.put((CorDef)entry.getKey(), newPos);
                mapNewInputToProjOutputs.put(entry.getValue(), newPos);
                ++newPos;
            }
        }
        int newGroupKeyCount = newPos;
        for (int i = 0; i < newInputOutput.size(); ++i) {
            if (mapNewInputToProjOutputs.containsKey(i)) continue;
            projects.add(RexInputRef.of2(i, newInputOutput));
            mapNewInputToProjOutputs.put(i, newPos);
            ++newPos;
        }
        assert (newPos == newInputOutput.size());
        RelNode newProject = this.relBuilder.push(newInput).projectNamed(Pair.left(projects), Pair.right(projects), true).build();
        HashMap<Integer, Integer> combinedMap = new HashMap<Integer, Integer>();
        for (Integer oldInputPos : frame.oldToNewOutputs.keySet()) {
            combinedMap.put(oldInputPos, (Integer)mapNewInputToProjOutputs.get(frame.oldToNewOutputs.get((Object)oldInputPos)));
        }
        this.register(oldInput, newProject, combinedMap, corDefOutputs);
        ImmutableBitSet newGroupSet = ImmutableBitSet.range(newGroupKeyCount);
        ArrayList<AggregateCall> newAggCalls = new ArrayList<AggregateCall>();
        List<AggregateCall> oldAggCalls = rel.getAggCallList();
        int oldInputOutputFieldCount = rel.getGroupSet().cardinality();
        int newInputOutputFieldCount = newGroupSet.cardinality();
        int i = -1;
        for (AggregateCall oldAggCall : oldAggCalls) {
            ++i;
            List<Integer> oldAggArgs = oldAggCall.getArgList();
            ArrayList<Integer> aggArgs = new ArrayList<Integer>();
            for (int oldPos : oldAggArgs) {
                aggArgs.add((Integer)combinedMap.get(oldPos));
            }
            int filterArg = oldAggCall.filterArg < 0 ? oldAggCall.filterArg : (Integer)combinedMap.get(oldAggCall.filterArg);
            newAggCalls.add(oldAggCall.adaptTo(newProject, aggArgs, filterArg, oldGroupKeyCount, newGroupKeyCount));
            combinedMap.put(oldInputOutputFieldCount + i, newInputOutputFieldCount + i);
        }
        this.relBuilder.push(LogicalAggregate.create(newProject, newGroupSet, null, newAggCalls));
        if (!omittedConstants.isEmpty()) {
            ArrayList<RexNode> postProjects = new ArrayList<RexNode>((Collection<RexNode>)this.relBuilder.fields());
            for (Map.Entry entry : omittedConstants.descendingMap().entrySet()) {
                postProjects.add((Integer)entry.getKey() + frame.corDefOutputs.size(), (RexNode)entry.getValue());
            }
            this.relBuilder.project(postProjects);
        }
        return this.register(rel, this.relBuilder.build(), combinedMap, corDefOutputs);
    }

    public Frame getInvoke(RelNode r, RelNode parent) {
        Frame frame = this.dispatcher.invoke(r);
        if (frame != null) {
            this.map.put(r, frame);
        }
        this.currentRel = parent;
        return frame;
    }

    private static RexLiteral projectedLiteral(RelNode rel, int i) {
        Project project;
        RexNode node;
        if (rel instanceof Project && (node = (project = (Project)rel).getProjects().get(i)) instanceof RexLiteral) {
            return (RexLiteral)node;
        }
        return null;
    }

    public Frame decorrelateRel(LogicalProject rel) {
        int newPos;
        RelNode oldInput = rel.getInput();
        Frame frame = this.getInvoke(oldInput, rel);
        if (frame == null) {
            return null;
        }
        List<RexNode> oldProjects = rel.getProjects();
        List<RelDataTypeField> relOutput = rel.getRowType().getFieldList();
        ArrayList<Pair<RexNode, String>> projects = new ArrayList<Pair<RexNode, String>>();
        if (this.cm.mapRefRelToCorRef.containsKey((Object)rel)) {
            frame = this.decorrelateInputWithValueGenerator(rel, frame);
        }
        HashMap<Integer, Integer> mapOldToNewOutputs = new HashMap<Integer, Integer>();
        for (newPos = 0; newPos < oldProjects.size(); ++newPos) {
            projects.add(newPos, Pair.of(this.decorrelateExpr(this.currentRel, this.map, this.cm, oldProjects.get(newPos)), relOutput.get(newPos).getName()));
            mapOldToNewOutputs.put(newPos, newPos);
        }
        TreeMap<CorDef, Integer> corDefOutputs = new TreeMap<CorDef, Integer>();
        for (Map.Entry entry : frame.corDefOutputs.entrySet()) {
            projects.add(RexInputRef.of2((Integer)entry.getValue(), frame.r.getRowType().getFieldList()));
            corDefOutputs.put((CorDef)entry.getKey(), newPos);
            ++newPos;
        }
        RelNode newProject = this.relBuilder.push(frame.r).projectNamed(Pair.left(projects), Pair.right(projects), true).build();
        return this.register(rel, newProject, mapOldToNewOutputs, corDefOutputs);
    }

    private RelNode createValueGenerator(Iterable<CorRef> correlations, int valueGenFieldOffset, SortedMap<CorDef, Integer> corDefOutputs) {
        RelNode oldInput;
        HashMap<RelNode, List<Integer>> mapNewInputToOutputs = new HashMap<RelNode, List<Integer>>();
        HashMap<RelNode, Integer> mapNewInputToNewOffset = new HashMap<RelNode, Integer>();
        for (CorRef corVar : correlations) {
            int newCorVarOffset;
            int oldCorVarOffset = corVar.field;
            RelNode oldInput2 = this.getCorRel(corVar);
            assert (oldInput2 != null);
            Frame frame = this.getFrame(oldInput2, true);
            assert (frame != null);
            RelNode newInput = frame.r;
            List newLocalOutputs = !mapNewInputToOutputs.containsKey(newInput) ? new ArrayList() : (List)mapNewInputToOutputs.get(newInput);
            if (!newLocalOutputs.contains(newCorVarOffset = ((Integer)frame.oldToNewOutputs.get((Object)oldCorVarOffset)).intValue())) {
                newLocalOutputs.add(newCorVarOffset);
            }
            mapNewInputToOutputs.put(newInput, newLocalOutputs);
        }
        int offset = 0;
        HashSet<RelNode> joinedInputs = new HashSet<RelNode>();
        RelNode r = null;
        for (CorRef corVar : correlations) {
            oldInput = this.getCorRel(corVar);
            assert (oldInput != null);
            RelNode newInput = this.getFrame((RelNode)oldInput, (boolean)true).r;
            assert (newInput != null);
            if (joinedInputs.contains(newInput)) continue;
            RelNode project = RelOptUtil.createProject(newInput, (List)mapNewInputToOutputs.get(newInput));
            RelNode distinct = this.relBuilder.push(project).distinct().build();
            RelOptCluster cluster = distinct.getCluster();
            joinedInputs.add(newInput);
            mapNewInputToNewOffset.put(newInput, offset);
            offset += distinct.getRowType().getFieldCount();
            if (r == null) {
                r = distinct;
                continue;
            }
            r = LogicalJoin.create(r, distinct, (RexNode)cluster.getRexBuilder().makeLiteral(true), (Set<CorrelationId>)ImmutableSet.of(), JoinRelType.INNER);
        }
        for (CorRef corRef : correlations) {
            oldInput = this.getCorRel(corRef);
            assert (oldInput != null);
            Frame frame = this.getFrame(oldInput, true);
            RelNode newInput = frame.r;
            assert (newInput != null);
            List newLocalOutputs = (List)mapNewInputToOutputs.get(newInput);
            int newLocalOutput = (Integer)frame.oldToNewOutputs.get((Object)corRef.field);
            int newOutput = newLocalOutputs.indexOf(newLocalOutput) + (Integer)mapNewInputToNewOffset.get(newInput) + valueGenFieldOffset;
            corDefOutputs.put(corRef.def(), newOutput);
        }
        return r;
    }

    private Frame getFrame(RelNode r, boolean safe) {
        Frame frame = this.map.get(r);
        if (frame == null && safe) {
            return new Frame(r, r, (SortedMap<CorDef, Integer>)ImmutableSortedMap.of(), RelDecorrelator.identityMap(r.getRowType().getFieldCount()));
        }
        return frame;
    }

    private RelNode getCorRel(CorRef corVar) {
        RelNode r = (RelNode)this.cm.mapCorToCorRel.get(corVar.corr);
        return r.getInput(0);
    }

    private Frame maybeAddValueGenerator(RelNode rel, Frame frame) {
        ImmutableSortedSet haves;
        CorelMap cm1 = new CorelMapBuilder().build(frame.r, rel);
        if (!cm1.mapRefRelToCorRef.containsKey((Object)rel)) {
            return frame;
        }
        Collection needs = cm1.mapRefRelToCorRef.get((Object)rel);
        if (this.hasAll(needs, (Collection<CorDef>)(haves = frame.corDefOutputs.keySet()))) {
            return frame;
        }
        return this.decorrelateInputWithValueGenerator(rel, frame);
    }

    private boolean hasAll(Collection<CorRef> corRefs, Collection<CorDef> corDefs) {
        for (CorRef corRef : corRefs) {
            if (this.has(corDefs, corRef)) continue;
            return false;
        }
        return true;
    }

    private boolean has(Collection<CorDef> corDefs, CorRef corr) {
        for (CorDef corDef : corDefs) {
            if (!corDef.corr.equals(corr.corr) || corDef.field != corr.field) continue;
            return true;
        }
        return false;
    }

    private Frame decorrelateInputWithValueGenerator(RelNode rel, Frame frame) {
        assert (rel.getInputs().size() == 1);
        RelNode oldInput = frame.r;
        TreeMap<CorDef, Integer> corDefOutputs = new TreeMap<CorDef, Integer>((SortedMap<CorDef, Integer>)frame.corDefOutputs);
        Collection corVarList = this.cm.mapRefRelToCorRef.get((Object)rel);
        if (rel instanceof Filter) {
            TreeMap<CorDef, Integer> map = new TreeMap<CorDef, Integer>();
            ArrayList<RexNode> projects = new ArrayList<RexNode>();
            for (CorRef correlation : corVarList) {
                CorDef def = correlation.def();
                if (corDefOutputs.containsKey(def) || map.containsKey(def)) continue;
                try {
                    this.findCorrelationEquivalent(correlation, ((Filter)rel).getCondition());
                }
                catch (Util.FoundOne e) {
                    if (e.getNode() instanceof RexInputRef) {
                        map.put(def, ((RexInputRef)e.getNode()).getIndex());
                        continue;
                    }
                    map.put(def, frame.r.getRowType().getFieldCount() + projects.size());
                    projects.add((RexNode)e.getNode());
                }
            }
            if (map.size() == corVarList.size()) {
                RelNode r;
                map.putAll((Map<CorDef, Integer>)frame.corDefOutputs);
                if (!projects.isEmpty()) {
                    this.relBuilder.push(oldInput).project(Iterables.concat(this.relBuilder.fields(), projects));
                    r = this.relBuilder.build();
                } else {
                    r = oldInput;
                }
                return this.register(rel.getInput(0), r, (Map<Integer, Integer>)frame.oldToNewOutputs, (SortedMap<CorDef, Integer>)map);
            }
        }
        int leftInputOutputCount = frame.r.getRowType().getFieldCount();
        RelNode valueGen = this.createValueGenerator(corVarList, leftInputOutputCount, corDefOutputs);
        LogicalJoin join = LogicalJoin.create(frame.r, valueGen, this.relBuilder.literal(true), (Set<CorrelationId>)ImmutableSet.of(), JoinRelType.INNER);
        return this.register(rel.getInput(0), join, (Map<Integer, Integer>)frame.oldToNewOutputs, (SortedMap<CorDef, Integer>)corDefOutputs);
    }

    private void findCorrelationEquivalent(CorRef correlation, RexNode e) throws Util.FoundOne {
        switch (e.getKind()) {
            case EQUALS: {
                RexCall call = (RexCall)e;
                List<RexNode> operands = call.getOperands();
                if (this.references(operands.get(0), correlation)) {
                    throw new Util.FoundOne(operands.get(1));
                }
                if (!this.references(operands.get(1), correlation)) break;
                throw new Util.FoundOne(operands.get(0));
            }
            case AND: {
                for (RexNode operand : ((RexCall)e).getOperands()) {
                    this.findCorrelationEquivalent(correlation, operand);
                }
                break;
            }
        }
    }

    private boolean references(RexNode e, CorRef correlation) {
        switch (e.getKind()) {
            case CAST: {
                RexNode operand = ((RexCall)e).getOperands().get(0);
                if (this.isWidening(e.getType(), operand.getType())) {
                    return this.references(operand, correlation);
                }
                return false;
            }
            case FIELD_ACCESS: {
                RexFieldAccess f = (RexFieldAccess)e;
                if (f.getField().getIndex() != correlation.field || !(f.getReferenceExpr() instanceof RexCorrelVariable) || ((RexCorrelVariable)f.getReferenceExpr()).id != correlation.corr) break;
                return true;
            }
        }
        return false;
    }

    private boolean isWidening(RelDataType type, RelDataType type1) {
        return type.getSqlTypeName() == type1.getSqlTypeName() && type.getPrecision() >= type1.getPrecision();
    }

    public Frame decorrelateRel(LogicalFilter rel) {
        RelNode oldInput = rel.getInput();
        Frame frame = this.getInvoke(oldInput, rel);
        if (frame == null) {
            return null;
        }
        frame = this.maybeAddValueGenerator(rel, frame);
        CorelMap cm2 = new CorelMapBuilder().build(rel);
        this.relBuilder.push(frame.r).filter(this.decorrelateExpr(this.currentRel, this.map, cm2, rel.getCondition()));
        return this.register(rel, this.relBuilder.build(), (Map<Integer, Integer>)frame.oldToNewOutputs, (SortedMap<CorDef, Integer>)frame.corDefOutputs);
    }

    public Frame decorrelateRel(LogicalCorrelate rel) {
        RelNode oldLeft = rel.getInput(0);
        RelNode oldRight = rel.getInput(1);
        Frame leftFrame = this.getInvoke(oldLeft, rel);
        Frame rightFrame = this.getInvoke(oldRight, rel);
        if (leftFrame == null || rightFrame == null) {
            return null;
        }
        if (rightFrame.corDefOutputs.isEmpty()) {
            return null;
        }
        assert (rel.getRequiredColumns().cardinality() <= rightFrame.corDefOutputs.keySet().size());
        TreeMap<CorDef, Integer> corDefOutputs = new TreeMap<CorDef, Integer>((SortedMap<CorDef, Integer>)rightFrame.corDefOutputs);
        ArrayList<RexNode> conditions = new ArrayList<RexNode>();
        List<RelDataTypeField> newLeftOutput = leftFrame.r.getRowType().getFieldList();
        int newLeftFieldCount = newLeftOutput.size();
        List<RelDataTypeField> newRightOutput = rightFrame.r.getRowType().getFieldList();
        for (Map.Entry rightOutput : new ArrayList(corDefOutputs.entrySet())) {
            CorDef corDef = (CorDef)rightOutput.getKey();
            if (!corDef.corr.equals(rel.getCorrelationId())) continue;
            int newLeftPos = (Integer)leftFrame.oldToNewOutputs.get((Object)corDef.field);
            int newRightPos = (Integer)rightOutput.getValue();
            conditions.add(this.relBuilder.call((SqlOperator)SqlStdOperatorTable.EQUALS, RexInputRef.of(newLeftPos, newLeftOutput), new RexInputRef(newLeftFieldCount + newRightPos, newRightOutput.get(newRightPos).getType())));
            corDefOutputs.remove(corDef);
        }
        for (CorDef corDef : corDefOutputs.keySet()) {
            int newPos = (Integer)corDefOutputs.get(corDef) + newLeftFieldCount;
            corDefOutputs.put(corDef, newPos);
        }
        corDefOutputs.putAll((Map<CorDef, Integer>)leftFrame.corDefOutputs);
        HashMap<Integer, Integer> mapOldToNewOutputs = new HashMap<Integer, Integer>();
        int oldLeftFieldCount = oldLeft.getRowType().getFieldCount();
        int oldRightFieldCount = oldRight.getRowType().getFieldCount();
        assert (rel.getRowType().getFieldCount() == oldLeftFieldCount + oldRightFieldCount);
        mapOldToNewOutputs.putAll((Map<Integer, Integer>)leftFrame.oldToNewOutputs);
        for (int i = 0; i < oldRightFieldCount; ++i) {
            mapOldToNewOutputs.put(i + oldLeftFieldCount, (Integer)rightFrame.oldToNewOutputs.get((Object)i) + newLeftFieldCount);
        }
        RexNode condition = RexUtil.composeConjunction(this.relBuilder.getRexBuilder(), conditions);
        LogicalJoin newJoin = LogicalJoin.create(leftFrame.r, rightFrame.r, condition, (Set<CorrelationId>)ImmutableSet.of(), rel.getJoinType().toJoinType());
        return this.register(rel, newJoin, mapOldToNewOutputs, corDefOutputs);
    }

    public Frame decorrelateRel(LogicalJoin rel) {
        RelNode oldLeft = rel.getInput(0);
        RelNode oldRight = rel.getInput(1);
        Frame leftFrame = this.getInvoke(oldLeft, rel);
        Frame rightFrame = this.getInvoke(oldRight, rel);
        if (leftFrame == null || rightFrame == null) {
            return null;
        }
        LogicalJoin newJoin = LogicalJoin.create(leftFrame.r, rightFrame.r, this.decorrelateExpr(this.currentRel, this.map, this.cm, rel.getCondition()), (Set<CorrelationId>)ImmutableSet.of(), rel.getJoinType());
        HashMap<Integer, Integer> mapOldToNewOutputs = new HashMap<Integer, Integer>();
        int oldLeftFieldCount = oldLeft.getRowType().getFieldCount();
        int newLeftFieldCount = leftFrame.r.getRowType().getFieldCount();
        int oldRightFieldCount = oldRight.getRowType().getFieldCount();
        assert (rel.getRowType().getFieldCount() == oldLeftFieldCount + oldRightFieldCount);
        mapOldToNewOutputs.putAll((Map<Integer, Integer>)leftFrame.oldToNewOutputs);
        for (int i = 0; i < oldRightFieldCount; ++i) {
            mapOldToNewOutputs.put(i + oldLeftFieldCount, (Integer)rightFrame.oldToNewOutputs.get((Object)i) + newLeftFieldCount);
        }
        TreeMap<CorDef, Integer> corDefOutputs = new TreeMap<CorDef, Integer>((SortedMap<CorDef, Integer>)leftFrame.corDefOutputs);
        for (Map.Entry entry : rightFrame.corDefOutputs.entrySet()) {
            corDefOutputs.put((CorDef)entry.getKey(), (Integer)entry.getValue() + newLeftFieldCount);
        }
        return this.register(rel, newJoin, mapOldToNewOutputs, corDefOutputs);
    }

    private static RexInputRef getNewForOldInputRef(RelNode currentRel, Map<RelNode, Frame> map, RexInputRef oldInputRef) {
        int oldLocalOrdinal;
        assert (currentRel != null);
        int oldOrdinal = oldInputRef.getIndex();
        int newOrdinal = 0;
        RelNode oldInput = null;
        for (RelNode oldInput0 : currentRel.getInputs()) {
            RelDataType oldInputType = oldInput0.getRowType();
            int n = oldInputType.getFieldCount();
            if (oldOrdinal < n) {
                oldInput = oldInput0;
                break;
            }
            RelNode newInput = map.get((Object)oldInput0).r;
            newOrdinal += newInput.getRowType().getFieldCount();
            oldOrdinal -= n;
        }
        assert (oldInput != null);
        Frame frame = map.get(oldInput);
        assert (frame != null);
        int newLocalOrdinal = oldLocalOrdinal = oldOrdinal;
        if (!frame.oldToNewOutputs.isEmpty()) {
            newLocalOrdinal = (Integer)frame.oldToNewOutputs.get((Object)oldLocalOrdinal);
        }
        return new RexInputRef(newOrdinal += newLocalOrdinal, frame.r.getRowType().getFieldList().get(newLocalOrdinal).getType());
    }

    private RelNode projectJoinOutputWithNullability(LogicalJoin join, LogicalProject project, int nullIndicatorPos) {
        RelDataTypeFactory typeFactory = join.getCluster().getTypeFactory();
        RelNode left = join.getLeft();
        JoinRelType joinType = join.getJoinType();
        RexInputRef nullIndicator = new RexInputRef(nullIndicatorPos, typeFactory.createTypeWithNullability(join.getRowType().getFieldList().get(nullIndicatorPos).getType(), true));
        ArrayList<Pair<RexNode, String>> newProjExprs = new ArrayList<Pair<RexNode, String>>();
        List<RelDataTypeField> leftInputFields = left.getRowType().getFieldList();
        for (int i = 0; i < leftInputFields.size(); ++i) {
            newProjExprs.add(RexInputRef.of2(i, leftInputFields));
        }
        boolean projectPulledAboveLeftCorrelator = joinType.generatesNullsOnRight();
        for (Pair<RexNode, String> pair : project.getNamedProjects()) {
            RexNode newProjExpr = this.removeCorrelationExpr((RexNode)pair.left, projectPulledAboveLeftCorrelator, nullIndicator);
            newProjExprs.add(Pair.of(newProjExpr, pair.right));
        }
        return this.relBuilder.push(join).projectNamed(Pair.left(newProjExprs), Pair.right(newProjExprs), true).build();
    }

    private RelNode aggregateCorrelatorOutput(Correlate correlate, LogicalProject project, Set<Integer> isCount) {
        RelNode left = correlate.getLeft();
        JoinRelType joinType = correlate.getJoinType().toJoinType();
        ArrayList<Pair<RexNode, String>> newProjects = new ArrayList<Pair<RexNode, String>>();
        List<RelDataTypeField> leftInputFields = left.getRowType().getFieldList();
        for (int i = 0; i < leftInputFields.size(); ++i) {
            newProjects.add(RexInputRef.of2(i, leftInputFields));
        }
        boolean projectPulledAboveLeftCorrelator = joinType.generatesNullsOnRight();
        for (Pair<RexNode, String> pair : project.getNamedProjects()) {
            RexNode newProjExpr = this.removeCorrelationExpr((RexNode)pair.left, projectPulledAboveLeftCorrelator, isCount);
            newProjects.add(Pair.of(newProjExpr, pair.right));
        }
        return this.relBuilder.push(correlate).projectNamed(Pair.left(newProjects), Pair.right(newProjects), true).build();
    }

    private boolean checkCorVars(LogicalCorrelate correlate, LogicalProject project, LogicalFilter filter, List<RexFieldAccess> correlatedJoinKeys) {
        if (filter != null) {
            assert (correlatedJoinKeys != null);
            HashSet corVarInFilter = Sets.newHashSet((Iterable)this.cm.mapRefRelToCorRef.get((Object)filter));
            for (RexFieldAccess correlatedJoinKey : correlatedJoinKeys) {
                corVarInFilter.remove(this.cm.mapFieldAccessToCorRef.get(correlatedJoinKey));
            }
            if (!corVarInFilter.isEmpty()) {
                return false;
            }
            corVarInFilter.addAll(this.cm.mapRefRelToCorRef.get((Object)filter));
            for (CorRef corVar : corVarInFilter) {
                if (this.cm.mapCorToCorRel.get(corVar.corr) == correlate) continue;
                return false;
            }
        }
        if (project != null && this.cm.mapRefRelToCorRef.containsKey((Object)project)) {
            for (CorRef corVar : this.cm.mapRefRelToCorRef.get((Object)project)) {
                if (this.cm.mapCorToCorRel.get(corVar.corr) == correlate) continue;
                return false;
            }
        }
        return true;
    }

    private void removeCorVarFromTree(LogicalCorrelate correlate) {
        if (this.cm.mapCorToCorRel.get(correlate.getCorrelationId()) == correlate) {
            this.cm.mapCorToCorRel.remove(correlate.getCorrelationId());
        }
    }

    private RelNode createProjectWithAdditionalExprs(RelNode input, List<Pair<RexNode, String>> additionalExprs) {
        List<RelDataTypeField> fieldList = input.getRowType().getFieldList();
        ArrayList<Pair<RexNode, String>> projects = new ArrayList<Pair<RexNode, String>>();
        for (Ord field : Ord.zip(fieldList)) {
            projects.add(Pair.of(this.relBuilder.getRexBuilder().makeInputRef(((RelDataTypeField)field.e).getType(), field.i), ((RelDataTypeField)field.e).getName()));
        }
        projects.addAll(additionalExprs);
        return this.relBuilder.push(input).projectNamed(Pair.left(projects), Pair.right(projects), true).build();
    }

    static Map<Integer, Integer> identityMap(int count) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < count; ++i) {
            builder.put((Object)i, (Object)i);
        }
        return builder.build();
    }

    Frame register(RelNode rel, RelNode newRel, Map<Integer, Integer> oldToNewOutputs, SortedMap<CorDef, Integer> corDefOutputs) {
        Frame frame = new Frame(rel, newRel, corDefOutputs, oldToNewOutputs);
        this.map.put(rel, frame);
        return frame;
    }

    static boolean allLessThan(Collection<Integer> integers, int limit, Litmus ret) {
        for (int value : integers) {
            if (value < limit) continue;
            return ret.fail("out of range; value: {}, limit: {}", value, limit);
        }
        return ret.succeed();
    }

    private static RelNode stripHep(RelNode rel) {
        if (rel instanceof HepRelVertex) {
            HepRelVertex hepRelVertex = (HepRelVertex)rel;
            rel = hepRelVertex.getCurrentRel();
        }
        return rel;
    }

    static class Frame {
        final RelNode r;
        final ImmutableSortedMap<CorDef, Integer> corDefOutputs;
        final ImmutableSortedMap<Integer, Integer> oldToNewOutputs;

        Frame(RelNode oldRel, RelNode r, SortedMap<CorDef, Integer> corDefOutputs, Map<Integer, Integer> oldToNewOutputs) {
            this.r = Objects.requireNonNull(r);
            this.corDefOutputs = ImmutableSortedMap.copyOf(corDefOutputs);
            this.oldToNewOutputs = ImmutableSortedMap.copyOf(oldToNewOutputs);
            assert (RelDecorrelator.allLessThan((Collection<Integer>)this.corDefOutputs.values(), r.getRowType().getFieldCount(), Litmus.THROW));
            assert (RelDecorrelator.allLessThan((Collection<Integer>)this.oldToNewOutputs.keySet(), oldRel.getRowType().getFieldCount(), Litmus.THROW));
            assert (RelDecorrelator.allLessThan((Collection<Integer>)this.oldToNewOutputs.values(), r.getRowType().getFieldCount(), Litmus.THROW));
        }
    }

    private static class CorelMapBuilder
    extends RelShuttleImpl {
        final SortedMap<CorrelationId, RelNode> mapCorToCorRel = new TreeMap<CorrelationId, RelNode>();
        final SortedSetMultimap<RelNode, CorRef> mapRefRelToCorRef = MultimapBuilder.SortedSetMultimapBuilder.hashKeys().treeSetValues().build();
        final Map<RexFieldAccess, CorRef> mapFieldAccessToCorVar = new HashMap<RexFieldAccess, CorRef>();
        final Holder<Integer> offset = Holder.of(0);
        int corrIdGenerator = 0;

        private CorelMapBuilder() {
        }

        CorelMap build(RelNode ... rels) {
            for (RelNode rel : rels) {
                RelDecorrelator.stripHep(rel).accept(this);
            }
            return new CorelMap((Multimap)this.mapRefRelToCorRef, this.mapCorToCorRel, this.mapFieldAccessToCorVar);
        }

        @Override
        public RelNode visit(LogicalJoin join) {
            try {
                this.stack.push(join);
                join.getCondition().accept(this.rexVisitor(join));
            }
            finally {
                this.stack.pop();
            }
            return this.visitJoin(join);
        }

        @Override
        protected RelNode visitChild(RelNode parent, int i, RelNode input) {
            return super.visitChild(parent, i, RelDecorrelator.stripHep(input));
        }

        @Override
        public RelNode visit(LogicalCorrelate correlate) {
            this.mapCorToCorRel.put(correlate.getCorrelationId(), correlate);
            return this.visitJoin(correlate);
        }

        private RelNode visitJoin(BiRel join) {
            int x = this.offset.get();
            this.visitChild(join, 0, join.getLeft());
            this.offset.set(x + join.getLeft().getRowType().getFieldCount());
            this.visitChild(join, 1, join.getRight());
            this.offset.set(x);
            return join;
        }

        @Override
        public RelNode visit(LogicalFilter filter) {
            try {
                this.stack.push(filter);
                filter.getCondition().accept(this.rexVisitor(filter));
            }
            finally {
                this.stack.pop();
            }
            return super.visit(filter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RelNode visit(LogicalProject project) {
            try {
                this.stack.push(project);
                for (RexNode node : project.getProjects()) {
                    node.accept(this.rexVisitor(project));
                }
            }
            finally {
                this.stack.pop();
            }
            return super.visit(project);
        }

        private RexVisitorImpl<Void> rexVisitor(final RelNode rel) {
            return new RexVisitorImpl<Void>(true){

                @Override
                public Void visitFieldAccess(RexFieldAccess fieldAccess) {
                    RexNode ref = fieldAccess.getReferenceExpr();
                    if (ref instanceof RexCorrelVariable) {
                        RexCorrelVariable var = (RexCorrelVariable)ref;
                        if (mapFieldAccessToCorVar.containsKey(fieldAccess)) {
                            mapRefRelToCorRef.put((Object)rel, (Object)mapFieldAccessToCorVar.get(fieldAccess));
                        } else {
                            CorRef correlation = new CorRef(var.id, fieldAccess.getField().getIndex(), corrIdGenerator++);
                            mapFieldAccessToCorVar.put(fieldAccess, correlation);
                            mapRefRelToCorRef.put((Object)rel, (Object)correlation);
                        }
                    }
                    return (Void)super.visitFieldAccess(fieldAccess);
                }

                @Override
                public Void visitSubQuery(RexSubQuery subQuery) {
                    subQuery.rel.accept(this);
                    return (Void)super.visitSubQuery(subQuery);
                }
            };
        }
    }

    private static class CorelMap {
        private final Multimap<RelNode, CorRef> mapRefRelToCorRef;
        private final SortedMap<CorrelationId, RelNode> mapCorToCorRel;
        private final Map<RexFieldAccess, CorRef> mapFieldAccessToCorRef;

        private CorelMap(Multimap<RelNode, CorRef> mapRefRelToCorRef, SortedMap<CorrelationId, RelNode> mapCorToCorRel, Map<RexFieldAccess, CorRef> mapFieldAccessToCorRef) {
            this.mapRefRelToCorRef = mapRefRelToCorRef;
            this.mapCorToCorRel = mapCorToCorRel;
            this.mapFieldAccessToCorRef = ImmutableMap.copyOf(mapFieldAccessToCorRef);
        }

        public String toString() {
            return "mapRefRelToCorRef=" + this.mapRefRelToCorRef + "\nmapCorToCorRel=" + this.mapCorToCorRel + "\nmapFieldAccessToCorRef=" + this.mapFieldAccessToCorRef + "\n";
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof CorelMap && this.mapRefRelToCorRef.equals(((CorelMap)obj).mapRefRelToCorRef) && this.mapCorToCorRel.equals(((CorelMap)obj).mapCorToCorRel) && this.mapFieldAccessToCorRef.equals(((CorelMap)obj).mapFieldAccessToCorRef);
        }

        public int hashCode() {
            return Objects.hash(this.mapRefRelToCorRef, this.mapCorToCorRel, this.mapFieldAccessToCorRef);
        }

        public static CorelMap of(SortedSetMultimap<RelNode, CorRef> mapRefRelToCorVar, SortedMap<CorrelationId, RelNode> mapCorToCorRel, Map<RexFieldAccess, CorRef> mapFieldAccessToCorVar) {
            return new CorelMap((Multimap<RelNode, CorRef>)mapRefRelToCorVar, mapCorToCorRel, mapFieldAccessToCorVar);
        }

        public boolean hasCorrelation() {
            return !this.mapCorToCorRel.isEmpty();
        }
    }

    static class CorDef
    implements Comparable<CorDef> {
        public final CorrelationId corr;
        public final int field;

        CorDef(CorrelationId corr, int field) {
            this.corr = corr;
            this.field = field;
        }

        public String toString() {
            return this.corr.getName() + '.' + this.field;
        }

        public int hashCode() {
            return Objects.hash(this.corr, this.field);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof CorDef && this.corr == ((CorDef)o).corr && this.field == ((CorDef)o).field;
        }

        @Override
        public int compareTo(@Nonnull CorDef o) {
            int c = this.corr.compareTo(o.corr);
            if (c != 0) {
                return c;
            }
            return Integer.compare(this.field, o.field);
        }
    }

    static class CorRef
    implements Comparable<CorRef> {
        public final int uniqueKey;
        public final CorrelationId corr;
        public final int field;

        CorRef(CorrelationId corr, int field, int uniqueKey) {
            this.corr = corr;
            this.field = field;
            this.uniqueKey = uniqueKey;
        }

        public String toString() {
            return this.corr.getName() + '.' + this.field;
        }

        public int hashCode() {
            return Objects.hash(this.uniqueKey, this.corr, this.field);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof CorRef && this.uniqueKey == ((CorRef)o).uniqueKey && this.corr == ((CorRef)o).corr && this.field == ((CorRef)o).field;
        }

        @Override
        public int compareTo(@Nonnull CorRef o) {
            int c = this.corr.compareTo(o.corr);
            if (c != 0) {
                return c;
            }
            c = Integer.compare(this.field, o.field);
            if (c != 0) {
                return c;
            }
            return Integer.compare(this.uniqueKey, o.uniqueKey);
        }

        public CorDef def() {
            return new CorDef(this.corr, this.field);
        }
    }

    private final class AdjustProjectForCountAggregateRule
    extends RelOptRule {
        final boolean flavor;

        AdjustProjectForCountAggregateRule(boolean flavor, RelBuilderFactory relBuilderFactory) {
            super(flavor ? AdjustProjectForCountAggregateRule.operand(LogicalCorrelate.class, AdjustProjectForCountAggregateRule.operand(RelNode.class, AdjustProjectForCountAggregateRule.any()), AdjustProjectForCountAggregateRule.operand(LogicalProject.class, AdjustProjectForCountAggregateRule.operand(LogicalAggregate.class, AdjustProjectForCountAggregateRule.any()), new RelOptRuleOperand[0])) : AdjustProjectForCountAggregateRule.operand(LogicalCorrelate.class, AdjustProjectForCountAggregateRule.operand(RelNode.class, AdjustProjectForCountAggregateRule.any()), AdjustProjectForCountAggregateRule.operand(LogicalAggregate.class, AdjustProjectForCountAggregateRule.any())), relBuilderFactory, null);
            this.flavor = flavor;
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalAggregate aggregate;
            LogicalProject aggOutputProject;
            LogicalCorrelate correlate = (LogicalCorrelate)call.rel(0);
            Object left = call.rel(1);
            if (this.flavor) {
                aggOutputProject = (LogicalProject)call.rel(2);
                aggregate = (LogicalAggregate)call.rel(3);
            } else {
                aggregate = (LogicalAggregate)call.rel(2);
                ArrayList<Pair<RexNode, String>> projects = new ArrayList<Pair<RexNode, String>>();
                List<RelDataTypeField> fields = aggregate.getRowType().getFieldList();
                for (int i = 0; i < fields.size(); ++i) {
                    projects.add(RexInputRef.of2(projects.size(), fields));
                }
                RelBuilder relBuilder = call.builder();
                relBuilder.push(aggregate).projectNamed(Pair.left(projects), Pair.right(projects), true);
                aggOutputProject = (LogicalProject)relBuilder.build();
            }
            this.onMatch2(call, correlate, (RelNode)left, aggOutputProject, aggregate);
        }

        private void onMatch2(RelOptRuleCall call, LogicalCorrelate correlate, RelNode leftInput, LogicalProject aggOutputProject, LogicalAggregate aggregate) {
            if (RelDecorrelator.this.generatedCorRels.contains(correlate)) {
                return;
            }
            RelDecorrelator.this.setCurrent(call.getPlanner().getRoot(), correlate);
            List<RexNode> aggOutputProjExprs = aggOutputProject.getProjects();
            if (aggOutputProjExprs.size() != 1) {
                return;
            }
            JoinRelType joinType = correlate.getJoinType().toJoinType();
            RexNode joinCond = RelDecorrelator.this.relBuilder.literal(true);
            if (joinType != JoinRelType.LEFT || joinCond != RelDecorrelator.this.relBuilder.literal(true)) {
                return;
            }
            if (!aggregate.getGroupSet().isEmpty()) {
                return;
            }
            List<AggregateCall> aggCalls = aggregate.getAggCallList();
            HashSet<Integer> isCount = new HashSet<Integer>();
            int i = -1;
            for (AggregateCall aggCall : aggCalls) {
                ++i;
                if (!(aggCall.getAggregation() instanceof SqlCountAggFunction)) continue;
                isCount.add(i);
            }
            LogicalCorrelate newCorrelate = LogicalCorrelate.create(leftInput, aggregate, correlate.getCorrelationId(), correlate.getRequiredColumns(), correlate.getJoinType());
            RelDecorrelator.this.generatedCorRels.add(newCorrelate);
            if (RelDecorrelator.this.cm.mapCorToCorRel.get(correlate.getCorrelationId()) == correlate) {
                RelDecorrelator.this.cm.mapCorToCorRel.put(correlate.getCorrelationId(), newCorrelate);
            }
            RelNode newOutput = RelDecorrelator.this.aggregateCorrelatorOutput(newCorrelate, aggOutputProject, isCount);
            call.transformTo(newOutput);
        }
    }

    private final class RemoveCorrelationForScalarAggregateRule
    extends RelOptRule {
        RemoveCorrelationForScalarAggregateRule(RelBuilderFactory relBuilderFactory) {
            super(RemoveCorrelationForScalarAggregateRule.operand(LogicalCorrelate.class, RemoveCorrelationForScalarAggregateRule.operand(RelNode.class, RemoveCorrelationForScalarAggregateRule.any()), RemoveCorrelationForScalarAggregateRule.operand(LogicalProject.class, RemoveCorrelationForScalarAggregateRule.operandJ(LogicalAggregate.class, null, Aggregate::isSimple, RemoveCorrelationForScalarAggregateRule.operand(LogicalProject.class, RemoveCorrelationForScalarAggregateRule.operand(RelNode.class, RemoveCorrelationForScalarAggregateRule.any()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), new RelOptRuleOperand[0])), relBuilderFactory, null);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalCorrelate correlate = (LogicalCorrelate)call.rel(0);
            Object left = call.rel(1);
            LogicalProject aggOutputProject = (LogicalProject)call.rel(2);
            LogicalAggregate aggregate = (LogicalAggregate)call.rel(3);
            LogicalProject aggInputProject = (LogicalProject)call.rel(4);
            Object right = call.rel(5);
            RelBuilder builder = call.builder();
            RexBuilder rexBuilder = builder.getRexBuilder();
            RelOptCluster cluster = correlate.getCluster();
            RelDecorrelator.this.setCurrent(call.getPlanner().getRoot(), correlate);
            List<RexNode> aggOutputProjects = aggOutputProject.getProjects();
            if (aggOutputProjects.size() != 1) {
                return;
            }
            JoinRelType joinType = correlate.getJoinType().toJoinType();
            RexNode joinCond = rexBuilder.makeLiteral(true);
            if (joinType != JoinRelType.LEFT || joinCond != rexBuilder.makeLiteral(true)) {
                return;
            }
            if (!aggregate.getGroupSet().isEmpty()) {
                return;
            }
            List<RexNode> aggInputProjects = aggInputProject.getProjects();
            List<AggregateCall> aggCalls = aggregate.getAggCallList();
            HashSet<Integer> isCountStar = new HashSet<Integer>();
            int k = -1;
            for (AggregateCall aggCall : aggCalls) {
                ++k;
                if (!(aggCall.getAggregation() instanceof SqlCountAggFunction) || aggCall.getArgList().size() != 0) continue;
                isCountStar.add(k);
            }
            if (right instanceof LogicalFilter && RelDecorrelator.this.cm.mapRefRelToCorRef.containsKey(right)) {
                LogicalFilter filter = (LogicalFilter)right;
                right = filter.getInput();
                assert (right instanceof HepRelVertex);
                if (RelOptUtil.getVariablesUsed(right = ((HepRelVertex)right).getCurrentRel()).size() > 0) {
                    return;
                }
                ArrayList<RexNode> rightJoinKeys = new ArrayList<RexNode>();
                ArrayList<RexNode> tmpCorrelatedJoinKeys = new ArrayList<RexNode>();
                RelOptUtil.splitCorrelatedFilterCondition(filter, rightJoinKeys, tmpCorrelatedJoinKeys, true);
                ArrayList<RexFieldAccess> correlatedJoinKeys = new ArrayList<RexFieldAccess>();
                ArrayList<RexInputRef> correlatedInputRefJoinKeys = new ArrayList<RexInputRef>();
                for (RexNode joinKey : tmpCorrelatedJoinKeys) {
                    assert (joinKey instanceof RexFieldAccess);
                    correlatedJoinKeys.add((RexFieldAccess)joinKey);
                    RexNode correlatedInputRef = RelDecorrelator.this.removeCorrelationExpr(joinKey, false);
                    assert (correlatedInputRef instanceof RexInputRef);
                    correlatedInputRefJoinKeys.add((RexInputRef)correlatedInputRef);
                }
                if (correlatedInputRefJoinKeys.isEmpty()) {
                    return;
                }
                RelMetadataQuery mq = call.getMetadataQuery();
                if (!RelMdUtil.areColumnsDefinitelyUniqueWhenNullsFiltered(mq, left, correlatedInputRefJoinKeys)) {
                    SQL2REL_LOGGER.debug("{} are not unique keys for {}", (Object)((Object)correlatedJoinKeys).toString(), (Object)left.toString());
                    return;
                }
                if (!RelDecorrelator.this.checkCorVars(correlate, aggInputProject, filter, correlatedJoinKeys)) {
                    return;
                }
                joinCond = RelDecorrelator.this.removeCorrelationExpr(filter.getCondition(), false);
            } else if (RelDecorrelator.this.cm.mapRefRelToCorRef.containsKey((Object)aggInputProject)) {
                if (RelOptUtil.getVariablesUsed(right).size() > 0) {
                    return;
                }
                if (!RelDecorrelator.this.checkCorVars(correlate, aggInputProject, null, null)) {
                    return;
                }
                int nFields = left.getRowType().getFieldCount();
                ImmutableBitSet allCols = ImmutableBitSet.range(nFields);
                RelMetadataQuery mq = call.getMetadataQuery();
                if (!RelMdUtil.areColumnsDefinitelyUnique(mq, left, allCols)) {
                    SQL2REL_LOGGER.debug("There are no unique keys for {}", left);
                    return;
                }
            } else {
                return;
            }
            RelDataType leftInputFieldType = left.getRowType();
            int leftInputFieldCount = leftInputFieldType.getFieldCount();
            int joinOutputProjExprCount = leftInputFieldCount + aggInputProjects.size() + 1;
            right = RelDecorrelator.this.createProjectWithAdditionalExprs(right, (List)ImmutableList.of(Pair.of(rexBuilder.makeLiteral(true), "nullIndicator")));
            LogicalJoin join = LogicalJoin.create(left, right, joinCond, (Set<CorrelationId>)ImmutableSet.of(), joinType);
            int nullIndicatorPos = join.getRowType().getFieldCount() - 1;
            RexInputRef nullIndicator = new RexInputRef(nullIndicatorPos, cluster.getTypeFactory().createTypeWithNullability(join.getRowType().getFieldList().get(nullIndicatorPos).getType(), true));
            ArrayList<RexNode> joinOutputProjects = new ArrayList<RexNode>();
            for (int i = 0; i < leftInputFieldCount; ++i) {
                joinOutputProjects.add(rexBuilder.makeInputRef(leftInputFieldType.getFieldList().get(i).getType(), i));
            }
            for (RexNode aggInputProjExpr : aggInputProjects) {
                joinOutputProjects.add(RelDecorrelator.this.removeCorrelationExpr(aggInputProjExpr, joinType.generatesNullsOnRight(), nullIndicator));
            }
            joinOutputProjects.add(rexBuilder.makeInputRef(join, nullIndicatorPos));
            RelNode joinOutputProject = builder.push(join).project(joinOutputProjects).build();
            nullIndicatorPos = joinOutputProjExprCount - 1;
            int groupCount = leftInputFieldCount;
            ArrayList<AggregateCall> newAggCalls = new ArrayList<AggregateCall>();
            k = -1;
            for (AggregateCall aggCall : aggCalls) {
                List<Integer> argList;
                if (isCountStar.contains(++k)) {
                    argList = Collections.singletonList(nullIndicatorPos);
                } else {
                    argList = new ArrayList<Integer>();
                    for (int aggArg : aggCall.getArgList()) {
                        argList.add(aggArg + groupCount);
                    }
                }
                int filterArg = aggCall.filterArg < 0 ? aggCall.filterArg : aggCall.filterArg + groupCount;
                newAggCalls.add(aggCall.adaptTo(joinOutputProject, argList, filterArg, aggregate.getGroupCount(), groupCount));
            }
            ImmutableBitSet groupSet = ImmutableBitSet.range(groupCount);
            LogicalAggregate newAggregate = LogicalAggregate.create(joinOutputProject, groupSet, null, newAggCalls);
            ArrayList<RexNode> newAggOutputProjectList = new ArrayList<RexNode>();
            for (int i : groupSet) {
                newAggOutputProjectList.add(rexBuilder.makeInputRef(newAggregate, i));
            }
            RexNode newAggOutputProjects = RelDecorrelator.this.removeCorrelationExpr(aggOutputProjects.get(0), false);
            newAggOutputProjectList.add(rexBuilder.makeCast(cluster.getTypeFactory().createTypeWithNullability(newAggOutputProjects.getType(), true), newAggOutputProjects));
            builder.push(newAggregate).project(newAggOutputProjectList);
            call.transformTo(builder.build());
            RelDecorrelator.this.removeCorVarFromTree(correlate);
        }
    }

    private final class RemoveCorrelationForScalarProjectRule
    extends RelOptRule {
        RemoveCorrelationForScalarProjectRule(RelBuilderFactory relBuilderFactory) {
            super(RemoveCorrelationForScalarProjectRule.operand(LogicalCorrelate.class, RemoveCorrelationForScalarProjectRule.operand(RelNode.class, RemoveCorrelationForScalarProjectRule.any()), RemoveCorrelationForScalarProjectRule.operand(LogicalAggregate.class, RemoveCorrelationForScalarProjectRule.operand(LogicalProject.class, RemoveCorrelationForScalarProjectRule.operand(RelNode.class, RemoveCorrelationForScalarProjectRule.any()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0])), relBuilderFactory, null);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            int nullIndicatorPos;
            LogicalCorrelate correlate = (LogicalCorrelate)call.rel(0);
            Object left = call.rel(1);
            LogicalAggregate aggregate = (LogicalAggregate)call.rel(2);
            LogicalProject project = (LogicalProject)call.rel(3);
            Object right = call.rel(4);
            RelOptCluster cluster = correlate.getCluster();
            RelDecorrelator.this.setCurrent(call.getPlanner().getRoot(), correlate);
            JoinRelType joinType = correlate.getJoinType().toJoinType();
            RexNode joinCond = RelDecorrelator.this.relBuilder.literal(true);
            if (joinType != JoinRelType.LEFT || joinCond != RelDecorrelator.this.relBuilder.literal(true)) {
                return;
            }
            if (!aggregate.getGroupSet().isEmpty() || aggregate.getAggCallList().size() != 1 || !(aggregate.getAggCallList().get(0).getAggregation() instanceof SqlSingleValueAggFunction)) {
                return;
            }
            if (project.getProjects().size() != 1) {
                return;
            }
            if (right instanceof LogicalFilter && RelDecorrelator.this.cm.mapRefRelToCorRef.containsKey(right)) {
                LogicalFilter filter = (LogicalFilter)right;
                right = filter.getInput();
                assert (right instanceof HepRelVertex);
                if (RelOptUtil.getVariablesUsed(right = ((HepRelVertex)right).getCurrentRel()).size() > 0) {
                    return;
                }
                ArrayList<RexNode> tmpRightJoinKeys = new ArrayList<RexNode>();
                ArrayList<RexNode> correlatedJoinKeys = new ArrayList<RexNode>();
                RelOptUtil.splitCorrelatedFilterCondition(filter, tmpRightJoinKeys, correlatedJoinKeys, false);
                ArrayList<RexInputRef> rightJoinKeys = new ArrayList<RexInputRef>();
                for (RexNode key : tmpRightJoinKeys) {
                    assert (key instanceof RexInputRef);
                    rightJoinKeys.add((RexInputRef)key);
                }
                if (rightJoinKeys.isEmpty()) {
                    return;
                }
                RelMetadataQuery mq = call.getMetadataQuery();
                if (!RelMdUtil.areColumnsDefinitelyUniqueWhenNullsFiltered(mq, (RelNode)right, rightJoinKeys)) {
                    SQL2REL_LOGGER.debug("{} are not unique keys for {}", (Object)((Object)rightJoinKeys).toString(), (Object)right.toString());
                    return;
                }
                RexUtil.FieldAccessFinder visitor = new RexUtil.FieldAccessFinder();
                RexUtil.apply((RexVisitor<Void>)visitor, correlatedJoinKeys, null);
                List<RexFieldAccess> correlatedKeyList = visitor.getFieldAccessList();
                if (!RelDecorrelator.this.checkCorVars(correlate, project, filter, correlatedKeyList)) {
                    return;
                }
                joinCond = RelDecorrelator.this.removeCorrelationExpr(filter.getCondition(), false);
                nullIndicatorPos = left.getRowType().getFieldCount() + ((RexInputRef)rightJoinKeys.get(0)).getIndex();
            } else if (RelDecorrelator.this.cm.mapRefRelToCorRef.containsKey((Object)project)) {
                if (RelOptUtil.getVariablesUsed(right).size() > 0) {
                    return;
                }
                if (!RelDecorrelator.this.checkCorVars(correlate, project, null, null)) {
                    return;
                }
                right = RelDecorrelator.this.createProjectWithAdditionalExprs(right, (List)ImmutableList.of(Pair.of(RelDecorrelator.this.relBuilder.literal(true), "nullIndicator")));
                right = RelOptUtil.createSingleValueAggRel(cluster, right);
                nullIndicatorPos = left.getRowType().getFieldCount() + right.getRowType().getFieldCount() - 1;
            } else {
                return;
            }
            LogicalJoin join = LogicalJoin.create(left, (RelNode)right, joinCond, (Set<CorrelationId>)ImmutableSet.of(), joinType);
            RelNode newProject = RelDecorrelator.this.projectJoinOutputWithNullability(join, project, nullIndicatorPos);
            call.transformTo(newProject);
            RelDecorrelator.this.removeCorVarFromTree(correlate);
        }
    }

    private final class RemoveSingleAggregateRule
    extends RelOptRule {
        RemoveSingleAggregateRule(RelBuilderFactory relBuilderFactory) {
            super(RemoveSingleAggregateRule.operand(LogicalAggregate.class, RemoveSingleAggregateRule.operand(LogicalProject.class, RemoveSingleAggregateRule.operand(LogicalAggregate.class, RemoveSingleAggregateRule.any()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalAggregate singleAggregate = (LogicalAggregate)call.rel(0);
            LogicalProject project = (LogicalProject)call.rel(1);
            LogicalAggregate aggregate = (LogicalAggregate)call.rel(2);
            if (!singleAggregate.getGroupSet().isEmpty() || singleAggregate.getAggCallList().size() != 1 || !(singleAggregate.getAggCallList().get(0).getAggregation() instanceof SqlSingleValueAggFunction)) {
                return;
            }
            List<RexNode> projExprs = project.getProjects();
            if (projExprs.size() != 1) {
                return;
            }
            if (!aggregate.getGroupSet().isEmpty()) {
                return;
            }
            RelBuilder relBuilder = call.builder();
            RelDataType type = relBuilder.getTypeFactory().createTypeWithNullability(projExprs.get(0).getType(), true);
            RexNode cast = relBuilder.getRexBuilder().makeCast(type, projExprs.get(0));
            relBuilder.push(aggregate).project(cast);
            call.transformTo(relBuilder.build());
        }
    }

    private class RemoveCorrelationRexShuttle
    extends RexShuttle {
        final RexBuilder rexBuilder;
        final RelDataTypeFactory typeFactory;
        final boolean projectPulledAboveLeftCorrelator;
        final RexInputRef nullIndicator;
        final ImmutableSet<Integer> isCount;

        RemoveCorrelationRexShuttle(RexBuilder rexBuilder, boolean projectPulledAboveLeftCorrelator, RexInputRef nullIndicator, Set<Integer> isCount) {
            this.projectPulledAboveLeftCorrelator = projectPulledAboveLeftCorrelator;
            this.nullIndicator = nullIndicator;
            this.isCount = ImmutableSet.copyOf(isCount);
            this.rexBuilder = rexBuilder;
            this.typeFactory = rexBuilder.getTypeFactory();
        }

        private RexNode createCaseExpression(RexInputRef nullInputRef, RexLiteral lit, RexNode rexNode) {
            RexNode[] caseOperands = new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexInputRef(nullInputRef.getIndex(), this.typeFactory.createTypeWithNullability(nullInputRef.getType(), true))), this.rexBuilder.makeCast(this.typeFactory.createTypeWithNullability(rexNode.getType(), true), lit), this.rexBuilder.makeCast(this.typeFactory.createTypeWithNullability(rexNode.getType(), true), rexNode)};
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, caseOperands);
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            if (RelDecorrelator.this.cm.mapFieldAccessToCorRef.containsKey(fieldAccess)) {
                CorRef corVar = (CorRef)RelDecorrelator.this.cm.mapFieldAccessToCorRef.get(fieldAccess);
                RexNode newRexNode = new RexInputRef(corVar.field, fieldAccess.getType());
                if (this.projectPulledAboveLeftCorrelator && this.nullIndicator != null) {
                    newRexNode = this.createCaseExpression(this.nullIndicator, this.rexBuilder.constantNull(), newRexNode);
                }
                return newRexNode;
            }
            return fieldAccess;
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            if (RelDecorrelator.this.currentRel instanceof LogicalCorrelate) {
                int leftInputFieldCount = ((LogicalCorrelate)RelDecorrelator.this.currentRel).getLeft().getRowType().getFieldCount();
                RelDataType newType = inputRef.getType();
                if (this.projectPulledAboveLeftCorrelator) {
                    newType = this.typeFactory.createTypeWithNullability(newType, true);
                }
                int pos = inputRef.getIndex();
                RexInputRef newInputRef = new RexInputRef(leftInputFieldCount + pos, newType);
                if (this.isCount != null && this.isCount.contains((Object)pos)) {
                    return this.createCaseExpression(newInputRef, this.rexBuilder.makeExactLiteral(BigDecimal.ZERO), newInputRef);
                }
                return newInputRef;
            }
            return inputRef;
        }

        @Override
        public RexNode visitLiteral(RexLiteral literal) {
            if (!RexUtil.isNull(literal) && this.projectPulledAboveLeftCorrelator && this.nullIndicator != null) {
                return this.createCaseExpression(this.nullIndicator, this.rexBuilder.constantNull(), literal);
            }
            return literal;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            RexNode newCall;
            boolean[] update = new boolean[]{false};
            List<RexNode> clonedOperands = this.visitList((List<? extends RexNode>)call.operands, update);
            if (update[0]) {
                SqlFunction function;
                SqlOperator operator = call.getOperator();
                boolean isSpecialCast = false;
                if (operator instanceof SqlFunction && (function = (SqlFunction)operator).getKind() == SqlKind.CAST && call.operands.size() < 2) {
                    isSpecialCast = true;
                }
                RelDataType newType = !isSpecialCast ? this.rexBuilder.deriveReturnType(operator, clonedOperands) : call.getType();
                newCall = this.rexBuilder.makeCall(newType, operator, clonedOperands);
            } else {
                newCall = call;
            }
            if (this.projectPulledAboveLeftCorrelator && this.nullIndicator != null) {
                return this.createCaseExpression(this.nullIndicator, this.rexBuilder.constantNull(), newCall);
            }
            return newCall;
        }
    }

    private static class DecorrelateRexShuttle
    extends RexShuttle {
        private final RelNode currentRel;
        private final Map<RelNode, Frame> map;
        private final CorelMap cm;

        private DecorrelateRexShuttle(RelNode currentRel, Map<RelNode, Frame> map, CorelMap cm) {
            this.currentRel = Objects.requireNonNull(currentRel);
            this.map = Objects.requireNonNull(map);
            this.cm = Objects.requireNonNull(cm);
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            int newInputOutputOffset = 0;
            for (RelNode input : this.currentRel.getInputs()) {
                Frame frame = this.map.get(input);
                if (frame != null) {
                    Integer newInputPos;
                    CorRef corRef = (CorRef)this.cm.mapFieldAccessToCorRef.get(fieldAccess);
                    if (corRef != null && (newInputPos = (Integer)frame.corDefOutputs.get((Object)corRef.def())) != null) {
                        return new RexInputRef(newInputPos + newInputOutputOffset, frame.r.getRowType().getFieldList().get(newInputPos).getType());
                    }
                    newInputOutputOffset += frame.r.getRowType().getFieldCount();
                    continue;
                }
                newInputOutputOffset += input.getRowType().getFieldCount();
            }
            return fieldAccess;
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            RexInputRef ref = RelDecorrelator.getNewForOldInputRef(this.currentRel, this.map, inputRef);
            if (ref.getIndex() == inputRef.getIndex() && ref.getType() == inputRef.getType()) {
                return inputRef;
            }
            return ref;
        }
    }
}

