/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.io.File;
import org.apache.calcite.util.Source;
import org.apache.calcite.util.Sources;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class SourceTest {
    private static final String ROOT_PREFIX = SourceTest.getRootPrefix();

    private static String getRootPrefix() {
        for (String s : new String[]{"/", "c:/"}) {
            if (!new File(s).isAbsolute()) continue;
            return s;
        }
        throw new IllegalStateException("Unsupported operation system detected. Both / and c:/ produce relative paths");
    }

    @Test
    public void testAppendWithSpaces() {
        String fooRelative = "fo o+";
        String fooAbsolute = ROOT_PREFIX + "fo o+";
        String barRelative = "b ar+";
        String barAbsolute = ROOT_PREFIX + "b ar+";
        this.assertAppend(Sources.file(null, (String)fooRelative), Sources.file(null, (String)barRelative), "fo o+/b ar+");
        this.assertAppend(Sources.file(null, (String)fooRelative), Sources.file(null, (String)barAbsolute), barAbsolute);
        this.assertAppend(Sources.file(null, (String)fooAbsolute), Sources.file(null, (String)barRelative), ROOT_PREFIX + "fo o+/b ar+");
        this.assertAppend(Sources.file(null, (String)fooAbsolute), Sources.file(null, (String)barAbsolute), barAbsolute);
        String urlFooRelative = "file:fo%20o+";
        String urlFooAbsolute = "file:" + ROOT_PREFIX + "fo%20o+";
        String urlBarRelative = "file:b%20ar+";
        String urlBarAbsolute = "file:" + ROOT_PREFIX + "b%20ar+";
        this.assertAppend(Sources.url((String)urlFooRelative), Sources.url((String)urlBarRelative), "fo o+/b ar+");
        this.assertAppend(Sources.url((String)urlFooRelative), Sources.url((String)urlBarAbsolute), barAbsolute);
        this.assertAppend(Sources.url((String)urlFooAbsolute), Sources.url((String)urlBarRelative), ROOT_PREFIX + "fo o+/b ar+");
        this.assertAppend(Sources.url((String)urlFooAbsolute), Sources.url((String)urlBarAbsolute), barAbsolute);
        this.assertAppend(Sources.file(null, (String)fooRelative), Sources.url((String)urlBarRelative), "fo o+/b ar+");
        this.assertAppend(Sources.file(null, (String)fooRelative), Sources.url((String)urlBarAbsolute), barAbsolute);
        this.assertAppend(Sources.file(null, (String)fooAbsolute), Sources.url((String)urlBarRelative), ROOT_PREFIX + "fo o+/b ar+");
        this.assertAppend(Sources.file(null, (String)fooAbsolute), Sources.url((String)urlBarAbsolute), barAbsolute);
        this.assertAppend(Sources.url((String)urlFooRelative), Sources.file(null, (String)barRelative), "fo o+/b ar+");
        this.assertAppend(Sources.url((String)urlFooRelative), Sources.file(null, (String)barAbsolute), barAbsolute);
        this.assertAppend(Sources.url((String)urlFooAbsolute), Sources.file(null, (String)barRelative), ROOT_PREFIX + "fo o+/b ar+");
        this.assertAppend(Sources.url((String)urlFooAbsolute), Sources.file(null, (String)barAbsolute), barAbsolute);
    }

    @Test
    public void testAppendHttp() {
        this.assertAppendUrl(Sources.url((String)"http://fo%20o+/ba%20r+"), Sources.file(null, (String)"no idea what I am doing+"), "http://fo%20o+/ba%20r+/no%20idea%20what%20I%20am%20doing+");
        this.assertAppendUrl(Sources.url((String)"http://fo%20o+"), Sources.file(null, (String)"no idea what I am doing+"), "http://fo%20o+/no%20idea%20what%20I%20am%20doing+");
        this.assertAppendUrl(Sources.url((String)"http://fo%20o+/ba%20r+"), Sources.url((String)"file:no%20idea%20what%20I%20am%20doing+"), "http://fo%20o+/ba%20r+/no%20idea%20what%20I%20am%20doing+");
        this.assertAppendUrl(Sources.url((String)"http://fo%20o+"), Sources.url((String)"file:no%20idea%20what%20I%20am%20doing+"), "http://fo%20o+/no%20idea%20what%20I%20am%20doing+");
    }

    private void assertAppend(Source parent, Source child, String expected) {
        Assert.assertThat((String)(parent + ".append(" + child + ")"), (Object)parent.append(child).file().toString(), (Matcher)Is.is((Object)new File(expected).toString()));
    }

    private void assertAppendUrl(Source parent, Source child, String expected) {
        Assert.assertThat((String)(parent + ".append(" + child + ")"), (Object)parent.append(child).url().toString(), (Matcher)Is.is((Object)expected));
    }

    @Test
    public void testSpaceInUrl() {
        String url = "file:" + ROOT_PREFIX + "dir%20name/test%20file.json";
        Source foo = Sources.url((String)url);
        Assert.assertEquals((String)(url + " .file().getAbsolutePath()"), (Object)new File(ROOT_PREFIX + "dir name/test file.json").getAbsolutePath(), (Object)foo.file().getAbsolutePath());
    }

    @Test
    public void testSpaceInRelativeUrl() {
        String url = "file:dir%20name/test%20file.json";
        Source foo = Sources.url((String)url);
        Assert.assertEquals((String)(url + " .file().getAbsolutePath()"), (Object)"dir name/test file.json", (Object)foo.file().getPath().replace('\\', '/'));
    }

    @Test
    public void testRelative() {
        Source fooBar = Sources.file(null, (String)(ROOT_PREFIX + "foo/bar"));
        Source foo = Sources.file(null, (String)(ROOT_PREFIX + "foo"));
        Source baz = Sources.file(null, (String)(ROOT_PREFIX + "baz"));
        Source bar = fooBar.relative(foo);
        Assert.assertThat((Object)bar.file().toString(), (Matcher)Is.is((Object)"bar"));
        Assert.assertThat((Object)fooBar.relative(baz), (Matcher)Is.is((Object)fooBar));
    }
}

