/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.nio.charset.Charset;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.test.AbstractSqlTester;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.sql.test.SqlTests;
import org.apache.calcite.sql.test.SqlValidatorTester;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.test.WithLex;
import org.apache.calcite.test.catalog.MockCatalogReaderExtended;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class SqlValidatorTestCase {
    private static final SqlTestFactory EXTENDED_TEST_FACTORY = SqlTestFactory.INSTANCE.withCatalogReader(MockCatalogReaderExtended::new);
    static final SqlTester EXTENDED_CATALOG_TESTER = new SqlValidatorTester(EXTENDED_TEST_FACTORY);
    static final SqlTester EXTENDED_CATALOG_TESTER_2003 = new SqlValidatorTester(EXTENDED_TEST_FACTORY).withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003);
    static final SqlTester EXTENDED_CATALOG_TESTER_LENIENT = new SqlValidatorTester(EXTENDED_TEST_FACTORY).withConformance((SqlConformance)SqlConformanceEnum.LENIENT);
    public static final MethodRule TESTER_CONFIGURATION_RULE = new TesterConfigurationRule();
    protected SqlTester tester = this.getTester();

    public SqlTester getTester() {
        return new SqlValidatorTester(SqlTestFactory.INSTANCE);
    }

    public final Sql sql(String sql) {
        return new Sql(this.tester, sql, true);
    }

    public final Sql expr(String sql) {
        return new Sql(this.tester, sql, false);
    }

    public final Sql winSql(String sql) {
        return this.sql(sql);
    }

    public final Sql win(String sql) {
        return this.sql("select * from emp " + sql);
    }

    public Sql winExp(String sql) {
        return this.winSql("select " + sql + " from emp window w as (order by deptno)");
    }

    public Sql winExp2(String sql) {
        return this.winSql("select " + sql + " from emp");
    }

    public void check(String sql) {
        this.sql(sql).ok();
    }

    public void checkExp(String sql) {
        this.tester.assertExceptionIsThrown(AbstractSqlTester.buildQuery(sql), null);
    }

    public final void checkFails(String sql, String expected) {
        this.sql(sql).fails(expected);
    }

    public final void checkExpFails(String sql, String expected) {
        this.tester.assertExceptionIsThrown(AbstractSqlTester.buildQuery(sql), expected);
    }

    public final void checkWholeExpFails(String sql, String expected) {
        assert (sql.indexOf(94) < 0);
        this.checkExpFails("^" + sql + "^", expected);
    }

    public final void checkExpType(String sql, String expected) {
        this.checkColumnType(AbstractSqlTester.buildQuery(sql), expected);
    }

    public final void checkColumnType(String sql, String expected) {
        this.tester.checkColumnType(sql, expected);
    }

    public final void checkResultType(String sql, String expected) {
        this.tester.checkResultType(sql, expected);
    }

    public final void checkIntervalConv(String sql, String expected) {
        this.tester.checkIntervalConv(AbstractSqlTester.buildQuery(sql), expected);
    }

    protected final void assertExceptionIsThrown(String sql, String expectedMsgPattern) {
        assert (expectedMsgPattern != null);
        this.tester.assertExceptionIsThrown(sql, expectedMsgPattern);
    }

    public void checkCharset(String sql, Charset expectedCharset) {
        this.tester.checkCharset(sql, expectedCharset);
    }

    public void checkCollation(String sql, String expectedCollationName, SqlCollation.Coercibility expectedCoercibility) {
        this.tester.checkCollation(sql, expectedCollationName, expectedCoercibility);
    }

    public static void checkEx(Throwable ex, String expectedMsgPattern, SqlParserUtil.StringAndPos sap) {
        SqlTests.checkEx(ex, expectedMsgPattern, sap, SqlTests.Stage.VALIDATE);
    }

    private static class TesterConfigurationRule
    implements MethodRule {
        private TesterConfigurationRule() {
        }

        public Statement apply(final Statement statement, final FrameworkMethod frameworkMethod, final Object o) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    SqlValidatorTestCase tc = (SqlValidatorTestCase)o;
                    SqlTester tester = tc.tester;
                    WithLex lex = (WithLex)frameworkMethod.getAnnotation(WithLex.class);
                    if (lex != null) {
                        tester = tester.withLex(lex.value());
                    }
                    tc.tester = tester;
                    statement.evaluate();
                }
            };
        }
    }

    static class Sql {
        private final SqlTester tester;
        private final String sql;

        Sql(SqlTester tester, String sql, boolean query) {
            this.tester = tester;
            this.sql = query ? sql : AbstractSqlTester.buildQuery(sql);
        }

        Sql tester(SqlTester tester) {
            return new Sql(tester, this.sql, true);
        }

        public Sql sql(String sql) {
            return new Sql(this.tester, sql, true);
        }

        Sql withExtendedCatalog() {
            return this.tester(EXTENDED_CATALOG_TESTER);
        }

        Sql withExtendedCatalog2003() {
            return this.tester(EXTENDED_CATALOG_TESTER_2003);
        }

        Sql withExtendedCatalogLenient() {
            return this.tester(EXTENDED_CATALOG_TESTER_LENIENT);
        }

        Sql ok() {
            this.tester.assertExceptionIsThrown(this.sql, null);
            return this;
        }

        Sql fails(String expected) {
            this.tester.assertExceptionIsThrown(this.sql, expected);
            return this;
        }

        Sql failsIf(boolean b, String expected) {
            if (b) {
                this.fails(expected);
            } else {
                this.ok();
            }
            return this;
        }

        public Sql type(String expectedType) {
            this.tester.checkResultType(this.sql, expectedType);
            return this;
        }

        public Sql columnType(String expectedType) {
            this.tester.checkColumnType(this.sql, expectedType);
            return this;
        }

        public Sql monotonic(SqlMonotonicity expectedMonotonicity) {
            this.tester.checkMonotonic(this.sql, expectedMonotonicity);
            return this;
        }

        public Sql bindType(String bindType) {
            this.tester.check(this.sql, null, parameterRowType -> Assert.assertThat((Object)parameterRowType.toString(), (Matcher)CoreMatchers.is((Object)bindType)), result -> {});
            return this;
        }

        public Sql sansCarets() {
            return new Sql(this.tester, this.sql.replace("^", ""), true);
        }
    }

    public static interface Tester {
        public SqlNode parseQuery(String var1) throws SqlParseException;

        public SqlNode parseAndValidate(SqlValidator var1, String var2);

        public SqlValidator getValidator();

        public void assertExceptionIsThrown(String var1, String var2);

        public RelDataType getColumnType(String var1);

        public RelDataType getResultType(String var1);

        public void checkCollation(String var1, String var2, SqlCollation.Coercibility var3);

        public void checkCharset(String var1, Charset var2);

        public void checkColumnType(String var1, String var2);

        public void checkFieldOrigin(String var1, String var2);

        public void checkRewrite(SqlValidator var1, String var2, String var3);

        public void checkResultType(String var1, String var2);

        public void checkIntervalConv(String var1, String var2);

        public SqlMonotonicity getMonotonicity(String var1);

        public SqlConformance getConformance();
    }
}

