/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.io.IOException;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.externalize.RelJsonReader;
import org.apache.calcite.rel.externalize.RelJsonWriter;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.test.SqlToRelConverterTest;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.TestUtil;
import org.junit.After;
import org.junit.Before;

public class SqlToRelConverterExtendedTest
extends SqlToRelConverterTest {
    Hook.Closeable closeable;

    @Before
    public void before() {
        this.closeable = Hook.CONVERTED.addThread(SqlToRelConverterExtendedTest::foo);
    }

    @After
    public void after() {
        if (this.closeable != null) {
            this.closeable.close();
            this.closeable = null;
        }
    }

    public static void foo(RelNode rel) {
        RelJsonWriter writer = new RelJsonWriter();
        rel.explain((RelWriter)writer);
        String json = writer.asString();
        final RelOptSchema[] schemas = new RelOptSchema[]{null};
        rel.accept((RelShuttle)new RelShuttleImpl(){

            public RelNode visit(TableScan scan) {
                schemas[0] = scan.getTable().getRelOptSchema();
                return super.visit(scan);
            }
        });
        Frameworks.withPlanner((cluster, relOptSchema, rootSchema) -> {
            RelJsonReader reader = new RelJsonReader(cluster, schemas[0], (Schema)rootSchema);
            try {
                RelNode relNode = reader.read(json);
            }
            catch (IOException e) {
                throw TestUtil.rethrow(e);
            }
            return null;
        });
    }
}

