/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.sql.test.SqlValidatorTester;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.test.SqlValidatorTest;
import org.apache.calcite.util.BarfingInvocationHandler;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.Util;

public class SqlTestGen {
    private SqlTestGen() {
    }

    public static void main(String[] args) {
        new SqlTestGen().genValidatorTest();
    }

    private void genValidatorTest() {
        File file = new File("validatorTest.sql");
        try (PrintWriter pw = Util.printWriter((File)file);){
            Method[] methods;
            for (Method method : methods = SqlTestGen.getJunitMethods(SqlValidatorSpooler.class)) {
                SqlValidatorSpooler test = new SqlValidatorSpooler(pw);
                Object result = method.invoke((Object)test, new Object[0]);
                assert (result == null);
            }
        }
        catch (Exception e) {
            throw TestUtil.rethrow(e);
        }
    }

    private static Method[] getJunitMethods(Class<SqlValidatorSpooler> clazz) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().startsWith("test") || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType() != Void.TYPE) continue;
            list.add(method);
        }
        return list.toArray(new Method[0]);
    }

    private static class SqlValidatorSpooler
    extends SqlValidatorTest {
        private static final SqlTestFactory SPOOLER_VALIDATOR = SqlTestFactory.INSTANCE.withValidator((opTab, catalogReader, typeFactory, conformance) -> (SqlValidator)Proxy.newProxyInstance(SqlValidatorSpooler.class.getClassLoader(), new Class[]{SqlValidator.class}, (InvocationHandler)((Object)new MyInvocationHandler())));
        private final PrintWriter pw;

        private SqlValidatorSpooler(PrintWriter pw) {
            this.pw = pw;
        }

        @Override
        public SqlTester getTester() {
            return new SqlValidatorTester(SPOOLER_VALIDATOR){

                @Override
                public void assertExceptionIsThrown(String sql, String expectedMsgPattern) {
                    if (expectedMsgPattern == null) {
                        pw.println("-- ");
                        pw.println(sql);
                        pw.println(";");
                    }
                }

                @Override
                public void checkColumnType(String sql, String expected) {
                }

                @Override
                public void checkResultType(String sql, String expected) {
                }

                @Override
                public void checkType(String sql, String expected) {
                }

                @Override
                public void checkCollation(String expression, String expectedCollationName, SqlCollation.Coercibility expectedCoercibility) {
                }

                @Override
                public void checkCharset(String expression, Charset expectedCharset) {
                }

                @Override
                public void checkIntervalConv(String sql, String expected) {
                }

                @Override
                public void checkRewrite(SqlValidator validator, String query, String expectedRewrite) {
                }

                @Override
                public void checkFieldOrigin(String sql, String fieldOriginList) {
                }
            };
        }

        public static class MyInvocationHandler
        extends BarfingInvocationHandler {
            public void setIdentifierExpansion(boolean b) {
            }

            public void setColumnReferenceExpansion(boolean b) {
            }

            public void setCallRewrite(boolean b) {
            }

            public boolean shouldExpandIdentifiers() {
                return true;
            }
        }
    }
}

