/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.Strong;
import org.apache.calcite.rel.metadata.NullSentinel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexInterpreter;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeAssignmentRules;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.RexProgramBuilderBase;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.TimestampWithTimeZoneString;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RexProgramTest
extends RexProgramBuilderBase {
    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    private void checkCnf(RexNode node, String expected) {
        Assert.assertThat((String)("RexUtil.toCnf(rexBuilder, " + node + ")"), (Object)RexUtil.toCnf((RexBuilder)this.rexBuilder, (RexNode)node).toString(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private void checkThresholdCnf(RexNode node, int threshold, String expected) {
        Assert.assertThat((String)("RexUtil.toCnf(rexBuilder, threshold=" + threshold + " , " + node + ")"), (Object)RexUtil.toCnf((RexBuilder)this.rexBuilder, (int)threshold, (RexNode)node).toString(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private void checkPullFactorsUnchanged(RexNode node) {
        this.checkPullFactors(node, node.toString());
    }

    private void checkPullFactors(RexNode node, String expected) {
        Assert.assertThat((String)("RexUtil.pullFactors(rexBuilder, " + node + ")"), (Object)RexUtil.pullFactors((RexBuilder)this.rexBuilder, (RexNode)node).toString(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private void assertNode(String message, String expected, RexNode node) {
        String actual = node.isA(SqlKind.CAST) || node.isA(SqlKind.NEW_SPECIFICATION) ? node.toString() : node + ":" + node.getType() + (node.getType().isNullable() ? "" : " NOT NULL");
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    private void checkSimplify(RexNode node, String expected) {
        String nodeString = node.toString();
        this.checkSimplify3_(node, expected, expected, expected);
        if (expected.equals(nodeString)) {
            throw new AssertionError((Object)"expected == node.toString(); use checkSimplifyUnchanged");
        }
    }

    private void checkSimplifyUnchanged(RexNode node) {
        String expected = node.toString();
        this.checkSimplify3_(node, expected, expected, expected);
    }

    private void checkSimplify2(RexNode node, String expected, String expectedFalse) {
        this.checkSimplify3_(node, expected, expectedFalse, expected);
        if (expected.equals(expectedFalse)) {
            throw new AssertionError((Object)"expected == expectedFalse; use checkSimplify");
        }
    }

    private void checkSimplify3(RexNode node, String expected, String expectedFalse, String expectedTrue) {
        this.checkSimplify3_(node, expected, expectedFalse, expectedTrue);
        if (expected.equals(expectedFalse) && expected.equals(expectedTrue)) {
            throw new AssertionError((Object)"expected == expectedFalse == expectedTrue; use checkSimplify");
        }
        if (expected.equals(expectedTrue)) {
            throw new AssertionError((Object)"expected == expectedTrue; use checkSimplify2");
        }
    }

    private void checkSimplify3_(RexNode node, String expected, String expectedFalse, String expectedTrue) {
        RexNode simplified = this.simplify.simplifyUnknownAs(node, RexUnknownAs.UNKNOWN);
        Assert.assertThat((String)("simplify(unknown as unknown): " + node), (Object)simplified.toString(), (Matcher)CoreMatchers.equalTo((Object)expected));
        if (node.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
            RexNode simplified2 = this.simplify.simplifyUnknownAs(node, RexUnknownAs.FALSE);
            Assert.assertThat((String)("simplify(unknown as false): " + node), (Object)simplified2.toString(), (Matcher)CoreMatchers.equalTo((Object)expectedFalse));
            RexNode simplified3 = this.simplify.simplifyUnknownAs(node, RexUnknownAs.TRUE);
            Assert.assertThat((String)("simplify(unknown as true): " + node), (Object)simplified3.toString(), (Matcher)CoreMatchers.equalTo((Object)expectedTrue));
        } else {
            Assert.assertThat((String)"node type is not BOOLEAN, so <<expectedFalse>> should match <<expected>>", (Object)expectedFalse, (Matcher)CoreMatchers.is((Object)expected));
            Assert.assertThat((String)"node type is not BOOLEAN, so <<expectedTrue>> should match <<expected>>", (Object)expectedTrue, (Matcher)CoreMatchers.is((Object)expected));
        }
    }

    private void checkSimplifyFilter(RexNode node, String expected) {
        RexNode simplified = this.simplify.simplifyUnknownAs(node, RexUnknownAs.FALSE);
        Assert.assertThat((Object)simplified.toString(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private void checkSimplifyFilter(RexNode node, RelOptPredicateList predicates, String expected) {
        RexNode simplified = this.simplify.withPredicates(predicates).simplifyUnknownAs(node, RexUnknownAs.FALSE);
        Assert.assertThat((Object)simplified.toString(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private static int nodeCount(RexNode node) {
        int n = 1;
        if (node instanceof RexCall) {
            for (RexNode operand : ((RexCall)node).getOperands()) {
                n += RexProgramTest.nodeCount(operand);
            }
        }
        return n;
    }

    @Test
    public void testBuildProgram() {
        RexProgramBuilder builder = this.createProg(0);
        RexProgram program = builder.getProgram(false);
        String programString = program.toString();
        TestUtil.assertEqualsVerbose("(expr#0..1=[{inputs}], expr#2=[+($0, 1)], expr#3=[77], expr#4=[+($0, $1)], expr#5=[+($0, $0)], expr#6=[+($t4, $t2)], a=[$t6], b=[$t5])", programString);
        RexProgram normalizedProgram = program.normalize(this.rexBuilder, null);
        String normalizedProgramString = normalizedProgram.toString();
        TestUtil.assertEqualsVerbose("(expr#0..1=[{inputs}], expr#2=[+($t0, $t1)], expr#3=[1], expr#4=[+($t0, $t3)], expr#5=[+($t2, $t4)], expr#6=[+($t0, $t0)], a=[$t5], b=[$t6])", normalizedProgramString);
    }

    @Test
    public void testNormalize() {
        RexProgramBuilder builder = this.createProg(0);
        String program = builder.getProgram(true).toString();
        TestUtil.assertEqualsVerbose("(expr#0..1=[{inputs}], expr#2=[+($t0, $t1)], expr#3=[1], expr#4=[+($t0, $t3)], expr#5=[+($t2, $t4)], expr#6=[+($t0, $t0)], a=[$t5], b=[$t6])", program);
    }

    @Test
    public void testElimDups() {
        RexProgramBuilder builder = this.createProg(1);
        String unnormalizedProgram = builder.getProgram(false).toString();
        TestUtil.assertEqualsVerbose("(expr#0..1=[{inputs}], expr#2=[+($0, 1)], expr#3=[77], expr#4=[+($0, $1)], expr#5=[+($0, 1)], expr#6=[+($0, $t5)], expr#7=[+($t4, $t2)], a=[$t7], b=[$t6])", unnormalizedProgram);
        RexProgramBuilder builder2 = this.createProg(1);
        String program2 = builder2.getProgram(true).toString();
        TestUtil.assertEqualsVerbose("(expr#0..1=[{inputs}], expr#2=[+($t0, $t1)], expr#3=[1], expr#4=[+($t0, $t3)], expr#5=[+($t2, $t4)], expr#6=[+($t0, $t4)], a=[$t5], b=[$t6])", program2);
    }

    @Test
    public void testSimplifyCondition() {
        RexProgram program = this.createProg(3).getProgram(false);
        Assert.assertThat((Object)program.toString(), (Matcher)CoreMatchers.is((Object)"(expr#0..1=[{inputs}], expr#2=[+($0, 1)], expr#3=[77], expr#4=[+($0, $1)], expr#5=[+($0, 1)], expr#6=[+($0, $t5)], expr#7=[+($t4, $t2)], expr#8=[5], expr#9=[>($t2, $t8)], expr#10=[true], expr#11=[IS NOT NULL($t5)], expr#12=[false], expr#13=[null:BOOLEAN], expr#14=[CASE($t9, $t10, $t11, $t12, $t13)], expr#15=[NOT($t14)], a=[$t7], b=[$t6], $condition=[$t15])"));
        Assert.assertThat((Object)program.normalize(this.rexBuilder, this.simplify).toString(), (Matcher)CoreMatchers.is((Object)"(expr#0..1=[{inputs}], expr#2=[+($t0, $t1)], expr#3=[1], expr#4=[+($t0, $t3)], expr#5=[+($t2, $t4)], expr#6=[+($t0, $t4)], expr#7=[5], expr#8=[<=($t4, $t7)], a=[$t5], b=[$t6], $condition=[$t8])"));
    }

    @Test
    public void testSimplifyCondition2() {
        RexProgram program = this.createProg(4).getProgram(false);
        Assert.assertThat((Object)program.toString(), (Matcher)CoreMatchers.is((Object)"(expr#0..1=[{inputs}], expr#2=[+($0, 1)], expr#3=[77], expr#4=[+($0, $1)], expr#5=[+($0, 1)], expr#6=[+($0, $t5)], expr#7=[+($t4, $t2)], expr#8=[5], expr#9=[>($t2, $t8)], expr#10=[true], expr#11=[IS NOT NULL($t5)], expr#12=[false], expr#13=[null:BOOLEAN], expr#14=[CASE($t9, $t10, $t11, $t12, $t13)], expr#15=[NOT($t14)], expr#16=[IS TRUE($t15)], a=[$t7], b=[$t6], $condition=[$t16])"));
        Assert.assertThat((Object)program.normalize(this.rexBuilder, this.simplify).toString(), (Matcher)CoreMatchers.is((Object)"(expr#0..1=[{inputs}], expr#2=[+($t0, $t1)], expr#3=[1], expr#4=[+($t0, $t3)], expr#5=[+($t2, $t4)], expr#6=[+($t0, $t4)], expr#7=[5], expr#8=[<=($t4, $t7)], a=[$t5], b=[$t6], $condition=[$t8])"));
    }

    @Test
    public void testDuplicateAnd() {
        RexProgramBuilder builder = this.createProg(2);
        String program = builder.getProgram(true).toString();
        TestUtil.assertEqualsVerbose("(expr#0..1=[{inputs}], expr#2=[+($t0, $t1)], expr#3=[1], expr#4=[+($t0, $t3)], expr#5=[+($t2, $t4)], expr#6=[+($t0, $t0)], expr#7=[>($t2, $t0)], a=[$t5], b=[$t6], $condition=[$t7])", program);
    }

    private RexProgramBuilder createProg(int variant) {
        RexLocalRef t1;
        RexLocalRef t5;
        assert (variant >= 0 && variant <= 4);
        List<RelDataType> types = Arrays.asList(this.typeFactory.createSqlType(SqlTypeName.INTEGER), this.typeFactory.createSqlType(SqlTypeName.INTEGER));
        List<String> names = Arrays.asList("x", "y");
        RelDataType inputRowType = this.typeFactory.createStructType(types, names);
        RexProgramBuilder builder = new RexProgramBuilder(inputRowType, this.rexBuilder);
        RexInputRef i0 = this.rexBuilder.makeInputRef(types.get(0), 0);
        RexLiteral c1 = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        RexLiteral c5 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(5L));
        RexLocalRef t2 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{i0, c1}));
        RexLiteral c77 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(77L));
        RexLocalRef t3 = builder.addExpr((RexNode)c77);
        Util.discard((Object)t3);
        RexInputRef i1 = this.rexBuilder.makeInputRef(types.get(1), 1);
        RexLocalRef t4 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{i0, i1}));
        switch (variant) {
            case 0: 
            case 2: {
                t5 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{i0, i0}));
                t1 = null;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                t1 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{i0, c1}));
                t5 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{i0, t1}));
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected variant " + variant));
            }
        }
        RexLocalRef t6 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{t4, t2}));
        builder.addProject(t6.getIndex(), "a");
        builder.addProject(t5.getIndex(), "b");
        switch (variant) {
            case 2: {
                RexLocalRef t7 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t4, i0}));
                RexLocalRef t8 = builder.addExpr(this.and(new RexNode[]{t7, t7}));
                builder.addCondition((RexNode)t8);
                builder.addCondition((RexNode)t7);
                break;
            }
            case 3: 
            case 4: {
                RexLocalRef t7 = builder.addExpr((RexNode)c5);
                RexLocalRef t8 = builder.addExpr(this.gt((RexNode)t2, (RexNode)t7));
                RexLocalRef t9 = builder.addExpr((RexNode)this.trueLiteral);
                assert (t1 != null);
                RexLocalRef t10 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{t1}));
                RexLocalRef t11 = builder.addExpr((RexNode)this.falseLiteral);
                RexLocalRef t12 = builder.addExpr((RexNode)this.nullBool);
                RexLocalRef t13 = builder.addExpr(this.case_(new RexNode[]{t8, t9, t10, t11, t12}));
                RexLocalRef t14 = builder.addExpr(this.not((RexNode)t13));
                if (variant == 3) {
                    builder.addCondition((RexNode)t14);
                    break;
                }
                RexLocalRef t15 = builder.addExpr(this.isTrue((RexNode)t14));
                builder.addCondition((RexNode)t15);
            }
        }
        return builder;
    }

    @Test
    public void testStrong() {
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        ImmutableBitSet c = ImmutableBitSet.of();
        ImmutableBitSet c0 = ImmutableBitSet.of((int[])new int[]{0});
        ImmutableBitSet c1 = ImmutableBitSet.of((int[])new int[]{1});
        ImmutableBitSet c01 = ImmutableBitSet.of((int[])new int[]{0, 1});
        ImmutableBitSet c13 = ImmutableBitSet.of((int[])new int[]{1, 3});
        RexInputRef i0 = this.rexBuilder.makeInputRef(intType, 0);
        RexInputRef i1 = this.rexBuilder.makeInputRef(intType, 1);
        Assert.assertThat((Object)Strong.isNull((RexNode)i0, (ImmutableBitSet)c0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)i0, (ImmutableBitSet)c1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)i0, (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)i0, (ImmutableBitSet)c13), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.trueLiteral, (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.trueLiteral, (ImmutableBitSet)c13), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.falseLiteral, (ImmutableBitSet)c13), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.nullInt, (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.nullInt, (ImmutableBitSet)c13), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.nullBool, (ImmutableBitSet)c13), (Matcher)CoreMatchers.is((Object)true));
        RexNode andUnknownTrue = this.and(new RexNode[]{this.nullBool, this.trueLiteral});
        RexNode andTrueUnknown = this.and(new RexNode[]{this.trueLiteral, this.nullBool});
        RexNode andFalseTrue = this.and(new RexNode[]{this.falseLiteral, this.trueLiteral});
        Assert.assertThat((Object)Strong.isNull((RexNode)andUnknownTrue, (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)andTrueUnknown, (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)andFalseTrue, (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.and(new RexNode[]{i0, this.isNull((RexNode)i1)}), (ImmutableBitSet)c0), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.and(new RexNode[]{i0, this.isNull((RexNode)i1)}), (ImmutableBitSet)c1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.and(new RexNode[]{i0, i1}), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.and(new RexNode[]{i0, i1}), (ImmutableBitSet)c1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.and(new RexNode[]{i0, this.isNull((RexNode)i1)}), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.or(new RexNode[]{i0, i1}), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.or(new RexNode[]{i0, i1}), (ImmutableBitSet)c0), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.or(new RexNode[]{i0, i1}), (ImmutableBitSet)c1), (Matcher)CoreMatchers.is((Object)false));
        RexNode i0NotNull = this.isNotNull((RexNode)i0);
        Assert.assertThat((Object)Strong.isNull((RexNode)i0NotNull, (ImmutableBitSet)c0), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNotTrue((RexNode)i0NotNull, (ImmutableBitSet)c0), (Matcher)CoreMatchers.is((Object)true));
        RexNode notI0NotNull = this.not(this.isNotNull((RexNode)i0));
        Assert.assertThat((Object)Strong.isNull((RexNode)notI0NotNull, (ImmutableBitSet)c0), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNotTrue((RexNode)notI0NotNull, (ImmutableBitSet)c0), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.nullIf((RexNode)this.nullInt, (RexNode)this.nullInt), (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.nullIf((RexNode)this.nullInt, (RexNode)this.trueLiteral), (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.nullIf((RexNode)this.trueLiteral, (RexNode)this.trueLiteral), (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.nullIf((RexNode)this.trueLiteral, (RexNode)this.falseLiteral), (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.nullIf((RexNode)this.trueLiteral, (RexNode)this.nullInt), (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.isNull((RexNode)this.nullInt), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.isNull((RexNode)this.trueLiteral), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.eq((RexNode)i0, (RexNode)i1), this.nullInt, this.ge((RexNode)i0, (RexNode)i1), this.nullInt, this.nullInt}), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.eq((RexNode)i0, (RexNode)i1), i0, this.ge((RexNode)i0, (RexNode)i1), this.nullInt, this.nullInt}), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.eq((RexNode)i0, (RexNode)i1), i0, this.ge((RexNode)i0, (RexNode)i1), this.nullInt, this.nullInt}), (ImmutableBitSet)c1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.eq((RexNode)i0, (RexNode)i1), this.nullInt, this.ge((RexNode)i0, (RexNode)i1), i0, this.nullInt}), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.eq((RexNode)i0, (RexNode)i1), this.nullInt, this.ge((RexNode)i0, (RexNode)i1), i0, this.nullInt}), (ImmutableBitSet)c1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.eq((RexNode)i0, (RexNode)i1), this.nullInt, this.ge((RexNode)i0, (RexNode)i1), this.nullInt, i0}), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.eq((RexNode)i0, (RexNode)i1), this.nullInt, this.ge((RexNode)i0, (RexNode)i1), this.nullInt, i0}), (ImmutableBitSet)c1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.isNotNull((RexNode)i0), i0, i1}), (ImmutableBitSet)c), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.isNotNull((RexNode)i0), i0, i1}), (ImmutableBitSet)c0), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.isNotNull((RexNode)i0), i0, i1}), (ImmutableBitSet)c1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Strong.isNull((RexNode)this.case_(new RexNode[]{this.isNotNull((RexNode)i0), i0, i1}), (ImmutableBitSet)c01), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void xAndNotX() {
        this.checkSimplify2(this.and(this.vBool(), this.not(this.vBool()), this.vBool(1), this.not(this.vBool(1))), "AND(null, IS NULL(?0.bool0), IS NULL(?0.bool1))", "false");
        this.checkSimplify2(this.and(this.vBool(), this.vBool(1), this.not(this.vBool(1))), "AND(?0.bool0, null, IS NULL(?0.bool1))", "false");
        this.checkSimplify(this.and(this.vBool(), this.not(this.vBool()), this.vBoolNotNull(1), this.not(this.vBoolNotNull(1))), "false");
    }

    @Test
    public void testLosslessCast() {
        RelDataType tinyIntType = this.typeFactory.createSqlType(SqlTypeName.TINYINT);
        RelDataType smallIntType = this.typeFactory.createSqlType(SqlTypeName.SMALLINT);
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType bigIntType = this.typeFactory.createSqlType(SqlTypeName.BIGINT);
        RelDataType floatType = this.typeFactory.createSqlType(SqlTypeName.FLOAT);
        RelDataType booleanType = this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        RelDataType charType5 = this.typeFactory.createSqlType(SqlTypeName.CHAR, 5);
        RelDataType charType6 = this.typeFactory.createSqlType(SqlTypeName.CHAR, 6);
        RelDataType varCharType10 = this.typeFactory.createSqlType(SqlTypeName.VARCHAR, 10);
        RelDataType varCharType11 = this.typeFactory.createSqlType(SqlTypeName.VARCHAR, 11);
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeInputRef(intType, 0)), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(tinyIntType, (RexNode)this.rexBuilder.makeInputRef(smallIntType, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(smallIntType, (RexNode)this.rexBuilder.makeInputRef(intType, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(intType, (RexNode)this.rexBuilder.makeInputRef(bigIntType, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(bigIntType, (RexNode)this.rexBuilder.makeInputRef(floatType, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(booleanType, (RexNode)this.rexBuilder.makeInputRef(bigIntType, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(intType, (RexNode)this.rexBuilder.makeInputRef(charType5, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(intType, (RexNode)this.rexBuilder.makeInputRef(varCharType10, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(varCharType10, (RexNode)this.rexBuilder.makeInputRef(varCharType11, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(charType5, (RexNode)this.rexBuilder.makeInputRef(bigIntType, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(charType5, (RexNode)this.rexBuilder.makeInputRef(smallIntType, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(varCharType10, (RexNode)this.rexBuilder.makeInputRef(intType, 0))), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(smallIntType, (RexNode)this.rexBuilder.makeInputRef(tinyIntType, 0))), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(intType, (RexNode)this.rexBuilder.makeInputRef(smallIntType, 0))), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(bigIntType, (RexNode)this.rexBuilder.makeInputRef(intType, 0))), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(intType, (RexNode)this.rexBuilder.makeInputRef(intType, 0))), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(charType6, (RexNode)this.rexBuilder.makeInputRef(smallIntType, 0))), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(varCharType10, (RexNode)this.rexBuilder.makeInputRef(smallIntType, 0))), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(varCharType11, (RexNode)this.rexBuilder.makeInputRef(intType, 0))), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(varCharType11, (RexNode)this.rexBuilder.makeInputRef(charType6, 0))), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)RexUtil.isLosslessCast((RexNode)this.rexBuilder.makeCast(varCharType11, (RexNode)this.rexBuilder.makeInputRef(varCharType10, 0))), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void removeRedundantCast() {
        this.checkSimplify(this.cast(this.vInt(), this.nullable(this.tInt())), "?0.int0");
        this.checkSimplifyUnchanged(this.cast(this.vInt(), this.tInt()));
        this.checkSimplify(this.cast(this.vIntNotNull(), this.nullable(this.tInt())), "?0.notNullInt0");
        this.checkSimplify(this.cast(this.vIntNotNull(), this.tInt()), "?0.notNullInt0");
        this.checkSimplify(this.cast(this.cast(this.vVarchar(), this.tInt()), this.tInt()), "CAST(?0.varchar0):INTEGER NOT NULL");
        this.checkSimplifyUnchanged(this.cast(this.cast(this.vVarchar(), this.tInt()), this.tVarchar()));
    }

    @Test
    public void testNoCommonReturnTypeFails() {
        try {
            RexNode node = this.coalesce(this.vVarchar(1), this.vInt(2));
            Assert.fail((String)("expected exception, got " + node));
        }
        catch (IllegalArgumentException e) {
            String expected = "Cannot infer return type for COALESCE; operand types: [VARCHAR, INTEGER]";
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Cannot infer return type for COALESCE; operand types: [VARCHAR, INTEGER]"));
        }
    }

    @Test
    public void testCnf() {
        RelDataType booleanType = this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType rowType = this.typeFactory.builder().add("a", booleanType).add("b", booleanType).add("c", booleanType).add("d", booleanType).add("e", booleanType).add("f", booleanType).add("g", booleanType).add("h", intType).build();
        RexDynamicParam range = this.rexBuilder.makeDynamicParam(rowType, 0);
        RexNode aRef = this.rexBuilder.makeFieldAccess((RexNode)range, 0);
        RexNode bRef = this.rexBuilder.makeFieldAccess((RexNode)range, 1);
        RexNode cRef = this.rexBuilder.makeFieldAccess((RexNode)range, 2);
        RexNode dRef = this.rexBuilder.makeFieldAccess((RexNode)range, 3);
        RexNode eRef = this.rexBuilder.makeFieldAccess((RexNode)range, 4);
        RexNode fRef = this.rexBuilder.makeFieldAccess((RexNode)range, 5);
        RexNode gRef = this.rexBuilder.makeFieldAccess((RexNode)range, 6);
        RexNode hRef = this.rexBuilder.makeFieldAccess((RexNode)range, 7);
        RexLiteral sevenLiteral = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(7L));
        RexNode hEqSeven = this.eq(hRef, (RexNode)sevenLiteral);
        this.checkCnf(aRef, "?0.a");
        this.checkCnf((RexNode)this.trueLiteral, "true");
        this.checkCnf((RexNode)this.falseLiteral, "false");
        this.checkCnf((RexNode)this.nullBool, "null:BOOLEAN");
        this.checkCnf(this.and(aRef, bRef), "AND(?0.a, ?0.b)");
        this.checkCnf(this.and(aRef, bRef, cRef), "AND(?0.a, ?0.b, ?0.c)");
        this.checkCnf(this.and(this.or(aRef, bRef), this.or(cRef, dRef)), "AND(OR(?0.a, ?0.b), OR(?0.c, ?0.d))");
        this.checkCnf(this.or(this.and(aRef, bRef), this.and(cRef, dRef)), "AND(OR(?0.a, ?0.c), OR(?0.a, ?0.d), OR(?0.b, ?0.c), OR(?0.b, ?0.d))");
        this.checkCnf(this.or(this.and(aRef, bRef), this.or(cRef, dRef)), "AND(OR(?0.a, ?0.c, ?0.d), OR(?0.b, ?0.c, ?0.d))");
        this.checkCnf(this.or(aRef, this.not(this.and(bRef, this.not(hEqSeven)))), "OR(?0.a, NOT(?0.b), =(?0.h, 7))");
        this.checkCnf(this.not(this.or(aRef, this.not(bRef))), "AND(NOT(?0.a), ?0.b)");
        this.checkCnf(this.not(this.or(new RexNode[]{this.and(new RexNode[]{aRef, this.trueLiteral}), this.not(bRef), this.falseLiteral})), "AND(NOT(?0.a), ?0.b)");
        this.checkCnf(this.and(aRef, this.or(bRef, this.and(cRef, dRef))), "AND(?0.a, OR(?0.b, ?0.c), OR(?0.b, ?0.d))");
        this.checkCnf(this.and(aRef, this.or(bRef, this.and(cRef, this.or(dRef, this.and(eRef, this.or(fRef, gRef)))))), "AND(?0.a, OR(?0.b, ?0.c), OR(?0.b, ?0.d, ?0.e), OR(?0.b, ?0.d, ?0.f, ?0.g))");
        this.checkCnf(this.and(aRef, this.or(bRef, this.and(cRef, this.or(dRef, this.and(eRef, this.or(fRef, this.and(gRef, this.or(new RexNode[]{this.trueLiteral, this.falseLiteral})))))))), "AND(?0.a, OR(?0.b, ?0.c), OR(?0.b, ?0.d, ?0.e), OR(?0.b, ?0.d, ?0.f, ?0.g))");
    }

    @Test
    public void testCnf2() {
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType rowType = this.typeFactory.builder().add("x", intType).add("y", intType).add("z", intType).add("a", intType).add("b", intType).build();
        RexDynamicParam range = this.rexBuilder.makeDynamicParam(rowType, 0);
        RexNode xRef = this.rexBuilder.makeFieldAccess((RexNode)range, 0);
        RexNode yRef = this.rexBuilder.makeFieldAccess((RexNode)range, 1);
        RexNode zRef = this.rexBuilder.makeFieldAccess((RexNode)range, 2);
        RexNode aRef = this.rexBuilder.makeFieldAccess((RexNode)range, 3);
        RexNode bRef = this.rexBuilder.makeFieldAccess((RexNode)range, 4);
        RexLiteral literal1 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(1L));
        RexLiteral literal2 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(2L));
        RexLiteral literal3 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(3L));
        this.checkCnf(this.or(this.and(this.eq(xRef, (RexNode)literal1), this.eq(yRef, (RexNode)literal1), this.eq(zRef, (RexNode)literal1)), this.and(this.eq(xRef, (RexNode)literal2), this.eq(yRef, (RexNode)literal2), this.eq(aRef, (RexNode)literal2)), this.and(this.eq(xRef, (RexNode)literal3), this.eq(aRef, (RexNode)literal3), this.eq(bRef, (RexNode)literal3))), "AND(OR(=(?0.x, 1), =(?0.x, 2), =(?0.x, 3)), OR(=(?0.x, 1), =(?0.x, 2), =(?0.a, 3)), OR(=(?0.x, 1), =(?0.x, 2), =(?0.b, 3)), OR(=(?0.x, 1), =(?0.y, 2), =(?0.x, 3)), OR(=(?0.x, 1), =(?0.y, 2), =(?0.a, 3)), OR(=(?0.x, 1), =(?0.y, 2), =(?0.b, 3)), OR(=(?0.x, 1), =(?0.a, 2), =(?0.x, 3)), OR(=(?0.x, 1), =(?0.a, 2), =(?0.a, 3)), OR(=(?0.x, 1), =(?0.a, 2), =(?0.b, 3)), OR(=(?0.y, 1), =(?0.x, 2), =(?0.x, 3)), OR(=(?0.y, 1), =(?0.x, 2), =(?0.a, 3)), OR(=(?0.y, 1), =(?0.x, 2), =(?0.b, 3)), OR(=(?0.y, 1), =(?0.y, 2), =(?0.x, 3)), OR(=(?0.y, 1), =(?0.y, 2), =(?0.a, 3)), OR(=(?0.y, 1), =(?0.y, 2), =(?0.b, 3)), OR(=(?0.y, 1), =(?0.a, 2), =(?0.x, 3)), OR(=(?0.y, 1), =(?0.a, 2), =(?0.a, 3)), OR(=(?0.y, 1), =(?0.a, 2), =(?0.b, 3)), OR(=(?0.z, 1), =(?0.x, 2), =(?0.x, 3)), OR(=(?0.z, 1), =(?0.x, 2), =(?0.a, 3)), OR(=(?0.z, 1), =(?0.x, 2), =(?0.b, 3)), OR(=(?0.z, 1), =(?0.y, 2), =(?0.x, 3)), OR(=(?0.z, 1), =(?0.y, 2), =(?0.a, 3)), OR(=(?0.z, 1), =(?0.y, 2), =(?0.b, 3)), OR(=(?0.z, 1), =(?0.a, 2), =(?0.x, 3)), OR(=(?0.z, 1), =(?0.a, 2), =(?0.a, 3)), OR(=(?0.z, 1), =(?0.a, 2), =(?0.b, 3)))");
    }

    @Test
    public void testThresholdCnf() {
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType rowType = this.typeFactory.builder().add("x", intType).add("y", intType).build();
        RexDynamicParam range = this.rexBuilder.makeDynamicParam(rowType, 0);
        RexNode xRef = this.rexBuilder.makeFieldAccess((RexNode)range, 0);
        RexNode yRef = this.rexBuilder.makeFieldAccess((RexNode)range, 1);
        RexLiteral literal1 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(1L));
        RexLiteral literal2 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(2L));
        RexLiteral literal3 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(3L));
        RexLiteral literal4 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(4L));
        this.checkThresholdCnf(this.or(this.eq(xRef, (RexNode)literal1), this.and(this.eq(xRef, (RexNode)literal2), this.eq(yRef, (RexNode)literal3))), 8, "AND(OR(=(?0.x, 1), =(?0.x, 2)), OR(=(?0.x, 1), =(?0.y, 3)))");
        this.checkThresholdCnf(this.or(this.eq(xRef, (RexNode)literal1), this.eq(xRef, (RexNode)literal2), this.and(this.eq(xRef, (RexNode)literal3), this.eq(yRef, (RexNode)literal4))), 8, "OR(=(?0.x, 1), =(?0.x, 2), AND(=(?0.x, 3), =(?0.y, 4)))");
    }

    @Test
    public void testCnfExponential() {
        int limit = (Boolean)CalciteSystemProperty.TEST_SLOW.value() != false ? 16 : 6;
        for (int i = 2; i < limit; ++i) {
            this.checkExponentialCnf(i);
        }
    }

    private void checkExponentialCnf(int n) {
        RelDataType booleanType = this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        RelDataTypeFactory.FieldInfoBuilder builder = this.typeFactory.builder();
        for (int i = 0; i < n; ++i) {
            builder.add("x" + i, booleanType).add("y" + i, booleanType);
        }
        RelDataType rowType3 = builder.build();
        RexDynamicParam range3 = this.rexBuilder.makeDynamicParam(rowType3, 0);
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        for (int i = 0; i < n; ++i) {
            list.add(this.and(this.rexBuilder.makeFieldAccess((RexNode)range3, i * 2), this.rexBuilder.makeFieldAccess((RexNode)range3, i * 2 + 1)));
        }
        RexNode cnf = RexUtil.toCnf((RexBuilder)this.rexBuilder, (RexNode)this.or(list));
        int nodeCount = RexProgramTest.nodeCount(cnf);
        Assert.assertThat((Object)((n + 1) * (int)Math.pow(2.0, n) + 1), (Matcher)CoreMatchers.equalTo((Object)nodeCount));
        if (n == 3) {
            Assert.assertThat((Object)cnf.toString(), (Matcher)CoreMatchers.equalTo((Object)"AND(OR(?0.x0, ?0.x1, ?0.x2), OR(?0.x0, ?0.x1, ?0.y2), OR(?0.x0, ?0.y1, ?0.x2), OR(?0.x0, ?0.y1, ?0.y2), OR(?0.y0, ?0.x1, ?0.x2), OR(?0.y0, ?0.x1, ?0.y2), OR(?0.y0, ?0.y1, ?0.x2), OR(?0.y0, ?0.y1, ?0.y2))"));
        }
    }

    @Test
    public void testPullFactors() {
        RelDataType booleanType = this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType rowType = this.typeFactory.builder().add("a", booleanType).add("b", booleanType).add("c", booleanType).add("d", booleanType).add("e", booleanType).add("f", booleanType).add("g", booleanType).add("h", intType).build();
        RexDynamicParam range = this.rexBuilder.makeDynamicParam(rowType, 0);
        RexNode aRef = this.rexBuilder.makeFieldAccess((RexNode)range, 0);
        RexNode bRef = this.rexBuilder.makeFieldAccess((RexNode)range, 1);
        RexNode cRef = this.rexBuilder.makeFieldAccess((RexNode)range, 2);
        RexNode dRef = this.rexBuilder.makeFieldAccess((RexNode)range, 3);
        RexNode eRef = this.rexBuilder.makeFieldAccess((RexNode)range, 4);
        RexNode fRef = this.rexBuilder.makeFieldAccess((RexNode)range, 5);
        RexNode gRef = this.rexBuilder.makeFieldAccess((RexNode)range, 6);
        RexNode hRef = this.rexBuilder.makeFieldAccess((RexNode)range, 7);
        RexLiteral sevenLiteral = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(7L));
        RexNode hEqSeven = this.eq(hRef, (RexNode)sevenLiteral);
        this.checkPullFactors(this.or(this.and(aRef, bRef), this.and(cRef, aRef, dRef, aRef)), "AND(?0.a, OR(?0.b, AND(?0.c, ?0.d)))");
        this.checkPullFactors(aRef, "?0.a");
        this.checkPullFactors((RexNode)this.trueLiteral, "true");
        this.checkPullFactors((RexNode)this.falseLiteral, "false");
        this.checkPullFactors((RexNode)this.nullBool, "null:BOOLEAN");
        this.checkPullFactors(this.and(aRef, bRef), "AND(?0.a, ?0.b)");
        this.checkPullFactors(this.and(aRef, bRef, cRef), "AND(?0.a, ?0.b, ?0.c)");
        this.checkPullFactorsUnchanged(this.and(this.or(aRef, bRef), this.or(cRef, dRef)));
        this.checkPullFactorsUnchanged(this.or(this.and(aRef, bRef), this.and(cRef, dRef)));
        this.checkPullFactors(this.or(this.and(aRef, bRef), this.or(cRef, dRef)), "OR(AND(?0.a, ?0.b), ?0.c, ?0.d)");
        this.checkPullFactorsUnchanged(this.or(aRef, this.not(this.and(bRef, this.not(hEqSeven)))));
        this.checkPullFactorsUnchanged(this.not(this.or(aRef, this.not(bRef))));
        this.checkPullFactorsUnchanged(this.not(this.or(new RexNode[]{this.and(new RexNode[]{aRef, this.trueLiteral}), this.not(bRef), this.falseLiteral})));
        this.checkPullFactorsUnchanged(this.and(aRef, this.or(bRef, this.and(cRef, dRef))));
        this.checkPullFactorsUnchanged(this.and(aRef, this.or(bRef, this.and(cRef, this.or(dRef, this.and(eRef, this.or(fRef, gRef)))))));
        this.checkPullFactorsUnchanged(this.and(aRef, this.or(bRef, this.and(cRef, this.or(dRef, this.and(eRef, this.or(fRef, this.and(gRef, this.or(new RexNode[]{this.trueLiteral, this.falseLiteral})))))))));
    }

    @Test
    public void testSimplify() {
        RelDataType booleanType = this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType intNullableType = this.typeFactory.createTypeWithNullability(intType, true);
        RelDataType rowType = this.typeFactory.builder().add("a", booleanType).add("b", booleanType).add("c", booleanType).add("d", booleanType).add("e", booleanType).add("f", booleanType).add("g", booleanType).add("h", intType).add("i", intNullableType).add("j", intType).add("k", intType).build();
        RexDynamicParam range = this.rexBuilder.makeDynamicParam(rowType, 0);
        RexNode aRef = this.rexBuilder.makeFieldAccess((RexNode)range, 0);
        RexNode bRef = this.rexBuilder.makeFieldAccess((RexNode)range, 1);
        RexNode cRef = this.rexBuilder.makeFieldAccess((RexNode)range, 2);
        RexNode dRef = this.rexBuilder.makeFieldAccess((RexNode)range, 3);
        RexNode eRef = this.rexBuilder.makeFieldAccess((RexNode)range, 4);
        RexNode hRef = this.rexBuilder.makeFieldAccess((RexNode)range, 7);
        RexNode iRef = this.rexBuilder.makeFieldAccess((RexNode)range, 8);
        RexNode jRef = this.rexBuilder.makeFieldAccess((RexNode)range, 9);
        RexNode kRef = this.rexBuilder.makeFieldAccess((RexNode)range, 10);
        RexLiteral literal1 = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        this.checkSimplify(this.and(aRef, bRef, aRef), "AND(?0.a, ?0.b)");
        this.checkSimplify(this.and(new RexNode[]{aRef, bRef, this.trueLiteral}), "AND(?0.a, ?0.b)");
        this.checkSimplify(this.and(new RexNode[]{aRef, bRef, this.falseLiteral}), "false");
        this.checkSimplify(this.and(this.not(aRef), bRef, this.not(cRef), this.not(aRef)), "AND(?0.b, NOT(?0.a), NOT(?0.c))");
        this.checkSimplify(this.and(this.not(aRef), bRef, this.not((RexNode)this.trueLiteral)), "false");
        this.checkSimplify(this.and(aRef, this.and(this.and(bRef, this.not(cRef), dRef, this.not(eRef)), this.not(eRef))), "AND(?0.a, ?0.b, ?0.d, NOT(?0.c), NOT(?0.e))");
        this.checkSimplify(this.and(aRef, bRef, this.not(this.or(cRef, this.or(dRef, eRef)))), "AND(?0.a, ?0.b, NOT(?0.c), NOT(?0.d), NOT(?0.e))");
        this.checkSimplify(this.and(aRef, bRef, this.not(this.or(this.not(cRef), dRef, this.not(eRef)))), "AND(?0.a, ?0.b, ?0.c, ?0.e, NOT(?0.d))");
        this.checkSimplify(this.or(aRef, bRef, aRef), "OR(?0.a, ?0.b)");
        this.checkSimplify(this.or(new RexNode[]{aRef, bRef, this.falseLiteral}), "OR(?0.a, ?0.b)");
        this.checkSimplify(this.or(new RexNode[]{aRef, bRef, this.trueLiteral}), "true");
        this.checkSimplify(this.case_(new RexNode[]{this.eq(bRef, cRef), dRef, this.falseLiteral, aRef, eRef}), "OR(AND(=(?0.b, ?0.c), ?0.d), AND(?0.e, <>(?0.b, ?0.c)))");
        this.checkSimplify(this.case_(new RexNode[]{this.eq(bRef, cRef), dRef, this.trueLiteral, aRef, this.eq(cRef, dRef), eRef, cRef}), "OR(AND(=(?0.b, ?0.c), ?0.d), AND(?0.a, <>(?0.b, ?0.c)))");
        this.checkSimplify(this.case_(new RexNode[]{this.trueLiteral, aRef, this.eq(cRef, dRef), eRef, cRef}), "?0.a");
        this.checkSimplify(this.case_(new RexNode[]{aRef, literal1, bRef, literal1, cRef, literal1, dRef, literal1, literal1}), "1");
        this.checkSimplify3(this.case_(new RexNode[]{aRef, this.trueLiteral, bRef, this.trueLiteral, cRef, this.falseLiteral, this.nullBool}), "OR(?0.a, ?0.b, AND(null, NOT(?0.a), NOT(?0.b), NOT(?0.c)))", "OR(?0.a, ?0.b)", "OR(?0.a, ?0.b, NOT(?0.c))");
        this.checkSimplify(this.case_(new RexNode[]{aRef, this.trueLiteral, bRef, this.falseLiteral, cRef, this.falseLiteral, dRef, this.trueLiteral, this.falseLiteral}), "OR(?0.a, AND(?0.d, NOT(?0.b), NOT(?0.c)))");
        this.checkSimplify(this.case_(new RexNode[]{aRef, this.trueLiteral, bRef, this.falseLiteral, cRef, this.falseLiteral, dRef, this.trueLiteral, eRef, this.falseLiteral, this.trueLiteral}), "OR(?0.a, AND(?0.d, NOT(?0.b), NOT(?0.c)), AND(NOT(?0.b), NOT(?0.c), NOT(?0.e)))");
        this.checkSimplify(this.case_(new RexNode[]{this.eq((RexNode)this.falseLiteral, (RexNode)this.falseLiteral), this.falseLiteral, this.eq((RexNode)this.falseLiteral, (RexNode)this.falseLiteral), this.trueLiteral, this.trueLiteral}), "false");
        this.checkSimplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{aRef}), "false");
        this.checkSimplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{aRef}), "true");
        this.checkSimplify2(this.and(this.le(hRef, (RexNode)literal1), this.gt(hRef, (RexNode)literal1)), "AND(<=(?0.h, 1), >(?0.h, 1))", "false");
        this.checkSimplify2(this.and(this.le(hRef, (RexNode)literal1), this.ge(hRef, (RexNode)literal1)), "AND(<=(?0.h, 1), >=(?0.h, 1))", "=(?0.h, 1)");
        this.checkSimplify2(this.and(this.lt(hRef, (RexNode)literal1), this.eq(hRef, (RexNode)literal1), this.ge(hRef, (RexNode)literal1)), "AND(<(?0.h, 1), =(?0.h, 1), >=(?0.h, 1))", "false");
        this.checkSimplify(this.and(this.lt(hRef, (RexNode)literal1), this.or(new RexNode[]{this.falseLiteral, this.falseLiteral})), "false");
        this.checkSimplify(this.and(this.lt(hRef, (RexNode)literal1), this.or(new RexNode[]{this.falseLiteral, this.gt(jRef, kRef)})), "AND(<(?0.h, 1), >(?0.j, ?0.k))");
        this.checkSimplify(this.or(this.lt(hRef, (RexNode)literal1), this.and(new RexNode[]{this.trueLiteral, this.trueLiteral})), "true");
        this.checkSimplify(this.or(this.lt(hRef, (RexNode)literal1), this.and(new RexNode[]{this.trueLiteral, this.or(new RexNode[]{this.trueLiteral, this.falseLiteral})})), "true");
        this.checkSimplify(this.or(this.lt(hRef, (RexNode)literal1), this.and(new RexNode[]{this.trueLiteral, this.and(new RexNode[]{this.trueLiteral, this.falseLiteral})})), "<(?0.h, 1)");
        this.checkSimplify(this.or(this.lt(hRef, (RexNode)literal1), this.and(new RexNode[]{this.trueLiteral, this.or(new RexNode[]{this.falseLiteral, this.falseLiteral})})), "<(?0.h, 1)");
        this.checkSimplify(this.eq((RexNode)literal1, (RexNode)literal1), "true");
        this.checkSimplify(this.eq(hRef, hRef), "true");
        this.checkSimplify3(this.eq(iRef, iRef), "OR(null, IS NOT NULL(?0.i))", "IS NOT NULL(?0.i)", "true");
        this.checkSimplifyUnchanged(this.eq(iRef, hRef));
        this.checkSimplify(this.le((RexNode)literal1, (RexNode)literal1), "true");
        this.checkSimplify(this.le(hRef, hRef), "true");
        this.checkSimplify3(this.le(iRef, iRef), "OR(null, IS NOT NULL(?0.i))", "IS NOT NULL(?0.i)", "true");
        this.checkSimplifyUnchanged(this.le(iRef, hRef));
        this.checkSimplify(this.ge((RexNode)literal1, (RexNode)literal1), "true");
        this.checkSimplify(this.ge(hRef, hRef), "true");
        this.checkSimplify3(this.ge(iRef, iRef), "OR(null, IS NOT NULL(?0.i))", "IS NOT NULL(?0.i)", "true");
        this.checkSimplifyUnchanged(this.ge(iRef, hRef));
        this.checkSimplify(this.ne((RexNode)literal1, (RexNode)literal1), "false");
        this.checkSimplify(this.ne(hRef, hRef), "false");
        this.checkSimplify3(this.ne(iRef, iRef), "AND(null, IS NULL(?0.i))", "false", "IS NULL(?0.i)");
        this.checkSimplifyUnchanged(this.ne(iRef, hRef));
        this.checkSimplify(this.lt((RexNode)literal1, (RexNode)literal1), "false");
        this.checkSimplify(this.lt(hRef, hRef), "false");
        this.checkSimplify3(this.lt(iRef, iRef), "AND(null, IS NULL(?0.i))", "false", "IS NULL(?0.i)");
        this.checkSimplifyUnchanged(this.lt(iRef, hRef));
        this.checkSimplify(this.gt((RexNode)literal1, (RexNode)literal1), "false");
        this.checkSimplify(this.gt(hRef, hRef), "false");
        this.checkSimplify3(this.gt(iRef, iRef), "AND(null, IS NULL(?0.i))", "false", "IS NULL(?0.i)");
        this.checkSimplifyUnchanged(this.gt(iRef, hRef));
        this.checkSimplify(this.isNull(this.not(this.vBool())), "IS NULL(?0.bool0)");
        this.checkSimplify(this.isNull(this.not(this.vBoolNotNull())), "false");
        this.checkSimplify(this.isNotNull(this.not(this.vBool())), "IS NOT NULL(?0.bool0)");
        this.checkSimplify(this.isNotNull(this.not(this.vBoolNotNull())), "true");
        this.checkSimplify(this.isNull((RexNode)this.nullBool), "true");
        this.checkSimplify(this.isNull(this.plus(this.vInt(0), this.vInt(1))), "OR(IS NULL(?0.int0), IS NULL(?0.int1))");
        this.checkSimplify(this.isNull(this.plus(this.vInt(0), this.vIntNotNull(1))), "IS NULL(?0.int0)");
        this.checkSimplify(this.isNull(this.plus(this.vIntNotNull(0), this.vIntNotNull(1))), "false");
        this.checkSimplify(this.isNull(this.plus(this.vIntNotNull(0), this.vInt(1))), "IS NULL(?0.int1)");
        this.checkSimplify(this.isNotNull(this.plus(this.vInt(0), this.vInt(1))), "AND(IS NOT NULL(?0.int0), IS NOT NULL(?0.int1))");
        this.checkSimplify(this.isNotNull(this.plus(this.vInt(0), this.vIntNotNull(1))), "IS NOT NULL(?0.int0)");
        this.checkSimplify(this.isNotNull(this.plus(this.vIntNotNull(0), this.vIntNotNull(1))), "true");
        this.checkSimplify(this.isNotNull(this.plus(this.vIntNotNull(0), this.vInt(1))), "IS NOT NULL(?0.int1)");
    }

    @Test
    public void simplifyStrong() {
        this.checkSimplify(this.ge((RexNode)this.trueLiteral, (RexNode)this.falseLiteral), "true");
        this.checkSimplify3(this.ge((RexNode)this.trueLiteral, (RexNode)this.nullBool), "null:BOOLEAN", "false", "true");
        this.checkSimplify3(this.ge((RexNode)this.nullBool, (RexNode)this.nullBool), "null:BOOLEAN", "false", "true");
        this.checkSimplify3(this.gt((RexNode)this.trueLiteral, (RexNode)this.nullBool), "null:BOOLEAN", "false", "true");
        this.checkSimplify3(this.le((RexNode)this.trueLiteral, (RexNode)this.nullBool), "null:BOOLEAN", "false", "true");
        this.checkSimplify3(this.lt((RexNode)this.trueLiteral, (RexNode)this.nullBool), "null:BOOLEAN", "false", "true");
        this.checkSimplify3(this.not((RexNode)this.nullBool), "null:BOOLEAN", "false", "true");
        this.checkSimplify3(this.ne(this.vInt(), (RexNode)this.nullBool), "null:BOOLEAN", "false", "true");
        this.checkSimplify3(this.eq(this.vInt(), (RexNode)this.nullBool), "null:BOOLEAN", "false", "true");
        this.checkSimplify(this.plus(this.vInt(), (RexNode)this.nullInt), "null:INTEGER");
        this.checkSimplify(this.sub(this.vInt(), (RexNode)this.nullInt), "null:INTEGER");
        this.checkSimplify(this.mul(this.vInt(), (RexNode)this.nullInt), "null:INTEGER");
        this.checkSimplify(this.div(this.vInt(), (RexNode)this.nullInt), "null:INTEGER");
    }

    @Test
    public void testSimplifyFilter() {
        RelDataType booleanType = this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType rowType = this.typeFactory.builder().add("a", intType).add("b", intType).add("c", booleanType).add("d", booleanType).add("e", booleanType).add("f", booleanType).add("g", booleanType).add("h", intType).build();
        RexDynamicParam range = this.rexBuilder.makeDynamicParam(rowType, 0);
        RexNode aRef = this.rexBuilder.makeFieldAccess((RexNode)range, 0);
        RexNode bRef = this.rexBuilder.makeFieldAccess((RexNode)range, 1);
        RexNode cRef = this.rexBuilder.makeFieldAccess((RexNode)range, 2);
        RexNode dRef = this.rexBuilder.makeFieldAccess((RexNode)range, 3);
        RexNode eRef = this.rexBuilder.makeFieldAccess((RexNode)range, 4);
        RexNode fRef = this.rexBuilder.makeFieldAccess((RexNode)range, 5);
        RexLiteral literal1 = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        RexLiteral literal5 = this.rexBuilder.makeExactLiteral(new BigDecimal(5));
        RexLiteral literal10 = this.rexBuilder.makeExactLiteral(BigDecimal.TEN);
        this.checkSimplifyFilter(this.and(this.le(aRef, (RexNode)literal1), this.gt(aRef, (RexNode)literal1)), "false");
        this.checkSimplifyFilter(this.and(this.le(aRef, (RexNode)literal1), this.ge(aRef, (RexNode)literal1)), "=(?0.a, 1)");
        this.checkSimplifyFilter(this.and(this.lt(aRef, (RexNode)literal1), this.eq(aRef, (RexNode)literal1), this.ge(aRef, (RexNode)literal1)), "false");
        ImmutableList args = ImmutableList.of((Object)this.eq(this.eq(aRef, (RexNode)literal1), (RexNode)this.trueLiteral), (Object)this.eq(bRef, (RexNode)literal1));
        this.checkSimplifyFilter(this.and((Iterable<? extends RexNode>)args), "AND(=(?0.a, 1), =(?0.b, 1))");
        Assert.assertThat((Object)this.simplify.simplifyFilterPredicates((Iterable)args).toString(), (Matcher)CoreMatchers.equalTo((Object)"AND(=(?0.a, 1), =(?0.b, 1))"));
        ImmutableList args2 = ImmutableList.of((Object)this.eq(aRef, (RexNode)literal1), (Object)this.eq(aRef, (RexNode)literal10));
        this.checkSimplifyFilter(this.and((Iterable<? extends RexNode>)args2), "false");
        Assert.assertThat((Object)this.simplify.simplifyFilterPredicates((Iterable)args2), (Matcher)CoreMatchers.nullValue());
        this.checkSimplifyFilter(this.and(this.eq(aRef, (RexNode)literal1), this.eq(bRef, (RexNode)literal1), this.eq(aRef, bRef)), "AND(=(?0.a, 1), =(?0.b, 1))");
        this.checkSimplifyFilter(this.and(this.eq(aRef, (RexNode)literal1), this.eq(bRef, (RexNode)literal10), this.eq(aRef, bRef)), "false");
        this.checkSimplifyFilter(this.and(this.gt(aRef, (RexNode)literal10), this.ge(bRef, (RexNode)literal1), this.lt(aRef, (RexNode)literal10)), "false");
        this.checkSimplifyFilter(this.or(this.gt(aRef, (RexNode)literal10), this.gt(bRef, (RexNode)literal1), this.gt(aRef, (RexNode)literal10)), "OR(>(?0.a, 10), >(?0.b, 1))");
        this.checkSimplifyFilter(this.case_(new RexNode[]{cRef, this.trueLiteral, dRef, this.trueLiteral, eRef, this.falseLiteral, fRef, this.falseLiteral, this.nullBool}), "OR(?0.c, ?0.d)");
        this.checkSimplifyFilter(this.and(this.gt(aRef, (RexNode)this.nullBool), this.ge(bRef, (RexNode)literal1)), "false");
        this.checkSimplifyFilter(this.and(this.lt((RexNode)literal1, aRef), this.lt((RexNode)literal5, aRef)), RelOptPredicateList.EMPTY, "<(5, ?0.a)");
        this.checkSimplifyFilter(this.and(this.lt((RexNode)literal1, aRef), this.lt(aRef, (RexNode)literal5)), RelOptPredicateList.EMPTY, "AND(<(1, ?0.a), <(?0.a, 5))");
        this.checkSimplifyFilter(this.and(this.gt((RexNode)literal1, aRef), this.gt((RexNode)literal5, aRef)), RelOptPredicateList.EMPTY, ">(1, ?0.a)");
        this.checkSimplifyFilter(this.and(this.gt((RexNode)literal1, aRef), this.gt(aRef, (RexNode)literal5)), RelOptPredicateList.EMPTY, "false");
        this.checkSimplifyFilter(this.and(this.gt(aRef, (RexNode)literal1), this.lt(aRef, (RexNode)literal10), this.lt(aRef, (RexNode)literal5)), RelOptPredicateList.EMPTY, "AND(>(?0.a, 1), <(?0.a, 5))");
        this.checkSimplifyFilter(this.and(this.gt(aRef, (RexNode)literal1), this.lt(aRef, (RexNode)literal10), this.lt(aRef, (RexNode)literal5)), RelOptPredicateList.of((RexBuilder)this.rexBuilder, (Iterable)ImmutableList.of((Object)this.gt(aRef, (RexNode)literal5))), "false");
        this.checkSimplifyFilter(this.and(this.gt(aRef, (RexNode)literal1), this.lt(aRef, (RexNode)literal10), this.le(aRef, (RexNode)literal5)), RelOptPredicateList.of((RexBuilder)this.rexBuilder, (Iterable)ImmutableList.of((Object)this.ge(aRef, (RexNode)literal5))), "=(?0.a, 5)");
        this.checkSimplifyFilter(this.and(this.gt(aRef, (RexNode)literal1), this.lt(aRef, (RexNode)literal10), this.lt(aRef, (RexNode)literal5)), RelOptPredicateList.of((RexBuilder)this.rexBuilder, (Iterable)ImmutableList.of((Object)this.lt(bRef, (RexNode)literal10), (Object)this.ge(aRef, (RexNode)literal1))), "AND(>(?0.a, 1), <(?0.a, 5))");
        this.checkSimplifyFilter(this.gt(aRef, (RexNode)literal1), RelOptPredicateList.of((RexBuilder)this.rexBuilder, (Iterable)ImmutableList.of((Object)this.lt(bRef, (RexNode)literal10), (Object)this.gt(aRef, (RexNode)literal5))), "true");
        this.checkSimplifyFilter(this.lt(aRef, (RexNode)literal1), RelOptPredicateList.of((RexBuilder)this.rexBuilder, (Iterable)ImmutableList.of((Object)this.lt(bRef, (RexNode)literal10), (Object)this.gt(aRef, (RexNode)literal5))), "false");
        this.checkSimplifyFilter(this.gt(aRef, (RexNode)literal5), RelOptPredicateList.of((RexBuilder)this.rexBuilder, (Iterable)ImmutableList.of((Object)this.lt(bRef, (RexNode)literal10), (Object)this.ge(aRef, (RexNode)literal5))), ">(?0.a, 5)");
        this.checkSimplifyFilter(this.gt(aRef, (RexNode)literal5), RelOptPredicateList.of((RexBuilder)this.rexBuilder, (Iterable)ImmutableList.of((Object)this.le(aRef, (RexNode)literal5))), "false");
        this.checkSimplifyFilter(this.gt(aRef, (RexNode)literal5), RelOptPredicateList.of((RexBuilder)this.rexBuilder, (Iterable)ImmutableList.of((Object)this.le(aRef, (RexNode)literal5), (Object)this.le(bRef, (RexNode)literal5))), "false");
        this.checkSimplifyFilter(this.or(this.gt(aRef, (RexNode)literal5), this.gt(bRef, (RexNode)literal5)), RelOptPredicateList.of((RexBuilder)this.rexBuilder, (Iterable)ImmutableList.of((Object)this.le(aRef, (RexNode)literal5), (Object)this.le(bRef, (RexNode)literal5))), "false");
    }

    @Test
    public void testSimplifyAndPush() {
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType rowType = this.typeFactory.builder().add("a", intType).add("b", intType).build();
        RexDynamicParam range = this.rexBuilder.makeDynamicParam(rowType, 0);
        RexNode aRef = this.rexBuilder.makeFieldAccess((RexNode)range, 0);
        RexNode bRef = this.rexBuilder.makeFieldAccess((RexNode)range, 1);
        RexLiteral literal1 = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        RexLiteral literal5 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(5L));
        RexLiteral literal10 = this.rexBuilder.makeExactLiteral(BigDecimal.TEN);
        this.checkSimplifyFilter(this.or(this.or(this.eq(aRef, (RexNode)literal1), this.eq(aRef, (RexNode)literal1)), this.eq(aRef, (RexNode)literal1)), "=(?0.a, 1)");
        this.checkSimplifyFilter(this.or(this.and(this.eq(aRef, (RexNode)literal1), this.eq(aRef, (RexNode)literal1)), this.and(this.eq(aRef, (RexNode)literal10), this.eq(aRef, (RexNode)literal1))), "=(?0.a, 1)");
        this.checkSimplifyFilter(this.and(this.eq(aRef, (RexNode)literal1), this.or(this.eq(aRef, (RexNode)literal1), this.eq(aRef, (RexNode)literal10))), "=(?0.a, 1)");
        this.checkSimplifyFilter(this.and(this.or(this.eq(aRef, (RexNode)literal1), this.eq(aRef, (RexNode)literal10)), this.eq(aRef, (RexNode)literal1)), "=(?0.a, 1)");
        this.checkSimplifyFilter(this.and(this.gt(aRef, (RexNode)literal10), this.gt(aRef, (RexNode)literal1)), ">(?0.a, 10)");
        this.checkSimplifyFilter(this.and(this.gt(aRef, (RexNode)literal1), this.gt(aRef, (RexNode)literal10)), ">(?0.a, 10)");
        this.checkSimplify3(this.and(new RexNode[]{this.nullBool, this.not(this.or(new RexNode[]{this.nullBool, this.vBool()}))}), "AND(null, NOT(?0.bool0))", "false", "NOT(?0.bool0)");
        this.checkSimplify2(this.and(this.vBool(1), this.vBool(2), this.vBool(3), this.not(this.vBool(1)), this.not(this.vBool(2)), this.not(this.vBool())), "AND(?0.bool3, null, IS NULL(?0.bool1), IS NULL(?0.bool2), NOT(?0.bool0))", "false");
    }

    @Test
    public void testSimplifyOrTerms() {
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType rowType = this.typeFactory.builder().add("a", intType).nullable(false).add("b", intType).nullable(true).add("c", intType).nullable(true).build();
        RexDynamicParam range = this.rexBuilder.makeDynamicParam(rowType, 0);
        RexNode aRef = this.rexBuilder.makeFieldAccess((RexNode)range, 0);
        RexNode bRef = this.rexBuilder.makeFieldAccess((RexNode)range, 1);
        RexNode cRef = this.rexBuilder.makeFieldAccess((RexNode)range, 2);
        RexLiteral literal1 = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        RexLiteral literal2 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(2L));
        RexLiteral literal3 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(3L));
        RexLiteral literal4 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(4L));
        this.checkSimplifyFilter(this.or(this.ne(aRef, (RexNode)literal1), this.eq(aRef, (RexNode)literal1)), "true");
        this.checkSimplifyFilter(this.or(this.eq(aRef, (RexNode)literal1), this.ne(aRef, (RexNode)literal1)), "OR(=(?0.a, 1), <>(?0.a, 1))");
        RexNode neOrEq = this.or(this.ne(bRef, (RexNode)literal1), this.eq(bRef, (RexNode)literal1));
        this.checkSimplifyFilter(neOrEq, "OR(<>(?0.b, 1), =(?0.b, 1))");
        RexNode simplified = this.simplify.simplifyUnknownAs(neOrEq, RexUnknownAs.UNKNOWN);
        Assert.assertThat((Object)simplified.toString(), (Matcher)CoreMatchers.equalTo((Object)"OR(<>(?0.b, 1), =(?0.b, 1))"));
        this.checkSimplifyFilter(this.or(this.isNull(aRef), this.isNotNull(aRef)), "true");
        this.checkSimplifyFilter(this.or(this.isNotNull(aRef), this.isNull(aRef)), "true");
        this.checkSimplifyFilter(this.or(this.isNotNull(bRef), this.isNull(bRef)), "true");
        this.checkSimplifyFilter(this.or(this.isNotNull(bRef), this.isNull(cRef)), "OR(IS NOT NULL(?0.b), IS NULL(?0.c))");
        this.checkSimplifyFilter(this.or(this.isNull(bRef), this.isNotFalse(bRef)), "OR(IS NULL(?0.b), IS NOT FALSE(?0.b))");
        this.checkSimplifyFilter(this.and(this.or(this.eq(bRef, (RexNode)literal1), this.eq(bRef, (RexNode)literal2)), this.eq(bRef, (RexNode)literal2), this.eq(aRef, (RexNode)literal3), this.or(this.eq(aRef, (RexNode)literal3), this.eq(aRef, (RexNode)literal4))), "AND(=(?0.b, 2), =(?0.a, 3))");
        this.checkSimplify3(this.or(this.lt(this.vInt(), (RexNode)this.nullInt), this.ne(this.literal(0), this.vInt())), "OR(null, <>(0, ?0.int0))", "<>(0, ?0.int0)", "true");
    }

    @Test
    public void testSimplifyNotAnd() {
        RexNode e = this.or(this.le(this.vBool(1), this.literal(true)), this.eq(this.literal(false), this.eq(this.literal(false), this.vBool(1))));
        this.checkSimplify(e, "OR(<=(?0.bool1, true), ?0.bool1)");
    }

    @Test
    public void testSimplifyUnknown() {
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType rowType = this.typeFactory.builder().add("a", intType).nullable(true).build();
        RexDynamicParam range = this.rexBuilder.makeDynamicParam(rowType, 0);
        RexNode aRef = this.rexBuilder.makeFieldAccess((RexNode)range, 0);
        RexLiteral literal1 = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        this.checkSimplify2(this.and(new RexNode[]{this.eq(aRef, (RexNode)literal1), this.nullInt}), "AND(=(?0.a, 1), null:INTEGER)", "false");
        this.checkSimplify3(this.and(new RexNode[]{this.trueLiteral, this.nullBool}), "null:BOOLEAN", "false", "true");
        this.checkSimplify(this.and(new RexNode[]{this.falseLiteral, this.nullBool}), "false");
        this.checkSimplify3(this.and(new RexNode[]{this.nullBool, this.eq(aRef, (RexNode)literal1)}), "AND(null, =(?0.a, 1))", "false", "=(?0.a, 1)");
        this.checkSimplify3(this.or(new RexNode[]{this.eq(aRef, (RexNode)literal1), this.nullBool}), "OR(=(?0.a, 1), null)", "=(?0.a, 1)", "true");
        this.checkSimplify(this.or(new RexNode[]{this.trueLiteral, this.nullBool}), "true");
        this.checkSimplify3(this.or(new RexNode[]{this.falseLiteral, this.nullBool}), "null:BOOLEAN", "false", "true");
    }

    @Test
    public void testSimplifyAnd3() {
        this.checkSimplify2(this.and(this.vBool(), this.not(this.vBool())), "AND(null, IS NULL(?0.bool0))", "false");
    }

    @Test
    public void testNestedAndSimplification() {
        this.checkSimplify2(this.and(this.eq(this.vInt(2), this.literal(2)), this.or(this.eq(this.vInt(3), this.literal(3)), this.and(this.ge(this.vInt(), this.literal(1)), this.le(this.vInt(), this.literal(1))))), "AND(=(?0.int2, 2), OR(=(?0.int3, 3), AND(>=(?0.int0, 1), <=(?0.int0, 1))))", "AND(=(?0.int2, 2), OR(=(?0.int3, 3), =(?0.int0, 1)))");
    }

    @Test
    public void fieldAccessEqualsHashCode() {
        Assert.assertEquals((String)"vBool() instances should be equal", (Object)this.vBool(), (Object)this.vBool());
        Assert.assertEquals((String)"vBool().hashCode()", (long)this.vBool().hashCode(), (long)this.vBool().hashCode());
        Assert.assertNotSame((String)"vBool() is expected to produce new RexFieldAccess", (Object)this.vBool(), (Object)this.vBool());
        Assert.assertNotEquals((String)"vBool(0) != vBool(1)", (Object)this.vBool(0), (Object)this.vBool(1));
    }

    @Test
    public void testSimplifyDynamicParam() {
        this.checkSimplify(this.or(this.vBool(), this.vBool()), "?0.bool0");
    }

    @Test
    public void testSimplifyCaseNotNullableBoolean() {
        RexNode condition = this.eq(this.vVarchar(), this.literal("S"));
        RexCall caseNode = (RexCall)this.case_(new RexNode[]{condition, this.trueLiteral, this.falseLiteral});
        RexCall result = (RexCall)this.simplify.simplifyUnknownAs((RexNode)caseNode, RexUnknownAs.UNKNOWN);
        Assert.assertThat((String)"The case should be nonNullable", (Object)caseNode.getType().isNullable(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((String)"Expected a nonNullable type", (Object)result.getType().isNullable(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)result.getType().getSqlTypeName(), (Matcher)CoreMatchers.is((Object)SqlTypeName.BOOLEAN));
        Assert.assertThat((Object)result.getOperator(), (Matcher)CoreMatchers.is((Object)SqlStdOperatorTable.IS_TRUE));
        Assert.assertThat(result.getOperands().get(0), (Matcher)CoreMatchers.is((Object)condition));
    }

    @Test
    public void testSimplifyCaseNullableBoolean() {
        RexNode condition = this.eq(this.input(this.tVarchar(), 0), this.literal("S"));
        RexNode caseNode = this.case_(new RexNode[]{condition, this.trueLiteral, this.falseLiteral});
        RexCall result = (RexCall)this.simplify.simplifyUnknownAs(caseNode, RexUnknownAs.UNKNOWN);
        Assert.assertThat((Object)result.getType().isNullable(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)result.getType().getSqlTypeName(), (Matcher)CoreMatchers.is((Object)SqlTypeName.BOOLEAN));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)condition));
    }

    @Test
    public void testSimplifyRecurseIntoArithmetics() {
        this.checkSimplify(this.plus(this.literal(1), this.case_(new RexNode[]{this.falseLiteral, this.literal(1), this.trueLiteral, this.literal(2), this.literal(3)})), "+(1, 2)");
    }

    @Test
    public void testSimplifyCaseBranchesCollapse() {
        this.checkSimplify(this.case_(this.isTrue(this.vBool()), this.literal(1), this.isNotTrue(this.vBool()), this.literal(1), this.literal(2)), "CASE(OR(?0.bool0, IS NOT TRUE(?0.bool0)), 1, 2)");
    }

    @Test
    public void testSimplifyCaseBranchesCollapse2() {
        this.checkSimplify(this.case_(new RexNode[]{this.isTrue(this.vBool()), this.literal(1), this.trueLiteral, this.literal(1), this.literal(2)}), "1");
    }

    @Test
    public void testSimplifyCaseNullableVarChar() {
        RexNode condition = this.eq(this.input(this.tVarchar(), 0), this.literal("S"));
        RexNode caseNode = this.case_(condition, this.literal("A"), this.literal("B"));
        RexCall result = (RexCall)this.simplify.simplifyUnknownAs(caseNode, RexUnknownAs.UNKNOWN);
        Assert.assertThat((Object)result.getType().isNullable(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)result.getType().getSqlTypeName(), (Matcher)CoreMatchers.is((Object)SqlTypeName.CHAR));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)caseNode));
    }

    @Test
    public void testSimplifyCaseCasting() {
        RexNode caseNode = this.case_(new RexNode[]{this.eq(this.vIntNotNull(), this.literal(3)), this.nullBool, this.falseLiteral});
        this.checkSimplify3(caseNode, "AND(=(?0.notNullInt0, 3), null)", "false", "=(?0.notNullInt0, 3)");
    }

    @Test
    public void testSimplifyCaseAndNotSimplicationIsInAction() {
        RexNode caseNode = this.case_(new RexNode[]{this.eq(this.vIntNotNull(), this.literal(0)), this.falseLiteral, this.eq(this.vIntNotNull(), this.literal(1)), this.trueLiteral, this.falseLiteral});
        this.checkSimplify(caseNode, "=(?0.notNullInt0, 1)");
    }

    @Test
    public void testSimplifyCaseBranchRemovalStrengthensType() {
        RexNode caseNode = this.case_(new RexNode[]{this.falseLiteral, this.nullBool, this.eq(this.div(this.vInt(), this.literal(2)), this.literal(3)), this.trueLiteral, this.falseLiteral});
        Assert.assertThat((String)("Expected to have a nullable type for " + caseNode + "."), (Object)caseNode.getType().isNullable(), (Matcher)CoreMatchers.is((Object)true));
        RexNode res = this.simplify.simplify(caseNode);
        Assert.assertThat((String)("Expected to have a nonNullable type for " + res + "."), (Object)res.getType().isNullable(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testSimplifyCaseCompaction() {
        RexNode caseNode = this.case_(this.vBool(0), this.vInt(0), this.vBool(1), this.vInt(0), this.vInt(1));
        this.checkSimplify(caseNode, "CASE(OR(?0.bool0, ?0.bool1), ?0.int0, ?0.int1)");
    }

    @Test
    public void testSimplifyCaseCompaction2() {
        RexNode caseNode = this.case_(this.vBool(0), this.vInt(0), this.vBool(1), this.vInt(1), this.vInt(1));
        this.checkSimplify(caseNode, "CASE(?0.bool0, ?0.int0, ?0.int1)");
    }

    @Test
    public void testSimplifyCaseCompactionDiv() {
        this.simplify = this.simplify.withParanoid(false);
        RexNode caseNode = this.case_(this.vBool(0), this.vInt(0), this.eq(this.div(this.literal(3), this.vIntNotNull()), this.literal(11)), this.vInt(0), this.vInt(1));
        this.checkSimplifyUnchanged(caseNode);
    }

    @Test
    public void testSimplifyCaseDiv1() {
        this.simplify = this.simplify.withParanoid(false);
        RexNode caseNode = this.case_(new RexNode[]{this.ne(this.vIntNotNull(), this.literal(0)), this.eq(this.div(this.literal(3), this.vIntNotNull()), this.literal(11)), this.falseLiteral});
        this.checkSimplifyUnchanged(caseNode);
    }

    @Test
    public void testSimplifyCaseDiv2() {
        this.simplify = this.simplify.withParanoid(false);
        RexNode caseNode = this.case_(new RexNode[]{this.eq(this.vIntNotNull(), this.literal(0)), this.trueLiteral, this.gt(this.div(this.literal(3), this.vIntNotNull()), this.literal(1)), this.trueLiteral, this.falseLiteral});
        this.checkSimplifyUnchanged(caseNode);
    }

    @Test
    public void testSimplifyCaseFirstBranchIsSafe() {
        RexNode caseNode = this.case_(new RexNode[]{this.gt(this.div(this.vIntNotNull(), this.literal(1)), this.literal(1)), this.falseLiteral, this.trueLiteral});
        this.checkSimplify(caseNode, "<=(/(?0.notNullInt0, 1), 1)");
    }

    @Test
    public void testPushNotIntoCase() {
        this.checkSimplify(this.not(this.case_(this.isTrue(this.vBool()), this.vBool(1), this.gt(this.div(this.vIntNotNull(), this.literal(2)), this.literal(1)), this.vBool(2), this.vBool(3))), "CASE(?0.bool0, NOT(?0.bool1), >(/(?0.notNullInt0, 2), 1), NOT(?0.bool2), NOT(?0.bool3))");
    }

    @Test
    public void testNotRecursion() {
        this.checkSimplify(this.not(this.coalesce(new RexNode[]{this.nullBool, this.trueLiteral})), "false");
    }

    @Test
    public void testSimplifyAnd() {
        RelDataType booleanNotNullableType = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.BOOLEAN), false);
        RelDataType booleanNullableType = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.BOOLEAN), true);
        RexNode andCondition = this.and(new RexNode[]{this.rexBuilder.makeInputRef(booleanNotNullableType, 0), this.rexBuilder.makeInputRef(booleanNullableType, 1), this.rexBuilder.makeInputRef(booleanNotNullableType, 2)});
        RexNode result = this.simplify.simplifyUnknownAs(andCondition, RexUnknownAs.UNKNOWN);
        Assert.assertThat((Object)result.getType().isNullable(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)result.getType().getSqlTypeName(), (Matcher)CoreMatchers.is((Object)SqlTypeName.BOOLEAN));
    }

    @Test
    public void testSimplifyIsNotNull() {
        RelDataType intType = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.INTEGER), false);
        RelDataType intNullableType = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.INTEGER), true);
        RexInputRef i0 = this.rexBuilder.makeInputRef(intNullableType, 0);
        RexInputRef i1 = this.rexBuilder.makeInputRef(intNullableType, 1);
        RexInputRef i2 = this.rexBuilder.makeInputRef(intType, 2);
        RexInputRef i3 = this.rexBuilder.makeInputRef(intType, 3);
        RexLiteral one = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        RexLiteral null_ = this.rexBuilder.makeNullLiteral(intType);
        this.checkSimplify(this.isNotNull(this.lt((RexNode)i0, (RexNode)i1)), "AND(IS NOT NULL($0), IS NOT NULL($1))");
        this.checkSimplify(this.isNotNull(this.lt((RexNode)i0, (RexNode)i2)), "IS NOT NULL($0)");
        this.checkSimplify(this.isNotNull(this.lt((RexNode)i2, (RexNode)i3)), "true");
        this.checkSimplify(this.isNotNull(this.lt((RexNode)i0, (RexNode)one)), "IS NOT NULL($0)");
        this.checkSimplify(this.isNotNull(this.lt((RexNode)i0, (RexNode)null_)), "false");
    }

    @Test
    public void checkSimplifyDynamicParam() {
        this.checkSimplify(this.isNotNull(this.lt(this.vInt(0), this.vInt(1))), "AND(IS NOT NULL(?0.int0), IS NOT NULL(?0.int1))");
        this.checkSimplify(this.isNotNull(this.lt(this.vInt(0), this.vIntNotNull(2))), "IS NOT NULL(?0.int0)");
        this.checkSimplify(this.isNotNull(this.lt(this.vIntNotNull(2), this.vIntNotNull(3))), "true");
        this.checkSimplify(this.isNotNull(this.lt(this.vInt(0), this.literal(BigDecimal.ONE))), "IS NOT NULL(?0.int0)");
        this.checkSimplify(this.isNotNull(this.lt(this.vInt(0), (RexNode)this.null_(this.tInt()))), "false");
    }

    @Test
    public void testSimplifyCastLiteral() {
        ArrayList<RexLiteral> literals = new ArrayList<RexLiteral>();
        literals.add(this.rexBuilder.makeExactLiteral(BigDecimal.ONE, this.typeFactory.createSqlType(SqlTypeName.INTEGER)));
        literals.add(this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(2L), this.typeFactory.createSqlType(SqlTypeName.BIGINT)));
        literals.add(this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(3L), this.typeFactory.createSqlType(SqlTypeName.SMALLINT)));
        literals.add(this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(4L), this.typeFactory.createSqlType(SqlTypeName.TINYINT)));
        literals.add(this.rexBuilder.makeExactLiteral(new BigDecimal("1234"), this.typeFactory.createSqlType(SqlTypeName.DECIMAL, 4, 0)));
        literals.add(this.rexBuilder.makeExactLiteral(new BigDecimal("123.45"), this.typeFactory.createSqlType(SqlTypeName.DECIMAL, 5, 2)));
        literals.add(this.rexBuilder.makeApproxLiteral(new BigDecimal("3.1415"), this.typeFactory.createSqlType(SqlTypeName.REAL)));
        literals.add(this.rexBuilder.makeApproxLiteral(BigDecimal.valueOf(Math.E), this.typeFactory.createSqlType(SqlTypeName.FLOAT)));
        literals.add(this.rexBuilder.makeApproxLiteral(BigDecimal.valueOf(Math.PI), this.typeFactory.createSqlType(SqlTypeName.DOUBLE)));
        literals.add(this.rexBuilder.makeLiteral(true));
        literals.add(this.rexBuilder.makeLiteral(false));
        literals.add(this.rexBuilder.makeLiteral("hello world"));
        literals.add(this.rexBuilder.makeLiteral("1969-07-20 12:34:56"));
        literals.add(this.rexBuilder.makeLiteral("1969-07-20"));
        literals.add(this.rexBuilder.makeLiteral("12:34:45"));
        literals.add((RexLiteral)this.rexBuilder.makeLiteral((Object)new ByteString(new byte[]{1, 2, -34, 0, -128}), this.typeFactory.createSqlType(SqlTypeName.BINARY, 5), false));
        literals.add(this.rexBuilder.makeDateLiteral(new DateString(1974, 8, 9)));
        literals.add(this.rexBuilder.makeTimeLiteral(new TimeString(1, 23, 45), 0));
        literals.add(this.rexBuilder.makeTimestampLiteral(new TimestampString(1974, 8, 9, 1, 23, 45), 0));
        LinkedHashMultimap map = LinkedHashMultimap.create();
        for (RexLiteral literal : literals) {
            map.put((Object)literal.getTypeName(), (Object)literal);
        }
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        types.add(this.typeFactory.createSqlType(SqlTypeName.INTEGER));
        types.add(this.typeFactory.createSqlType(SqlTypeName.BIGINT));
        types.add(this.typeFactory.createSqlType(SqlTypeName.SMALLINT));
        types.add(this.typeFactory.createSqlType(SqlTypeName.TINYINT));
        types.add(this.typeFactory.createSqlType(SqlTypeName.REAL));
        types.add(this.typeFactory.createSqlType(SqlTypeName.FLOAT));
        types.add(this.typeFactory.createSqlType(SqlTypeName.DOUBLE));
        types.add(this.typeFactory.createSqlType(SqlTypeName.BOOLEAN));
        types.add(this.typeFactory.createSqlType(SqlTypeName.VARCHAR, 10));
        types.add(this.typeFactory.createSqlType(SqlTypeName.CHAR, 5));
        types.add(this.typeFactory.createSqlType(SqlTypeName.VARBINARY, 60));
        types.add(this.typeFactory.createSqlType(SqlTypeName.BINARY, 3));
        types.add(this.typeFactory.createSqlType(SqlTypeName.TIMESTAMP));
        types.add(this.typeFactory.createSqlType(SqlTypeName.TIME));
        types.add(this.typeFactory.createSqlType(SqlTypeName.DATE));
        for (RelDataType fromType : types) {
            for (RelDataType toType : types) {
                if (!SqlTypeAssignmentRules.instance((boolean)false).canCastFrom(toType.getSqlTypeName(), fromType.getSqlTypeName())) continue;
                for (RexLiteral literal : map.get((Object)fromType.getSqlTypeName())) {
                    RexNode cast = this.rexBuilder.makeCast(toType, (RexNode)literal);
                    if (cast instanceof RexLiteral) {
                        Assert.assertThat((Object)cast.getType(), (Matcher)CoreMatchers.is((Object)toType));
                        continue;
                    }
                    RexNode simplified = this.simplify.simplifyUnknownAs(cast, RexUnknownAs.UNKNOWN);
                    boolean expectedSimplify = literal.getTypeName() != toType.getSqlTypeName() || literal.getTypeName() == SqlTypeName.CHAR && ((NlsString)literal.getValue()).getValue().length() > toType.getPrecision() || literal.getTypeName() == SqlTypeName.BINARY && ((ByteString)literal.getValue()).length() > toType.getPrecision();
                    boolean couldSimplify = !cast.equals((Object)simplified);
                    String reason = (expectedSimplify ? "expected to simplify, but could not: " : "simplified, but did not expect to: ") + cast + " --> " + simplified;
                    Assert.assertThat((String)reason, (Object)couldSimplify, (Matcher)CoreMatchers.is((Object)expectedSimplify));
                }
            }
        }
    }

    @Test
    public void testCastLiteral() {
        this.assertNode("cast(literal int not null)", "42:INTEGER NOT NULL", this.cast(this.literal(42), this.tInt()));
        this.assertNode("cast(literal int)", "42:INTEGER NOT NULL", this.cast(this.literal(42), this.nullable(this.tInt())));
        this.assertNode("abstractCast(literal int not null)", "CAST(42):INTEGER NOT NULL", this.abstractCast(this.literal(42), this.tInt()));
        this.assertNode("abstractCast(literal int)", "CAST(42):INTEGER", this.abstractCast(this.literal(42), this.nullable(this.tInt())));
    }

    @Test
    public void testSimplifyCastLiteral2() {
        RexLiteral literalAbc = this.rexBuilder.makeLiteral("abc");
        RexLiteral literalOne = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType varcharType = this.typeFactory.createSqlType(SqlTypeName.VARCHAR, 10);
        RelDataType booleanType = this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        RelDataType dateType = this.typeFactory.createSqlType(SqlTypeName.DATE);
        RelDataType timestampType = this.typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
        this.checkSimplifyUnchanged(this.cast((RexNode)literalAbc, intType));
        this.checkSimplifyUnchanged(this.cast((RexNode)literalOne, intType));
        this.checkSimplifyUnchanged(this.cast((RexNode)literalAbc, varcharType));
        this.checkSimplify(this.cast((RexNode)literalOne, varcharType), "'1':VARCHAR(10)");
        this.checkSimplifyUnchanged(this.cast((RexNode)literalAbc, booleanType));
        this.checkSimplify(this.cast((RexNode)literalOne, booleanType), "false");
        this.checkSimplifyUnchanged(this.cast((RexNode)literalAbc, dateType));
        this.checkSimplify(this.cast((RexNode)literalOne, dateType), "1970-01-02");
        this.checkSimplifyUnchanged(this.cast((RexNode)literalAbc, timestampType));
        this.checkSimplify(this.cast((RexNode)literalOne, timestampType), "1970-01-01 00:00:00");
    }

    @Test
    public void testSimplifyCastLiteral3() {
        RexLiteral literalDate = this.rexBuilder.makeDateLiteral(new DateString("2011-07-20"));
        RexLiteral literalTime = this.rexBuilder.makeTimeLiteral(new TimeString("12:34:56"), 0);
        RexLiteral literalTimestamp = this.rexBuilder.makeTimestampLiteral(new TimestampString("2011-07-20 12:34:56"), 0);
        RexLiteral literalTimeLTZ = this.rexBuilder.makeTimeWithLocalTimeZoneLiteral(new TimeString(1, 23, 45), 0);
        RexLiteral timeLTZChar1 = this.rexBuilder.makeLiteral("12:34:45 America/Los_Angeles");
        RexLiteral timeLTZChar2 = this.rexBuilder.makeLiteral("12:34:45 UTC");
        RexLiteral timeLTZChar3 = this.rexBuilder.makeLiteral("12:34:45 GMT+01");
        RexLiteral timestampLTZChar1 = this.rexBuilder.makeLiteral("2011-07-20 12:34:56 Asia/Tokyo");
        RexLiteral timestampLTZChar2 = this.rexBuilder.makeLiteral("2011-07-20 12:34:56 GMT+01");
        RexLiteral timestampLTZChar3 = this.rexBuilder.makeLiteral("2011-07-20 12:34:56 UTC");
        RexLiteral literalTimestampLTZ = this.rexBuilder.makeTimestampWithLocalTimeZoneLiteral(new TimestampString(2011, 7, 20, 8, 23, 45), 0);
        RelDataType dateType = this.typeFactory.createSqlType(SqlTypeName.DATE);
        RelDataType timeType = this.typeFactory.createSqlType(SqlTypeName.TIME);
        RelDataType timestampType = this.typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
        RelDataType timeLTZType = this.typeFactory.createSqlType(SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE);
        RelDataType timestampLTZType = this.typeFactory.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        RelDataType varCharType = this.typeFactory.createSqlType(SqlTypeName.VARCHAR, 40);
        this.checkSimplify(this.cast((RexNode)timeLTZChar1, timeLTZType), "20:34:45:TIME_WITH_LOCAL_TIME_ZONE(0)");
        this.checkSimplify(this.cast((RexNode)timeLTZChar2, timeLTZType), "12:34:45:TIME_WITH_LOCAL_TIME_ZONE(0)");
        this.checkSimplify(this.cast((RexNode)timeLTZChar3, timeLTZType), "11:34:45:TIME_WITH_LOCAL_TIME_ZONE(0)");
        this.checkSimplifyUnchanged(this.cast((RexNode)literalTimeLTZ, timeLTZType));
        this.checkSimplify(this.cast((RexNode)timestampLTZChar1, timestampLTZType), "2011-07-20 03:34:56:TIMESTAMP_WITH_LOCAL_TIME_ZONE(0)");
        this.checkSimplify(this.cast((RexNode)timestampLTZChar2, timestampLTZType), "2011-07-20 11:34:56:TIMESTAMP_WITH_LOCAL_TIME_ZONE(0)");
        this.checkSimplify(this.cast((RexNode)timestampLTZChar3, timestampLTZType), "2011-07-20 12:34:56:TIMESTAMP_WITH_LOCAL_TIME_ZONE(0)");
        this.checkSimplifyUnchanged(this.cast((RexNode)literalTimestampLTZ, timestampLTZType));
        this.checkSimplify(this.cast((RexNode)literalDate, timestampLTZType), "2011-07-20 07:00:00:TIMESTAMP_WITH_LOCAL_TIME_ZONE(0)");
        this.checkSimplify(this.cast((RexNode)literalTime, timestampLTZType), "2011-07-20 19:34:56:TIMESTAMP_WITH_LOCAL_TIME_ZONE(0)");
        this.checkSimplify(this.cast((RexNode)literalTimestamp, timestampLTZType), "2011-07-20 19:34:56:TIMESTAMP_WITH_LOCAL_TIME_ZONE(0)");
        this.checkSimplify(this.cast((RexNode)literalTimestamp, dateType), "2011-07-20");
        this.checkSimplify(this.cast((RexNode)literalTimestampLTZ, dateType), "2011-07-20");
        this.checkSimplify(this.cast((RexNode)literalTimestampLTZ, timeType), "01:23:45");
        this.checkSimplify(this.cast((RexNode)literalTimestampLTZ, timestampType), "2011-07-20 01:23:45");
        this.checkSimplify(this.cast((RexNode)literalTimeLTZ, timeType), "17:23:45");
        this.checkSimplify(this.cast((RexNode)literalTime, timeLTZType), "20:34:56:TIME_WITH_LOCAL_TIME_ZONE(0)");
        this.checkSimplify(this.cast((RexNode)literalTimestampLTZ, timeLTZType), "08:23:45:TIME_WITH_LOCAL_TIME_ZONE(0)");
        this.checkSimplify(this.cast((RexNode)literalTimeLTZ, varCharType), "'17:23:45 America/Los_Angeles':VARCHAR(40)");
        this.checkSimplify(this.cast((RexNode)literalTimestampLTZ, varCharType), "'2011-07-20 01:23:45 America/Los_Angeles':VARCHAR(40)");
        this.checkSimplify(this.cast((RexNode)literalTimeLTZ, timestampType), "2011-07-19 18:23:45");
        this.checkSimplify(this.cast((RexNode)literalTimeLTZ, timestampLTZType), "2011-07-20 01:23:45:TIMESTAMP_WITH_LOCAL_TIME_ZONE(0)");
    }

    @Test
    public void testRemovalOfNullabilityWideningCast() {
        RexNode expr = this.cast(this.isTrue(this.vBoolNotNull()), this.tBoolean(true));
        Assert.assertThat((Object)expr.getType().isNullable(), (Matcher)CoreMatchers.is((Object)true));
        RexNode result = this.simplify.simplifyUnknownAs(expr, RexUnknownAs.UNKNOWN);
        Assert.assertThat((Object)result.getType().isNullable(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testCompareTimestampWithTimeZone() {
        TimestampWithTimeZoneString timestampLTZChar1 = new TimestampWithTimeZoneString("2011-07-20 10:34:56 America/Los_Angeles");
        TimestampWithTimeZoneString timestampLTZChar2 = new TimestampWithTimeZoneString("2011-07-20 19:34:56 Europe/Rome");
        TimestampWithTimeZoneString timestampLTZChar3 = new TimestampWithTimeZoneString("2011-07-20 01:34:56 Asia/Tokyo");
        TimestampWithTimeZoneString timestampLTZChar4 = new TimestampWithTimeZoneString("2011-07-20 10:34:56 America/Los_Angeles");
        Assert.assertThat((Object)timestampLTZChar1.equals((Object)timestampLTZChar2), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)timestampLTZChar1.equals((Object)timestampLTZChar3), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)timestampLTZChar1.equals((Object)timestampLTZChar4), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSimplifyLiterals() {
        RexLiteral literalAbc = this.rexBuilder.makeLiteral("abc");
        RexLiteral literalDef = this.rexBuilder.makeLiteral("def");
        RexLiteral literalZero = this.rexBuilder.makeExactLiteral(BigDecimal.ZERO);
        RexLiteral literalOne = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        RexLiteral literalOneDotZero = this.rexBuilder.makeExactLiteral(new BigDecimal(1.0));
        this.checkSimplify(this.eq((RexNode)literalAbc, (RexNode)literalAbc), "true");
        this.checkSimplify(this.eq((RexNode)literalAbc, (RexNode)literalDef), "false");
        this.checkSimplify(this.ne((RexNode)literalAbc, (RexNode)literalAbc), "false");
        this.checkSimplify(this.ne((RexNode)literalAbc, (RexNode)literalDef), "true");
        this.checkSimplify(this.gt((RexNode)literalAbc, (RexNode)literalDef), "false");
        this.checkSimplify(this.gt((RexNode)literalDef, (RexNode)literalAbc), "true");
        this.checkSimplify(this.gt((RexNode)literalDef, (RexNode)literalDef), "false");
        this.checkSimplify(this.ge((RexNode)literalAbc, (RexNode)literalDef), "false");
        this.checkSimplify(this.ge((RexNode)literalDef, (RexNode)literalAbc), "true");
        this.checkSimplify(this.ge((RexNode)literalDef, (RexNode)literalDef), "true");
        this.checkSimplify(this.lt((RexNode)literalAbc, (RexNode)literalDef), "true");
        this.checkSimplify(this.lt((RexNode)literalAbc, (RexNode)literalDef), "true");
        this.checkSimplify(this.lt((RexNode)literalDef, (RexNode)literalDef), "false");
        this.checkSimplify(this.le((RexNode)literalAbc, (RexNode)literalDef), "true");
        this.checkSimplify(this.le((RexNode)literalDef, (RexNode)literalAbc), "false");
        this.checkSimplify(this.le((RexNode)literalDef, (RexNode)literalDef), "true");
        this.checkSimplify(this.eq((RexNode)literalZero, (RexNode)literalOne), "false");
        this.checkSimplify(this.eq((RexNode)literalOne, (RexNode)literalZero), "false");
        this.checkSimplify(this.ne((RexNode)literalZero, (RexNode)literalOne), "true");
        this.checkSimplify(this.ne((RexNode)literalOne, (RexNode)literalZero), "true");
        this.checkSimplify(this.gt((RexNode)literalZero, (RexNode)literalOne), "false");
        this.checkSimplify(this.gt((RexNode)literalOne, (RexNode)literalZero), "true");
        this.checkSimplify(this.gt((RexNode)literalOne, (RexNode)literalOne), "false");
        this.checkSimplify(this.ge((RexNode)literalZero, (RexNode)literalOne), "false");
        this.checkSimplify(this.ge((RexNode)literalOne, (RexNode)literalZero), "true");
        this.checkSimplify(this.ge((RexNode)literalOne, (RexNode)literalOne), "true");
        this.checkSimplify(this.lt((RexNode)literalZero, (RexNode)literalOne), "true");
        this.checkSimplify(this.lt((RexNode)literalOne, (RexNode)literalZero), "false");
        this.checkSimplify(this.lt((RexNode)literalOne, (RexNode)literalOne), "false");
        this.checkSimplify(this.le((RexNode)literalZero, (RexNode)literalOne), "true");
        this.checkSimplify(this.le((RexNode)literalOne, (RexNode)literalZero), "false");
        this.checkSimplify(this.le((RexNode)literalOne, (RexNode)literalOne), "true");
        this.checkSimplify(this.eq((RexNode)literalOne, (RexNode)literalOneDotZero), "true");
        this.checkSimplify(this.eq((RexNode)literalOneDotZero, (RexNode)literalOne), "true");
        this.checkSimplify(this.ne((RexNode)literalOne, (RexNode)literalOneDotZero), "false");
        this.checkSimplify(this.ne((RexNode)literalOneDotZero, (RexNode)literalOne), "false");
        this.checkSimplifyUnchanged(this.eq((RexNode)literalZero, (RexNode)literalAbc));
        this.checkSimplifyUnchanged(this.eq((RexNode)literalAbc, (RexNode)literalZero));
        this.checkSimplifyUnchanged(this.ne((RexNode)literalZero, (RexNode)literalAbc));
        this.checkSimplifyUnchanged(this.ne((RexNode)literalAbc, (RexNode)literalZero));
        this.checkSimplifyUnchanged(this.gt((RexNode)literalZero, (RexNode)literalAbc));
        this.checkSimplifyUnchanged(this.gt((RexNode)literalAbc, (RexNode)literalZero));
        this.checkSimplifyUnchanged(this.ge((RexNode)literalZero, (RexNode)literalAbc));
        this.checkSimplifyUnchanged(this.ge((RexNode)literalAbc, (RexNode)literalZero));
        this.checkSimplifyUnchanged(this.lt((RexNode)literalZero, (RexNode)literalAbc));
        this.checkSimplifyUnchanged(this.lt((RexNode)literalAbc, (RexNode)literalZero));
        this.checkSimplifyUnchanged(this.le((RexNode)literalZero, (RexNode)literalAbc));
        this.checkSimplifyUnchanged(this.le((RexNode)literalAbc, (RexNode)literalZero));
    }

    @Test
    public void testSelfComparisions() {
        this.checkSimplify3(this.and(this.eq(this.vInt(), this.vInt()), this.eq(this.vInt(1), this.vInt(1))), "AND(OR(null, IS NOT NULL(?0.int0)), OR(null, IS NOT NULL(?0.int1)))", "AND(IS NOT NULL(?0.int0), IS NOT NULL(?0.int1))", "true");
        this.checkSimplify3(this.and(this.ne(this.vInt(), this.vInt()), this.ne(this.vInt(1), this.vInt(1))), "AND(null, IS NULL(?0.int0), IS NULL(?0.int1))", "false", "AND(IS NULL(?0.int0), IS NULL(?0.int1))");
    }

    @Test
    public void testBooleanComparisions() {
        this.checkSimplify(this.eq(this.vBool(), (RexNode)this.trueLiteral), "?0.bool0");
        this.checkSimplify(this.ge(this.vBool(), (RexNode)this.trueLiteral), "?0.bool0");
        this.checkSimplify(this.ne(this.vBool(), (RexNode)this.trueLiteral), "NOT(?0.bool0)");
        this.checkSimplify(this.lt(this.vBool(), (RexNode)this.trueLiteral), "NOT(?0.bool0)");
        this.checkSimplifyUnchanged(this.gt(this.vBool(), (RexNode)this.trueLiteral));
        this.checkSimplifyUnchanged(this.le(this.vBool(), (RexNode)this.trueLiteral));
        this.checkSimplify(this.gt(this.vBoolNotNull(), (RexNode)this.trueLiteral), "false");
        this.checkSimplify(this.le(this.vBoolNotNull(), (RexNode)this.trueLiteral), "true");
        this.checkSimplify(this.eq(this.vBool(), (RexNode)this.falseLiteral), "NOT(?0.bool0)");
        this.checkSimplify(this.ne(this.vBool(), (RexNode)this.falseLiteral), "?0.bool0");
        this.checkSimplify(this.gt(this.vBool(), (RexNode)this.falseLiteral), "?0.bool0");
        this.checkSimplify(this.le(this.vBool(), (RexNode)this.falseLiteral), "NOT(?0.bool0)");
        this.checkSimplifyUnchanged(this.ge(this.vBool(), (RexNode)this.falseLiteral));
        this.checkSimplifyUnchanged(this.lt(this.vBool(), (RexNode)this.falseLiteral));
        this.checkSimplify(this.ge(this.vBoolNotNull(), (RexNode)this.falseLiteral), "true");
        this.checkSimplify(this.lt(this.vBoolNotNull(), (RexNode)this.falseLiteral), "false");
    }

    @Test
    public void testSimpleDynamicVars() {
        this.assertTypeAndToString(this.vBool(2), "?0.bool2", "BOOLEAN");
        this.assertTypeAndToString(this.vBoolNotNull(0), "?0.notNullBool0", "BOOLEAN NOT NULL");
        this.assertTypeAndToString(this.vInt(2), "?0.int2", "INTEGER");
        this.assertTypeAndToString(this.vIntNotNull(0), "?0.notNullInt0", "INTEGER NOT NULL");
        this.assertTypeAndToString(this.vVarchar(), "?0.varchar0", "VARCHAR");
        this.assertTypeAndToString(this.vVarcharNotNull(9), "?0.notNullVarchar9", "VARCHAR NOT NULL");
    }

    private void assertTypeAndToString(RexNode rexNode, String representation, String type) {
        Assert.assertEquals((Object)representation, (Object)rexNode.toString());
        Assert.assertEquals((String)("type of " + rexNode), (Object)type, (Object)(rexNode.getType().toString() + (rexNode.getType().isNullable() ? "" : " NOT NULL")));
    }

    @Test
    public void testIsDeterministic() {
        SqlSpecialOperator ndc = new SqlSpecialOperator("NDC", SqlKind.OTHER_FUNCTION, 0, false, ReturnTypes.BOOLEAN, null, null){

            public boolean isDeterministic() {
                return false;
            }
        };
        RexNode n = this.rexBuilder.makeCall((SqlOperator)ndc, new RexNode[0]);
        Assert.assertFalse((boolean)RexUtil.isDeterministic((RexNode)n));
        Assert.assertEquals((long)0L, (long)RexUtil.retainDeterministic((List)RelOptUtil.conjunctions((RexNode)n)).size());
    }

    @Test
    public void testConstantMap() {
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType rowType = this.typeFactory.builder().add("a", intType).add("b", intType).add("c", intType).add("d", intType).add("e", intType).build();
        RexDynamicParam range = this.rexBuilder.makeDynamicParam(rowType, 0);
        RexNode aRef = this.rexBuilder.makeFieldAccess((RexNode)range, 0);
        RexNode bRef = this.rexBuilder.makeFieldAccess((RexNode)range, 1);
        RexNode cRef = this.rexBuilder.makeFieldAccess((RexNode)range, 2);
        RexNode dRef = this.rexBuilder.makeFieldAccess((RexNode)range, 3);
        RexNode eRef = this.rexBuilder.makeFieldAccess((RexNode)range, 4);
        RexLiteral literal1 = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        RexLiteral literal2 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(2L));
        ImmutableMap map = RexUtil.predicateConstants(RexNode.class, (RexBuilder)this.rexBuilder, (List)ImmutableList.of((Object)this.eq(aRef, bRef), (Object)this.eq(cRef, (RexNode)literal1), (Object)this.eq(cRef, aRef), (Object)this.eq(dRef, eRef)));
        Assert.assertThat((Object)RexProgramTest.getString((ImmutableMap<RexNode, RexNode>)map), (Matcher)CoreMatchers.is((Object)"{1=?0.c, ?0.a=?0.b, ?0.b=?0.a, ?0.c=1, ?0.d=?0.e, ?0.e=?0.d}"));
        RexInputRef ref0 = this.rexBuilder.makeInputRef(rowType, 0);
        ImmutableMap map2 = RexUtil.predicateConstants(RexNode.class, (RexBuilder)this.rexBuilder, (List)ImmutableList.of((Object)this.eq((RexNode)ref0, (RexNode)literal1), (Object)this.eq((RexNode)ref0, (RexNode)literal2)));
        Assert.assertThat((Object)RexProgramTest.getString((ImmutableMap<RexNode, RexNode>)map2), (Matcher)CoreMatchers.is((Object)"{}"));
        ImmutableMap map3 = RexUtil.predicateConstants(RexNode.class, (RexBuilder)this.rexBuilder, (List)ImmutableList.of((Object)this.eq(aRef, (RexNode)literal1), (Object)this.eq(aRef, (RexNode)literal2)));
        Assert.assertThat((Object)RexProgramTest.getString((ImmutableMap<RexNode, RexNode>)map3), (Matcher)CoreMatchers.is((Object)"{1=?0.a, 2=?0.a}"));
    }

    @Test
    public void notDistinct() {
        this.checkSimplify(this.isFalse(this.isNotDistinctFrom(this.vBool(0), this.vBool(1))), "IS DISTINCT FROM(?0.bool0, ?0.bool1)");
    }

    @Test
    public void testSimplifyCoalesce() {
        this.checkSimplify(this.coalesce(this.vIntNotNull(), this.vInt()), "?0.notNullInt0");
        this.checkSimplifyUnchanged(this.coalesce(this.vInt(), this.vIntNotNull()));
        this.checkSimplify(this.coalesce(this.vInt(), this.vInt()), "?0.int0");
        this.checkSimplify(this.coalesce(this.vIntNotNull(), this.vIntNotNull()), "?0.notNullInt0");
        this.checkSimplify(this.coalesce(this.vIntNotNull(), this.literal(1)), "?0.notNullInt0");
        this.checkSimplifyUnchanged(this.coalesce(this.vInt(), this.literal(1)));
        this.checkSimplify(this.coalesce(this.vInt(), this.plus(this.vInt(), this.vIntNotNull()), this.literal(1), this.vIntNotNull()), "COALESCE(?0.int0, +(?0.int0, ?0.notNullInt0), 1)");
        this.checkSimplify(this.coalesce(new RexNode[]{this.gt((RexNode)this.nullInt, (RexNode)this.nullInt), this.trueLiteral}), "true");
        this.checkSimplify(this.coalesce(this.unaryPlus((RexNode)this.nullInt), this.unaryPlus(this.vInt())), "+(?0.int0)");
        this.checkSimplifyUnchanged(this.coalesce(this.unaryPlus(this.vInt(1)), this.unaryPlus(this.vInt())));
        this.checkSimplify(this.coalesce(new RexNode[]{this.nullInt, this.vInt()}), "?0.int0");
        this.checkSimplify(this.coalesce(new RexNode[]{this.vInt(), this.nullInt, this.vInt(1)}), "COALESCE(?0.int0, ?0.int1)");
    }

    @Test
    public void simplifyNull() {
        this.checkSimplify3((RexNode)this.nullBool, "null:BOOLEAN", "false", "true");
        this.checkSimplifyUnchanged((RexNode)this.nullInt);
    }

    private static String getString(ImmutableMap<RexNode, RexNode> map) {
        TreeMap map2 = new TreeMap();
        for (Map.Entry entry : map.entrySet()) {
            map2.put(((RexNode)entry.getKey()).toString(), entry.getValue());
        }
        return map2.toString();
    }

    @Test
    public void testSimplifyFalse() {
        RelDataType booleanNullableType = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.BOOLEAN), true);
        RexNode booleanInput = this.input(booleanNullableType, 0);
        RexNode isFalse = this.isFalse(booleanInput);
        RexCall result = (RexCall)this.simplify(isFalse);
        Assert.assertThat((Object)result.getType().isNullable(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)result.getOperator(), (Matcher)CoreMatchers.is((Object)SqlStdOperatorTable.IS_FALSE));
        Assert.assertThat((Object)result.getOperands().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(result.getOperands().get(0), (Matcher)CoreMatchers.is((Object)booleanInput));
        RexNode isFalseIsFalse = this.isFalse(isFalse);
        RexCall result2 = (RexCall)this.simplify(isFalseIsFalse);
        Assert.assertThat((Object)result2.getType().isNullable(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)result2.getOperator(), (Matcher)CoreMatchers.is((Object)SqlStdOperatorTable.IS_NOT_FALSE));
        Assert.assertThat((Object)result2.getOperands().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(result2.getOperands().get(0), (Matcher)CoreMatchers.is((Object)booleanInput));
    }

    @Test
    public void testSimplifyNot() {
        this.checkSimplify(this.not(this.not(this.vBool())), "?0.bool0");
        this.checkSimplify(this.not((RexNode)this.trueLiteral), "false");
        this.checkSimplify(this.not((RexNode)this.falseLiteral), "true");
        this.checkSimplify3(this.not(this.isFalse(this.vBool())), "IS NOT FALSE(?0.bool0)", "IS NOT FALSE(?0.bool0)", "?0.bool0");
        this.checkSimplify3(this.not(this.isTrue(this.vBool())), "IS NOT TRUE(?0.bool0)", "IS NOT TRUE(?0.bool0)", "NOT(?0.bool0)");
        this.checkSimplify(this.not(this.isNull(this.vBool())), "IS NOT NULL(?0.bool0)");
        this.checkSimplify(this.not(this.isNotNull(this.vBool())), "IS NULL(?0.bool0)");
        this.checkSimplify(this.not(this.and(this.vBool(0), this.vBool(1))), "OR(NOT(?0.bool0), NOT(?0.bool1))");
        this.checkSimplify(this.not(this.or(this.vBool(0), this.vBool(1))), "AND(NOT(?0.bool0), NOT(?0.bool1))");
    }

    @Test
    public void testSimplifyAndNot() {
        this.checkSimplify(this.and(this.gt(this.vInt(1), this.literal(1)), this.not(this.gt(this.vInt(2), this.literal(2)))), "AND(>(?0.int1, 1), <=(?0.int2, 2))");
        this.checkSimplify3(this.and(this.eq(this.vInt(1), this.vInt(1)), this.not(this.ge(this.vInt(2), this.vInt(2)))), "AND(OR(null, IS NOT NULL(?0.int1)), null, IS NULL(?0.int2))", "false", "IS NULL(?0.int2)");
        this.checkSimplify3(this.not(this.and(this.eq(this.vInt(1), this.vInt(1)), this.not(this.ge(this.vInt(2), this.vInt(2))))), "OR(AND(null, IS NULL(?0.int1)), null, IS NOT NULL(?0.int2))", "IS NOT NULL(?0.int2)", "true");
    }

    @Test
    public void testSimplifyOrNot() {
        this.checkSimplify(this.or(this.gt(this.vInt(1), this.literal(1)), this.not(this.gt(this.vInt(2), this.literal(2)))), "OR(>(?0.int1, 1), <=(?0.int2, 2))");
        this.checkSimplify3(this.or(this.eq(this.vInt(1), this.vInt(1)), this.not(this.ge(this.vInt(2), this.vInt(2)))), "OR(null, IS NOT NULL(?0.int1), AND(null, IS NULL(?0.int2)))", "IS NOT NULL(?0.int1)", "true");
        this.checkSimplify3(this.not(this.or(this.eq(this.vInt(1), this.vInt(1)), this.not(this.ge(this.vInt(2), this.vInt(2))))), "AND(null, IS NULL(?0.int1), OR(null, IS NOT NULL(?0.int2)))", "false", "IS NULL(?0.int1)");
    }

    private RexNode simplify(RexNode e) {
        RexSimplify simplify = new RexSimplify(this.rexBuilder, RelOptPredicateList.EMPTY, RexUtil.EXECUTOR).withParanoid(true);
        return simplify.simplifyUnknownAs(e, RexUnknownAs.UNKNOWN);
    }

    @Test
    public void testInterpreter() {
        Assert.assertThat((Object)this.eval((RexNode)this.trueLiteral), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.eval((RexNode)this.nullInt), (Matcher)CoreMatchers.is((Object)NullSentinel.INSTANCE));
        Assert.assertThat((Object)this.eval(this.eq((RexNode)this.nullInt, (RexNode)this.nullInt)), (Matcher)CoreMatchers.is((Object)NullSentinel.INSTANCE));
        Assert.assertThat((Object)this.eval(this.eq((RexNode)this.trueLiteral, (RexNode)this.nullInt)), (Matcher)CoreMatchers.is((Object)NullSentinel.INSTANCE));
        Assert.assertThat((Object)this.eval(this.eq((RexNode)this.falseLiteral, (RexNode)this.trueLiteral)), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.eval(this.ne((RexNode)this.falseLiteral, (RexNode)this.trueLiteral)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.eval(this.ne((RexNode)this.falseLiteral, (RexNode)this.nullInt)), (Matcher)CoreMatchers.is((Object)NullSentinel.INSTANCE));
        Assert.assertThat((Object)this.eval(this.and(new RexNode[]{this.trueLiteral, this.falseLiteral})), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testIsNullRecursion() {
        this.checkSimplify(this.isNull(this.or(new RexNode[]{this.coalesce(new RexNode[]{this.nullBool, this.trueLiteral}), this.falseLiteral})), "false");
    }

    @Test
    public void testRedundantIsTrue() {
        this.checkSimplify2(this.isTrue(this.isTrue(this.vBool())), "IS TRUE(?0.bool0)", "?0.bool0");
    }

    @Test
    public void testRedundantIsFalse() {
        this.checkSimplify2(this.isTrue(this.isFalse(this.vBool())), "IS FALSE(?0.bool0)", "NOT(?0.bool0)");
    }

    @Test
    public void testRedundantIsNotTrue() {
        this.checkSimplify3(this.isNotFalse(this.isNotTrue(this.vBool())), "IS NOT TRUE(?0.bool0)", "IS NOT TRUE(?0.bool0)", "NOT(?0.bool0)");
    }

    @Test
    public void testRedundantIsNotFalse() {
        this.checkSimplify3(this.isNotFalse(this.isNotFalse(this.vBool())), "IS NOT FALSE(?0.bool0)", "IS NOT FALSE(?0.bool0)", "?0.bool0");
    }

    @Test
    public void testIsAlwaysTrueAndFalseXisNullisNotNullisFalse() {
        this.checkIs(this.isFalse(this.isNotNull(this.isNull(this.vBool()))), false);
    }

    @Test
    public void testIsAlwaysTrueAndFalseNotXisNullisNotNullisFalse() {
        this.checkIs(this.isFalse(this.not(this.isNotNull(this.isNull(this.vBool())))), true);
    }

    @Test
    public void testIsAlwaysTrueAndFalseXisNullisNotNullisTrue() {
        this.checkIs(this.isTrue(this.isNotNull(this.isNull(this.vBool()))), true);
    }

    @Test
    public void testIsAlwaysTrueAndFalseNotXisNullisNotNullisTrue() {
        this.checkIs(this.isTrue(this.not(this.isNotNull(this.isNull(this.vBool())))), false);
    }

    @Test
    public void testIsAlwaysTrueAndFalseNotXisNullisNotNullisNotTrue() {
        this.checkIs(this.isNotTrue(this.not(this.isNotNull(this.isNull(this.vBool())))), true);
    }

    @Test
    public void testIsAlwaysTrueAndFalseXisNullisNotNull() {
        this.checkIs(this.isNotNull(this.isNull(this.vBool())), true);
    }

    @Test
    public void testIsAlwaysTrueAndFalseXisNotNullisNotNull() {
        this.checkIs(this.isNotNull(this.isNotNull(this.vBool())), true);
    }

    @Test
    public void testIsAlwaysTrueAndFalseXisNullisNull() {
        this.checkIs(this.isNull(this.isNull(this.vBool())), false);
    }

    @Test
    public void testIsAlwaysTrueAndFalseXisNotNullisNull() {
        this.checkIs(this.isNull(this.isNotNull(this.vBool())), false);
    }

    @Test
    public void testIsAlwaysTrueAndFalseXisNullisNotNullisNotFalse() {
        this.checkIs(this.isNotFalse(this.isNotNull(this.isNull(this.vBool()))), true);
    }

    @Test
    public void testIsAlwaysTrueAndFalseXisNullisNotNullisNotTrue() {
        this.checkIs(this.isNotTrue(this.isNotNull(this.isNull(this.vBool()))), false);
    }

    private void checkIs(RexNode e, boolean expected) {
        Assert.assertThat((String)("isAlwaysTrue() of expression: " + e.toString()), (Object)e.isAlwaysTrue(), (Matcher)CoreMatchers.is((Object)expected));
        Assert.assertThat((String)("isAlwaysFalse() of expression: " + e.toString()), (Object)e.isAlwaysFalse(), (Matcher)CoreMatchers.is((Object)(!expected ? 1 : 0)));
        Assert.assertThat((String)"Simplification is not using isAlwaysX informations", (Object)this.simplify(e).toString(), (Matcher)CoreMatchers.is((Object)(expected ? "true" : "false")));
    }

    private Comparable eval(RexNode e) {
        return RexInterpreter.evaluate((RexNode)e, (Map)ImmutableMap.of());
    }

    @Test
    public void testInDigest() {
        RexNode e = this.in(this.vInt(), this.literal(1), this.literal(2));
        Assert.assertThat((Object)e.toString(), (Matcher)CoreMatchers.is((Object)"IN(?0.int0, 1, 2)"));
    }
}

