/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.calcite.sql.util.ListSqlOperatorTable;

public class MockSqlOperatorTable
extends ChainedSqlOperatorTable {
    private final ListSqlOperatorTable listOpTab;

    public MockSqlOperatorTable(SqlOperatorTable parentTable) {
        super((List)ImmutableList.of((Object)parentTable, (Object)new ListSqlOperatorTable()));
        this.listOpTab = (ListSqlOperatorTable)this.tableList.get(1);
    }

    public void addOperator(SqlOperator op) {
        this.listOpTab.add(op);
    }

    public static void addRamp(MockSqlOperatorTable opTab) {
        opTab.addOperator((SqlOperator)new RampFunction());
        opTab.addOperator((SqlOperator)new DedupFunction());
    }

    public static class DedupFunction
    extends SqlFunction {
        public DedupFunction() {
            super("DEDUP", SqlKind.OTHER_FUNCTION, null, null, OperandTypes.VARIADIC, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.builder().add("NAME", SqlTypeName.VARCHAR, 1024).build();
        }
    }

    public static class RampFunction
    extends SqlFunction {
        public RampFunction() {
            super("RAMP", SqlKind.OTHER_FUNCTION, null, null, (SqlOperandTypeChecker)OperandTypes.NUMERIC, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.builder().add("I", SqlTypeName.INTEGER).build();
        }
    }
}

