/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.util.TestUtil;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class JdbcFrontJdbcBackTest {
    @Test
    public void testWhere2() {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).query("select * from \"foodmart\".\"days\" where \"day\" < 3").returns("day=1; week_day=Sunday\nday=2; week_day=Monday\n");
    }

    @Ignore
    @Test
    public void testTables() throws Exception {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).doWithConnection(connection -> {
            try {
                ResultSet rset = connection.getMetaData().getTables(null, null, null, null);
                StringBuilder buf = new StringBuilder();
                while (rset.next()) {
                    buf.append(rset.getString(3)).append(';');
                }
                Assert.assertEquals((Object)"account;agg_c_10_sales_fact_1997;agg_c_14_sales_fact_1997;agg_c_special_sales_fact_1997;agg_g_ms_pcat_sales_fact_1997;agg_l_03_sales_fact_1997;agg_l_04_sales_fact_1997;agg_l_05_sales_fact_1997;agg_lc_06_sales_fact_1997;agg_lc_100_sales_fact_1997;agg_ll_01_sales_fact_1997;agg_pl_01_sales_fact_1997;category;currency;customer;days;department;employee;employee_closure;expense_fact;inventory_fact_1997;inventory_fact_1998;position;product;product_class;products;promotion;region;reserve_employee;salary;sales_fact_1997;sales_fact_1998;sales_fact_dec_1998;store;store_ragged;time_by_day;warehouse;warehouse_class;COLUMNS;TABLES;", (Object)buf.toString());
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        });
    }

    @Test
    public void testTablesByType() throws Exception {
        this.checkTablesByType("SYSTEM TABLE", (Matcher<String>)Is.is((Object)"COLUMNS;TABLES;"));
        this.checkTablesByType("SYSTEM_TABLE", (Matcher<String>)Is.is((Object)""));
    }

    private void checkTablesByType(String tableType, Matcher<String> matcher) throws Exception {
        CalciteAssert.that().with(CalciteAssert.Config.REGULAR_PLUS_METADATA).doWithConnection(connection -> {
            try (ResultSet rset = connection.getMetaData().getTables(null, null, null, new String[]{tableType});){
                StringBuilder buf = new StringBuilder();
                while (rset.next()) {
                    buf.append(rset.getString(3)).append(';');
                }
                Assert.assertThat((Object)buf.toString(), (Matcher)matcher);
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        });
    }

    @Test
    public void testColumns() throws Exception {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).doWithConnection(connection -> {
            try {
                ResultSet rset = connection.getMetaData().getColumns(null, null, "sales_fact_1997", null);
                StringBuilder buf = new StringBuilder();
                while (rset.next()) {
                    buf.append(rset.getString(4)).append(';');
                }
                Assert.assertEquals((Object)"product_id;time_id;customer_id;promotion_id;store_id;store_sales;store_cost;unit_sales;", (Object)buf.toString());
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        });
    }

    @Test
    public void testEmpty() throws Exception {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).doWithConnection(connection -> {
            try {
                ResultSet rset = connection.getMetaData().getPrimaryKeys(null, null, "sales_fact_1997");
                Assert.assertFalse((boolean)rset.next());
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        });
    }

    @Test
    public void testCase() {
        CalciteAssert.that().with(CalciteAssert.Config.JDBC_FOODMART).query("select\n  case when \"sales_fact_1997\".\"promotion_id\" = 1 then 0\n  else \"sales_fact_1997\".\"store_sales\" end as \"c0\"\nfrom \"sales_fact_1997\" as \"sales_fact_1997\"where \"product_id\" = 1\nand \"time_id\" < 400").returns2("c0=11.4\nc0=8.55\n");
    }
}

