/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.clone.CloneSchema;
import org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.config.Lex;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.CalciteMetaImpl;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.model.ModelHandler;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.runtime.GeoFunctions;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableFunction;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.TableFunctionImpl;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.schema.impl.ViewTableMacro;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.calcite.test.BookstoreSchema;
import org.apache.calcite.test.ConnectionSpec;
import org.apache.calcite.test.CountriesTableFunction;
import org.apache.calcite.test.JdbcTest;
import org.apache.calcite.test.Matchers;
import org.apache.calcite.test.StreamTest;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Closer;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.JsonBuilder;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Smalls;
import org.apache.calcite.util.Sources;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.Util;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;

public class CalciteAssert {
    public static final DatabaseInstance DB = DatabaseInstance.valueOf((String)CalciteSystemProperty.TEST_DB.value());
    private static final DateFormat UTC_DATE_FORMAT;
    private static final DateFormat UTC_TIME_FORMAT;
    private static final DateFormat UTC_TIMESTAMP_FORMAT;
    public static final ConnectionFactory EMPTY_CONNECTION_FACTORY;
    private static final AssertThat DISABLED;

    private CalciteAssert() {
    }

    public static AssertThat that() {
        return AssertThat.EMPTY;
    }

    public static AssertThat that(Config config) {
        return CalciteAssert.that().with(config);
    }

    public static AssertThat model(String model) {
        return CalciteAssert.that().withModel(model);
    }

    public static AssertThat hr() {
        return CalciteAssert.that(Config.REGULAR);
    }

    static java.util.function.Function<RelNode, Void> checkRel(String expected, AtomicInteger counter) {
        return relNode -> {
            if (counter != null) {
                counter.incrementAndGet();
            }
            String s = RelOptUtil.toString((RelNode)relNode);
            Assert.assertThat((Object)s, Matchers.containsStringLinux(expected));
            return null;
        };
    }

    static Consumer<Throwable> checkException(String expected) {
        return p0 -> {
            Assert.assertNotNull((String)"expected exception but none was thrown", (Object)p0);
            String stack = TestUtil.printStackTrace(p0);
            Assert.assertTrue((String)stack, (boolean)stack.contains(expected));
        };
    }

    static Consumer<Throwable> checkValidationException(final String expected) {
        return new Consumer<Throwable>(){

            @Override
            public void accept(@Nullable Throwable throwable) {
                Assert.assertNotNull((String)"Nothing was thrown", (Object)throwable);
                Exception exception = this.containsCorrectException(throwable);
                Assert.assertTrue((String)"Expected to fail at validation, but did not", (exception != null ? 1 : 0) != 0);
                if (expected != null) {
                    String stack = TestUtil.printStackTrace(exception);
                    Assert.assertTrue((String)stack, (boolean)stack.contains(expected));
                }
            }

            private boolean isCorrectException(Throwable throwable) {
                return throwable instanceof SqlValidatorException || throwable instanceof CalciteException;
            }

            private Exception containsCorrectException(Throwable root) {
                for (Throwable currentCause = root; currentCause != null; currentCause = currentCause.getCause()) {
                    if (!this.isCorrectException(currentCause)) continue;
                    return (Exception)currentCause;
                }
                return null;
            }
        };
    }

    static Consumer<ResultSet> checkResult(String expected) {
        return CalciteAssert.checkResult(expected, new ResultSetFormatter());
    }

    static Consumer<ResultSet> checkResult(String expected, ResultSetFormatter resultSetFormatter) {
        return resultSet -> {
            try {
                resultSetFormatter.resultSet((ResultSet)resultSet);
                Assert.assertThat((Object)resultSetFormatter.string(), Matchers.isLinux(expected));
            }
            catch (SQLException e) {
                TestUtil.rethrow(e);
            }
        };
    }

    static Consumer<ResultSet> checkResultValue(String expected) {
        return resultSet -> {
            try {
                if (!resultSet.next()) {
                    throw new AssertionError((Object)"too few rows");
                }
                if (resultSet.getMetaData().getColumnCount() != 1) {
                    throw new AssertionError((Object)"expected 1 column");
                }
                String resultString = resultSet.getString(1);
                Assert.assertThat((Object)resultString, expected == null ? CoreMatchers.nullValue(String.class) : Matchers.isLinux(expected));
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        };
    }

    public static Consumer<ResultSet> checkResultCount(org.hamcrest.Matcher<Integer> expected) {
        return resultSet -> {
            try {
                int count = CalciteAssert.countRows(resultSet);
                Assert.assertThat((Object)count, (org.hamcrest.Matcher)expected);
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        };
    }

    public static Consumer<Integer> checkUpdateCount(int expected) {
        return updateCount -> Assert.assertThat((Object)updateCount, (org.hamcrest.Matcher)CoreMatchers.is((Object)expected));
    }

    static Consumer<ResultSet> consistentResult(final boolean ordered) {
        return new Consumer<ResultSet>(){
            int executeCount = 0;
            Collection expected;

            @Override
            public void accept(ResultSet resultSet) {
                ++this.executeCount;
                try {
                    Collection<String> result = CalciteAssert.toStringList(resultSet, ordered ? new ArrayList() : new TreeSet());
                    if (this.executeCount == 1) {
                        this.expected = result;
                    } else if (!this.expected.equals(result)) {
                        Assert.assertThat((Object)CalciteAssert.newlineList(result), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)CalciteAssert.newlineList(this.expected)));
                        Assert.fail((String)"oops");
                    }
                }
                catch (SQLException e) {
                    throw TestUtil.rethrow(e);
                }
            }
        };
    }

    static String newlineList(Collection collection) {
        StringBuilder buf = new StringBuilder();
        for (Object o : collection) {
            buf.append(o).append('\n');
        }
        return buf.toString();
    }

    static Consumer<ResultSet> checkResultUnordered(String ... lines) {
        return CalciteAssert.checkResult(true, false, lines);
    }

    static Consumer<ResultSet> checkResult(boolean sort, boolean head, String ... lines) {
        return resultSet -> {
            try {
                List<String> trimmedActualList;
                ArrayList expectedList = Lists.newArrayList((Object[])lines);
                if (sort) {
                    Collections.sort(expectedList);
                }
                ArrayList<String> actualList = new ArrayList<String>();
                CalciteAssert.toStringList(resultSet, actualList);
                if (sort) {
                    Collections.sort(actualList);
                }
                if (!(trimmedActualList = head && actualList.size() > expectedList.size() ? actualList.subList(0, expectedList.size()) : actualList).equals(expectedList)) {
                    Assert.assertThat((Object)Util.lines(trimmedActualList), (org.hamcrest.Matcher)CoreMatchers.equalTo((Object)Util.lines((Iterable)expectedList)));
                }
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        };
    }

    public static Consumer<ResultSet> checkResultContains(String ... expected) {
        return s -> {
            try {
                String actual = CalciteAssert.toString(s);
                for (String st : expected) {
                    Assert.assertThat((Object)actual, Matchers.containsStringLinux(st));
                }
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        };
    }

    public static Consumer<ResultSet> checkResultContains(String expected, int count) {
        return s -> {
            try {
                String actual = Util.toLinux((String)CalciteAssert.toString(s));
                Assert.assertTrue((String)(actual + " should have " + count + " occurrence of " + expected), (StringUtils.countMatches((CharSequence)actual, (CharSequence)expected) == count ? 1 : 0) != 0);
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        };
    }

    public static Consumer<ResultSet> checkMaskedResultContains(String expected) {
        return s -> {
            try {
                String actual = Util.toLinux((String)CalciteAssert.toString(s));
                String maskedActual = actual.replaceAll(", id = [0-9]+", "");
                Assert.assertThat((Object)maskedActual, (org.hamcrest.Matcher)CoreMatchers.containsString((String)expected));
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        };
    }

    public static Consumer<ResultSet> checkResultType(String expected) {
        return s -> {
            try {
                String actual = CalciteAssert.typeString(s.getMetaData());
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (SQLException e) {
                throw TestUtil.rethrow(e);
            }
        };
    }

    private static String typeString(ResultSetMetaData metaData) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < metaData.getColumnCount(); ++i) {
            list.add(metaData.getColumnName(i + 1) + " " + metaData.getColumnTypeName(i + 1) + (metaData.isNullable(i + 1) == 0 ? " NOT NULL" : ""));
        }
        return ((Object)list).toString();
    }

    /*
     * WARNING - void declaration
     */
    static void assertQuery(Connection connection, String sql, int limit, boolean materializationsEnabled, List<Pair<Hook, Consumer>> hooks, Consumer<ResultSet> resultChecker, Consumer<Integer> updateChecker, Consumer<Throwable> exceptionChecker) {
        try {
            Statement statement;
            block32: {
                void var11_20;
                try (Closer closer = new Closer();){
                    if (connection.isWrapperFor(CalciteConnection.class)) {
                        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
                        Properties properties = calciteConnection.getProperties();
                        properties.setProperty(CalciteConnectionProperty.MATERIALIZATIONS_ENABLED.camelName(), Boolean.toString(materializationsEnabled));
                        properties.setProperty(CalciteConnectionProperty.CREATE_MATERIALIZATIONS.camelName(), Boolean.toString(materializationsEnabled));
                        if (!properties.containsKey(CalciteConnectionProperty.TIME_ZONE.camelName())) {
                            properties.setProperty(CalciteConnectionProperty.TIME_ZONE.camelName(), DateTimeUtils.UTC_ZONE.getID());
                        }
                    }
                    for (Pair pair : hooks) {
                        closer.add((AutoCloseable)((Hook)pair.left).addThread((Consumer)pair.right));
                    }
                    statement = connection.createStatement();
                    statement.setMaxRows(limit <= 0 ? limit : Math.max(limit, 1));
                    Object var11_18 = null;
                    Integer updateCount = null;
                    try {
                        if (updateChecker == null) {
                            ResultSet resultSet = statement.executeQuery(sql);
                        } else {
                            updateCount = statement.executeUpdate(sql);
                        }
                        if (exceptionChecker != null) {
                            exceptionChecker.accept(null);
                            return;
                        }
                    }
                    catch (Error | Exception e) {
                        if (exceptionChecker != null) {
                            exceptionChecker.accept(e);
                            return;
                        }
                        throw e;
                    }
                    if (resultChecker != null) {
                        resultChecker.accept((ResultSet)var11_20);
                    }
                    if (updateChecker != null) {
                        updateChecker.accept(updateCount);
                    }
                    if (var11_20 == null) break block32;
                }
                var11_20.close();
            }
            statement.close();
            connection.close();
        }
        catch (Throwable e) {
            String message = "With materializationsEnabled=" + materializationsEnabled + ", limit=" + limit;
            if (!TestUtil.hasMessage(e, sql)) {
                message = message + ", sql=" + sql;
            }
            throw TestUtil.rethrow(e, message);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void assertPrepare(Connection connection, String sql, int limit, boolean materializationsEnabled, List<Pair<Hook, Consumer>> hooks, Consumer<ResultSet> resultChecker, Consumer<Integer> updateChecker, Consumer<Throwable> exceptionChecker, PreparedStatementConsumer consumer) {
        try {
            PreparedStatement statement;
            block32: {
                void var12_21;
                try (Closer closer = new Closer();){
                    if (connection.isWrapperFor(CalciteConnection.class)) {
                        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
                        Properties properties = calciteConnection.getProperties();
                        properties.setProperty(CalciteConnectionProperty.MATERIALIZATIONS_ENABLED.camelName(), Boolean.toString(materializationsEnabled));
                        properties.setProperty(CalciteConnectionProperty.CREATE_MATERIALIZATIONS.camelName(), Boolean.toString(materializationsEnabled));
                        if (!properties.containsKey(CalciteConnectionProperty.TIME_ZONE.camelName())) {
                            properties.setProperty(CalciteConnectionProperty.TIME_ZONE.camelName(), DateTimeUtils.UTC_ZONE.getID());
                        }
                    }
                    for (Pair pair : hooks) {
                        closer.add((AutoCloseable)((Hook)pair.left).addThread((Consumer)pair.right));
                    }
                    statement = connection.prepareStatement(sql);
                    statement.setMaxRows(limit <= 0 ? limit : Math.max(limit, 1));
                    Object var12_19 = null;
                    Integer updateCount = null;
                    try {
                        consumer.accept(statement);
                        if (updateChecker == null) {
                            ResultSet resultSet = statement.executeQuery();
                        } else {
                            updateCount = statement.executeUpdate(sql);
                        }
                        if (exceptionChecker != null) {
                            exceptionChecker.accept(null);
                            return;
                        }
                    }
                    catch (Error | Exception e) {
                        if (exceptionChecker != null) {
                            exceptionChecker.accept(e);
                            return;
                        }
                        throw e;
                    }
                    if (resultChecker != null) {
                        resultChecker.accept((ResultSet)var12_21);
                    }
                    if (updateChecker != null) {
                        updateChecker.accept(updateCount);
                    }
                    if (var12_21 == null) break block32;
                }
                var12_21.close();
            }
            statement.close();
            connection.close();
        }
        catch (Throwable e) {
            String message = "With materializationsEnabled=" + materializationsEnabled + ", limit=" + limit;
            if (!TestUtil.hasMessage(e, sql)) {
                message = message + ", sql=" + sql;
            }
            throw TestUtil.rethrow(e, message);
        }
    }

    static void assertPrepare(Connection connection, String sql, boolean materializationsEnabled, java.util.function.Function<RelNode, Void> convertChecker, java.util.function.Function<RelNode, Void> substitutionChecker) {
        try (Closer closer = new Closer();){
            if (convertChecker != null) {
                closer.add((AutoCloseable)Hook.TRIMMED.addThread(convertChecker::apply));
            }
            if (substitutionChecker != null) {
                closer.add((AutoCloseable)Hook.SUB.addThread(substitutionChecker::apply));
            }
            ((CalciteConnection)connection).getProperties().setProperty(CalciteConnectionProperty.MATERIALIZATIONS_ENABLED.camelName(), Boolean.toString(materializationsEnabled));
            ((CalciteConnection)connection).getProperties().setProperty(CalciteConnectionProperty.CREATE_MATERIALIZATIONS.camelName(), Boolean.toString(materializationsEnabled));
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.close();
            connection.close();
        }
        catch (Throwable e) {
            String message = "With materializationsEnabled=" + materializationsEnabled;
            if (!TestUtil.hasMessage(e, sql)) {
                message = message + ", sql=" + sql;
            }
            throw TestUtil.rethrow(e, message);
        }
    }

    static String toString(ResultSet resultSet) throws SQLException {
        return new ResultSetFormatter().resultSet(resultSet).string();
    }

    static int countRows(ResultSet resultSet) throws SQLException {
        int n = 0;
        while (resultSet.next()) {
            ++n;
        }
        return n;
    }

    static Collection<String> toStringList(ResultSet resultSet, Collection<String> list) throws SQLException {
        return new ResultSetFormatter().toStringList(resultSet, list);
    }

    static List<String> toList(ResultSet resultSet) throws SQLException {
        return (List)CalciteAssert.toStringList(resultSet, new ArrayList<String>());
    }

    static ImmutableMultiset<String> toSet(ResultSet resultSet) throws SQLException {
        return ImmutableMultiset.copyOf(CalciteAssert.toList(resultSet));
    }

    static Object call(Object o, String methodName, Object ... args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return CalciteAssert.method(o, methodName, args).invoke(o, args);
    }

    /*
     * Unable to fully structure code
     */
    static Method method(Object o, String methodName, Object[] args) {
        aClass = o.getClass();
        while (true) lbl-1000:
        // 5 sources

        {
            block1: for (Method method1 : aClass.getMethods()) {
                if (!method1.getName().equals(methodName) || method1.getParameterTypes().length != args.length || !Modifier.isPublic(method1.getDeclaringClass().getModifiers())) continue;
                for (Pair pair : Pair.zip((Object[])args, (Object[])method1.getParameterTypes())) {
                    if (((Class)pair.right).isInstance(pair.left)) continue;
                    continue block1;
                }
                return method1;
            }
            if (aClass.getSuperclass() != null && aClass.getSuperclass() != Object.class) {
                aClass = aClass.getSuperclass();
                ** continue;
            }
            interfaces = aClass.getInterfaces();
            if (interfaces.length <= 0) break;
            aClass = interfaces[0];
        }
        throw new AssertionError((Object)("method " + methodName + " not found"));
    }

    public static SchemaPlus addSchema(SchemaPlus rootSchema, SchemaSpec schema) {
        switch (schema) {
            case REFLECTIVE_FOODMART: {
                return rootSchema.add(schema.schemaName, (Schema)new ReflectiveSchema((Object)new JdbcTest.FoodmartSchema()));
            }
            case JDBC_SCOTT: {
                ConnectionSpec cs = DatabaseInstance.HSQLDB.scott;
                DataSource dataSource = JdbcSchema.dataSource((String)cs.url, (String)cs.driver, (String)cs.username, (String)cs.password);
                return rootSchema.add(schema.schemaName, (Schema)JdbcSchema.create((SchemaPlus)rootSchema, (String)schema.schemaName, (DataSource)dataSource, (String)cs.catalog, (String)cs.schema));
            }
            case JDBC_FOODMART: {
                ConnectionSpec cs = CalciteAssert.DB.foodmart;
                DataSource dataSource = JdbcSchema.dataSource((String)cs.url, (String)cs.driver, (String)cs.username, (String)cs.password);
                return rootSchema.add(schema.schemaName, (Schema)JdbcSchema.create((SchemaPlus)rootSchema, (String)schema.schemaName, (DataSource)dataSource, (String)cs.catalog, (String)cs.schema));
            }
            case JDBC_FOODMART_WITH_LATTICE: {
                SchemaPlus foodmart = CalciteAssert.addSchemaIfNotExists(rootSchema, SchemaSpec.JDBC_FOODMART);
                foodmart.add(schema.schemaName, Lattice.create((CalciteSchema)((CalciteSchema)foodmart.unwrap(CalciteSchema.class)), (String)"select 1 from \"foodmart\".\"sales_fact_1997\" as s\njoin \"foodmart\".\"time_by_day\" as t using (\"time_id\")\njoin \"foodmart\".\"customer\" as c using (\"customer_id\")\njoin \"foodmart\".\"product\" as p using (\"product_id\")\njoin \"foodmart\".\"product_class\" as pc on p.\"product_class_id\" = pc.\"product_class_id\"", (boolean)true));
                return foodmart;
            }
            case SCOTT: {
                SchemaPlus jdbcScott = CalciteAssert.addSchemaIfNotExists(rootSchema, SchemaSpec.JDBC_SCOTT);
                return rootSchema.add(schema.schemaName, (Schema)new CloneSchema(jdbcScott));
            }
            case CLONE_FOODMART: {
                SchemaPlus foodmart = CalciteAssert.addSchemaIfNotExists(rootSchema, SchemaSpec.JDBC_FOODMART);
                return rootSchema.add("foodmart2", (Schema)new CloneSchema(foodmart));
            }
            case GEO: {
                ModelHandler.addFunctions((SchemaPlus)rootSchema, null, (List)ImmutableList.of(), (String)GeoFunctions.class.getName(), (String)"*", (boolean)true);
                SchemaPlus s = rootSchema.add(schema.schemaName, (Schema)new AbstractSchema());
                ModelHandler.addFunctions((SchemaPlus)s, (String)"countries", (List)ImmutableList.of(), (String)CountriesTableFunction.class.getName(), null, (boolean)false);
                String sql = "select * from table(\"countries\"(true))";
                ViewTableMacro viewMacro = ViewTable.viewMacro((SchemaPlus)rootSchema, (String)"select * from table(\"countries\"(true))", (List)ImmutableList.of((Object)"GEO"), (List)ImmutableList.of(), (Boolean)false);
                s.add("countries", (org.apache.calcite.schema.Function)viewMacro);
                return s;
            }
            case HR: {
                return rootSchema.add(schema.schemaName, (Schema)new ReflectiveSchema((Object)new JdbcTest.HrSchema()));
            }
            case LINGUAL: {
                return rootSchema.add(schema.schemaName, (Schema)new ReflectiveSchema((Object)new JdbcTest.LingualSchema()));
            }
            case BLANK: {
                return rootSchema.add(schema.schemaName, (Schema)new AbstractSchema());
            }
            case ORINOCO: {
                SchemaPlus orinoco = rootSchema.add(schema.schemaName, (Schema)new AbstractSchema());
                orinoco.add("ORDERS", (Table)new StreamTest.OrdersHistoryTable(StreamTest.OrdersStreamTableFactory.getRowList()));
                return orinoco;
            }
            case POST: {
                SchemaPlus post = rootSchema.add(schema.schemaName, (Schema)new AbstractSchema());
                post.add("EMP", (org.apache.calcite.schema.Function)ViewTable.viewMacro((SchemaPlus)post, (String)"select * from (values\n    ('Jane', 10, 'F'),\n    ('Bob', 10, 'M'),\n    ('Eric', 20, 'M'),\n    ('Susan', 30, 'F'),\n    ('Alice', 30, 'F'),\n    ('Adam', 50, 'M'),\n    ('Eve', 50, 'F'),\n    ('Grace', 60, 'F'),\n    ('Wilma', cast(null as integer), 'F'))\n  as t(ename, deptno, gender)", (List)ImmutableList.of(), (List)ImmutableList.of((Object)"POST", (Object)"EMP"), null));
                post.add("DEPT", (org.apache.calcite.schema.Function)ViewTable.viewMacro((SchemaPlus)post, (String)"select * from (values\n    (10, 'Sales'),\n    (20, 'Marketing'),\n    (30, 'Engineering'),\n    (40, 'Empty')) as t(deptno, dname)", (List)ImmutableList.of(), (List)ImmutableList.of((Object)"POST", (Object)"DEPT"), null));
                post.add("DEPT30", (org.apache.calcite.schema.Function)ViewTable.viewMacro((SchemaPlus)post, (String)"select * from dept where deptno = 30", (List)ImmutableList.of((Object)"POST"), (List)ImmutableList.of((Object)"POST", (Object)"DEPT30"), null));
                post.add("EMPS", (org.apache.calcite.schema.Function)ViewTable.viewMacro((SchemaPlus)post, (String)"select * from (values\n    (100, 'Fred',  10, CAST(NULL AS CHAR(1)), CAST(NULL AS VARCHAR(20)), 40,               25, TRUE,    FALSE, DATE '1996-08-03'),\n    (110, 'Eric',  20, 'M',                   'San Francisco',           3,                80, UNKNOWN, FALSE, DATE '2001-01-01'),\n    (110, 'John',  40, 'M',                   'Vancouver',               2, CAST(NULL AS INT), FALSE,   TRUE,  DATE '2002-05-03'),\n    (120, 'Wilma', 20, 'F',                   CAST(NULL AS VARCHAR(20)), 1,                 5, UNKNOWN, TRUE,  DATE '2005-09-07'),\n    (130, 'Alice', 40, 'F',                   'Vancouver',               2, CAST(NULL AS INT), FALSE,   TRUE,  DATE '2007-01-01'))\n as t(empno, name, deptno, gender, city, empid, age, slacker, manager, joinedat)", (List)ImmutableList.of(), (List)ImmutableList.of((Object)"POST", (Object)"EMPS"), null));
                return post;
            }
            case AUX: {
                SchemaPlus aux = rootSchema.add(schema.schemaName, (Schema)new AbstractSchema());
                TableFunction tableFunction = TableFunctionImpl.create(Smalls.SimpleTableFunction.class, (String)"eval");
                aux.add("TBLFUN", (org.apache.calcite.schema.Function)tableFunction);
                String simpleSql = "select *\nfrom (values\n    ('ABC', 1),\n    ('DEF', 2),\n    ('GHI', 3))\n  as t(strcol, intcol)";
                aux.add("SIMPLETABLE", (org.apache.calcite.schema.Function)ViewTable.viewMacro((SchemaPlus)aux, (String)"select *\nfrom (values\n    ('ABC', 1),\n    ('DEF', 2),\n    ('GHI', 3))\n  as t(strcol, intcol)", (List)ImmutableList.of(), (List)ImmutableList.of((Object)"AUX", (Object)"SIMPLETABLE"), null));
                String lateralSql = "SELECT *\nFROM AUX.SIMPLETABLE ST\nCROSS JOIN LATERAL TABLE(AUX.TBLFUN(ST.INTCOL))";
                aux.add("VIEWLATERAL", (org.apache.calcite.schema.Function)ViewTable.viewMacro((SchemaPlus)aux, (String)"SELECT *\nFROM AUX.SIMPLETABLE ST\nCROSS JOIN LATERAL TABLE(AUX.TBLFUN(ST.INTCOL))", (List)ImmutableList.of(), (List)ImmutableList.of((Object)"AUX", (Object)"VIEWLATERAL"), null));
                return aux;
            }
            case BOOKSTORE: {
                return rootSchema.add(schema.schemaName, (Schema)new ReflectiveSchema((Object)new BookstoreSchema()));
            }
        }
        throw new AssertionError((Object)("unknown schema " + (Object)((Object)schema)));
    }

    private static SchemaPlus addSchemaIfNotExists(SchemaPlus rootSchema, SchemaSpec schemaSpec) {
        SchemaPlus schema = rootSchema.getSubSchema(schemaSpec.schemaName);
        if (schema != null) {
            return schema;
        }
        return CalciteAssert.addSchema(rootSchema, schemaSpec);
    }

    public static void assertArrayEqual(String message, Object[] expected, Object[] actual) {
        Assert.assertEquals((String)message, (Object)CalciteAssert.str(expected), (Object)CalciteAssert.str(actual));
    }

    private static String str(Object[] objects) {
        return objects == null ? null : Arrays.stream(objects).map(Object::toString).collect(Collectors.joining("\n"));
    }

    static PropBuilder propBuilder() {
        return new PropBuilder();
    }

    static {
        TimeZone utc = DateTimeUtils.UTC_ZONE;
        UTC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
        UTC_DATE_FORMAT.setTimeZone(utc);
        UTC_TIME_FORMAT = new SimpleDateFormat("HH:mm:ss", Locale.ROOT);
        UTC_TIME_FORMAT.setTimeZone(utc);
        UTC_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT);
        UTC_TIMESTAMP_FORMAT.setTimeZone(utc);
        EMPTY_CONNECTION_FACTORY = new MapConnectionFactory(ImmutableMap.of(), ImmutableList.of());
        DISABLED = new AssertThat(EMPTY_CONNECTION_FACTORY){

            @Override
            public AssertThat with(Config config) {
                return this;
            }

            @Override
            public AssertThat with(ConnectionFactory connectionFactory) {
                return this;
            }

            @Override
            public AssertThat with(String property, Object value) {
                return this;
            }

            @Override
            public AssertThat withSchema(String name, Schema schema) {
                return this;
            }

            @Override
            public AssertQuery query(String sql) {
                return NopAssertQuery.of(sql);
            }

            @Override
            public AssertThat connectThrows(Consumer<Throwable> exceptionChecker) {
                return this;
            }

            @Override
            public <T> AssertThat doWithConnection(java.util.function.Function<CalciteConnection, T> fn) throws Exception {
                return this;
            }

            @Override
            public AssertThat withDefaultSchema(String schema) {
                return this;
            }

            @Override
            public AssertThat with(SchemaSpec ... specs) {
                return this;
            }

            @Override
            public AssertThat with(Lex lex) {
                return this;
            }

            @Override
            public AssertThat with(ConnectionPostProcessor postProcessor) {
                return this;
            }

            @Override
            public AssertThat enable(boolean enabled) {
                return this;
            }

            @Override
            public AssertThat pooled() {
                return this;
            }
        };
    }

    public static interface PreparedStatementConsumer {
        public void accept(PreparedStatement var1) throws SQLException;
    }

    static class PropBuilder {
        final Properties properties = new Properties();

        PropBuilder() {
        }

        PropBuilder set(CalciteConnectionProperty p, String v) {
            this.properties.setProperty(p.camelName(), v);
            return this;
        }

        Properties build() {
            return this.properties;
        }
    }

    static class ResultSetFormatter {
        final StringBuilder buf = new StringBuilder();

        ResultSetFormatter() {
        }

        public ResultSetFormatter resultSet(ResultSet resultSet) throws SQLException {
            ResultSetMetaData metaData = resultSet.getMetaData();
            while (resultSet.next()) {
                this.rowToString(resultSet, metaData);
                this.buf.append("\n");
            }
            return this;
        }

        ResultSetFormatter rowToString(ResultSet resultSet, ResultSetMetaData metaData) throws SQLException {
            int n = metaData.getColumnCount();
            if (n > 0) {
                int i = 1;
                while (true) {
                    this.buf.append(metaData.getColumnLabel(i)).append("=").append(this.adjustValue(resultSet.getString(i)));
                    if (i == n) break;
                    this.buf.append("; ");
                    ++i;
                }
            }
            return this;
        }

        protected String adjustValue(String string) {
            return string;
        }

        public Collection<String> toStringList(ResultSet resultSet, Collection<String> list) throws SQLException {
            ResultSetMetaData metaData = resultSet.getMetaData();
            while (resultSet.next()) {
                this.rowToString(resultSet, metaData);
                list.add(this.buf.toString());
                this.buf.setLength(0);
            }
            return list;
        }

        public String string() {
            String s = this.buf.toString();
            this.buf.setLength(0);
            return s;
        }
    }

    public static enum SchemaSpec {
        REFLECTIVE_FOODMART("foodmart"),
        JDBC_FOODMART("foodmart"),
        CLONE_FOODMART("foodmart2"),
        JDBC_FOODMART_WITH_LATTICE("lattice"),
        GEO("GEO"),
        HR("hr"),
        JDBC_SCOTT("JDBC_SCOTT"),
        SCOTT("scott"),
        BLANK("BLANK"),
        LINGUAL("SALES"),
        POST("POST"),
        ORINOCO("ORINOCO"),
        AUX("AUX"),
        BOOKSTORE("bookstore");

        public final String schemaName;

        private SchemaSpec(String schemaName) {
            this.schemaName = schemaName;
        }
    }

    public static enum DatabaseInstance {
        HSQLDB(new ConnectionSpec("jdbc:hsqldb:res:foodmart", "FOODMART", "FOODMART", "org.hsqldb.jdbcDriver", "foodmart"), new ConnectionSpec("jdbc:hsqldb:res:scott", "SCOTT", "TIGER", "org.hsqldb.jdbcDriver", "SCOTT")),
        H2(new ConnectionSpec("jdbc:h2:" + (String)CalciteSystemProperty.TEST_DATASET_PATH.value() + "/h2/target/foodmart;user=foodmart;password=foodmart", "foodmart", "foodmart", "org.h2.Driver", "foodmart"), null),
        MYSQL(new ConnectionSpec("jdbc:mysql://localhost/foodmart", "foodmart", "foodmart", "com.mysql.jdbc.Driver", "foodmart"), null),
        ORACLE(new ConnectionSpec("jdbc:oracle:thin:@localhost:1521:XE", "foodmart", "foodmart", "oracle.jdbc.OracleDriver", "FOODMART"), null),
        POSTGRESQL(new ConnectionSpec("jdbc:postgresql://localhost/foodmart?user=foodmart&password=foodmart&searchpath=foodmart", "foodmart", "foodmart", "org.postgresql.Driver", "foodmart"), null);

        public final ConnectionSpec foodmart;
        public final ConnectionSpec scott;

        private DatabaseInstance(ConnectionSpec foodmart, ConnectionSpec scott) {
            this.foodmart = foodmart;
            this.scott = scott;
        }
    }

    private static class NopAssertQuery
    extends AssertQuery {
        private NopAssertQuery(String sql) {
            super(null, sql);
        }

        static AssertQuery of(String sql) {
            return new NopAssertQuery(sql);
        }

        @Override
        protected Connection createConnection() {
            throw new AssertionError((Object)"disabled");
        }

        @Override
        public AssertQuery returns(String sql, Consumer<ResultSet> checker) {
            return this;
        }

        @Override
        public AssertQuery throws_(String message) {
            return this;
        }

        @Override
        public AssertQuery runs() {
            return this;
        }

        @Override
        public AssertQuery convertMatches(java.util.function.Function<RelNode, Void> checker) {
            return this;
        }

        @Override
        public AssertQuery substitutionMatches(java.util.function.Function<RelNode, Void> checker) {
            return this;
        }

        @Override
        public AssertQuery planContains(String expected) {
            return this;
        }

        @Override
        public AssertQuery planHasSql(String expected) {
            return this;
        }

        @Override
        public AssertQuery planUpdateHasSql(String expected, int count) {
            return this;
        }

        @Override
        public AssertQuery queryContains(Consumer<List> predicate1) {
            return this;
        }
    }

    public static enum Config {
        EMPTY,
        REGULAR,
        LINGUAL,
        JDBC_FOODMART,
        JDBC_SCOTT,
        FOODMART_CLONE,
        GEO,
        JDBC_FOODMART_WITH_LATTICE,
        REGULAR_PLUS_METADATA,
        SCOTT,
        SPARK,
        AUX;

    }

    public static class AssertMetaData {
        private final ConnectionFactory connectionFactory;
        private final java.util.function.Function<Connection, ResultSet> function;

        AssertMetaData(ConnectionFactory connectionFactory, java.util.function.Function<Connection, ResultSet> function) {
            this.connectionFactory = connectionFactory;
            this.function = function;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final AssertMetaData returns(Consumer<ResultSet> checker) {
            try (Connection c = this.connectionFactory.createConnection();){
                ResultSet resultSet = this.function.apply(c);
                checker.accept(resultSet);
                resultSet.close();
                c.close();
                AssertMetaData assertMetaData = this;
                return assertMetaData;
            }
            catch (Throwable e) {
                throw TestUtil.rethrow(e);
            }
        }

        public AssertMetaData returns(String expected) {
            return this.returns(CalciteAssert.checkResult(expected));
        }
    }

    public static class AssertQuery {
        private final String sql;
        private ConnectionFactory connectionFactory;
        private String plan;
        private int limit;
        private boolean materializationsEnabled = false;
        private final List<Pair<Hook, Consumer>> hooks = new ArrayList<Pair<Hook, Consumer>>();
        private PreparedStatementConsumer consumer;

        private AssertQuery(ConnectionFactory connectionFactory, String sql) {
            this.sql = sql;
            this.connectionFactory = connectionFactory;
        }

        protected Connection createConnection() {
            try {
                return this.connectionFactory.createConnection();
            }
            catch (SQLException e) {
                throw new IllegalStateException("Unable to create connection: connectionFactory = " + this.connectionFactory, e);
            }
        }

        public final AssertQuery withConnection(Consumer<Connection> f) {
            try (Connection c = this.createConnection();){
                f.accept(c);
            }
            catch (SQLException e) {
                TestUtil.rethrow(e);
            }
            return this;
        }

        public AssertQuery enable(boolean enabled) {
            return enabled ? this : NopAssertQuery.of(this.sql);
        }

        public AssertQuery returns(String expected) {
            return this.returns(CalciteAssert.checkResult(expected));
        }

        public AssertQuery returns2(String expected) {
            return this.returns(CalciteAssert.checkResult(expected, new ResultSetFormatter(){

                @Override
                protected String adjustValue(String s) {
                    if (s != null) {
                        if (s.contains(".")) {
                            while (s.endsWith("0")) {
                                s = s.substring(0, s.length() - 1);
                            }
                            if (s.endsWith(".")) {
                                s = s.substring(0, s.length() - 1);
                            }
                        }
                        if (s.endsWith(" 00:00:00")) {
                            s = s.substring(0, s.length() - " 00:00:00".length());
                        }
                    }
                    return s;
                }
            }));
        }

        public AssertQuery returnsValue(String expected) {
            return this.returns(CalciteAssert.checkResultValue(expected));
        }

        public AssertQuery returnsCount(int expectedCount) {
            return this.returns(CalciteAssert.checkResultCount((org.hamcrest.Matcher<Integer>)CoreMatchers.is((Object)expectedCount)));
        }

        public final AssertQuery returns(Consumer<ResultSet> checker) {
            return this.returns(this.sql, checker);
        }

        public final AssertQuery updates(int count) {
            return this.withConnection(connection -> CalciteAssert.assertQuery(connection, this.sql, this.limit, this.materializationsEnabled, this.hooks, null, CalciteAssert.checkUpdateCount(count), null));
        }

        @Deprecated
        public final AssertQuery returns(Function<ResultSet, Void> checker) {
            return this.returns(this.sql, arg_0 -> checker.apply(arg_0));
        }

        protected AssertQuery returns(String sql, Consumer<ResultSet> checker) {
            return this.withConnection(connection -> {
                if (this.consumer == null) {
                    CalciteAssert.assertQuery(connection, sql, this.limit, this.materializationsEnabled, this.hooks, checker, null, null);
                } else {
                    CalciteAssert.assertPrepare(connection, sql, this.limit, this.materializationsEnabled, this.hooks, checker, null, null, this.consumer);
                }
            });
        }

        public AssertQuery returnsUnordered(String ... lines) {
            return this.returns(CalciteAssert.checkResult(true, false, lines));
        }

        public AssertQuery returnsOrdered(String ... lines) {
            return this.returns(CalciteAssert.checkResult(false, false, lines));
        }

        public AssertQuery returnsStartingWith(String ... lines) {
            return this.returns(CalciteAssert.checkResult(false, true, lines));
        }

        public AssertQuery throws_(String message) {
            return this.withConnection(connection -> CalciteAssert.assertQuery(connection, this.sql, this.limit, this.materializationsEnabled, this.hooks, null, null, CalciteAssert.checkException(message)));
        }

        public AssertQuery failsAtValidation(String optionalMessage) {
            return this.withConnection(connection -> CalciteAssert.assertQuery(connection, this.sql, this.limit, this.materializationsEnabled, this.hooks, null, null, CalciteAssert.checkValidationException(optionalMessage)));
        }

        public AssertQuery failsAtValidation() {
            return this.failsAtValidation(null);
        }

        public AssertQuery runs() {
            return this.withConnection(connection -> {
                if (this.consumer == null) {
                    CalciteAssert.assertQuery(connection, this.sql, this.limit, this.materializationsEnabled, this.hooks, null, null, null);
                } else {
                    CalciteAssert.assertPrepare(connection, this.sql, this.limit, this.materializationsEnabled, this.hooks, null, null, null, this.consumer);
                }
            });
        }

        public AssertQuery typeIs(String expected) {
            return this.withConnection(connection -> CalciteAssert.assertQuery(connection, this.sql, this.limit, false, this.hooks, CalciteAssert.checkResultType(expected), null, null));
        }

        public final AssertQuery convertContains(String expected) {
            return this.convertMatches(CalciteAssert.checkRel(expected, null));
        }

        public final AssertQuery consumesPreparedStatement(PreparedStatementConsumer consumer) {
            this.consumer = consumer;
            return this;
        }

        public AssertQuery convertMatches(java.util.function.Function<RelNode, Void> checker) {
            return this.withConnection(connection -> CalciteAssert.assertPrepare(connection, this.sql, this.materializationsEnabled, checker, null));
        }

        public AssertQuery substitutionMatches(java.util.function.Function<RelNode, Void> checker) {
            return this.withConnection(connection -> CalciteAssert.assertPrepare(connection, this.sql, this.materializationsEnabled, null, checker));
        }

        public AssertQuery explainContains(String expected) {
            return this.explainMatches("", CalciteAssert.checkResultContains(expected));
        }

        public final AssertQuery explainMatches(String extra, Consumer<ResultSet> checker) {
            return this.returns("explain plan " + extra + "for " + this.sql, checker);
        }

        public AssertQuery planContains(String expected) {
            this.ensurePlan(null);
            Assert.assertTrue((String)("Plan [" + this.plan + "] contains [" + expected + "]"), (boolean)Util.toLinux((String)this.plan).replaceAll("\\\\r\\\\n", "\\\\n").contains(expected));
            return this;
        }

        public AssertQuery planUpdateHasSql(String expected, int count) {
            this.ensurePlan(CalciteAssert.checkUpdateCount(count));
            expected = "getDataSource(), \"" + expected.replace("\\", "\\\\").replace("\"", "\\\"").replaceAll("\n", "\\\\n") + "\"";
            Assert.assertTrue((String)("Plan [" + this.plan + "] contains [" + expected + "]"), (boolean)Util.toLinux((String)this.plan).replaceAll("\\\\r\\\\n", "\\\\n").contains(expected));
            return this;
        }

        public AssertQuery planHasSql(String expected) {
            return this.planContains("getDataSource(), \"" + expected.replace("\\", "\\\\").replace("\"", "\\\"").replaceAll("\n", "\\\\n") + "\"");
        }

        private void ensurePlan(Consumer<Integer> checkUpdate) {
            if (this.plan != null) {
                return;
            }
            this.addHook(Hook.JAVA_PLAN, a0 -> {
                this.plan = a0;
            });
            this.withConnection(connection -> {
                CalciteAssert.assertQuery(connection, this.sql, this.limit, this.materializationsEnabled, this.hooks, null, checkUpdate, null);
                Assert.assertNotNull((Object)this.plan);
            });
        }

        public AssertQuery queryContains(Consumer<List> predicate1) {
            ArrayList list = new ArrayList();
            this.addHook(Hook.QUERY_PLAN, list::add);
            return this.withConnection(connection -> {
                CalciteAssert.assertQuery(connection, this.sql, this.limit, this.materializationsEnabled, this.hooks, null, null, null);
                predicate1.accept(list);
            });
        }

        @Deprecated
        public final AssertQuery queryContains(Function<List, Void> predicate1) {
            return this.queryContains(arg_0 -> predicate1.apply(arg_0));
        }

        public AssertQuery limit(int limit) {
            this.limit = limit;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sameResultWithMaterializationsDisabled() {
            boolean save = this.materializationsEnabled;
            try {
                this.materializationsEnabled = false;
                boolean ordered = this.sql.toUpperCase(Locale.ROOT).contains("ORDER BY");
                Consumer<ResultSet> checker = CalciteAssert.consistentResult(ordered);
                this.returns(checker);
                this.materializationsEnabled = true;
                this.returns(checker);
            }
            finally {
                this.materializationsEnabled = save;
            }
        }

        public AssertQuery enableMaterializations(boolean enable) {
            this.materializationsEnabled = enable;
            return this;
        }

        @Deprecated
        public <T> AssertQuery withHook(Hook hook, java.util.function.Function<T, Void> handler) {
            return this.withHook(hook, handler::apply);
        }

        public <T> AssertQuery withHook(Hook hook, Consumer<T> handler) {
            this.addHook(hook, handler);
            return this;
        }

        private <T> void addHook(Hook hook, Consumer<T> handler) {
            this.hooks.add((Pair<Hook, Consumer>)Pair.of((Object)hook, handler));
        }

        public <V> AssertQuery withProperty(Hook hook, V value) {
            return this.withHook(hook, Hook.propertyJ(value));
        }

        public AssertQuery withRel(java.util.function.Function<RelBuilder, RelNode> relFn) {
            return this.withHook(Hook.STRING_TO_QUERY, (T pair) -> {
                RelBuilder b = RelBuilder.create((FrameworkConfig)((FrameworkConfig)pair.left));
                ((Holder)pair.right).set((Object)CalcitePrepare.Query.of((RelNode)((RelNode)relFn.apply(b))));
            });
        }
    }

    private static class MapConnectionFactory
    extends ConnectionFactory {
        private final ImmutableMap<String, String> map;
        private final ImmutableList<ConnectionPostProcessor> postProcessors;

        private MapConnectionFactory(ImmutableMap<String, String> map, ImmutableList<ConnectionPostProcessor> postProcessors) {
            this.map = Objects.requireNonNull(map);
            this.postProcessors = Objects.requireNonNull(postProcessors);
        }

        public boolean equals(Object obj) {
            return this == obj || obj.getClass() == MapConnectionFactory.class && ((MapConnectionFactory)obj).map.equals(this.map) && ((MapConnectionFactory)obj).postProcessors.equals(this.postProcessors);
        }

        public int hashCode() {
            return Objects.hash(this.map, this.postProcessors);
        }

        @Override
        public Connection createConnection() throws SQLException {
            Properties info = new Properties();
            for (Map.Entry entry : this.map.entrySet()) {
                info.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            Connection connection = DriverManager.getConnection("jdbc:calcite:", info);
            for (ConnectionPostProcessor postProcessor : this.postProcessors) {
                connection = postProcessor.apply(connection);
            }
            return connection;
        }

        @Override
        public ConnectionFactory with(String property, Object value) {
            return new MapConnectionFactory((ImmutableMap<String, String>)FlatLists.append(this.map, (Object)property, (Object)value.toString()), this.postProcessors);
        }

        @Override
        public ConnectionFactory with(ConnectionProperty property, Object value) {
            if (!property.type().valid(value, property.valueClass())) {
                throw new IllegalArgumentException();
            }
            return this.with(property.camelName(), (Object)value.toString());
        }

        @Override
        public ConnectionFactory with(ConnectionPostProcessor postProcessor) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(this.postProcessors);
            builder.add((Object)postProcessor);
            return new MapConnectionFactory(this.map, (ImmutableList<ConnectionPostProcessor>)builder.build());
        }
    }

    private static class PoolingConnectionFactory
    extends ConnectionFactory {
        private final PoolingDataSource dataSource;

        PoolingConnectionFactory(ConnectionFactory factory) {
            PoolableConnectionFactory connectionFactory = new PoolableConnectionFactory(factory::createConnection, null);
            connectionFactory.setRollbackOnReturn(false);
            this.dataSource = new PoolingDataSource((ObjectPool)new GenericObjectPool((PooledObjectFactory)connectionFactory));
        }

        @Override
        public Connection createConnection() throws SQLException {
            return this.dataSource.getConnection();
        }
    }

    public static class AddSchemaSpecPostProcessor
    implements ConnectionPostProcessor {
        private final SchemaSpec schemaSpec;

        public AddSchemaSpecPostProcessor(SchemaSpec schemaSpec) {
            this.schemaSpec = schemaSpec;
        }

        @Override
        public Connection apply(Connection connection) throws SQLException {
            CalciteConnection con = connection.unwrap(CalciteConnection.class);
            SchemaPlus rootSchema = con.getRootSchema();
            switch (this.schemaSpec) {
                case JDBC_FOODMART_WITH_LATTICE: 
                case CLONE_FOODMART: {
                    CalciteAssert.addSchema(rootSchema, SchemaSpec.JDBC_FOODMART);
                }
            }
            CalciteAssert.addSchema(rootSchema, this.schemaSpec);
            con.setSchema(this.schemaSpec.schemaName);
            return connection;
        }
    }

    public static class DefaultSchemaPostProcessor
    implements ConnectionPostProcessor {
        private final String name;

        public DefaultSchemaPostProcessor(String name) {
            this.name = name;
        }

        @Override
        public Connection apply(Connection connection) throws SQLException {
            connection.setSchema(this.name);
            return connection;
        }
    }

    public static class AddSchemaPostProcessor
    implements ConnectionPostProcessor {
        private final String name;
        private final Schema schema;

        public AddSchemaPostProcessor(String name, Schema schema) {
            this.name = Objects.requireNonNull(name);
            this.schema = Objects.requireNonNull(schema);
        }

        @Override
        public Connection apply(Connection connection) throws SQLException {
            if (this.schema != null) {
                CalciteConnection con = connection.unwrap(CalciteConnection.class);
                SchemaPlus rootSchema = con.getRootSchema();
                rootSchema.add(this.name, this.schema);
            }
            connection.setSchema(this.name);
            return connection;
        }
    }

    @FunctionalInterface
    public static interface ConnectionPostProcessor {
        public Connection apply(Connection var1) throws SQLException;
    }

    public static abstract class ConnectionFactory {
        public abstract Connection createConnection() throws SQLException;

        public ConnectionFactory with(String property, Object value) {
            throw new UnsupportedOperationException();
        }

        public ConnectionFactory with(ConnectionProperty property, Object value) {
            throw new UnsupportedOperationException();
        }

        public ConnectionFactory with(ConnectionPostProcessor postProcessor) {
            throw new UnsupportedOperationException();
        }
    }

    public static class AssertThat {
        private final ConnectionFactory connectionFactory;
        private static final AssertThat EMPTY = new AssertThat(EMPTY_CONNECTION_FACTORY);

        private AssertThat(ConnectionFactory connectionFactory) {
            this.connectionFactory = Objects.requireNonNull(connectionFactory);
        }

        public AssertThat with(Config config) {
            switch (config) {
                case EMPTY: {
                    return EMPTY;
                }
                case REGULAR: {
                    return this.with(SchemaSpec.HR, SchemaSpec.REFLECTIVE_FOODMART, SchemaSpec.POST);
                }
                case REGULAR_PLUS_METADATA: {
                    return this.with(SchemaSpec.HR, SchemaSpec.REFLECTIVE_FOODMART);
                }
                case GEO: {
                    return this.with(SchemaSpec.GEO).with((ConnectionProperty)CalciteConnectionProperty.CONFORMANCE, (Object)SqlConformanceEnum.LENIENT);
                }
                case LINGUAL: {
                    return this.with(SchemaSpec.LINGUAL);
                }
                case JDBC_FOODMART: {
                    return this.with(SchemaSpec.JDBC_FOODMART);
                }
                case FOODMART_CLONE: {
                    return this.with(SchemaSpec.CLONE_FOODMART);
                }
                case JDBC_FOODMART_WITH_LATTICE: {
                    return this.with(SchemaSpec.JDBC_FOODMART_WITH_LATTICE);
                }
                case JDBC_SCOTT: {
                    return this.with(SchemaSpec.JDBC_SCOTT);
                }
                case SCOTT: {
                    return this.with(SchemaSpec.SCOTT);
                }
                case SPARK: {
                    return this.with((ConnectionProperty)CalciteConnectionProperty.SPARK, (Object)true);
                }
                case AUX: {
                    return this.with(SchemaSpec.AUX, SchemaSpec.POST);
                }
            }
            throw Util.unexpected((Enum)config);
        }

        public AssertThat with(SchemaSpec ... specs) {
            AssertThat next = this;
            for (SchemaSpec spec : specs) {
                next = next.with(new AddSchemaSpecPostProcessor(spec));
            }
            return next;
        }

        public AssertThat with(ConnectionFactory connectionFactory) {
            return new AssertThat(connectionFactory);
        }

        public final AssertThat with(Map<String, String> map) {
            AssertThat x = this;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                x = this.with(entry.getKey(), (Object)entry.getValue());
            }
            return x;
        }

        public AssertThat with(String property, Object value) {
            return new AssertThat(this.connectionFactory.with(property, value));
        }

        public AssertThat with(ConnectionProperty property, Object value) {
            if (!property.type().valid(value, property.valueClass())) {
                throw new IllegalArgumentException();
            }
            return new AssertThat(this.connectionFactory.with(property, value));
        }

        public AssertThat with(Lex lex) {
            return this.with((ConnectionProperty)CalciteConnectionProperty.LEX, (Object)lex);
        }

        public AssertThat withSchema(String name, Schema schema) {
            return new AssertThat(this.connectionFactory.with(new AddSchemaPostProcessor(name, schema)));
        }

        public AssertThat withDefaultSchema(String schema) {
            return new AssertThat(this.connectionFactory.with(new DefaultSchemaPostProcessor(schema)));
        }

        public AssertThat with(ConnectionPostProcessor postProcessor) {
            return new AssertThat(this.connectionFactory.with(postProcessor));
        }

        public final AssertThat withModel(String model) {
            return this.with((ConnectionProperty)CalciteConnectionProperty.MODEL, (Object)("inline:" + model));
        }

        public final AssertThat withModel(URL model) {
            return this.with((ConnectionProperty)CalciteConnectionProperty.MODEL, (Object)Sources.of((URL)model).file().getAbsolutePath());
        }

        public final AssertThat withMaterializations(String model, String ... materializations) {
            return this.withMaterializations(model, false, materializations);
        }

        public final AssertThat withMaterializations(String model, boolean existing, String ... materializations) {
            return this.withMaterializations(model, (JsonBuilder builder) -> {
                assert (materializations.length % 2 == 0);
                List list = builder.list();
                for (int i = 0; i < materializations.length; ++i) {
                    String table = materializations[i++];
                    Map map = builder.map();
                    map.put("table", table);
                    if (!existing) {
                        map.put("view", table + "v");
                    }
                    String sql = materializations[i];
                    String sql2 = sql.replaceAll("`", "\"");
                    map.put("sql", sql2);
                    list.add(map);
                }
                return list;
            });
        }

        public final AssertThat withMaterializations(String model, java.util.function.Function<JsonBuilder, List<Object>> materializations) {
            String model2;
            JsonBuilder builder = new JsonBuilder();
            List<Object> list = materializations.apply(builder);
            String buf = "materializations: " + builder.toJsonString(list);
            if (model.contains("defaultSchema: 'foodmart'")) {
                int endIndex = model.lastIndexOf(93);
                model2 = model.substring(0, endIndex) + ", \n{ name: 'mat', " + buf + "}\n]" + model.substring(endIndex + 1);
            } else if (model.contains("type: ")) {
                model2 = model.replaceFirst("type: ", Matcher.quoteReplacement(buf + ",\ntype: "));
            } else {
                throw new AssertionError((Object)"do not know where to splice");
            }
            return this.withModel(model2);
        }

        public AssertQuery query(String sql) {
            return new AssertQuery(this.connectionFactory, sql);
        }

        public AssertThat connectThrows(String message) {
            return this.connectThrows(CalciteAssert.checkException(message));
        }

        public AssertThat connectThrows(Consumer<Throwable> exceptionChecker) {
            Throwable throwable;
            try (Connection x = this.connectionFactory.createConnection();){
                try {
                    x.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throwable = null;
            }
            catch (Throwable e) {
                throwable = e;
            }
            exceptionChecker.accept(throwable);
            return this;
        }

        public <T> AssertThat doWithConnection(java.util.function.Function<CalciteConnection, T> fn) throws Exception {
            try (Connection connection = this.connectionFactory.createConnection();){
                T t = fn.apply((CalciteConnection)connection);
                Util.discard(t);
                AssertThat assertThat = this;
                return assertThat;
            }
        }

        public final AssertThat doWithConnection(Consumer<CalciteConnection> fn) throws Exception {
            return this.doWithConnection((CalciteConnection c) -> {
                fn.accept((CalciteConnection)c);
                return null;
            });
        }

        public <T> AssertThat doWithDataContext(java.util.function.Function<DataContext, T> fn) throws Exception {
            try (CalciteConnection connection = (CalciteConnection)this.connectionFactory.createConnection();){
                DataContext dataContext = CalciteMetaImpl.createDataContext((CalciteConnection)connection);
                T t = fn.apply(dataContext);
                Util.discard(t);
                AssertThat assertThat = this;
                return assertThat;
            }
        }

        public Connection connect() throws SQLException {
            return this.connectionFactory.createConnection();
        }

        public AssertThat enable(boolean enabled) {
            return enabled ? this : DISABLED;
        }

        public AssertThat pooled() {
            if (this.connectionFactory instanceof PoolingConnectionFactory) {
                return this;
            }
            return new AssertThat(new PoolingConnectionFactory(this.connectionFactory));
        }

        public AssertMetaData metaData(java.util.function.Function<Connection, ResultSet> function) {
            return new AssertMetaData(this.connectionFactory, function);
        }
    }
}

