/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;

class PlannerTests {
    static final Convention PHYS_CALLING_CONVENTION = new Convention.Impl("PHYS", RelNode.class){

        public boolean canConvertConvention(Convention toConvention) {
            return true;
        }

        public boolean useAbstractConvertersForConversion(RelTraitSet fromTraits, RelTraitSet toTraits) {
            return true;
        }
    };

    private PlannerTests() {
    }

    static RelOptCluster newCluster(VolcanoPlanner planner) {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        return RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)new RexBuilder((RelDataTypeFactory)typeFactory));
    }

    static class GoodSingleRule
    extends RelOptRule {
        GoodSingleRule() {
            super(GoodSingleRule.operand(NoneSingleRel.class, (RelOptRuleOperandChildren)GoodSingleRule.any()));
        }

        public Convention getOutConvention() {
            return PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            NoneSingleRel single = (NoneSingleRel)call.rel(0);
            RelNode input = single.getInput();
            RelNode physInput = GoodSingleRule.convert((RelNode)input, (RelTraitSet)single.getTraitSet().replace((RelTrait)PHYS_CALLING_CONVENTION));
            call.transformTo((RelNode)new PhysSingleRel(single.getCluster(), physInput));
        }
    }

    static class PhysLeafRule
    extends RelOptRule {
        PhysLeafRule() {
            super(PhysLeafRule.operand(NoneLeafRel.class, (RelOptRuleOperandChildren)PhysLeafRule.any()));
        }

        public Convention getOutConvention() {
            return PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            NoneLeafRel leafRel = (NoneLeafRel)call.rel(0);
            call.transformTo((RelNode)new PhysLeafRel(leafRel.getCluster(), leafRel.label));
        }
    }

    static class PhysSingleRel
    extends TestSingleRel {
        PhysSingleRel(RelOptCluster cluster, RelNode input) {
            super(cluster, cluster.traitSetOf((RelTrait)PHYS_CALLING_CONVENTION), input);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeTinyCost();
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (traitSet.comprises(new RelTrait[]{PHYS_CALLING_CONVENTION}));
            return new PhysSingleRel(this.getCluster(), (RelNode)PhysSingleRel.sole(inputs));
        }
    }

    static class PhysLeafRel
    extends TestLeafRel {
        PhysLeafRel(RelOptCluster cluster, String label) {
            super(cluster, cluster.traitSetOf((RelTrait)PHYS_CALLING_CONVENTION), label);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeTinyCost();
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (traitSet.comprises(new RelTrait[]{PHYS_CALLING_CONVENTION}));
            assert (inputs.isEmpty());
            return this;
        }
    }

    static class NoneLeafRel
    extends TestLeafRel {
        NoneLeafRel(RelOptCluster cluster, String label) {
            super(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), label);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (traitSet.comprises(new RelTrait[]{Convention.NONE}));
            assert (inputs.isEmpty());
            return this;
        }
    }

    static class NoneSingleRel
    extends TestSingleRel {
        NoneSingleRel(RelOptCluster cluster, RelNode input) {
            super(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), input);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (traitSet.comprises(new RelTrait[]{Convention.NONE}));
            return new NoneSingleRel(this.getCluster(), (RelNode)NoneSingleRel.sole(inputs));
        }
    }

    static abstract class TestSingleRel
    extends SingleRel {
        TestSingleRel(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
            super(cluster, traits, input);
        }

        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeInfiniteCost();
        }

        protected RelDataType deriveRowType() {
            return this.getInput().getRowType();
        }
    }

    static abstract class TestLeafRel
    extends AbstractRelNode {
        final String label;

        TestLeafRel(RelOptCluster cluster, RelTraitSet traits, String label) {
            super(cluster, traits);
            this.label = label;
        }

        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeInfiniteCost();
        }

        protected RelDataType deriveRowType() {
            RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
            return typeFactory.builder().add("this", typeFactory.createJavaType(Void.TYPE)).build();
        }

        public RelWriter explainTerms(RelWriter pw) {
            return super.explainTerms(pw).item("label", (Object)this.label);
        }
    }
}

