/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.util.Util;
import org.junit.ComparisonFailure;

public abstract class TestUtil {
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("\r\n|\r|\n");
    private static final Pattern TAB_PATTERN = Pattern.compile("\t");
    private static final String LINE_BREAK = "\\\\n\"" + Util.LINE_SEPARATOR + " + \"";
    private static final String JAVA_VERSION = System.getProperties().getProperty("java.version");

    public static void assertEqualsVerbose(String expected, String actual) {
        if (actual == null) {
            if (expected == null) {
                return;
            }
            String message = "Expected:\n" + expected + "\nActual: null";
            throw new ComparisonFailure(message, expected, null);
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        String s = TestUtil.toJavaString(actual);
        String message = "Expected:\n" + expected + "\nActual:\n" + actual + "\nActual java:\n" + s + '\n';
        throw new ComparisonFailure(message, expected, actual);
    }

    public static String quoteForJava(String s) {
        s = Util.replace((String)s, (String)"\\", (String)"\\\\");
        s = Util.replace((String)s, (String)"\"", (String)"\\\"");
        s = LINE_BREAK_PATTERN.matcher(s).replaceAll(LINE_BREAK);
        s = TAB_PATTERN.matcher(s).replaceAll("\\\\t");
        s = "\"" + s + "\"";
        String spurious = " + \n\"\"";
        if (s.endsWith(" + \n\"\"")) {
            s = s.substring(0, s.length() - " + \n\"\"".length());
        }
        return s;
    }

    public static String toJavaString(String s) {
        String spurious;
        s = Util.replace((String)s, (String)"\"", (String)"\\\"");
        s = LINE_BREAK_PATTERN.matcher(s).replaceAll(LINE_BREAK);
        s = TAB_PATTERN.matcher(s).replaceAll("\\\\t");
        s = "\"" + s + "\"";
        if (s.endsWith(spurious = "\n \\+ \"\"")) {
            s = s.substring(0, s.length() - spurious.length());
        }
        return s;
    }

    public static String fold(String ... strings) {
        StringBuilder buf = new StringBuilder();
        for (String string : strings) {
            buf.append(string);
            buf.append('\n');
        }
        return buf.toString();
    }

    public static String escapeString(String s) {
        return TestUtil.escapeString(new StringBuilder(), s).toString();
    }

    public static StringBuilder escapeString(StringBuilder buf, String s) {
        buf.append('\"');
        int n = s.length();
        int lastChar = 0;
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\r': {
                    if (lastChar == 10) break;
                    buf.append("\\r");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            lastChar = c;
        }
        return buf.append('\"');
    }

    public static String quotePattern(String s) {
        return s.replaceAll("\\\\", "\\\\").replaceAll("\\.", "\\\\.").replaceAll("\\+", "\\\\+").replaceAll("\\{", "\\\\{").replaceAll("\\}", "\\\\}").replaceAll("\\|", "\\\\||").replaceAll("[$]", "\\\\\\$").replaceAll("\\?", "\\\\?").replaceAll("\\*", "\\\\*").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]");
    }

    public static int getJavaMajorVersion() {
        return TestUtil.majorVersionFromString(JAVA_VERSION);
    }

    @VisibleForTesting
    static int majorVersionFromString(String version) {
        Objects.requireNonNull(version, "version");
        if (version.startsWith("1.")) {
            String[] versions = version.split("\\.");
            return Integer.parseInt(versions[1]);
        }
        Matcher matcher = Pattern.compile("^\\d+").matcher(version);
        if (!matcher.lookingAt()) {
            throw new IllegalArgumentException("Can't parse (detect) JDK version from " + version);
        }
        return Integer.parseInt(matcher.group());
    }

    public static boolean hasMessage(Throwable t, String substring) {
        while (t != null) {
            String message = t.getMessage();
            if (message != null && message.contains(substring)) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }

    public static <E extends Throwable> RuntimeException rethrow(Throwable e) throws E {
        if (e instanceof InvocationTargetException) {
            e = e.getCause();
        }
        throw e;
    }

    public static <E extends Throwable> RuntimeException rethrow(Throwable e, String message) throws E {
        e.addSuppressed(new ExtraInformation(message));
        throw e;
    }

    public static String printStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    private static class ExtraInformation
    extends Throwable {
        ExtraInformation(String message) {
            super(message);
        }
    }
}

