/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableSet;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Properties;
import java.util.Set;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.externalize.RelXmlWriter;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlDelegatingConformance;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.test.DiffRepository;
import org.apache.calcite.test.SqlToRelTestBase;
import org.apache.calcite.test.SqlValidatorTest;
import org.apache.calcite.test.catalog.MockCatalogReaderExtended;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SqlToRelConverterTest
extends SqlToRelTestBase {
    @Override
    protected DiffRepository getDiffRepos() {
        return DiffRepository.lookup(SqlToRelConverterTest.class);
    }

    public final Sql sql(String sql) {
        return new Sql(sql, true, true, this.tester, false, SqlToRelConverter.Config.DEFAULT, this.tester.getConformance());
    }

    protected final void check(String sql, String plan) {
        this.sql(sql).convertsTo(plan);
    }

    @Test
    public void testDotLiteralAfterNestedRow() {
        String sql = "select ((1,2),(3,4,5)).\"EXPR$1\".\"EXPR$2\" from emp";
        this.sql("select ((1,2),(3,4,5)).\"EXPR$1\".\"EXPR$2\" from emp").ok();
    }

    @Test
    public void testDotLiteralAfterRow() {
        String sql = "select row(1,2).\"EXPR$1\" from emp";
        this.sql("select row(1,2).\"EXPR$1\" from emp").ok();
    }

    @Test
    public void testIntegerLiteral() {
        String sql = "select 1 from emp";
        this.sql("select 1 from emp").ok();
    }

    @Test
    public void testIntervalLiteralYearToMonth() {
        String sql = "select\n  cast(empno as Integer) * (INTERVAL '1-1' YEAR TO MONTH)\nfrom emp";
        this.sql("select\n  cast(empno as Integer) * (INTERVAL '1-1' YEAR TO MONTH)\nfrom emp").ok();
    }

    @Test
    public void testIntervalLiteralHourToMinute() {
        String sql = "select\n cast(empno as Integer) * (INTERVAL '1:1' HOUR TO MINUTE)\nfrom emp";
        this.sql("select\n cast(empno as Integer) * (INTERVAL '1:1' HOUR TO MINUTE)\nfrom emp").ok();
    }

    @Test
    public void testAliasList() {
        String sql = "select a + b from (\n  select deptno, 1 as uno, name from dept\n) as d(a, b, c)\nwhere c like 'X%'";
        this.sql("select a + b from (\n  select deptno, 1 as uno, name from dept\n) as d(a, b, c)\nwhere c like 'X%'").ok();
    }

    @Test
    public void testAliasList2() {
        String sql = "select * from (\n  select a, b, c from (values (1, 2, 3)) as t (c, b, a)\n) join dept on dept.deptno = c\norder by c + a";
        this.sql("select * from (\n  select a, b, c from (values (1, 2, 3)) as t (c, b, a)\n) join dept on dept.deptno = c\norder by c + a").ok();
    }

    @Test
    public void testStructTypeAlias() {
        String sql = "select t.r AS myRow \nfrom (select row(row(1)) r from dept) t";
        this.sql("select t.r AS myRow \nfrom (select row(row(1)) r from dept) t").ok();
    }

    @Test
    public void testJoinUsingDynamicTable() {
        String sql = "select * from SALES.NATION t1\njoin SALES.NATION t2\nusing (n_nationkey)";
        this.sql("select * from SALES.NATION t1\njoin SALES.NATION t2\nusing (n_nationkey)").with(this.getTesterWithDynamicTable()).ok();
    }

    @Test
    public void testMultiAnd() {
        String sql = "select * from emp\nwhere deptno < 10\nand deptno > 5\nand (deptno = 8 or empno < 100)";
        this.sql("select * from emp\nwhere deptno < 10\nand deptno > 5\nand (deptno = 8 or empno < 100)").ok();
    }

    @Test
    public void testJoinOn() {
        String sql = "SELECT * FROM emp\nJOIN dept on emp.deptno = dept.deptno";
        this.sql("SELECT * FROM emp\nJOIN dept on emp.deptno = dept.deptno").ok();
    }

    @Test
    public void testConditionOffByOne() {
        String sql = "SELECT * FROM emp\nJOIN dept on emp.deptno + 0 = dept.deptno";
        this.sql("SELECT * FROM emp\nJOIN dept on emp.deptno + 0 = dept.deptno").ok();
    }

    @Test
    public void testConditionOffByOneReversed() {
        String sql = "SELECT * FROM emp\nJOIN dept on dept.deptno = emp.deptno + 0";
        this.sql("SELECT * FROM emp\nJOIN dept on dept.deptno = emp.deptno + 0").ok();
    }

    @Test
    public void testJoinOnExpression() {
        String sql = "SELECT * FROM emp\nJOIN dept on emp.deptno + 1 = dept.deptno - 2";
        this.sql("SELECT * FROM emp\nJOIN dept on emp.deptno + 1 = dept.deptno - 2").ok();
    }

    @Test
    public void testJoinOnIn() {
        String sql = "select * from emp join dept\n on emp.deptno = dept.deptno and emp.empno in (1, 3)";
        this.sql("select * from emp join dept\n on emp.deptno = dept.deptno and emp.empno in (1, 3)").ok();
    }

    @Test
    public void testJoinOnInSubQuery() {
        String sql = "select * from emp left join dept\non emp.empno = 1\nor dept.deptno in (select deptno from emp where empno > 5)";
        this.sql("select * from emp left join dept\non emp.empno = 1\nor dept.deptno in (select deptno from emp where empno > 5)").expand(false).ok();
    }

    @Test
    public void testJoinOnExists() {
        String sql = "select * from emp left join dept\non emp.empno = 1\nor exists (select deptno from emp where empno > dept.deptno + 5)";
        this.sql("select * from emp left join dept\non emp.empno = 1\nor exists (select deptno from emp where empno > dept.deptno + 5)").expand(false).ok();
    }

    @Test
    public void testJoinUsing() {
        this.sql("SELECT * FROM emp JOIN dept USING (deptno)").ok();
    }

    @Test
    public void testJoinUsingThreeWay() {
        String sql = "select *\nfrom emp as e\njoin dept as d using (deptno)\njoin emp as e2 using (empno)";
        this.sql("select *\nfrom emp as e\njoin dept as d using (deptno)\njoin emp as e2 using (empno)").ok();
    }

    @Test
    public void testJoinUsingCompound() {
        String sql = "SELECT * FROM emp LEFT JOIN (SELECT *, deptno * 5 as empno FROM dept) USING (deptno,empno)";
        this.sql("SELECT * FROM emp LEFT JOIN (SELECT *, deptno * 5 as empno FROM dept) USING (deptno,empno)").ok();
    }

    @Test
    public void testValuesUsing() {
        String sql = "select d.deptno, min(e.empid) as empid\nfrom (values (100, 'Bill', 1)) as e(empid, name, deptno)\njoin (values (1, 'LeaderShip')) as d(deptno, name)\n  using (deptno)\ngroup by d.deptno";
        this.sql("select d.deptno, min(e.empid) as empid\nfrom (values (100, 'Bill', 1)) as e(empid, name, deptno)\njoin (values (1, 'LeaderShip')) as d(deptno, name)\n  using (deptno)\ngroup by d.deptno").ok();
    }

    @Test
    public void testJoinNatural() {
        this.sql("SELECT * FROM emp NATURAL JOIN dept").ok();
    }

    @Test
    public void testJoinNaturalNoCommonColumn() {
        String sql = "SELECT *\nFROM emp NATURAL JOIN (SELECT deptno AS foo, name FROM dept) AS d";
        this.sql("SELECT *\nFROM emp NATURAL JOIN (SELECT deptno AS foo, name FROM dept) AS d").ok();
    }

    @Test
    public void testJoinNaturalMultipleCommonColumn() {
        String sql = "SELECT *\nFROM emp\nNATURAL JOIN (SELECT deptno, name AS ename FROM dept) AS d";
        this.sql("SELECT *\nFROM emp\nNATURAL JOIN (SELECT deptno, name AS ename FROM dept) AS d").ok();
    }

    @Test
    public void testJoinWithUnion() {
        String sql = "select grade\nfrom (select empno from emp union select deptno from dept),\n  salgrade";
        this.sql("select grade\nfrom (select empno from emp union select deptno from dept),\n  salgrade").ok();
    }

    @Test
    public void testGroup() {
        this.sql("select deptno from emp group by deptno").ok();
    }

    @Test
    public void testGroupByAlias() {
        this.sql("select empno as d from emp group by d").conformance((SqlConformance)SqlConformanceEnum.LENIENT).ok();
    }

    @Test
    public void testGroupByAliasOfSubExpressionsInProject() {
        String sql = "select deptno+empno as d, deptno+empno+mgr\nfrom emp group by d,mgr";
        this.sql("select deptno+empno as d, deptno+empno+mgr\nfrom emp group by d,mgr").conformance((SqlConformance)SqlConformanceEnum.LENIENT).ok();
    }

    @Test
    public void testGroupByAliasEqualToColumnName() {
        this.sql("select empno, ename as deptno from emp group by empno, deptno").conformance((SqlConformance)SqlConformanceEnum.LENIENT).ok();
    }

    @Test
    public void testGroupByOrdinal() {
        this.sql("select empno from emp group by 1").conformance((SqlConformance)SqlConformanceEnum.LENIENT).ok();
    }

    @Test
    public void testGroupByContainsLiterals() {
        String sql = "select count(*) from (\n  select 1 from emp group by substring(ename from 2 for 3))";
        this.sql("select count(*) from (\n  select 1 from emp group by substring(ename from 2 for 3))").conformance((SqlConformance)SqlConformanceEnum.LENIENT).ok();
    }

    @Test
    public void testAliasInHaving() {
        this.sql("select count(empno) as e from emp having e > 1").conformance((SqlConformance)SqlConformanceEnum.LENIENT).ok();
    }

    @Test
    public void testGroupJustOneAgg() {
        String sql = "select deptno, sum(sal) as sum_sal from emp group by deptno";
        this.sql("select deptno, sum(sal) as sum_sal from emp group by deptno").ok();
    }

    @Test
    public void testGroupExpressionsInsideAndOut() {
        String sql = "select\n  deptno + 4, sum(sal), sum(3 + sal), 2 * count(sal)\nfrom emp group by deptno";
        this.sql("select\n  deptno + 4, sum(sal), sum(3 + sal), 2 * count(sal)\nfrom emp group by deptno").ok();
    }

    @Test
    public void testAggregateNoGroup() {
        this.sql("select sum(deptno) from emp").ok();
    }

    @Test
    public void testGroupEmpty() {
        this.sql("select sum(deptno) from emp group by ()").ok();
    }

    @Test
    public void testSingletonGroupingSet() {
        this.sql("select sum(sal) from emp group by grouping sets (deptno)").ok();
    }

    @Test
    public void testGroupingSets() {
        String sql = "select deptno, ename, sum(sal) from emp\ngroup by grouping sets ((deptno), (ename, deptno))\norder by 2";
        this.sql("select deptno, ename, sum(sal) from emp\ngroup by grouping sets ((deptno), (ename, deptno))\norder by 2").ok();
    }

    @Test
    public void testGroupingSetsWithRollup() {
        String sql = "select deptno, ename, sum(sal) from emp\ngroup by grouping sets ( rollup(deptno), (ename, deptno))\norder by 2";
        this.sql("select deptno, ename, sum(sal) from emp\ngroup by grouping sets ( rollup(deptno), (ename, deptno))\norder by 2").ok();
    }

    @Test
    public void testGroupingSetsWithCube() {
        String sql = "select deptno, ename, sum(sal) from emp\ngroup by grouping sets ( (deptno), CUBE(ename, deptno))\norder by 2";
        this.sql("select deptno, ename, sum(sal) from emp\ngroup by grouping sets ( (deptno), CUBE(ename, deptno))\norder by 2").ok();
    }

    @Test
    public void testGroupingSetsWithRollupCube() {
        String sql = "select deptno, ename, sum(sal) from emp\ngroup by grouping sets ( CUBE(deptno), ROLLUP(ename, deptno))\norder by 2";
        this.sql("select deptno, ename, sum(sal) from emp\ngroup by grouping sets ( CUBE(deptno), ROLLUP(ename, deptno))\norder by 2").ok();
    }

    @Test
    public void testGroupingSetsProduct() {
        String sql = "select 1\nfrom (values (0, 1, 2, 3, 4)) as t(a, b, c, x, y)\ngroup by grouping sets ((a, b), c), grouping sets ((x, y), ())";
        this.sql("select 1\nfrom (values (0, 1, 2, 3, 4)) as t(a, b, c, x, y)\ngroup by grouping sets ((a, b), c), grouping sets ((x, y), ())").ok();
    }

    @Test
    public void testGroupingFunctionWithGroupBy() {
        String sql = "select\n  deptno, grouping(deptno), count(*), grouping(empno)\nfrom emp\ngroup by empno, deptno\norder by 2";
        this.sql("select\n  deptno, grouping(deptno), count(*), grouping(empno)\nfrom emp\ngroup by empno, deptno\norder by 2").ok();
    }

    @Test
    public void testGroupingFunction() {
        String sql = "select\n  deptno, grouping(deptno), count(*), grouping(empno)\nfrom emp\ngroup by rollup(empno, deptno)";
        this.sql("select\n  deptno, grouping(deptno), count(*), grouping(empno)\nfrom emp\ngroup by rollup(empno, deptno)").ok();
    }

    @Test
    public void testGroupByWithDuplicates() {
        this.sql("select sum(sal) from emp group by (), ()").ok();
    }

    @Test
    public void testDuplicateGroupingSets() {
        String sql = "select sum(sal) from emp\ngroup by sal,\n  grouping sets (deptno,\n    grouping sets ((deptno, ename), ename),\n      (ename)),\n  ()";
        this.sql("select sum(sal) from emp\ngroup by sal,\n  grouping sets (deptno,\n    grouping sets ((deptno, ename), ename),\n      (ename)),\n  ()").ok();
    }

    @Test
    public void testGroupingSetsCartesianProduct() {
        String sql = "select 1\nfrom (values (1, 2, 3, 4)) as t(a, b, c, d)\ngroup by grouping sets (a, b), grouping sets (c, d)";
        this.sql("select 1\nfrom (values (1, 2, 3, 4)) as t(a, b, c, d)\ngroup by grouping sets (a, b), grouping sets (c, d)").ok();
    }

    @Test
    public void testGroupingSetsCartesianProduct2() {
        String sql = "select 1\nfrom (values (1, 2, 3, 4)) as t(a, b, c, d)\ngroup by grouping sets (a, (a, b)), grouping sets (c), d";
        this.sql("select 1\nfrom (values (1, 2, 3, 4)) as t(a, b, c, d)\ngroup by grouping sets (a, (a, b)), grouping sets (c), d").ok();
    }

    @Test
    public void testRollupSimple() {
        String sql = "select a, b, count(*) as c\nfrom (values (cast(null as integer), 2)) as t(a, b)\ngroup by rollup(a, b)";
        this.sql("select a, b, count(*) as c\nfrom (values (cast(null as integer), 2)) as t(a, b)\ngroup by rollup(a, b)").ok();
    }

    @Test
    public void testRollup() {
        String sql = "select 1\nfrom (values (1, 2, 3, 4)) as t(a, b, c, d)\ngroup by rollup(a, b), rollup(c, d)";
        this.sql("select 1\nfrom (values (1, 2, 3, 4)) as t(a, b, c, d)\ngroup by rollup(a, b), rollup(c, d)").ok();
    }

    @Test
    public void testRollupTuples() {
        String sql = "select 1\nfrom (values (1, 2, 3, 4)) as t(a, b, c, d)\ngroup by rollup(b, (a, d))";
        this.sql("select 1\nfrom (values (1, 2, 3, 4)) as t(a, b, c, d)\ngroup by rollup(b, (a, d))").ok();
    }

    @Test
    public void testCube() {
        String sql = "select 1\nfrom (values (1, 2, 3, 4)) as t(a, b, c, d)\ngroup by cube(a, b)";
        this.sql("select 1\nfrom (values (1, 2, 3, 4)) as t(a, b, c, d)\ngroup by cube(a, b)").ok();
    }

    @Test
    public void testGroupingSetsWith() {
        String sql = "with t(a, b, c, d) as (values (1, 2, 3, 4))\nselect 1 from t\ngroup by rollup(a, b), rollup(c, d)";
        this.sql("with t(a, b, c, d) as (values (1, 2, 3, 4))\nselect 1 from t\ngroup by rollup(a, b), rollup(c, d)").ok();
    }

    @Test
    public void testHaving() {
        String sql = "select sum(sal + sal) from emp having sum(sal) > 10";
        this.sql("select sum(sal + sal) from emp having sum(sal) > 10").ok();
    }

    @Test
    public void testGroupBug281() {
        String sql = "select name from (select name from dept group by name)";
        this.sql("select name from (select name from dept group by name)").ok();
    }

    @Test
    public void testGroupBug281b() {
        String sql = "select name, foo from (\nselect deptno, name, count(deptno) as foo\nfrom dept\ngroup by name, deptno, name)";
        this.sql("select name, foo from (\nselect deptno, name, count(deptno) as foo\nfrom dept\ngroup by name, deptno, name)").ok();
    }

    @Test
    public void testGroupByExpression() {
        String sql = "select count(*)\nfrom emp\ngroup by substring(ename FROM 1 FOR 1)";
        this.sql("select count(*)\nfrom emp\ngroup by substring(ename FROM 1 FOR 1)").ok();
    }

    @Test
    public void testAggDistinct() {
        String sql = "select deptno, sum(sal), sum(distinct sal), count(*)\nfrom emp\ngroup by deptno";
        this.sql("select deptno, sum(sal), sum(distinct sal), count(*)\nfrom emp\ngroup by deptno").ok();
    }

    @Test
    public void testAggFilter() {
        String sql = "select\n  deptno, sum(sal * 2) filter (where empno < 10), count(*)\nfrom emp\ngroup by deptno";
        this.sql("select\n  deptno, sum(sal * 2) filter (where empno < 10), count(*)\nfrom emp\ngroup by deptno").ok();
    }

    @Test
    public void testAggFilterWithIn() {
        String sql = "select\n  deptno, sum(sal * 2) filter (where empno not in (1, 2)), count(*)\nfrom emp\ngroup by deptno";
        this.sql("select\n  deptno, sum(sal * 2) filter (where empno not in (1, 2)), count(*)\nfrom emp\ngroup by deptno").ok();
    }

    @Test
    public void testFakeStar() {
        this.sql("SELECT * FROM (VALUES (0, 0)) AS T(A, \"*\")").ok();
    }

    @Test
    public void testSelectDistinct() {
        this.sql("select distinct sal + 5 from emp").ok();
    }

    @Test
    public void testSelectOverDistinct() {
        String sql = "select SUM(DISTINCT deptno)\nover (ROWS BETWEEN 10 PRECEDING AND CURRENT ROW)\nfrom emp\n";
        this.sql("select SUM(DISTINCT deptno)\nover (ROWS BETWEEN 10 PRECEDING AND CURRENT ROW)\nfrom emp\n").ok();
    }

    @Test
    public void testSelectStreamPartitionDistinct() {
        String sql = "select stream\n  count(distinct orderId) over (partition by productId\n    order by rowtime\n    range interval '1' second preceding) as c,\n  count(distinct orderId) over w as c2,\n  count(orderId) over w as c3\nfrom orders\nwindow w as (partition by productId)";
        this.sql("select stream\n  count(distinct orderId) over (partition by productId\n    order by rowtime\n    range interval '1' second preceding) as c,\n  count(distinct orderId) over w as c2,\n  count(orderId) over w as c3\nfrom orders\nwindow w as (partition by productId)").ok();
    }

    @Test
    public void testSelectDistinctGroup() {
        this.sql("select distinct sum(sal) from emp group by deptno").ok();
    }

    @Test
    public void testSelectDistinctDup() {
        String sql = "select distinct sal + 5, deptno, sal + 5 from emp where deptno < 10";
        this.sql("select distinct sal + 5, deptno, sal + 5 from emp where deptno < 10").ok();
    }

    @Test
    public void testSelectWithoutFrom() {
        String sql = "select 2+2";
        this.sql("select 2+2").ok();
    }

    @Test
    public void testDuplicateColumnsInSubQuery() {
        String sql = "select \"e\" from (\nselect empno as \"e\", deptno as d, 1 as \"e\" from EMP)";
        this.sql(sql).ok();
    }

    @Test
    public void testOrder() {
        String sql = "select empno from emp order by empno";
        this.sql("select empno from emp order by empno").ok();
        String sql2 = "select empno from emp order by empno, empno asc";
        this.sql("select empno from emp order by empno, empno asc").ok();
        String sql3 = "select empno from emp order by empno, empno desc";
        this.sql("select empno from emp order by empno, empno desc").ok();
    }

    @Test
    public void testOrderBasedRepeatFields() {
        String sql = "select empno from emp order by empno DESC, empno ASC";
        this.sql("select empno from emp order by empno DESC, empno ASC").ok();
    }

    @Test
    public void testOrderDescNullsLast() {
        String sql = "select empno from emp order by empno desc nulls last";
        this.sql("select empno from emp order by empno desc nulls last").ok();
    }

    @Test
    public void testOrderByOrdinalDesc() {
        if (!this.tester.getConformance().isSortByOrdinal()) {
            return;
        }
        String sql = "select empno + 1, deptno, empno from emp order by 2 desc";
        this.sql("select empno + 1, deptno, empno from emp order by 2 desc").ok();
        String sql2 = "select empno + 1, deptno, empno from emp order by 2.5 desc";
        this.sql("select empno + 1, deptno, empno from emp order by 2.5 desc").ok();
    }

    @Test
    public void testOrderDistinct() {
        String sql = "select distinct empno, deptno + 1\nfrom emp order by deptno + 1 + empno";
        this.sql("select distinct empno, deptno + 1\nfrom emp order by deptno + 1 + empno").ok();
    }

    @Test
    public void testOrderByNegativeOrdinal() {
        String sql = "select empno + 1, deptno, empno from emp order by -1 desc";
        this.sql("select empno + 1, deptno, empno from emp order by -1 desc").ok();
    }

    @Test
    public void testOrderByOrdinalInExpr() {
        String sql = "select empno + 1, deptno, empno from emp order by 1 + 2 desc";
        this.sql("select empno + 1, deptno, empno from emp order by 1 + 2 desc").ok();
    }

    @Test
    public void testOrderByIdenticalExpr() {
        String sql = "select empno + 1 from emp order by deptno asc, empno + 1 desc";
        this.sql("select empno + 1 from emp order by deptno asc, empno + 1 desc").ok();
    }

    @Test
    public void testOrderByAlias() {
        String sql = "select empno + 1 as x, empno - 2 as y from emp order by y";
        this.sql("select empno + 1 as x, empno - 2 as y from emp order by y").ok();
    }

    @Test
    public void testOrderByAliasInExpr() {
        String sql = "select empno + 1 as x, empno - 2 as y\nfrom emp order by y + 3";
        this.sql("select empno + 1 as x, empno - 2 as y\nfrom emp order by y + 3").ok();
    }

    @Test
    public void testOrderByAliasOverrides() {
        if (!this.tester.getConformance().isSortByAlias()) {
            return;
        }
        String sql = "select empno + 1 as empno, empno - 2 as y\nfrom emp order by empno + 3";
        this.sql("select empno + 1 as empno, empno - 2 as y\nfrom emp order by empno + 3").ok();
    }

    @Test
    public void testOrderByAliasDoesNotOverride() {
        if (this.tester.getConformance().isSortByAlias()) {
            return;
        }
        String sql = "select empno + 1 as empno, empno - 2 as y\nfrom emp order by empno + 3";
        this.sql("select empno + 1 as empno, empno - 2 as y\nfrom emp order by empno + 3").ok();
    }

    @Test
    public void testOrderBySameExpr() {
        String sql = "select empno from emp, dept\norder by sal + empno desc, sal * empno, sal + empno desc";
        this.sql("select empno from emp, dept\norder by sal + empno desc, sal * empno, sal + empno desc").ok();
    }

    @Test
    public void testOrderUnion() {
        String sql = "select empno, sal from emp\nunion all\nselect deptno, deptno from dept\norder by sal desc, empno asc";
        this.sql("select empno, sal from emp\nunion all\nselect deptno, deptno from dept\norder by sal desc, empno asc").ok();
    }

    @Test
    public void testOrderUnionOrdinal() {
        if (!this.tester.getConformance().isSortByOrdinal()) {
            return;
        }
        String sql = "select empno, sal from emp\nunion all\nselect deptno, deptno from dept\norder by 2";
        this.sql("select empno, sal from emp\nunion all\nselect deptno, deptno from dept\norder by 2").ok();
    }

    @Test
    public void testOrderUnionExprs() {
        String sql = "select empno, sal from emp\nunion all\nselect deptno, deptno from dept\norder by empno * sal + 2";
        this.sql("select empno, sal from emp\nunion all\nselect deptno, deptno from dept\norder by empno * sal + 2").ok();
    }

    @Test
    public void testOrderOffsetFetch() {
        String sql = "select empno from emp\norder by empno offset 10 rows fetch next 5 rows only";
        this.sql("select empno from emp\norder by empno offset 10 rows fetch next 5 rows only").ok();
    }

    @Test
    public void testOrderOffsetFetchWithDynamicParameter() {
        String sql = "select empno from emp\norder by empno offset ? rows fetch next ? rows only";
        this.sql("select empno from emp\norder by empno offset ? rows fetch next ? rows only").ok();
    }

    @Test
    public void testOffsetFetch() {
        String sql = "select empno from emp\noffset 10 rows fetch next 5 rows only";
        this.sql("select empno from emp\noffset 10 rows fetch next 5 rows only").ok();
    }

    @Test
    public void testOffsetFetchWithDynamicParameter() {
        String sql = "select empno from emp\noffset ? rows fetch next ? rows only";
        this.sql("select empno from emp\noffset ? rows fetch next ? rows only").ok();
    }

    @Test
    public void testOffset() {
        String sql = "select empno from emp offset 10 rows";
        this.sql("select empno from emp offset 10 rows").ok();
    }

    @Test
    public void testOffsetWithDynamicParameter() {
        String sql = "select empno from emp offset ? rows";
        this.sql("select empno from emp offset ? rows").ok();
    }

    @Test
    public void testFetch() {
        String sql = "select empno from emp fetch next 5 rows only";
        this.sql("select empno from emp fetch next 5 rows only").ok();
    }

    @Test
    public void testFetchWithDynamicParameter() {
        String sql = "select empno from emp fetch next ? rows only";
        this.sql("select empno from emp fetch next ? rows only").ok();
    }

    @Test
    public void testGroupAlias() {
        String sql = "select \"$f2\", max(x), max(x + 1)\nfrom (values (1, 2)) as t(\"$f2\", x)\ngroup by \"$f2\"";
        this.sql("select \"$f2\", max(x), max(x + 1)\nfrom (values (1, 2)) as t(\"$f2\", x)\ngroup by \"$f2\"").ok();
    }

    @Test
    public void testOrderGroup() {
        String sql = "select deptno, count(*)\nfrom emp\ngroup by deptno\norder by deptno * sum(sal) desc, min(empno)";
        this.sql("select deptno, count(*)\nfrom emp\ngroup by deptno\norder by deptno * sum(sal) desc, min(empno)").ok();
    }

    @Test
    public void testCountNoGroup() {
        String sql = "select count(*), sum(sal)\nfrom emp\nwhere empno > 10";
        this.sql("select count(*), sum(sal)\nfrom emp\nwhere empno > 10").ok();
    }

    @Test
    public void testWith() {
        String sql = "with emp2 as (select * from emp)\nselect * from emp2";
        this.sql("with emp2 as (select * from emp)\nselect * from emp2").ok();
    }

    @Test
    public void testWithOrder() {
        String sql = "with emp2 as (select * from emp)\nselect * from emp2 order by deptno";
        this.sql("with emp2 as (select * from emp)\nselect * from emp2 order by deptno").ok();
    }

    @Test
    public void testWithUnionOrder() {
        String sql = "with emp2 as (select empno, deptno as x from emp)\nselect * from emp2\nunion all\nselect * from emp2\norder by empno + x";
        this.sql("with emp2 as (select empno, deptno as x from emp)\nselect * from emp2\nunion all\nselect * from emp2\norder by empno + x").ok();
    }

    @Test
    public void testWithUnion() {
        String sql = "with emp2 as (select * from emp where deptno > 10)\nselect empno from emp2 where deptno < 30\nunion all\nselect deptno from emp";
        this.sql("with emp2 as (select * from emp where deptno > 10)\nselect empno from emp2 where deptno < 30\nunion all\nselect deptno from emp").ok();
    }

    @Test
    public void testWithAlias() {
        String sql = "with w(x, y) as\n  (select * from dept where deptno > 10)\nselect x from w where x < 30 union all select deptno from dept";
        this.sql("with w(x, y) as\n  (select * from dept where deptno > 10)\nselect x from w where x < 30 union all select deptno from dept").ok();
    }

    @Test
    public void testWithInsideWhereExists() {
        String sql = "select * from emp\nwhere exists (\n  with dept2 as (select * from dept where dept.deptno >= emp.deptno)\n  select 1 from dept2 where deptno <= emp.deptno)";
        this.sql("select * from emp\nwhere exists (\n  with dept2 as (select * from dept where dept.deptno >= emp.deptno)\n  select 1 from dept2 where deptno <= emp.deptno)").decorrelate(false).ok();
    }

    @Test
    public void testWithInsideWhereExistsRex() {
        String sql = "select * from emp\nwhere exists (\n  with dept2 as (select * from dept where dept.deptno >= emp.deptno)\n  select 1 from dept2 where deptno <= emp.deptno)";
        this.sql("select * from emp\nwhere exists (\n  with dept2 as (select * from dept where dept.deptno >= emp.deptno)\n  select 1 from dept2 where deptno <= emp.deptno)").decorrelate(false).expand(false).ok();
    }

    @Test
    public void testWithInsideWhereExistsDecorrelate() {
        String sql = "select * from emp\nwhere exists (\n  with dept2 as (select * from dept where dept.deptno >= emp.deptno)\n  select 1 from dept2 where deptno <= emp.deptno)";
        this.sql("select * from emp\nwhere exists (\n  with dept2 as (select * from dept where dept.deptno >= emp.deptno)\n  select 1 from dept2 where deptno <= emp.deptno)").decorrelate(true).ok();
    }

    @Test
    public void testWithInsideWhereExistsDecorrelateRex() {
        String sql = "select * from emp\nwhere exists (\n  with dept2 as (select * from dept where dept.deptno >= emp.deptno)\n  select 1 from dept2 where deptno <= emp.deptno)";
        this.sql("select * from emp\nwhere exists (\n  with dept2 as (select * from dept where dept.deptno >= emp.deptno)\n  select 1 from dept2 where deptno <= emp.deptno)").decorrelate(true).expand(false).ok();
    }

    @Test
    public void testWithInsideScalarSubQuery() {
        String sql = "select (\n with dept2 as (select * from dept where deptno > 10) select count(*) from dept2) as c\nfrom emp";
        this.sql("select (\n with dept2 as (select * from dept where deptno > 10) select count(*) from dept2) as c\nfrom emp").ok();
    }

    @Test
    public void testWithInsideScalarSubQueryRex() {
        String sql = "select (\n with dept2 as (select * from dept where deptno > 10) select count(*) from dept2) as c\nfrom emp";
        this.sql("select (\n with dept2 as (select * from dept where deptno > 10) select count(*) from dept2) as c\nfrom emp").expand(false).ok();
    }

    @Test
    public void testWithExists() {
        String sql = "with t (a, b) as (select * from (values (1, 2)))\nselect * from t where exists (\n  select 1 from emp where deptno = t.a)";
        this.sql("with t (a, b) as (select * from (values (1, 2)))\nselect * from t where exists (\n  select 1 from emp where deptno = t.a)").ok();
    }

    @Test
    public void testTableSubset() {
        String sql = "select deptno, name from dept";
        this.sql("select deptno, name from dept").ok();
    }

    @Test
    public void testTableExpression() {
        String sql = "select deptno + deptno from dept";
        this.sql("select deptno + deptno from dept").ok();
    }

    @Test
    public void testTableExtend() {
        String sql = "select * from dept extend (x varchar(5) not null)";
        this.sql("select * from dept extend (x varchar(5) not null)").ok();
    }

    @Test
    public void testTableExtendSubset() {
        String sql = "select deptno, x from dept extend (x int)";
        this.sql("select deptno, x from dept extend (x int)").ok();
    }

    @Test
    public void testTableExtendExpression() {
        String sql = "select deptno + x from dept extend (x int not null)";
        this.sql("select deptno + x from dept extend (x int not null)").ok();
    }

    @Test
    public void testModifiableViewExtend() {
        String sql = "select *\nfrom EMP_MODIFIABLEVIEW extend (x varchar(5) not null)";
        this.sql("select *\nfrom EMP_MODIFIABLEVIEW extend (x varchar(5) not null)").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testModifiableViewExtendSubset() {
        String sql = "select x, empno\nfrom EMP_MODIFIABLEVIEW extend (x varchar(5) not null)";
        this.sql("select x, empno\nfrom EMP_MODIFIABLEVIEW extend (x varchar(5) not null)").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testModifiableViewExtendExpression() {
        String sql = "select empno + x\nfrom EMP_MODIFIABLEVIEW extend (x int not null)";
        this.sql("select empno + x\nfrom EMP_MODIFIABLEVIEW extend (x int not null)").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testSelectViewExtendedColumnCollision() {
        this.sql("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR\n from EMP_MODIFIABLEVIEW3\n where SAL = 20").with(this.getExtendedTester()).ok();
        this.sql("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR\n from EMP_MODIFIABLEVIEW3 extend (SAL int)\n where SAL = 20").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testSelectViewExtendedColumnCaseSensitiveCollision() {
        this.sql("select ENAME, EMPNO, JOB, SLACKER, \"sal\", HIREDATE, MGR\n from EMP_MODIFIABLEVIEW3 extend (\"sal\" boolean)\n where \"sal\" = true").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testSelectViewExtendedColumnExtendedCollision() {
        this.sql("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, EXTRA\n from EMP_MODIFIABLEVIEW2\n where SAL = 20").with(this.getExtendedTester()).ok();
        this.sql("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, EXTRA\n from EMP_MODIFIABLEVIEW2 extend (EXTRA boolean)\n where SAL = 20").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testSelectViewExtendedColumnCaseSensitiveExtendedCollision() {
        this.sql("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, \"extra\"\n from EMP_MODIFIABLEVIEW2 extend (\"extra\" boolean)\n where \"extra\" = false").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testSelectViewExtendedColumnUnderlyingCollision() {
        this.sql("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR, COMM\n from EMP_MODIFIABLEVIEW3 extend (COMM int)\n where SAL = 20").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testSelectViewExtendedColumnCaseSensitiveUnderlyingCollision() {
        this.sql("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR, \"comm\"\n from EMP_MODIFIABLEVIEW3 extend (\"comm\" int)\n where \"comm\" = 20").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testUpdateExtendedColumnCollision() {
        this.sql("update empdefaults(empno INTEGER NOT NULL, deptno INTEGER) set deptno = 1, empno = 20, ename = 'Bob' where deptno = 10").ok();
    }

    @Test
    public void testUpdateExtendedColumnCaseSensitiveCollision() {
        this.sql("update empdefaults(\"slacker\" INTEGER, deptno INTEGER) set deptno = 1, \"slacker\" = 100 where ename = 'Bob'").ok();
    }

    @Test
    public void testUpdateExtendedColumnModifiableViewCollision() {
        this.sql("update EMP_MODIFIABLEVIEW3(empno INTEGER NOT NULL, deptno INTEGER) set deptno = 20, empno = 20, ename = 'Bob' where empno = 10").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testUpdateExtendedColumnModifiableViewCaseSensitiveCollision() {
        this.sql("update EMP_MODIFIABLEVIEW2(\"slacker\" INTEGER, deptno INTEGER) set deptno = 20, \"slacker\" = 100 where ename = 'Bob'").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testUpdateExtendedColumnModifiableViewExtendedCollision() {
        this.sql("update EMP_MODIFIABLEVIEW2(\"slacker\" INTEGER, extra BOOLEAN) set deptno = 20, \"slacker\" = 100, extra = true where ename = 'Bob'").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testUpdateExtendedColumnModifiableViewExtendedCaseSensitiveCollision() {
        this.sql("update EMP_MODIFIABLEVIEW2(\"extra\" INTEGER, extra BOOLEAN) set deptno = 20, \"extra\" = 100, extra = true where ename = 'Bob'").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testUpdateExtendedColumnModifiableViewUnderlyingCollision() {
        this.sql("update EMP_MODIFIABLEVIEW3(extra BOOLEAN, comm INTEGER) set empno = 20, comm = true, extra = true where ename = 'Bob'").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testSelectModifiableViewConstraint() {
        String sql = "select deptno from EMP_MODIFIABLEVIEW2\nwhere deptno = ?";
        this.sql("select deptno from EMP_MODIFIABLEVIEW2\nwhere deptno = ?").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testModifiableViewDdlExtend() {
        String sql = "select extra from EMP_MODIFIABLEVIEW2";
        this.sql("select extra from EMP_MODIFIABLEVIEW2").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testExplicitTable() {
        this.sql("table emp").ok();
    }

    @Test
    public void testCollectionTable() {
        this.sql("select * from table(ramp(3))").ok();
    }

    @Test
    public void testCollectionTableWithLateral() {
        this.sql("select * from dept, lateral table(ramp(dept.deptno))").ok();
    }

    @Test
    public void testCollectionTableWithLateral2() {
        this.sql("select * from dept, lateral table(ramp(deptno))").ok();
    }

    @Test
    public void testCollectionTableWithLateral3() {
        this.sql("select * from dept, lateral table(DEDUP(dept.deptno, dept.name))").ok();
    }

    @Test
    public void testSample() {
        String sql = "select * from emp tablesample substitute('DATASET1') where empno > 5";
        this.sql("select * from emp tablesample substitute('DATASET1') where empno > 5").ok();
    }

    @Test
    public void testSampleQuery() {
        String sql = "select * from (\n select * from emp as e tablesample substitute('DATASET1')\n join dept on e.deptno = dept.deptno\n) tablesample substitute('DATASET2')\nwhere empno > 5";
        this.sql("select * from (\n select * from emp as e tablesample substitute('DATASET1')\n join dept on e.deptno = dept.deptno\n) tablesample substitute('DATASET2')\nwhere empno > 5").ok();
    }

    @Test
    public void testSampleBernoulli() {
        String sql = "select * from emp tablesample bernoulli(50) where empno > 5";
        this.sql("select * from emp tablesample bernoulli(50) where empno > 5").ok();
    }

    @Test
    public void testSampleBernoulliQuery() {
        String sql = "select * from (\n select * from emp as e tablesample bernoulli(10) repeatable(1)\n join dept on e.deptno = dept.deptno\n) tablesample bernoulli(50) repeatable(99)\nwhere empno > 5";
        this.sql("select * from (\n select * from emp as e tablesample bernoulli(10) repeatable(1)\n join dept on e.deptno = dept.deptno\n) tablesample bernoulli(50) repeatable(99)\nwhere empno > 5").ok();
    }

    @Test
    public void testSampleSystem() {
        String sql = "select * from emp tablesample system(50) where empno > 5";
        this.sql("select * from emp tablesample system(50) where empno > 5").ok();
    }

    @Test
    public void testSampleSystemQuery() {
        String sql = "select * from (\n select * from emp as e tablesample system(10) repeatable(1)\n join dept on e.deptno = dept.deptno\n) tablesample system(50) repeatable(99)\nwhere empno > 5";
        this.sql("select * from (\n select * from emp as e tablesample system(10) repeatable(1)\n join dept on e.deptno = dept.deptno\n) tablesample system(50) repeatable(99)\nwhere empno > 5").ok();
    }

    @Test
    public void testCollectionTableWithCursorParam() {
        String sql = "select * from table(dedup(cursor(select ename from emp), cursor(select name from dept), 'NAME'))";
        this.sql("select * from table(dedup(cursor(select ename from emp), cursor(select name from dept), 'NAME'))").decorrelate(false).ok();
    }

    @Test
    public void testUnnest() {
        String sql = "select*from unnest(multiset[1,2])";
        this.sql("select*from unnest(multiset[1,2])").ok();
    }

    @Test
    public void testUnnestSubQuery() {
        String sql = "select*from unnest(multiset(select*from dept))";
        this.sql("select*from unnest(multiset(select*from dept))").ok();
    }

    @Test
    public void testUnnestArrayAggPlan() {
        String sql = "select d.deptno, e2.empno_avg\nfrom dept_nested as d outer apply\n (select avg(e.empno) as empno_avg from UNNEST(d.employees) as e) e2";
        this.sql("select d.deptno, e2.empno_avg\nfrom dept_nested as d outer apply\n (select avg(e.empno) as empno_avg from UNNEST(d.employees) as e) e2").conformance((SqlConformance)SqlConformanceEnum.LENIENT).ok();
    }

    @Test
    public void testUnnestArrayPlan() {
        String sql = "select d.deptno, e2.empno\nfrom dept_nested as d,\n UNNEST(d.employees) e2";
        this.sql("select d.deptno, e2.empno\nfrom dept_nested as d,\n UNNEST(d.employees) e2").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testUnnestArrayPlanAs() {
        String sql = "select d.deptno, e2.empno\nfrom dept_nested as d,\n UNNEST(d.employees) as e2(empno, y, z)";
        this.sql("select d.deptno, e2.empno\nfrom dept_nested as d,\n UNNEST(d.employees) as e2(empno, y, z)").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testArrayOfRecord() {
        this.sql("select employees[1].detail.skills[2+3].desc from dept_nested").ok();
    }

    @Test
    public void testFlattenRecords() {
        this.sql("select employees[1] from dept_nested").ok();
    }

    @Test
    public void testUnnestArray() {
        this.sql("select*from unnest(array(select*from dept))").ok();
    }

    @Test
    public void testUnnestWithOrdinality() {
        String sql = "select*from unnest(array(select*from dept)) with ordinality";
        this.sql("select*from unnest(array(select*from dept)) with ordinality").ok();
    }

    @Test
    public void testMultisetSubQuery() {
        String sql = "select multiset(select deptno from dept) from (values(true))";
        this.sql("select multiset(select deptno from dept) from (values(true))").ok();
    }

    @Test
    public void testMultiset() {
        String sql = "select 'a',multiset[10] from dept";
        this.sql("select 'a',multiset[10] from dept").ok();
    }

    @Test
    public void testMultisetOfColumns() {
        String sql = "select 'abc',multiset[deptno,sal] from emp";
        this.sql("select 'abc',multiset[deptno,sal] from emp").expand(true).ok();
    }

    @Test
    public void testMultisetOfColumnsRex() {
        this.sql("select 'abc',multiset[deptno,sal] from emp").ok();
    }

    @Test
    public void testCorrelationJoin() {
        String sql = "select *,\n  multiset(select * from emp where deptno=dept.deptno) as empset\nfrom dept";
        this.sql("select *,\n  multiset(select * from emp where deptno=dept.deptno) as empset\nfrom dept").ok();
    }

    @Test
    public void testCorrelationJoinRex() {
        String sql = "select *,\n  multiset(select * from emp where deptno=dept.deptno) as empset\nfrom dept";
        this.sql("select *,\n  multiset(select * from emp where deptno=dept.deptno) as empset\nfrom dept").expand(false).ok();
    }

    @Test
    public void testCorrelatedSubQueryInJoin() {
        String sql = "select *\nfrom emp as e\njoin dept as d using (deptno)\nwhere d.name = (\n  select max(name)\n  from dept as d2\n  where d2.deptno = d.deptno)";
        this.sql("select *\nfrom emp as e\njoin dept as d using (deptno)\nwhere d.name = (\n  select max(name)\n  from dept as d2\n  where d2.deptno = d.deptno)").expand(false).ok();
    }

    @Test
    public void testExists() {
        String sql = "select*from emp\nwhere exists (select 1 from dept where deptno=55)";
        this.sql("select*from emp\nwhere exists (select 1 from dept where deptno=55)").ok();
    }

    @Test
    public void testExistsCorrelated() {
        String sql = "select*from emp where exists (\n  select 1 from dept where emp.deptno=dept.deptno)";
        this.sql("select*from emp where exists (\n  select 1 from dept where emp.deptno=dept.deptno)").decorrelate(false).ok();
    }

    @Test
    public void testNotExistsCorrelated() {
        String sql = "select * from emp where not exists (\n  select 1 from dept where emp.deptno=dept.deptno)";
        this.sql("select * from emp where not exists (\n  select 1 from dept where emp.deptno=dept.deptno)").decorrelate(false).ok();
    }

    @Test
    public void testExistsCorrelatedDecorrelate() {
        String sql = "select*from emp where exists (\n  select 1 from dept where emp.deptno=dept.deptno)";
        this.sql("select*from emp where exists (\n  select 1 from dept where emp.deptno=dept.deptno)").decorrelate(true).ok();
    }

    @Test
    public void testExistsCorrelatedDecorrelateRex() {
        String sql = "select*from emp where exists (\n  select 1 from dept where emp.deptno=dept.deptno)";
        this.sql("select*from emp where exists (\n  select 1 from dept where emp.deptno=dept.deptno)").decorrelate(true).expand(false).ok();
    }

    @Test
    public void testExistsCorrelatedLimit() {
        String sql = "select*from emp where exists (\n  select 1 from dept where emp.deptno=dept.deptno limit 1)";
        this.sql("select*from emp where exists (\n  select 1 from dept where emp.deptno=dept.deptno limit 1)").decorrelate(false).ok();
    }

    @Test
    public void testExistsCorrelatedLimitDecorrelate() {
        String sql = "select*from emp where exists (\n  select 1 from dept where emp.deptno=dept.deptno limit 1)";
        this.sql("select*from emp where exists (\n  select 1 from dept where emp.deptno=dept.deptno limit 1)").decorrelate(true).expand(true).ok();
    }

    @Test
    public void testExistsCorrelatedLimitDecorrelateRex() {
        String sql = "select*from emp where exists (\n  select 1 from dept where emp.deptno=dept.deptno limit 1)";
        this.sql("select*from emp where exists (\n  select 1 from dept where emp.deptno=dept.deptno limit 1)").decorrelate(true).expand(false).ok();
    }

    @Test
    public void testInValueListShort() {
        String sql = "select empno from emp where deptno in (10, 20)";
        this.sql("select empno from emp where deptno in (10, 20)").ok();
        this.sql("select empno from emp where deptno in (10, 20)").expand(false).ok();
    }

    @Test
    public void testInValueListLong() {
        String sql = "select empno from emp where deptno in (10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 130, 140, 150, 160, 170, 180, 190, 200, 210, 220, 230)";
        this.sql("select empno from emp where deptno in (10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 130, 140, 150, 160, 170, 180, 190, 200, 210, 220, 230)").ok();
    }

    @Test
    public void testInUncorrelatedSubQuery() {
        String sql = "select empno from emp where deptno in (select deptno from dept)";
        this.sql("select empno from emp where deptno in (select deptno from dept)").ok();
    }

    @Test
    public void testInUncorrelatedSubQueryRex() {
        String sql = "select empno from emp where deptno in (select deptno from dept)";
        this.sql("select empno from emp where deptno in (select deptno from dept)").expand(false).ok();
    }

    @Test
    public void testCompositeInUncorrelatedSubQueryRex() {
        String sql = "select empno from emp where (empno, deptno) in (select deptno - 10, deptno from dept)";
        this.sql("select empno from emp where (empno, deptno) in (select deptno - 10, deptno from dept)").expand(false).ok();
    }

    @Test
    public void testNotInUncorrelatedSubQuery() {
        String sql = "select empno from emp where deptno not in (select deptno from dept)";
        this.sql("select empno from emp where deptno not in (select deptno from dept)").ok();
    }

    @Test
    public void testAllValueList() {
        String sql = "select empno from emp where deptno > all (10, 20)";
        this.sql("select empno from emp where deptno > all (10, 20)").expand(false).ok();
    }

    @Test
    public void testSomeValueList() {
        String sql = "select empno from emp where deptno > some (10, 20)";
        this.sql("select empno from emp where deptno > some (10, 20)").expand(false).ok();
    }

    @Test
    public void testSome() {
        String sql = "select empno from emp where deptno > some (\n  select deptno from dept)";
        this.sql("select empno from emp where deptno > some (\n  select deptno from dept)").expand(false).ok();
    }

    @Test
    public void testNotInUncorrelatedSubQueryRex() {
        String sql = "select empno from emp where deptno not in (select deptno from dept)";
        this.sql("select empno from emp where deptno not in (select deptno from dept)").expand(false).ok();
    }

    @Test
    public void testNotCaseInThreeClause() {
        String sql = "select empno from emp where not case when true then deptno in (10,20) else true end";
        this.sql("select empno from emp where not case when true then deptno in (10,20) else true end").expand(false).ok();
    }

    @Test
    public void testNotCaseInMoreClause() {
        String sql = "select empno from emp where not case when true then deptno in (10,20) when false then false else deptno in (30,40) end";
        this.sql("select empno from emp where not case when true then deptno in (10,20) when false then false else deptno in (30,40) end").expand(false).ok();
    }

    @Test
    public void testNotCaseInWithoutElse() {
        String sql = "select empno from emp where not case when true then deptno in (10,20)  end";
        this.sql("select empno from emp where not case when true then deptno in (10,20)  end").expand(false).ok();
    }

    @Test
    public void testWhereInCorrelated() {
        String sql = "select empno from emp as e\njoin dept as d using (deptno)\nwhere e.sal in (\n  select e2.sal from emp as e2 where e2.deptno > e.deptno)";
        this.sql("select empno from emp as e\njoin dept as d using (deptno)\nwhere e.sal in (\n  select e2.sal from emp as e2 where e2.deptno > e.deptno)").expand(false).ok();
    }

    @Test
    public void testInUncorrelatedSubQueryInSelect() {
        String sql = "select name, deptno in (\n  select case when true then deptno else null end from emp)\nfrom dept";
        this.sql("select name, deptno in (\n  select case when true then deptno else null end from emp)\nfrom dept").ok();
    }

    @Test
    public void testInUncorrelatedSubQueryInSelectRex() {
        String sql = "select name, deptno in (\n  select case when true then deptno else null end from emp)\nfrom dept";
        this.sql("select name, deptno in (\n  select case when true then deptno else null end from emp)\nfrom dept").expand(false).ok();
    }

    @Test
    public void testInUncorrelatedSubQueryInHavingRex() {
        String sql = "select sum(sal) as s\nfrom emp\ngroup by deptno\nhaving count(*) > 2\nand deptno in (\n  select case when true then deptno else null end from emp)";
        this.sql("select sum(sal) as s\nfrom emp\ngroup by deptno\nhaving count(*) > 2\nand deptno in (\n  select case when true then deptno else null end from emp)").expand(false).ok();
    }

    @Test
    public void testUncorrelatedScalarSubQueryInOrderRex() {
        String sql = "select ename\nfrom emp\norder by (select case when true then deptno else null end from emp) desc,\n  ename";
        this.sql("select ename\nfrom emp\norder by (select case when true then deptno else null end from emp) desc,\n  ename").expand(false).ok();
    }

    @Test
    public void testUncorrelatedScalarSubQueryInGroupOrderRex() {
        String sql = "select sum(sal) as s\nfrom emp\ngroup by deptno\norder by (select case when true then deptno else null end from emp) desc,\n  count(*)";
        this.sql("select sum(sal) as s\nfrom emp\ngroup by deptno\norder by (select case when true then deptno else null end from emp) desc,\n  count(*)").expand(false).ok();
    }

    @Test
    public void testUncorrelatedScalarSubQueryInAggregateRex() {
        String sql = "select sum((select min(deptno) from emp)) as s\nfrom emp\ngroup by deptno\n";
        this.sql("select sum((select min(deptno) from emp)) as s\nfrom emp\ngroup by deptno\n").expand(false).ok();
    }

    @Test
    public void testNotInUncorrelatedSubQueryInSelect() {
        String sql = "select empno, deptno not in (\n  select case when true then deptno else null end from dept)\nfrom emp";
        this.sql("select empno, deptno not in (\n  select case when true then deptno else null end from dept)\nfrom emp").ok();
    }

    @Test
    public void testNotInUncorrelatedSubQueryInSelectRex() {
        String sql = "select empno, deptno not in (\n  select case when true then deptno else null end from dept)\nfrom emp";
        this.sql("select empno, deptno not in (\n  select case when true then deptno else null end from dept)\nfrom emp").expand(false).ok();
    }

    @Test
    public void testNotInUncorrelatedSubQueryInSelectNotNull() {
        String sql = "select empno, deptno not in (\n  select deptno from dept)\nfrom emp";
        this.sql("select empno, deptno not in (\n  select deptno from dept)\nfrom emp").ok();
    }

    @Test
    public void testNotInUncorrelatedSubQueryInSelectMayBeNull() {
        String sql = "select empno, deptno not in (\n  select mgr from emp)\nfrom emp";
        this.sql("select empno, deptno not in (\n  select mgr from emp)\nfrom emp").ok();
    }

    @Test
    public void testNotInUncorrelatedSubQueryInSelectDeduceNotNull() {
        String sql = "select empno, deptno not in (\n  select mgr from emp where mgr > 5)\nfrom emp";
        this.sql("select empno, deptno not in (\n  select mgr from emp where mgr > 5)\nfrom emp").ok();
    }

    @Test
    public void testNotInUncorrelatedSubQueryInSelectDeduceNotNull2() {
        String sql = "select empno, deptno not in (\n  select mgr from emp where mgr is not null)\nfrom emp";
        this.sql("select empno, deptno not in (\n  select mgr from emp where mgr is not null)\nfrom emp").ok();
    }

    @Test
    public void testNotInUncorrelatedSubQueryInSelectDeduceNotNull3() {
        String sql = "select empno, deptno not in (\n  select mgr from emp where mgr in (\n    select mgr from emp where deptno = 10))\nfrom emp";
        this.sql("select empno, deptno not in (\n  select mgr from emp where mgr in (\n    select mgr from emp where deptno = 10))\nfrom emp").ok();
    }

    @Test
    public void testNotInUncorrelatedSubQueryInSelectNotNullRex() {
        String sql = "select empno, deptno not in (\n  select deptno from dept)\nfrom emp";
        this.sql("select empno, deptno not in (\n  select deptno from dept)\nfrom emp").expand(false).ok();
    }

    @Test
    public void testUnnestSelect() {
        String sql = "select*from unnest(select multiset[deptno] from dept)";
        this.sql("select*from unnest(select multiset[deptno] from dept)").expand(true).ok();
    }

    @Test
    public void testUnnestSelectRex() {
        String sql = "select*from unnest(select multiset[deptno] from dept)";
        this.sql("select*from unnest(select multiset[deptno] from dept)").expand(false).ok();
    }

    @Test
    public void testJoinUnnest() {
        String sql = "select*from dept as d, unnest(multiset[d.deptno * 2])";
        this.sql("select*from dept as d, unnest(multiset[d.deptno * 2])").ok();
    }

    @Test
    public void testJoinUnnestRex() {
        String sql = "select*from dept as d, unnest(multiset[d.deptno * 2])";
        this.sql("select*from dept as d, unnest(multiset[d.deptno * 2])").expand(false).ok();
    }

    @Test
    public void testLateral() {
        String sql = "select * from emp,\n  LATERAL (select * from dept where emp.deptno=dept.deptno)";
        this.sql("select * from emp,\n  LATERAL (select * from dept where emp.deptno=dept.deptno)").decorrelate(false).ok();
    }

    @Test
    public void testLateralDecorrelate() {
        String sql = "select * from emp,\n LATERAL (select * from dept where emp.deptno=dept.deptno)";
        this.sql("select * from emp,\n LATERAL (select * from dept where emp.deptno=dept.deptno)").decorrelate(true).expand(true).ok();
    }

    @Test
    public void testLateralDecorrelateRex() {
        String sql = "select * from emp,\n LATERAL (select * from dept where emp.deptno=dept.deptno)";
        this.sql("select * from emp,\n LATERAL (select * from dept where emp.deptno=dept.deptno)").decorrelate(true).ok();
    }

    @Test
    public void testLateralDecorrelateThetaRex() {
        String sql = "select * from emp,\n LATERAL (select * from dept where emp.deptno < dept.deptno)";
        this.sql("select * from emp,\n LATERAL (select * from dept where emp.deptno < dept.deptno)").decorrelate(true).ok();
    }

    @Test
    public void testNestedCorrelations() {
        String sql = "select *\nfrom (select 2+deptno d2, 3+deptno d3 from emp) e\n where exists (select 1 from (select deptno+1 d1 from dept) d\n where d1=e.d2 and exists (select 2 from (select deptno+4 d4, deptno+5 d5, deptno+6 d6 from dept)\n where d4=d.d1 and d5=d.d1 and d6=e.d3))";
        this.sql("select *\nfrom (select 2+deptno d2, 3+deptno d3 from emp) e\n where exists (select 1 from (select deptno+1 d1 from dept) d\n where d1=e.d2 and exists (select 2 from (select deptno+4 d4, deptno+5 d5, deptno+6 d6 from dept)\n where d4=d.d1 and d5=d.d1 and d6=e.d3))").decorrelate(false).ok();
    }

    @Test
    public void testNestedCorrelationsDecorrelated() {
        String sql = "select *\nfrom (select 2+deptno d2, 3+deptno d3 from emp) e\n where exists (select 1 from (select deptno+1 d1 from dept) d\n where d1=e.d2 and exists (select 2 from (select deptno+4 d4, deptno+5 d5, deptno+6 d6 from dept)\n where d4=d.d1 and d5=d.d1 and d6=e.d3))";
        this.sql("select *\nfrom (select 2+deptno d2, 3+deptno d3 from emp) e\n where exists (select 1 from (select deptno+1 d1 from dept) d\n where d1=e.d2 and exists (select 2 from (select deptno+4 d4, deptno+5 d5, deptno+6 d6 from dept)\n where d4=d.d1 and d5=d.d1 and d6=e.d3))").decorrelate(true).expand(true).ok();
    }

    @Test
    public void testNestedCorrelationsDecorrelatedRex() {
        String sql = "select *\nfrom (select 2+deptno d2, 3+deptno d3 from emp) e\n where exists (select 1 from (select deptno+1 d1 from dept) d\n where d1=e.d2 and exists (select 2 from (select deptno+4 d4, deptno+5 d5, deptno+6 d6 from dept)\n where d4=d.d1 and d5=d.d1 and d6=e.d3))";
        this.sql("select *\nfrom (select 2+deptno d2, 3+deptno d3 from emp) e\n where exists (select 1 from (select deptno+1 d1 from dept) d\n where d1=e.d2 and exists (select 2 from (select deptno+4 d4, deptno+5 d5, deptno+6 d6 from dept)\n where d4=d.d1 and d5=d.d1 and d6=e.d3))").decorrelate(true).ok();
    }

    @Test
    public void testElement() {
        this.sql("select element(multiset[5]) from emp").ok();
    }

    @Test
    public void testElementInValues() {
        this.sql("values element(multiset[5])").ok();
    }

    @Test
    public void testUnionAll() {
        String sql = "select empno from emp union all select deptno from dept";
        this.sql("select empno from emp union all select deptno from dept").ok();
    }

    @Test
    public void testUnion() {
        String sql = "select empno from emp union select deptno from dept";
        this.sql("select empno from emp union select deptno from dept").ok();
    }

    @Test
    public void testUnionValues() {
        String sql = "values (10), (20)\nunion all\nselect 34 from emp\nunion all values (30), (45 + 10)";
        this.sql("values (10), (20)\nunion all\nselect 34 from emp\nunion all values (30), (45 + 10)").ok();
    }

    @Test
    public void testUnionSubQuery() {
        String sql = "select deptno from emp as emp0 cross join\n (select empno from emp union all\n  select deptno from dept where deptno > 20 union all\n  values (45), (67))";
        this.sql("select deptno from emp as emp0 cross join\n (select empno from emp union all\n  select deptno from dept where deptno > 20 union all\n  values (45), (67))").ok();
    }

    @Test
    public void testIsDistinctFrom() {
        String sql = "select empno is distinct from deptno\nfrom (values (cast(null as int), 1),\n             (2, cast(null as int))) as emp(empno, deptno)";
        this.sql("select empno is distinct from deptno\nfrom (values (cast(null as int), 1),\n             (2, cast(null as int))) as emp(empno, deptno)").ok();
    }

    @Test
    public void testIsNotDistinctFrom() {
        String sql = "select empno is not distinct from deptno\nfrom (values (cast(null as int), 1),\n             (2, cast(null as int))) as emp(empno, deptno)";
        this.sql("select empno is not distinct from deptno\nfrom (values (cast(null as int), 1),\n             (2, cast(null as int))) as emp(empno, deptno)").ok();
    }

    @Test
    public void testNotLike() {
        String sql = "values ('a' not like 'b' escape 'c')";
        this.sql("values ('a' not like 'b' escape 'c')").ok();
    }

    @Test
    public void testTumble() {
        String sql = "select STREAM\n  TUMBLE_START(rowtime, INTERVAL '1' MINUTE) AS s,\n  TUMBLE_END(rowtime, INTERVAL '1' MINUTE) AS e\nfrom Shipments\nGROUP BY TUMBLE(rowtime, INTERVAL '1' MINUTE)";
        this.sql("select STREAM\n  TUMBLE_START(rowtime, INTERVAL '1' MINUTE) AS s,\n  TUMBLE_END(rowtime, INTERVAL '1' MINUTE) AS e\nfrom Shipments\nGROUP BY TUMBLE(rowtime, INTERVAL '1' MINUTE)").ok();
    }

    @Test
    public void testNotNotIn() {
        String sql = "select * from EMP where not (ename not in ('Fred') )";
        this.sql("select * from EMP where not (ename not in ('Fred') )").ok();
    }

    @Test
    public void testOverMultiple() {
        String sql = "select sum(sal) over w1,\n  sum(deptno) over w1,\n  sum(deptno) over w2\nfrom emp\nwhere deptno - sal > 999\nwindow w1 as (partition by job order by hiredate rows 2 preceding),\n  w2 as (partition by job order by hiredate rows 3 preceding disallow partial),\n  w3 as (partition by job order by hiredate range interval '1' second preceding)";
        this.sql("select sum(sal) over w1,\n  sum(deptno) over w1,\n  sum(deptno) over w2\nfrom emp\nwhere deptno - sal > 999\nwindow w1 as (partition by job order by hiredate rows 2 preceding),\n  w2 as (partition by job order by hiredate rows 3 preceding disallow partial),\n  w3 as (partition by job order by hiredate range interval '1' second preceding)").ok();
    }

    @Test
    public void testNestedAggregates() {
        String sql = "SELECT\n  avg(sum(sal) + 2 * min(empno) + 3 * avg(empno))\n  over (partition by deptno)\nfrom emp\ngroup by deptno";
        this.sql("SELECT\n  avg(sum(sal) + 2 * min(empno) + 3 * avg(empno))\n  over (partition by deptno)\nfrom emp\ngroup by deptno").ok();
    }

    @Test
    public void testCase() {
        this.sql("values (case 'a' when 'a' then 1 end)").ok();
    }

    @Test
    public void testCharLength() {
        this.sql("values (character_length('foo'))").ok();
    }

    @Test
    public void testOverAvg() {
        String sql = "select sum(sal) over w1,\n  avg(sal) over w1\nfrom emp\nwindow w1 as (partition by job order by hiredate rows 2 preceding)";
        this.sql("select sum(sal) over w1,\n  avg(sal) over w1\nfrom emp\nwindow w1 as (partition by job order by hiredate rows 2 preceding)").ok();
    }

    @Test
    public void testOverAvg2() {
        String sql = "select sum(sal) over w1,\n  avg(CAST(sal as real)) over w1\nfrom emp\nwindow w1 as (partition by job order by hiredate rows 2 preceding)";
        this.sql("select sum(sal) over w1,\n  avg(CAST(sal as real)) over w1\nfrom emp\nwindow w1 as (partition by job order by hiredate rows 2 preceding)").ok();
    }

    @Test
    public void testOverCountStar() {
        String sql = "select count(sal) over w1,\n  count(*) over w1\nfrom emp\nwindow w1 as (partition by job order by hiredate rows 2 preceding)";
        this.sql("select count(sal) over w1,\n  count(*) over w1\nfrom emp\nwindow w1 as (partition by job order by hiredate rows 2 preceding)").ok();
    }

    @Test
    public void testOverOrderWindow() {
        String sql = "select last_value(deptno) over w\nfrom emp\nwindow w as (order by empno)";
        this.sql("select last_value(deptno) over w\nfrom emp\nwindow w as (order by empno)").ok();
        String sql2 = "select last_value(deptno) over (order by empno)\nfrom emp\n";
        this.sql("select last_value(deptno) over (order by empno)\nfrom emp\n").ok();
    }

    @Test
    public void testOverOrderFollowingWindow() {
        String sql = "select last_value(deptno) over w\nfrom emp\nwindow w as (order by empno rows 2 following)";
        this.sql("select last_value(deptno) over w\nfrom emp\nwindow w as (order by empno rows 2 following)").ok();
        String sql2 = "select\n  last_value(deptno) over (order by empno rows 2 following)\nfrom emp\n";
        this.sql("select\n  last_value(deptno) over (order by empno rows 2 following)\nfrom emp\n").ok();
    }

    @Test
    public void testTumbleTable() {
        String sql = "select stream tumble_end(rowtime, interval '2' hour) as rowtime, productId\nfrom orders\ngroup by tumble(rowtime, interval '2' hour), productId";
        this.sql("select stream tumble_end(rowtime, interval '2' hour) as rowtime, productId\nfrom orders\ngroup by tumble(rowtime, interval '2' hour), productId").ok();
    }

    @Test
    public void testTumbleTableRowtimeNotFirstColumn() {
        String sql = "select stream\n   tumble_end(rowtime, interval '2' hour) as rowtime, orderId\nfrom shipments\ngroup by tumble(rowtime, interval '2' hour), orderId";
        this.sql("select stream\n   tumble_end(rowtime, interval '2' hour) as rowtime, orderId\nfrom shipments\ngroup by tumble(rowtime, interval '2' hour), orderId").ok();
    }

    @Test
    public void testHopTable() {
        String sql = "select stream hop_start(rowtime, interval '1' hour, interval '3' hour) as rowtime,\n  count(*) as c\nfrom orders\ngroup by hop(rowtime, interval '1' hour, interval '3' hour)";
        this.sql("select stream hop_start(rowtime, interval '1' hour, interval '3' hour) as rowtime,\n  count(*) as c\nfrom orders\ngroup by hop(rowtime, interval '1' hour, interval '3' hour)").ok();
    }

    @Test
    public void testSessionTable() {
        String sql = "select stream session_start(rowtime, interval '1' hour) as rowtime,\n  session_end(rowtime, interval '1' hour),\n  count(*) as c\nfrom orders\ngroup by session(rowtime, interval '1' hour)";
        this.sql("select stream session_start(rowtime, interval '1' hour) as rowtime,\n  session_end(rowtime, interval '1' hour),\n  count(*) as c\nfrom orders\ngroup by session(rowtime, interval '1' hour)").ok();
    }

    @Test
    public void testInterval() {
    }

    @Test
    public void testStream() {
        String sql = "select stream productId from orders where productId = 10";
        this.sql("select stream productId from orders where productId = 10").ok();
    }

    @Test
    public void testStreamGroupBy() {
        String sql = "select stream\n floor(rowtime to second) as rowtime, count(*) as c\nfrom orders\ngroup by floor(rowtime to second)";
        this.sql("select stream\n floor(rowtime to second) as rowtime, count(*) as c\nfrom orders\ngroup by floor(rowtime to second)").ok();
    }

    @Test
    public void testStreamWindowedAggregation() {
        String sql = "select stream *,\n  count(*) over (partition by productId\n    order by rowtime\n    range interval '1' second preceding) as c\nfrom orders";
        this.sql("select stream *,\n  count(*) over (partition by productId\n    order by rowtime\n    range interval '1' second preceding) as c\nfrom orders").ok();
    }

    @Test
    public void testExplainAsXml() {
        String sql = "select 1 + 2, 3 from (values (true))";
        RelNode rel = this.tester.convertSqlToRel((String)sql).rel;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        RelXmlWriter planWriter = new RelXmlWriter(pw, SqlExplainLevel.EXPPLAN_ATTRIBUTES);
        rel.explain((RelWriter)planWriter);
        pw.flush();
        TestUtil.assertEqualsVerbose("<RelNode type=\"LogicalProject\">\n\t<Property name=\"EXPR$0\">\n\t\t+(1, 2)\t</Property>\n\t<Property name=\"EXPR$1\">\n\t\t3\t</Property>\n\t<Inputs>\n\t\t<RelNode type=\"LogicalValues\">\n\t\t\t<Property name=\"tuples\">\n\t\t\t\t[{ true }]\t\t\t</Property>\n\t\t\t<Inputs/>\n\t\t</RelNode>\n\t</Inputs>\n</RelNode>\n", Util.toLinux((String)sw.toString()));
    }

    @Test
    public void testSortWithTrim() {
        String sql = "select ename from (select * from emp order by sal) a";
        this.sql("select ename from (select * from emp order by sal) a").trim(true).ok();
    }

    @Test
    public void testOffset0() {
        String sql = "select * from emp offset 0";
        this.sql("select * from emp offset 0").ok();
    }

    @Test
    public void testGroupByCaseSubQuery() {
        String sql = "SELECT CASE WHEN emp.empno IN (3) THEN 0 ELSE 1 END\nFROM emp\nGROUP BY (CASE WHEN emp.empno IN (3) THEN 0 ELSE 1 END)";
        this.sql("SELECT CASE WHEN emp.empno IN (3) THEN 0 ELSE 1 END\nFROM emp\nGROUP BY (CASE WHEN emp.empno IN (3) THEN 0 ELSE 1 END)").ok();
    }

    @Test
    public void testAggCaseSubQuery() {
        String sql = "SELECT SUM(CASE WHEN empno IN (3) THEN 0 ELSE 1 END) FROM emp";
        this.sql("SELECT SUM(CASE WHEN empno IN (3) THEN 0 ELSE 1 END) FROM emp").ok();
    }

    @Test
    public void testAggNoDuplicateColumnNames() {
        String sql = "SELECT  empno, EXPR$2, COUNT(empno) FROM (\n    SELECT empno, deptno AS EXPR$2\n    FROM emp)\nGROUP BY empno, EXPR$2";
        this.sql("SELECT  empno, EXPR$2, COUNT(empno) FROM (\n    SELECT empno, deptno AS EXPR$2\n    FROM emp)\nGROUP BY empno, EXPR$2").ok();
    }

    @Test
    public void testAggScalarSubQuery() {
        String sql = "SELECT SUM(SELECT min(deptno) FROM dept) FROM emp";
        this.sql("SELECT SUM(SELECT min(deptno) FROM dept) FROM emp").ok();
    }

    @Test
    public void testAggCaseInSubQuery() {
        String sql = "SELECT SUM(\n  CASE WHEN deptno IN (SELECT deptno FROM dept) THEN 1 ELSE 0 END)\nFROM emp";
        this.sql("SELECT SUM(\n  CASE WHEN deptno IN (SELECT deptno FROM dept) THEN 1 ELSE 0 END)\nFROM emp").expand(false).ok();
    }

    @Test
    public void testCorrelatedSubQueryInAggregate() {
        String sql = "SELECT SUM(\n  (select char_length(name) from dept\n   where dept.deptno = emp.empno))\nFROM emp";
        this.sql("SELECT SUM(\n  (select char_length(name) from dept\n   where dept.deptno = emp.empno))\nFROM emp").expand(false).ok();
    }

    @Test
    public void testGroupByCaseIn() {
        String sql = "select\n (CASE WHEN (deptno IN (10, 20)) THEN 0 ELSE deptno END),\n min(empno) from EMP\ngroup by (CASE WHEN (deptno IN (10, 20)) THEN 0 ELSE deptno END)";
        this.sql("select\n (CASE WHEN (deptno IN (10, 20)) THEN 0 ELSE deptno END),\n min(empno) from EMP\ngroup by (CASE WHEN (deptno IN (10, 20)) THEN 0 ELSE deptno END)").ok();
    }

    @Test
    public void testInsert() {
        String sql = "insert into empnullables (deptno, empno, ename)\nvalues (10, 150, 'Fred')";
        this.sql("insert into empnullables (deptno, empno, ename)\nvalues (10, 150, 'Fred')").ok();
    }

    @Test
    public void testInsertSubset() {
        String sql = "insert into empnullables\nvalues (50, 'Fred')";
        this.sql("insert into empnullables\nvalues (50, 'Fred')").conformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003).ok();
    }

    @Test
    public void testInsertWithCustomInitializerExpressionFactory() {
        String sql = "insert into empdefaults (deptno) values (300)";
        this.sql("insert into empdefaults (deptno) values (300)").ok();
    }

    @Test
    public void testInsertSubsetWithCustomInitializerExpressionFactory() {
        String sql = "insert into empdefaults values (100)";
        this.sql("insert into empdefaults values (100)").conformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003).ok();
    }

    @Test
    public void testInsertBind() {
        String sql = "insert into empnullables (deptno, empno, ename)\nvalues (?, ?, ?)";
        this.sql("insert into empnullables (deptno, empno, ename)\nvalues (?, ?, ?)").ok();
    }

    @Test
    public void testInsertBindSubset() {
        String sql = "insert into empnullables\nvalues (?, ?)";
        this.sql("insert into empnullables\nvalues (?, ?)").conformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003).ok();
    }

    @Test
    public void testInsertBindWithCustomInitializerExpressionFactory() {
        String sql = "insert into empdefaults (deptno) values (?)";
        this.sql("insert into empdefaults (deptno) values (?)").ok();
    }

    @Test
    public void testInsertBindSubsetWithCustomInitializerExpressionFactory() {
        String sql = "insert into empdefaults values (?)";
        this.sql("insert into empdefaults values (?)").conformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003).ok();
    }

    @Test
    public void testInsertSubsetView() {
        String sql = "insert into empnullables_20\nvalues (10, 'Fred')";
        this.sql("insert into empnullables_20\nvalues (10, 'Fred')").conformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003).ok();
    }

    @Test
    public void testInsertExtendedColumn() {
        String sql = "insert into empdefaults(updated TIMESTAMP) (ename, deptno, empno, updated, sal) values ('Fred', 456, 44, timestamp '2017-03-12 13:03:05', 999999)";
        this.sql("insert into empdefaults(updated TIMESTAMP) (ename, deptno, empno, updated, sal) values ('Fred', 456, 44, timestamp '2017-03-12 13:03:05', 999999)").ok();
    }

    @Test
    public void testInsertBindExtendedColumn() {
        String sql = "insert into empdefaults(updated TIMESTAMP) (ename, deptno, empno, updated, sal) values ('Fred', 456, 44, ?, 999999)";
        this.sql("insert into empdefaults(updated TIMESTAMP) (ename, deptno, empno, updated, sal) values ('Fred', 456, 44, ?, 999999)").ok();
    }

    @Test
    public void testInsertExtendedColumnModifiableView() {
        String sql = "insert into EMP_MODIFIABLEVIEW2(updated TIMESTAMP) (ename, deptno, empno, updated, sal) values ('Fred', 20, 44, timestamp '2017-03-12 13:03:05', 999999)";
        this.sql("insert into EMP_MODIFIABLEVIEW2(updated TIMESTAMP) (ename, deptno, empno, updated, sal) values ('Fred', 20, 44, timestamp '2017-03-12 13:03:05', 999999)").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testInsertBindExtendedColumnModifiableView() {
        String sql = "insert into EMP_MODIFIABLEVIEW2(updated TIMESTAMP) (ename, deptno, empno, updated, sal) values ('Fred', 20, 44, ?, 999999)";
        this.sql("insert into EMP_MODIFIABLEVIEW2(updated TIMESTAMP) (ename, deptno, empno, updated, sal) values ('Fred', 20, 44, ?, 999999)").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testDelete() {
        String sql = "delete from emp";
        this.sql("delete from emp").ok();
    }

    @Test
    public void testDeleteWhere() {
        String sql = "delete from emp where deptno = 10";
        this.sql("delete from emp where deptno = 10").ok();
    }

    @Test
    public void testDeleteBind() {
        String sql = "delete from emp where deptno = ?";
        this.sql("delete from emp where deptno = ?").ok();
    }

    @Test
    public void testDeleteBindExtendedColumn() {
        String sql = "delete from emp(enddate TIMESTAMP) where enddate < ?";
        this.sql("delete from emp(enddate TIMESTAMP) where enddate < ?").ok();
    }

    @Test
    public void testDeleteBindModifiableView() {
        String sql = "delete from EMP_MODIFIABLEVIEW2 where empno = ?";
        this.sql("delete from EMP_MODIFIABLEVIEW2 where empno = ?").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testDeleteBindExtendedColumnModifiableView() {
        String sql = "delete from EMP_MODIFIABLEVIEW2(note VARCHAR)\nwhere note = ?";
        this.sql("delete from EMP_MODIFIABLEVIEW2(note VARCHAR)\nwhere note = ?").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testUpdate() {
        String sql = "update emp set empno = empno + 1";
        this.sql("update emp set empno = empno + 1").ok();
    }

    @Ignore(value="CALCITE-1527")
    @Test
    public void testUpdateSubQuery() {
        String sql = "update emp\nset empno = (\n  select min(empno) from emp as e where e.deptno = emp.deptno)";
        this.sql("update emp\nset empno = (\n  select min(empno) from emp as e where e.deptno = emp.deptno)").ok();
    }

    @Test
    public void testUpdateWhere() {
        String sql = "update emp set empno = empno + 1 where deptno = 10";
        this.sql("update emp set empno = empno + 1 where deptno = 10").ok();
    }

    @Test
    public void testUpdateModifiableView() {
        String sql = "update EMP_MODIFIABLEVIEW2\nset sal = sal + 5000 where slacker = false";
        this.sql("update EMP_MODIFIABLEVIEW2\nset sal = sal + 5000 where slacker = false").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testUpdateExtendedColumn() {
        String sql = "update empdefaults(updated TIMESTAMP) set deptno = 1, updated = timestamp '2017-03-12 13:03:05', empno = 20, ename = 'Bob' where deptno = 10";
        this.sql("update empdefaults(updated TIMESTAMP) set deptno = 1, updated = timestamp '2017-03-12 13:03:05', empno = 20, ename = 'Bob' where deptno = 10").ok();
    }

    @Test
    public void testUpdateExtendedColumnModifiableView() {
        String sql = "update EMP_MODIFIABLEVIEW2(updated TIMESTAMP)\nset updated = timestamp '2017-03-12 13:03:05', sal = sal + 5000\nwhere slacker = false";
        this.sql("update EMP_MODIFIABLEVIEW2(updated TIMESTAMP)\nset updated = timestamp '2017-03-12 13:03:05', sal = sal + 5000\nwhere slacker = false").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testUpdateBind() {
        String sql = "update emp set sal = sal + ? where slacker = false";
        this.sql("update emp set sal = sal + ? where slacker = false").ok();
    }

    @Test
    public void testUpdateBind2() {
        String sql = "update emp set sal = ? where slacker = false";
        this.sql("update emp set sal = ? where slacker = false").ok();
    }

    @Ignore(value="CALCITE-1708")
    @Test
    public void testUpdateBindExtendedColumn() {
        String sql = "update emp(test INT) set test = ?, sal = sal + 5000 where slacker = false";
        this.sql("update emp(test INT) set test = ?, sal = sal + 5000 where slacker = false").ok();
    }

    @Ignore(value="CALCITE-1708")
    @Test
    public void testUpdateBindExtendedColumnModifiableView() {
        String sql = "update EMP_MODIFIABLEVIEW2(test INT) set test = ?, sal = sal + 5000 where slacker = false";
        this.sql("update EMP_MODIFIABLEVIEW2(test INT) set test = ?, sal = sal + 5000 where slacker = false").ok();
    }

    @Ignore(value="CALCITE-985")
    @Test
    public void testMerge() {
        String sql = "merge into emp as target\nusing (select * from emp where deptno = 30) as source\non target.empno = source.empno\nwhen matched then\n  update set sal = sal + source.sal\nwhen not matched then\n  insert (empno, deptno, sal)\n  values (source.empno, source.deptno, source.sal)";
        this.sql("merge into emp as target\nusing (select * from emp where deptno = 30) as source\non target.empno = source.empno\nwhen matched then\n  update set sal = sal + source.sal\nwhen not matched then\n  insert (empno, deptno, sal)\n  values (source.empno, source.deptno, source.sal)").ok();
    }

    @Test
    public void testSelectView() {
        String sql = "select * from emp_20 where empno > 100";
        this.sql("select * from emp_20 where empno > 100").ok();
    }

    @Test
    public void testInsertView() {
        String sql = "insert into empnullables_20 (empno, ename)\nvalues (150, 'Fred')";
        this.sql("insert into empnullables_20 (empno, ename)\nvalues (150, 'Fred')").ok();
    }

    @Test
    public void testInsertModifiableView() {
        String sql = "insert into EMP_MODIFIABLEVIEW (EMPNO, ENAME, JOB) values (34625, 'nom', 'accountant')";
        this.sql("insert into EMP_MODIFIABLEVIEW (EMPNO, ENAME, JOB) values (34625, 'nom', 'accountant')").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testInsertSubsetModifiableView() {
        String sql = "insert into EMP_MODIFIABLEVIEW values (10, 'Fred')";
        this.sql("insert into EMP_MODIFIABLEVIEW values (10, 'Fred')").with(this.getExtendedTester()).conformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003).ok();
    }

    @Test
    public void testInsertBindModifiableView() {
        String sql = "insert into EMP_MODIFIABLEVIEW (empno, job) values (?, ?)";
        this.sql("insert into EMP_MODIFIABLEVIEW (empno, job) values (?, ?)").with(this.getExtendedTester()).ok();
    }

    @Test
    public void testInsertBindSubsetModifiableView() {
        String sql = "insert into EMP_MODIFIABLEVIEW values (?, ?)";
        this.sql("insert into EMP_MODIFIABLEVIEW values (?, ?)").conformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003).with(this.getExtendedTester()).ok();
    }

    @Test
    public void testInsertWithCustomColumnResolving() {
        String sql = "insert into struct.t values (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.sql("insert into struct.t values (?, ?, ?, ?, ?, ?, ?, ?, ?)").ok();
    }

    @Test
    public void testInsertWithCustomColumnResolving2() {
        String sql = "insert into struct.t_nullables (f0.c0, f1.c2, c1)\nvalues (?, ?, ?)";
        this.sql("insert into struct.t_nullables (f0.c0, f1.c2, c1)\nvalues (?, ?, ?)").ok();
    }

    @Test
    public void testInsertViewWithCustomColumnResolving() {
        String sql = "insert into struct.t_10 (f0.c0, f1.c2, c1, k0,\n  f1.a0, f2.a0, f0.c1, f2.c3)\nvalues (?, ?, ?, ?, ?, ?, ?, ?)";
        this.sql("insert into struct.t_10 (f0.c0, f1.c2, c1, k0,\n  f1.a0, f2.a0, f0.c1, f2.c3)\nvalues (?, ?, ?, ?, ?, ?, ?, ?)").ok();
    }

    @Test
    public void testUpdateWithCustomColumnResolving() {
        String sql = "update struct.t set c0 = c0 + 1";
        this.sql("update struct.t set c0 = c0 + 1").ok();
    }

    @Test
    public void testSubQueryAggregateFunctionFollowedBySimpleOperation() {
        String sql = "select deptno\nfrom EMP\nwhere deptno > (select min(deptno) * 2 + 10 from EMP)";
        this.sql("select deptno\nfrom EMP\nwhere deptno > (select min(deptno) * 2 + 10 from EMP)").ok();
    }

    @Test
    public void testSubQueryOr() {
        String sql = "select * from emp where deptno = 10 or deptno in (\n    select dept.deptno from dept where deptno < 5)\n";
        this.sql("select * from emp where deptno = 10 or deptno in (\n    select dept.deptno from dept where deptno < 5)\n").expand(false).ok();
    }

    @Test
    public void testSubQueryValues() {
        String sql = "select deptno\nfrom EMP\nwhere deptno > (values 10)";
        this.sql("select deptno\nfrom EMP\nwhere deptno > (values 10)").ok();
    }

    @Test
    public void testSubQueryLimitOne() {
        String sql = "select deptno\nfrom EMP\nwhere deptno > (select deptno\nfrom EMP order by deptno limit 1)";
        this.sql("select deptno\nfrom EMP\nwhere deptno > (select deptno\nfrom EMP order by deptno limit 1)").ok();
    }

    @Test
    public void testIdenticalExpressionInSubQuery() {
        String sql = "select deptno\nfrom EMP\nwhere deptno in (1, 2) or deptno in (1, 2)";
        this.sql("select deptno\nfrom EMP\nwhere deptno in (1, 2) or deptno in (1, 2)").ok();
    }

    @Test
    public void testHavingAggrFunctionIn() {
        String sql = "select deptno\nfrom emp\ngroup by deptno\nhaving sum(case when deptno in (1, 2) then 0 else 1 end) +\nsum(case when deptno in (3, 4) then 0 else 1 end) > 10";
        this.sql("select deptno\nfrom emp\ngroup by deptno\nhaving sum(case when deptno in (1, 2) then 0 else 1 end) +\nsum(case when deptno in (3, 4) then 0 else 1 end) > 10").ok();
    }

    @Test
    public void testHavingInSubQueryWithAggrFunction() {
        String sql = "select sal\nfrom emp\ngroup by sal\nhaving sal in (\n  select deptno\n  from dept\n  group by deptno\n  having sum(deptno) > 0)";
        this.sql("select sal\nfrom emp\ngroup by sal\nhaving sal in (\n  select deptno\n  from dept\n  group by deptno\n  having sum(deptno) > 0)").ok();
    }

    @Test
    public void testAggregateAndScalarSubQueryInHaving() {
        String sql = "select deptno\nfrom emp\ngroup by deptno\nhaving max(emp.empno) > (SELECT min(emp.empno) FROM emp)\n";
        this.sql("select deptno\nfrom emp\ngroup by deptno\nhaving max(emp.empno) > (SELECT min(emp.empno) FROM emp)\n").ok();
    }

    @Test
    public void testAggregateAndScalarSubQueryInSelect() {
        String sql = "select deptno,\n  max(emp.empno) > (SELECT min(emp.empno) FROM emp) as b\nfrom emp\ngroup by deptno\n";
        this.sql("select deptno,\n  max(emp.empno) > (SELECT min(emp.empno) FROM emp) as b\nfrom emp\ngroup by deptno\n").ok();
    }

    @Test
    public void testWindowAggWithGroupBy() {
        String sql = "select min(deptno), rank() over (order by empno),\nmax(empno) over (partition by deptno)\nfrom emp group by deptno, empno\n";
        this.sql("select min(deptno), rank() over (order by empno),\nmax(empno) over (partition by deptno)\nfrom emp group by deptno, empno\n").ok();
    }

    @Test
    public void testWindowAverageWithGroupBy() {
        String sql = "select avg(deptno) over ()\nfrom emp\ngroup by deptno";
        this.sql("select avg(deptno) over ()\nfrom emp\ngroup by deptno").ok();
    }

    @Test
    public void testWindowAggWithGroupByAndJoin() {
        String sql = "select min(d.deptno), rank() over (order by e.empno),\n max(e.empno) over (partition by e.deptno)\nfrom emp e, dept d\nwhere e.deptno = d.deptno\ngroup by d.deptno, e.empno, e.deptno\n";
        this.sql("select min(d.deptno), rank() over (order by e.empno),\n max(e.empno) over (partition by e.deptno)\nfrom emp e, dept d\nwhere e.deptno = d.deptno\ngroup by d.deptno, e.empno, e.deptno\n").ok();
    }

    @Test
    public void testWindowAggWithGroupByAndHaving() {
        String sql = "select min(deptno), rank() over (order by empno),\nmax(empno) over (partition by deptno)\nfrom emp group by deptno, empno\nhaving empno < 10 and min(deptno) < 20\n";
        this.sql("select min(deptno), rank() over (order by empno),\nmax(empno) over (partition by deptno)\nfrom emp group by deptno, empno\nhaving empno < 10 and min(deptno) < 20\n").ok();
    }

    @Test
    public void testWindowAggInSubQueryJoin() {
        String sql = "select T.x, T.y, T.z, emp.empno\nfrom (select min(deptno) as x,\n   rank() over (order by empno) as y,\n   max(empno) over (partition by deptno) as z\n   from emp group by deptno, empno) as T\n inner join emp on T.x = emp.deptno\n and T.y = emp.empno\n";
        this.sql("select T.x, T.y, T.z, emp.empno\nfrom (select min(deptno) as x,\n   rank() over (order by empno) as y,\n   max(empno) over (partition by deptno) as z\n   from emp group by deptno, empno) as T\n inner join emp on T.x = emp.deptno\n and T.y = emp.empno\n").ok();
    }

    @Test
    public void testOrderByOver() {
        String sql = "select deptno, rank() over(partition by empno order by deptno)\nfrom emp order by row_number() over(partition by empno order by deptno)";
        this.sql(sql).ok();
    }

    @Test
    public void testCorrelationScalarAggAndFilter() {
        String sql = "SELECT e1.empno\nFROM emp e1, dept d1 where e1.deptno = d1.deptno\nand e1.deptno < 10 and d1.deptno < 15\nand e1.sal > (select avg(sal) from emp e2 where e1.empno = e2.empno)";
        this.sql("SELECT e1.empno\nFROM emp e1, dept d1 where e1.deptno = d1.deptno\nand e1.deptno < 10 and d1.deptno < 15\nand e1.sal > (select avg(sal) from emp e2 where e1.empno = e2.empno)").decorrelate(true).expand(true).ok();
    }

    @Test
    public void testCorrelationMultiScalarAggregate() {
        String sql = "select sum(e1.empno)\nfrom emp e1, dept d1\nwhere e1.deptno = d1.deptno\nand e1.sal > (select avg(e2.sal) from emp e2\n  where e2.deptno = d1.deptno)";
        this.sql("select sum(e1.empno)\nfrom emp e1, dept d1\nwhere e1.deptno = d1.deptno\nand e1.sal > (select avg(e2.sal) from emp e2\n  where e2.deptno = d1.deptno)").decorrelate(true).expand(true).ok();
    }

    @Test
    public void testCorrelationScalarAggAndFilterRex() {
        String sql = "SELECT e1.empno\nFROM emp e1, dept d1 where e1.deptno = d1.deptno\nand e1.deptno < 10 and d1.deptno < 15\nand e1.sal > (select avg(sal) from emp e2 where e1.empno = e2.empno)";
        this.sql("SELECT e1.empno\nFROM emp e1, dept d1 where e1.deptno = d1.deptno\nand e1.deptno < 10 and d1.deptno < 15\nand e1.sal > (select avg(sal) from emp e2 where e1.empno = e2.empno)").decorrelate(true).expand(false).ok();
    }

    @Test
    public void testCorrelationExistsAndFilter() {
        String sql = "SELECT e1.empno\nFROM emp e1, dept d1 where e1.deptno = d1.deptno\nand e1.deptno < 10 and d1.deptno < 15\nand exists (select * from emp e2 where e1.empno = e2.empno)";
        this.sql("SELECT e1.empno\nFROM emp e1, dept d1 where e1.deptno = d1.deptno\nand e1.deptno < 10 and d1.deptno < 15\nand exists (select * from emp e2 where e1.empno = e2.empno)").decorrelate(true).expand(true).ok();
    }

    @Test
    public void testCorrelationExistsAndFilterRex() {
        String sql = "SELECT e1.empno\nFROM emp e1, dept d1 where e1.deptno = d1.deptno\nand e1.deptno < 10 and d1.deptno < 15\nand exists (select * from emp e2 where e1.empno = e2.empno)";
        this.sql("SELECT e1.empno\nFROM emp e1, dept d1 where e1.deptno = d1.deptno\nand e1.deptno < 10 and d1.deptno < 15\nand exists (select * from emp e2 where e1.empno = e2.empno)").decorrelate(true).ok();
    }

    @Test
    public void testCorrelationExistsAndFilterThetaRex() {
        String sql = "SELECT e1.empno\nFROM emp e1, dept d1 where e1.deptno = d1.deptno\nand e1.deptno < 10 and d1.deptno < 15\nand exists (select * from emp e2 where e1.empno < e2.empno)";
        this.sql("SELECT e1.empno\nFROM emp e1, dept d1 where e1.deptno = d1.deptno\nand e1.deptno < 10 and d1.deptno < 15\nand exists (select * from emp e2 where e1.empno < e2.empno)").decorrelate(true).ok();
    }

    @Test
    public void testCorrelationNotExistsAndFilter() {
        String sql = "SELECT e1.empno\nFROM emp e1, dept d1 where e1.deptno = d1.deptno\nand e1.deptno < 10 and d1.deptno < 15\nand not exists (select * from emp e2 where e1.empno = e2.empno)";
        this.sql("SELECT e1.empno\nFROM emp e1, dept d1 where e1.deptno = d1.deptno\nand e1.deptno < 10 and d1.deptno < 15\nand not exists (select * from emp e2 where e1.empno = e2.empno)").decorrelate(true).ok();
    }

    @Test
    public void testCustomColumnResolving() {
        String sql = "select k0 from struct.t";
        this.sql("select k0 from struct.t").ok();
    }

    @Test
    public void testCustomColumnResolving2() {
        String sql = "select c2 from struct.t";
        this.sql("select c2 from struct.t").ok();
    }

    @Test
    public void testCustomColumnResolving3() {
        String sql = "select f1.c2 from struct.t";
        this.sql("select f1.c2 from struct.t").ok();
    }

    @Test
    public void testCustomColumnResolving4() {
        String sql = "select c1 from struct.t order by f0.c1";
        this.sql("select c1 from struct.t order by f0.c1").ok();
    }

    @Test
    public void testCustomColumnResolving5() {
        String sql = "select count(c1) from struct.t group by f0.c1";
        this.sql("select count(c1) from struct.t group by f0.c1").ok();
    }

    @Test
    public void testCustomColumnResolvingWithSelectStar() {
        String sql = "select * from struct.t";
        this.sql("select * from struct.t").ok();
    }

    @Test
    public void testCustomColumnResolvingWithSelectFieldNameDotStar() {
        String sql = "select f1.* from struct.t";
        this.sql("select f1.* from struct.t").ok();
    }

    @Test
    public void testSelectFromDynamicTable() throws Exception {
        String sql = "select n_nationkey, n_name from SALES.NATION";
        this.sql("select n_nationkey, n_name from SALES.NATION").with(this.getTesterWithDynamicTable()).ok();
    }

    @Test
    public void testSelectStarFromDynamicTable() throws Exception {
        String sql = "select * from SALES.NATION";
        this.sql("select * from SALES.NATION").with(this.getTesterWithDynamicTable()).ok();
    }

    @Test
    public void testNotInWithLiteral() {
        String sql = "SELECT *\nFROM SALES.NATION\nWHERE n_name NOT IN\n    (SELECT ''\n     FROM SALES.NATION)";
        this.sql("SELECT *\nFROM SALES.NATION\nWHERE n_name NOT IN\n    (SELECT ''\n     FROM SALES.NATION)").with(this.getTesterWithDynamicTable()).ok();
    }

    @Test
    public void testReferDynamicStarInSelectOB() throws Exception {
        String sql = "select n_nationkey, n_name\nfrom (select * from SALES.NATION)\norder by n_regionkey";
        this.sql("select n_nationkey, n_name\nfrom (select * from SALES.NATION)\norder by n_regionkey").with(this.getTesterWithDynamicTable()).ok();
    }

    @Test
    public void testDynamicStarInTableJoin() throws Exception {
        String sql = "select * from  (select * from SALES.NATION) T1,  (SELECT * from SALES.CUSTOMER) T2  where T1.n_nationkey = T2.c_nationkey";
        this.sql("select * from  (select * from SALES.NATION) T1,  (SELECT * from SALES.CUSTOMER) T2  where T1.n_nationkey = T2.c_nationkey").with(this.getTesterWithDynamicTable()).ok();
    }

    @Test
    public void testDynamicNestedColumn() {
        String sql = "select t3.fake_q1['fake_col2'] as fake2\nfrom (\n  select t2.fake_col as fake_q1\n  from SALES.CUSTOMER as t2) as t3";
        this.sql("select t3.fake_q1['fake_col2'] as fake2\nfrom (\n  select t2.fake_col as fake_q1\n  from SALES.CUSTOMER as t2) as t3").with(this.getTesterWithDynamicTable()).ok();
    }

    @Test
    public void testDynamicSchemaUnnest() {
        String sql3 = "select t1.c_nationkey, t3.fake_col3\nfrom SALES.CUSTOMER as t1,\nlateral (select t2.\"$unnest\" as fake_col3\n         from unnest(t1.fake_col) as t2) as t3";
        this.sql("select t1.c_nationkey, t3.fake_col3\nfrom SALES.CUSTOMER as t1,\nlateral (select t2.\"$unnest\" as fake_col3\n         from unnest(t1.fake_col) as t2) as t3").with(this.getTesterWithDynamicTable()).ok();
    }

    @Test
    public void testStarDynamicSchemaUnnest() {
        String sql3 = "select *\nfrom SALES.CUSTOMER as t1,\nlateral (select t2.\"$unnest\" as fake_col3\n         from unnest(t1.fake_col) as t2) as t3";
        this.sql("select *\nfrom SALES.CUSTOMER as t1,\nlateral (select t2.\"$unnest\" as fake_col3\n         from unnest(t1.fake_col) as t2) as t3").with(this.getTesterWithDynamicTable()).ok();
    }

    @Test
    public void testStarDynamicSchemaUnnest2() {
        String sql3 = "select *\nfrom SALES.CUSTOMER as t1,\nunnest(t1.fake_col) as t2";
        this.sql("select *\nfrom SALES.CUSTOMER as t1,\nunnest(t1.fake_col) as t2").with(this.getTesterWithDynamicTable()).ok();
    }

    @Test
    public void testStarDynamicSchemaUnnestNestedSubQuery() {
        String sql3 = "select t2.c1\nfrom (select * from SALES.CUSTOMER) as t1,\nunnest(t1.fake_col) as t2(c1)";
        this.sql(sql3).with(this.getTesterWithDynamicTable()).ok();
    }

    @Test
    public void testReferDynamicStarInSelectWhereGB() throws Exception {
        String sql = "select n_regionkey, count(*) as cnt from (select * from SALES.NATION) where n_nationkey > 5 group by n_regionkey";
        this.sql("select n_regionkey, count(*) as cnt from (select * from SALES.NATION) where n_nationkey > 5 group by n_regionkey").with(this.getTesterWithDynamicTable()).ok();
    }

    @Test
    public void testDynamicStarInJoinAndSubQ() throws Exception {
        String sql = "select * from  (select * from SALES.NATION T1,  SALES.CUSTOMER T2 where T1.n_nationkey = T2.c_nationkey)";
        this.sql("select * from  (select * from SALES.NATION T1,  SALES.CUSTOMER T2 where T1.n_nationkey = T2.c_nationkey)").with(this.getTesterWithDynamicTable()).ok();
    }

    @Test
    public void testStarJoinStaticDynTable() throws Exception {
        String sql = "select * from SALES.NATION N, SALES.REGION as R where N.n_regionkey = R.r_regionkey";
        this.sql("select * from SALES.NATION N, SALES.REGION as R where N.n_regionkey = R.r_regionkey").with(this.getTesterWithDynamicTable()).ok();
    }

    @Test
    public void testGrpByColFromStarInSubQuery() throws Exception {
        String sql = "SELECT n.n_nationkey AS col  from (SELECT * FROM SALES.NATION) as n  group by n.n_nationkey";
        this.sql("SELECT n.n_nationkey AS col  from (SELECT * FROM SALES.NATION) as n  group by n.n_nationkey").with(this.getTesterWithDynamicTable()).ok();
    }

    @Test
    public void testDynStarInExistSubQ() throws Exception {
        String sql = "select *\nfrom SALES.REGION where exists (select * from SALES.NATION)";
        this.sql("select *\nfrom SALES.REGION where exists (select * from SALES.NATION)").with(this.getTesterWithDynamicTable()).ok();
    }

    @Test
    public void testSelectDynamicStarOrderBy() throws Exception {
        String sql = "SELECT * from SALES.NATION order by n_nationkey";
        this.sql("SELECT * from SALES.NATION order by n_nationkey").with(this.getTesterWithDynamicTable()).ok();
    }

    @Test
    public void testInToSemiJoin() {
        String sql = "SELECT empno\nFROM emp AS e\nWHERE cast(e.empno as bigint) in (130, 131, 132, 133, 134)";
        SqlToRelConverter.Config noConvertConfig = SqlToRelConverter.configBuilder().withInSubQueryThreshold(10).build();
        this.sql("SELECT empno\nFROM emp AS e\nWHERE cast(e.empno as bigint) in (130, 131, 132, 133, 134)").withConfig(noConvertConfig).convertsTo("${planNotConverted}");
        SqlToRelConverter.Config convertConfig = SqlToRelConverter.configBuilder().withInSubQueryThreshold(2).build();
        this.sql("SELECT empno\nFROM emp AS e\nWHERE cast(e.empno as bigint) in (130, 131, 132, 133, 134)").withConfig(convertConfig).convertsTo("${planConverted}");
    }

    @Test
    public void testWindowOnDynamicStar() throws Exception {
        String sql = "SELECT SUM(n_nationkey) OVER w\nFROM (SELECT * FROM SALES.NATION) subQry\nWINDOW w AS (PARTITION BY REGION ORDER BY n_nationkey)";
        this.sql("SELECT SUM(n_nationkey) OVER w\nFROM (SELECT * FROM SALES.NATION) subQry\nWINDOW w AS (PARTITION BY REGION ORDER BY n_nationkey)").with(this.getTesterWithDynamicTable()).ok();
    }

    @Test
    public void testWindowAndGroupByWithDynamicStar() {
        String sql = "SELECT\nn_regionkey,\nMAX(MIN(n_nationkey)) OVER (PARTITION BY n_regionkey)\nFROM (SELECT * FROM SALES.NATION)\nGROUP BY n_regionkey";
        this.sql("SELECT\nn_regionkey,\nMAX(MIN(n_nationkey)) OVER (PARTITION BY n_regionkey)\nFROM (SELECT * FROM SALES.NATION)\nGROUP BY n_regionkey").conformance((SqlConformance)new SqlDelegatingConformance((SqlConformance)SqlConformanceEnum.DEFAULT){

            public boolean isGroupByAlias() {
                return true;
            }
        }).with(this.getTesterWithDynamicTable()).ok();
    }

    @Test
    public void testAnyValueAggregateFunctionNoGroupBy() throws Exception {
        String sql = "SELECT any_value(empno) as anyempno FROM emp AS e";
        this.sql("SELECT any_value(empno) as anyempno FROM emp AS e").ok();
    }

    @Test
    public void testAnyValueAggregateFunctionGroupBy() throws Exception {
        String sql = "SELECT any_value(empno) as anyempno FROM emp AS e group by e.sal";
        this.sql("SELECT any_value(empno) as anyempno FROM emp AS e group by e.sal").ok();
    }

    private SqlToRelTestBase.Tester getExtendedTester() {
        return this.tester.withCatalogReaderFactory(MockCatalogReaderExtended::new);
    }

    @Test
    public void testLarge() {
        int x = 300;
        SqlValidatorTest.checkLarge(300, input -> {
            RelRoot root = this.tester.convertSqlToRel((String)input);
            String s = RelOptUtil.toString((RelNode)root.project());
            Assert.assertThat((Object)s, (Matcher)CoreMatchers.notNullValue());
        });
    }

    @Test
    public void testUnionInFrom() {
        String sql = "select x0, x1 from (\n  select 'a' as x0, 'a' as x1, 'a' as x2 from emp\n  union all\n  select 'bb' as x0, 'bb' as x1, 'bb' as x2 from dept)";
        this.sql("select x0, x1 from (\n  select 'a' as x0, 'a' as x1, 'a' as x2 from emp\n  union all\n  select 'bb' as x0, 'bb' as x1, 'bb' as x2 from dept)").ok();
    }

    @Test
    public void testMatchRecognize1() {
        String sql = "select *\n  from emp match_recognize\n  (\n    partition by job, sal\n    order by job asc, sal desc, empno\n    pattern (strt down+ up+)\n    define\n      down as down.mgr < PREV(down.mgr),\n      up as up.mgr > prev(up.mgr)) as mr";
        this.sql("select *\n  from emp match_recognize\n  (\n    partition by job, sal\n    order by job asc, sal desc, empno\n    pattern (strt down+ up+)\n    define\n      down as down.mgr < PREV(down.mgr),\n      up as up.mgr > prev(up.mgr)) as mr").ok();
    }

    @Test
    public void testMatchRecognizeMeasures1() {
        String sql = "select *\nfrom emp match_recognize (\n  partition by job, sal\n  order by job asc, sal desc\n  measures MATCH_NUMBER() as match_num,\n    CLASSIFIER() as var_match,\n    STRT.mgr as start_nw,\n    LAST(DOWN.mgr) as bottom_nw,\n    LAST(up.mgr) as end_nw\n  pattern (strt down+ up+)\n  define\n    down as down.mgr < PREV(down.mgr),\n    up as up.mgr > prev(up.mgr)) as mr";
        this.sql("select *\nfrom emp match_recognize (\n  partition by job, sal\n  order by job asc, sal desc\n  measures MATCH_NUMBER() as match_num,\n    CLASSIFIER() as var_match,\n    STRT.mgr as start_nw,\n    LAST(DOWN.mgr) as bottom_nw,\n    LAST(up.mgr) as end_nw\n  pattern (strt down+ up+)\n  define\n    down as down.mgr < PREV(down.mgr),\n    up as up.mgr > prev(up.mgr)) as mr").ok();
    }

    @Test
    public void testMatchRecognizeMeasures2() {
        String sql = "select *\nfrom emp match_recognize (\n  partition by job\n  order by sal\n  measures MATCH_NUMBER() as match_num,\n    CLASSIFIER() as var_match,\n    STRT.mgr as start_nw,\n    LAST(DOWN.mgr) as bottom_nw,\n    LAST(up.mgr) as end_nw\n  pattern (strt down+ up+)\n  define\n    down as down.mgr < PREV(down.mgr),\n    up as up.mgr > prev(up.mgr)) as mr";
        this.sql("select *\nfrom emp match_recognize (\n  partition by job\n  order by sal\n  measures MATCH_NUMBER() as match_num,\n    CLASSIFIER() as var_match,\n    STRT.mgr as start_nw,\n    LAST(DOWN.mgr) as bottom_nw,\n    LAST(up.mgr) as end_nw\n  pattern (strt down+ up+)\n  define\n    down as down.mgr < PREV(down.mgr),\n    up as up.mgr > prev(up.mgr)) as mr").ok();
    }

    @Test
    public void testMatchRecognizeMeasures3() {
        String sql = "select *\nfrom emp match_recognize (\n  partition by job\n  order by sal\n  measures MATCH_NUMBER() as match_num,\n    CLASSIFIER() as var_match,\n    STRT.mgr as start_nw,\n    LAST(DOWN.mgr) as bottom_nw,\n    LAST(up.mgr) as end_nw\n  ALL ROWS PER MATCH\n  pattern (strt down+ up+)\n  define\n    down as down.mgr < PREV(down.mgr),\n    up as up.mgr > prev(up.mgr)) as mr";
        this.sql("select *\nfrom emp match_recognize (\n  partition by job\n  order by sal\n  measures MATCH_NUMBER() as match_num,\n    CLASSIFIER() as var_match,\n    STRT.mgr as start_nw,\n    LAST(DOWN.mgr) as bottom_nw,\n    LAST(up.mgr) as end_nw\n  ALL ROWS PER MATCH\n  pattern (strt down+ up+)\n  define\n    down as down.mgr < PREV(down.mgr),\n    up as up.mgr > prev(up.mgr)) as mr").ok();
    }

    @Test
    public void testMatchRecognizePatternSkip1() {
        String sql = "select *\n  from emp match_recognize\n  (\n    after match skip to next row\n    pattern (strt down+ up+)\n    define\n      down as down.mgr < PREV(down.mgr),\n      up as up.mgr > NEXT(up.mgr)\n  ) mr";
        this.sql("select *\n  from emp match_recognize\n  (\n    after match skip to next row\n    pattern (strt down+ up+)\n    define\n      down as down.mgr < PREV(down.mgr),\n      up as up.mgr > NEXT(up.mgr)\n  ) mr").ok();
    }

    @Test
    public void testMatchRecognizeSubset1() {
        String sql = "select *\n  from emp match_recognize\n  (\n    after match skip to down\n    pattern (strt down+ up+)\n    subset stdn = (strt, down)\n    define\n      down as down.mgr < PREV(down.mgr),\n      up as up.mgr > NEXT(up.mgr)\n  ) mr";
        this.sql("select *\n  from emp match_recognize\n  (\n    after match skip to down\n    pattern (strt down+ up+)\n    subset stdn = (strt, down)\n    define\n      down as down.mgr < PREV(down.mgr),\n      up as up.mgr > NEXT(up.mgr)\n  ) mr").ok();
    }

    @Test
    public void testMatchRecognizePrevLast() {
        String sql = "SELECT *\nFROM emp\nMATCH_RECOGNIZE (\n  MEASURES\n    STRT.mgr AS start_mgr,\n    LAST(DOWN.mgr) AS bottom_mgr,\n    LAST(UP.mgr) AS end_mgr\n  ONE ROW PER MATCH\n  PATTERN (STRT DOWN+ UP+)\n  DEFINE\n    DOWN AS DOWN.mgr < PREV(DOWN.mgr),\n    UP AS UP.mgr > PREV(LAST(DOWN.mgr, 1), 1)\n) AS T";
        this.sql("SELECT *\nFROM emp\nMATCH_RECOGNIZE (\n  MEASURES\n    STRT.mgr AS start_mgr,\n    LAST(DOWN.mgr) AS bottom_mgr,\n    LAST(UP.mgr) AS end_mgr\n  ONE ROW PER MATCH\n  PATTERN (STRT DOWN+ UP+)\n  DEFINE\n    DOWN AS DOWN.mgr < PREV(DOWN.mgr),\n    UP AS UP.mgr > PREV(LAST(DOWN.mgr, 1), 1)\n) AS T").ok();
    }

    @Test
    public void testMatchRecognizePrevDown() {
        String sql = "SELECT *\nFROM emp\nMATCH_RECOGNIZE (\n  MEASURES\n    STRT.mgr AS start_mgr,\n    LAST(DOWN.mgr) AS up_days,\n    LAST(UP.mgr) AS total_days\n  PATTERN (STRT DOWN+ UP+)\n  DEFINE\n    DOWN AS DOWN.mgr < PREV(DOWN.mgr),\n    UP AS UP.mgr > PREV(DOWN.mgr)\n) AS T";
        this.sql("SELECT *\nFROM emp\nMATCH_RECOGNIZE (\n  MEASURES\n    STRT.mgr AS start_mgr,\n    LAST(DOWN.mgr) AS up_days,\n    LAST(UP.mgr) AS total_days\n  PATTERN (STRT DOWN+ UP+)\n  DEFINE\n    DOWN AS DOWN.mgr < PREV(DOWN.mgr),\n    UP AS UP.mgr > PREV(DOWN.mgr)\n) AS T").ok();
    }

    @Test
    public void testPrevClassifier() {
        String sql = "SELECT *\nFROM emp\nMATCH_RECOGNIZE (\n  MEASURES\n    STRT.mgr AS start_mgr,\n    LAST(DOWN.mgr) AS up_days,\n    LAST(UP.mgr) AS total_days\n  PATTERN (STRT DOWN? UP+)\n  DEFINE\n    DOWN AS DOWN.mgr < PREV(DOWN.mgr),\n    UP AS CASE\n            WHEN PREV(CLASSIFIER()) = 'STRT'\n              THEN UP.mgr > 15\n            ELSE\n              UP.mgr > 20\n            END\n) AS T";
        this.sql("SELECT *\nFROM emp\nMATCH_RECOGNIZE (\n  MEASURES\n    STRT.mgr AS start_mgr,\n    LAST(DOWN.mgr) AS up_days,\n    LAST(UP.mgr) AS total_days\n  PATTERN (STRT DOWN? UP+)\n  DEFINE\n    DOWN AS DOWN.mgr < PREV(DOWN.mgr),\n    UP AS CASE\n            WHEN PREV(CLASSIFIER()) = 'STRT'\n              THEN UP.mgr > 15\n            ELSE\n              UP.mgr > 20\n            END\n) AS T").ok();
    }

    @Test
    public void testUserDefinedOrderByOver() {
        String sql = "select deptno,\n  rank() over(partition by empno order by deptno)\nfrom emp\norder by row_number() over(partition by empno order by deptno)";
        Properties properties = new Properties();
        properties.setProperty(CalciteConnectionProperty.DEFAULT_NULL_COLLATION.camelName(), NullCollation.LOW.name());
        CalciteConnectionConfigImpl connectionConfig = new CalciteConnectionConfigImpl(properties);
        SqlToRelTestBase.TesterImpl tester = new SqlToRelTestBase.TesterImpl(this.getDiffRepos(), false, false, true, false, null, null, SqlToRelConverter.Config.DEFAULT, (SqlConformance)SqlConformanceEnum.DEFAULT, Contexts.of((Object)connectionConfig));
        this.sql(sql).with(tester).ok();
    }

    @Test
    public void testJsonExists() {
        String sql = "select json_exists(ename, 'lax $')\nfrom emp";
        this.sql("select json_exists(ename, 'lax $')\nfrom emp").ok();
    }

    @Test
    public void testJsonValue() {
        String sql = "select json_value(ename, 'lax $')\nfrom emp";
        this.sql("select json_value(ename, 'lax $')\nfrom emp").ok();
    }

    @Test
    public void testJsonQuery() {
        String sql = "select json_query(ename, 'lax $')\nfrom emp";
        this.sql("select json_query(ename, 'lax $')\nfrom emp").ok();
    }

    @Test
    public void testJsonArray() {
        String sql = "select json_array(ename, ename)\nfrom emp";
        this.sql("select json_array(ename, ename)\nfrom emp").ok();
    }

    @Test
    public void testJsonArrayAgg1() {
        String sql = "select json_arrayagg(ename)\nfrom emp";
        this.sql("select json_arrayagg(ename)\nfrom emp").ok();
    }

    @Test
    public void testJsonArrayAgg2() {
        String sql = "select json_arrayagg(ename order by ename)\nfrom emp";
        this.sql("select json_arrayagg(ename order by ename)\nfrom emp").ok();
    }

    @Test
    public void testJsonArrayAgg3() {
        String sql = "select json_arrayagg(ename order by ename null on null)\nfrom emp";
        this.sql("select json_arrayagg(ename order by ename null on null)\nfrom emp").ok();
    }

    @Test
    public void testJsonArrayAgg4() {
        String sql = "select json_arrayagg(ename null on null) within group (order by ename)\nfrom emp";
        this.sql("select json_arrayagg(ename null on null) within group (order by ename)\nfrom emp").ok();
    }

    @Test
    public void testJsonObject() {
        String sql = "select json_object(ename: deptno, ename: deptno)\nfrom emp";
        this.sql("select json_object(ename: deptno, ename: deptno)\nfrom emp").ok();
    }

    @Test
    public void testJsonObjectAgg() {
        String sql = "select json_objectagg(ename: deptno)\nfrom emp";
        this.sql("select json_objectagg(ename: deptno)\nfrom emp").ok();
    }

    @Test
    public void testJsonPredicate() {
        String sql = "select\nename is json,\nename is json value,\nename is json object,\nename is json array,\nename is json scalar,\nename is not json,\nename is not json value,\nename is not json object,\nename is not json array,\nename is not json scalar\nfrom emp";
        this.sql("select\nename is json,\nename is json value,\nename is json object,\nename is json array,\nename is json scalar,\nename is not json,\nename is not json value,\nename is not json object,\nename is not json array,\nename is not json scalar\nfrom emp").ok();
    }

    @Test
    public void testWithinGroup1() {
        String sql = "select deptno,\n collect(empno) within group (order by deptno, hiredate desc)\nfrom emp\ngroup by deptno";
        this.sql("select deptno,\n collect(empno) within group (order by deptno, hiredate desc)\nfrom emp\ngroup by deptno").ok();
    }

    @Test
    public void testWithinGroup2() {
        String sql = "select dept.deptno,\n collect(sal) within group (order by sal desc) as s,\n collect(sal) within group (order by 1)as s1,\n collect(sal) within group (order by sal)\n  filter (where sal > 2000) as s2\nfrom emp\njoin dept using (deptno)\ngroup by dept.deptno";
        this.sql("select dept.deptno,\n collect(sal) within group (order by sal desc) as s,\n collect(sal) within group (order by 1)as s1,\n collect(sal) within group (order by sal)\n  filter (where sal > 2000) as s2\nfrom emp\njoin dept using (deptno)\ngroup by dept.deptno").ok();
    }

    @Test
    public void testWithinGroup3() {
        String sql = "select deptno,\n collect(empno) within group (order by empno not in (1, 2)), count(*)\nfrom emp\ngroup by deptno";
        this.sql("select deptno,\n collect(empno) within group (order by empno not in (1, 2)), count(*)\nfrom emp\ngroup by deptno").ok();
    }

    @Test
    public void testOrderByRemoval1() {
        String sql = "select * from (\n  select empno from emp order by deptno offset 0) t\norder by empno desc";
        this.sql("select * from (\n  select empno from emp order by deptno offset 0) t\norder by empno desc").ok();
    }

    @Test
    public void testOrderByRemoval2() {
        String sql = "select * from (\n  select empno from emp order by deptno offset 1) t\norder by empno desc";
        this.sql("select * from (\n  select empno from emp order by deptno offset 1) t\norder by empno desc").ok();
    }

    @Test
    public void testOrderByRemoval3() {
        String sql = "select * from (\n  select empno from emp order by deptno limit 10) t\norder by empno";
        this.sql("select * from (\n  select empno from emp order by deptno limit 10) t\norder by empno").ok();
    }

    public class Sql {
        private final String sql;
        private final boolean expand;
        private final boolean decorrelate;
        private final SqlToRelTestBase.Tester tester;
        private final boolean trim;
        private final SqlToRelConverter.Config config;
        private final SqlConformance conformance;

        Sql(String sql, boolean expand, boolean decorrelate, SqlToRelTestBase.Tester tester, boolean trim, SqlToRelConverter.Config config, SqlConformance conformance) {
            this.sql = sql;
            this.expand = expand;
            this.decorrelate = decorrelate;
            this.tester = tester;
            this.trim = trim;
            this.config = config;
            this.conformance = conformance;
        }

        public void ok() {
            this.convertsTo("${plan}");
        }

        public void convertsTo(String plan) {
            this.tester.withExpand(this.expand).withDecorrelation(this.decorrelate).withConformance(this.conformance).withConfig(this.config).assertConvertsTo(this.sql, plan, this.trim);
        }

        public Sql withConfig(SqlToRelConverter.Config config) {
            return new Sql(this.sql, this.expand, this.decorrelate, this.tester, this.trim, config, this.conformance);
        }

        public Sql expand(boolean expand) {
            return new Sql(this.sql, expand, this.decorrelate, this.tester, this.trim, this.config, this.conformance);
        }

        public Sql decorrelate(boolean decorrelate) {
            return new Sql(this.sql, this.expand, decorrelate, this.tester, this.trim, this.config, this.conformance);
        }

        public Sql with(SqlToRelTestBase.Tester tester) {
            return new Sql(this.sql, this.expand, this.decorrelate, tester, this.trim, this.config, this.conformance);
        }

        public Sql trim(boolean trim) {
            return new Sql(this.sql, this.expand, this.decorrelate, this.tester, trim, this.config, this.conformance);
        }

        public Sql conformance(SqlConformance conformance) {
            return new Sql(this.sql, this.expand, this.decorrelate, this.tester, this.trim, this.config, conformance);
        }
    }

    public static class RelValidityChecker
    extends RelVisitor
    implements RelNode.Context {
        int invalidCount;
        final Deque<RelNode> stack = new ArrayDeque<RelNode>();

        public Set<CorrelationId> correlationIds() {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (RelNode r : this.stack) {
                builder.addAll((Iterable)r.getVariablesSet());
            }
            return builder.build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(RelNode node, int ordinal, RelNode parent) {
            try {
                this.stack.push(node);
                if (!node.isValid(Litmus.THROW, (RelNode.Context)this)) {
                    ++this.invalidCount;
                }
                super.visit(node, ordinal, parent);
            }
            finally {
                this.stack.pop();
            }
        }
    }
}

