/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableMap;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.PathNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlJsonExistsErrorBehavior;
import org.apache.calcite.sql.SqlJsonQueryEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SqlJsonFunctionsTest {
    public static final String INVOC_DESC_JSON_VALUE_EXPRESSION = "jsonValueExpression";
    public static final String INVOC_DESC_JSON_STRUCTURED_VALUE_EXPRESSION = "jsonStructuredValueExpression";
    public static final String INVOC_DESC_JSON_API_COMMON_SYNTAX = "jsonApiCommonSyntax";
    public static final String INVOC_DESC_JSON_EXISTS = "jsonExists";
    public static final String INVOC_DESC_JSON_VALUE_ANY = "jsonValueAny";
    public static final String INVOC_DESC_JSON_QUERY = "jsonQuery";
    public static final String INVOC_DESC_JSONIZE = "jsonize";
    public static final String INVOC_DESC_DEJSONIZE = "dejsonize";
    public static final String INVOC_DESC_JSON_OBJECT = "jsonObject";
    public static final String INVOC_DESC_JSON_TYPE = "jsonType";
    public static final String INVOC_DESC_JSON_DEPTH = "jsonDepth";
    public static final String INVOC_DESC_JSON_OBJECT_AGG_ADD = "jsonObjectAggAdd";
    public static final String INVOC_DESC_JSON_ARRAY = "jsonArray";
    public static final String INVOC_DESC_JSON_ARRAY_AGG_ADD = "jsonArrayAggAdd";
    public static final String INVOC_DESC_IS_JSON_VALUE = "isJsonValue";
    public static final String INVOC_DESC_IS_JSON_SCALAR = "isJsonScalar";
    public static final String INVOC_DESC_IS_JSON_ARRAY = "isJsonArray";
    public static final String INVOC_DESC_IS_JSON_OBJECT = "isJsonObject";

    @Test
    public void testJsonValueExpression() {
        this.assertJsonValueExpression("{}", (Matcher<Object>)CoreMatchers.is(Collections.emptyMap()));
    }

    @Test
    public void testJsonStructuredValueExpression() {
        this.assertJsonStructuredValueExpression("bar", (Matcher<Object>)CoreMatchers.is((Object)"bar"));
        this.assertJsonStructuredValueExpression(100, (Matcher<Object>)CoreMatchers.is((Object)100));
    }

    @Test
    public void testJsonApiCommonSyntax() {
        this.assertJsonApiCommonSyntax(ImmutableMap.of((Object)"foo", (Object)"bar"), "lax $.foo", (Matcher<? super SqlFunctions.PathContext>)this.contextMatches(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, (Object)"bar")));
        this.assertJsonApiCommonSyntax(ImmutableMap.of((Object)"foo", (Object)"bar"), "strict $.foo", (Matcher<? super SqlFunctions.PathContext>)this.contextMatches(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.STRICT, (Object)"bar")));
        this.assertJsonApiCommonSyntax(ImmutableMap.of((Object)"foo", (Object)"bar"), "lax $.foo1", (Matcher<? super SqlFunctions.PathContext>)this.contextMatches(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, null)));
        this.assertJsonApiCommonSyntax(ImmutableMap.of((Object)"foo", (Object)"bar"), "strict $.foo1", (Matcher<? super SqlFunctions.PathContext>)this.contextMatches(SqlFunctions.PathContext.withStrictException((Exception)new PathNotFoundException("No results for path: $['foo1']"))));
        this.assertJsonApiCommonSyntax(ImmutableMap.of((Object)"foo", (Object)100), "lax $.foo", (Matcher<? super SqlFunctions.PathContext>)this.contextMatches(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, (Object)100)));
    }

    @Test
    public void testJsonExists() {
        this.assertJsonExists(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.STRICT, (Object)"bar"), SqlJsonExistsErrorBehavior.FALSE, (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertJsonExists(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.STRICT, (Object)"bar"), SqlJsonExistsErrorBehavior.TRUE, (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertJsonExists(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.STRICT, (Object)"bar"), SqlJsonExistsErrorBehavior.UNKNOWN, (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertJsonExists(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.STRICT, (Object)"bar"), SqlJsonExistsErrorBehavior.ERROR, (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertJsonExists(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, null), SqlJsonExistsErrorBehavior.FALSE, (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertJsonExists(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, null), SqlJsonExistsErrorBehavior.TRUE, (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertJsonExists(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, null), SqlJsonExistsErrorBehavior.UNKNOWN, (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertJsonExists(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, null), SqlJsonExistsErrorBehavior.ERROR, (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertJsonExists(SqlFunctions.PathContext.withStrictException((Exception)new Exception("test message")), SqlJsonExistsErrorBehavior.FALSE, (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertJsonExists(SqlFunctions.PathContext.withStrictException((Exception)new Exception("test message")), SqlJsonExistsErrorBehavior.TRUE, (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertJsonExists(SqlFunctions.PathContext.withStrictException((Exception)new Exception("test message")), SqlJsonExistsErrorBehavior.UNKNOWN, (Matcher<? super Boolean>)CoreMatchers.nullValue());
        this.assertJsonExistsFailed(SqlFunctions.PathContext.withStrictException((Exception)new Exception("test message")), SqlJsonExistsErrorBehavior.ERROR, this.errorMatches(new RuntimeException("java.lang.Exception: test message")));
    }

    @Test
    public void testJsonValueAny() {
        this.assertJsonValueAny(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, (Object)"bar"), SqlJsonValueEmptyOrErrorBehavior.NULL, null, SqlJsonValueEmptyOrErrorBehavior.NULL, null, (Matcher<Object>)CoreMatchers.is((Object)"bar"));
        this.assertJsonValueAny(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, null), SqlJsonValueEmptyOrErrorBehavior.NULL, null, SqlJsonValueEmptyOrErrorBehavior.NULL, null, (Matcher<Object>)CoreMatchers.nullValue());
        this.assertJsonValueAny(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, null), SqlJsonValueEmptyOrErrorBehavior.DEFAULT, "empty", SqlJsonValueEmptyOrErrorBehavior.NULL, null, (Matcher<Object>)CoreMatchers.is((Object)"empty"));
        this.assertJsonValueAnyFailed(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, null), SqlJsonValueEmptyOrErrorBehavior.ERROR, null, SqlJsonValueEmptyOrErrorBehavior.NULL, null, this.errorMatches(new CalciteException("Empty result of JSON_VALUE function is not allowed", null)));
        this.assertJsonValueAny(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, Collections.emptyList()), SqlJsonValueEmptyOrErrorBehavior.NULL, null, SqlJsonValueEmptyOrErrorBehavior.NULL, null, (Matcher<Object>)CoreMatchers.nullValue());
        this.assertJsonValueAny(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, Collections.emptyList()), SqlJsonValueEmptyOrErrorBehavior.DEFAULT, "empty", SqlJsonValueEmptyOrErrorBehavior.NULL, null, (Matcher<Object>)CoreMatchers.is((Object)"empty"));
        this.assertJsonValueAnyFailed(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, Collections.emptyList()), SqlJsonValueEmptyOrErrorBehavior.ERROR, null, SqlJsonValueEmptyOrErrorBehavior.NULL, null, this.errorMatches(new CalciteException("Empty result of JSON_VALUE function is not allowed", null)));
        this.assertJsonValueAny(SqlFunctions.PathContext.withStrictException((Exception)new Exception("test message")), SqlJsonValueEmptyOrErrorBehavior.NULL, null, SqlJsonValueEmptyOrErrorBehavior.NULL, null, (Matcher<Object>)CoreMatchers.nullValue());
        this.assertJsonValueAny(SqlFunctions.PathContext.withStrictException((Exception)new Exception("test message")), SqlJsonValueEmptyOrErrorBehavior.NULL, null, SqlJsonValueEmptyOrErrorBehavior.DEFAULT, "empty", (Matcher<Object>)CoreMatchers.is((Object)"empty"));
        this.assertJsonValueAnyFailed(SqlFunctions.PathContext.withStrictException((Exception)new Exception("test message")), SqlJsonValueEmptyOrErrorBehavior.NULL, null, SqlJsonValueEmptyOrErrorBehavior.ERROR, null, this.errorMatches(new RuntimeException("java.lang.Exception: test message")));
        this.assertJsonValueAny(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.STRICT, Collections.emptyList()), SqlJsonValueEmptyOrErrorBehavior.NULL, null, SqlJsonValueEmptyOrErrorBehavior.NULL, null, (Matcher<Object>)CoreMatchers.nullValue());
        this.assertJsonValueAny(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.STRICT, Collections.emptyList()), SqlJsonValueEmptyOrErrorBehavior.NULL, null, SqlJsonValueEmptyOrErrorBehavior.DEFAULT, "empty", (Matcher<Object>)CoreMatchers.is((Object)"empty"));
        this.assertJsonValueAnyFailed(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.STRICT, Collections.emptyList()), SqlJsonValueEmptyOrErrorBehavior.NULL, null, SqlJsonValueEmptyOrErrorBehavior.ERROR, null, this.errorMatches(new CalciteException("Strict jsonpath mode requires scalar value, and the actual value is: '[]'", null)));
    }

    @Test
    public void testJsonQuery() {
        this.assertJsonQuery(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, Collections.singletonList("bar")), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.is((Object)"[\"bar\"]"));
        this.assertJsonQuery(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, null), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.nullValue());
        this.assertJsonQuery(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, null), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.EMPTY_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.is((Object)"[]"));
        this.assertJsonQuery(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, null), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.EMPTY_OBJECT, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.is((Object)"{}"));
        this.assertJsonQueryFailed(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, null), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.ERROR, SqlJsonQueryEmptyOrErrorBehavior.NULL, this.errorMatches(new CalciteException("Empty result of JSON_QUERY function is not allowed", null)));
        this.assertJsonQuery(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, (Object)"bar"), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.nullValue());
        this.assertJsonQuery(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, (Object)"bar"), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.EMPTY_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.is((Object)"[]"));
        this.assertJsonQuery(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, (Object)"bar"), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.EMPTY_OBJECT, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.is((Object)"{}"));
        this.assertJsonQueryFailed(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.LAX, (Object)"bar"), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.ERROR, SqlJsonQueryEmptyOrErrorBehavior.NULL, this.errorMatches(new CalciteException("Empty result of JSON_QUERY function is not allowed", null)));
        this.assertJsonQuery(SqlFunctions.PathContext.withStrictException((Exception)new Exception("test message")), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.EMPTY_ARRAY, (Matcher<? super String>)CoreMatchers.is((Object)"[]"));
        this.assertJsonQuery(SqlFunctions.PathContext.withStrictException((Exception)new Exception("test message")), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.EMPTY_OBJECT, (Matcher<? super String>)CoreMatchers.is((Object)"{}"));
        this.assertJsonQueryFailed(SqlFunctions.PathContext.withStrictException((Exception)new Exception("test message")), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.ERROR, this.errorMatches(new RuntimeException("java.lang.Exception: test message")));
        this.assertJsonQuery(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.STRICT, (Object)"bar"), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.nullValue());
        this.assertJsonQuery(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.STRICT, (Object)"bar"), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.EMPTY_ARRAY, (Matcher<? super String>)CoreMatchers.is((Object)"[]"));
        this.assertJsonQueryFailed(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.STRICT, (Object)"bar"), SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.ERROR, this.errorMatches(new CalciteException("Strict jsonpath mode requires array or object value, and the actual value is: 'bar'", null)));
        this.assertJsonQuery(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.STRICT, (Object)"bar"), SqlJsonQueryWrapperBehavior.WITH_UNCONDITIONAL_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.is((Object)"[\"bar\"]"));
        this.assertJsonQuery(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.STRICT, (Object)"bar"), SqlJsonQueryWrapperBehavior.WITH_CONDITIONAL_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.is((Object)"[\"bar\"]"));
        this.assertJsonQuery(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.STRICT, Collections.singletonList("bar")), SqlJsonQueryWrapperBehavior.WITH_UNCONDITIONAL_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.is((Object)"[[\"bar\"]]"));
        this.assertJsonQuery(SqlFunctions.PathContext.withReturned((SqlFunctions.PathMode)SqlFunctions.PathMode.STRICT, Collections.singletonList("bar")), SqlJsonQueryWrapperBehavior.WITH_CONDITIONAL_ARRAY, SqlJsonQueryEmptyOrErrorBehavior.NULL, SqlJsonQueryEmptyOrErrorBehavior.NULL, (Matcher<? super String>)CoreMatchers.is((Object)"[\"bar\"]"));
    }

    @Test
    public void testJsonize() {
        this.assertJsonize(new HashMap(), (Matcher<? super String>)CoreMatchers.is((Object)"{}"));
    }

    @Test
    public void testDejsonize() {
        this.assertDejsonize("{}", (Matcher<Object>)CoreMatchers.is(Collections.emptyMap()));
        this.assertDejsonize("[]", (Matcher<Object>)CoreMatchers.is(Collections.emptyList()));
        String message = "com.fasterxml.jackson.core.JsonParseException: Unexpected close marker '}': expected ']' (for Array starting at [Source: (String)\"[}\"; line: 1, column: 1])\n at [Source: (String)\"[}\"; line: 1, column: 3]";
        this.assertDejsonizeFailed("[}", this.errorMatches((Throwable)new InvalidJsonException("com.fasterxml.jackson.core.JsonParseException: Unexpected close marker '}': expected ']' (for Array starting at [Source: (String)\"[}\"; line: 1, column: 1])\n at [Source: (String)\"[}\"; line: 1, column: 3]")));
    }

    @Test
    public void testJsonObject() {
        this.assertJsonObject((Matcher<? super String>)CoreMatchers.is((Object)"{}"), SqlJsonConstructorNullClause.NULL_ON_NULL, new Object[0]);
        this.assertJsonObject((Matcher<? super String>)CoreMatchers.is((Object)"{\"foo\":\"bar\"}"), SqlJsonConstructorNullClause.NULL_ON_NULL, "foo", "bar");
        this.assertJsonObject((Matcher<? super String>)CoreMatchers.is((Object)"{\"foo\":null}"), SqlJsonConstructorNullClause.NULL_ON_NULL, "foo", null);
        this.assertJsonObject((Matcher<? super String>)CoreMatchers.is((Object)"{}"), SqlJsonConstructorNullClause.ABSENT_ON_NULL, "foo", null);
    }

    @Test
    public void testJsonType() {
        this.assertJsonType((Matcher<? super String>)CoreMatchers.is((Object)"OBJECT"), "{}");
        this.assertJsonType((Matcher<? super String>)CoreMatchers.is((Object)"ARRAY"), "[\"foo\",null]");
        this.assertJsonType((Matcher<? super String>)CoreMatchers.is((Object)"NULL"), "null");
        this.assertJsonType((Matcher<? super String>)CoreMatchers.is((Object)"BOOLEAN"), "false");
        this.assertJsonType((Matcher<? super String>)CoreMatchers.is((Object)"INTEGER"), "12");
        this.assertJsonType((Matcher<? super String>)CoreMatchers.is((Object)"DOUBLE"), "11.22");
    }

    @Test
    public void testJsonDepth() {
        this.assertJsonDepth((Matcher<? super Integer>)CoreMatchers.is((Object)1), "{}");
        this.assertJsonDepth((Matcher<? super Integer>)CoreMatchers.is((Object)1), "false");
        this.assertJsonDepth((Matcher<? super Integer>)CoreMatchers.is((Object)1), "12");
        this.assertJsonDepth((Matcher<? super Integer>)CoreMatchers.is((Object)1), "11.22");
        this.assertJsonDepth((Matcher<? super Integer>)CoreMatchers.is((Object)2), "[\"foo\",null]");
        this.assertJsonDepth((Matcher<? super Integer>)CoreMatchers.is((Object)3), "{\"a\": [10, true]}");
        this.assertJsonDepth((Matcher<? super Integer>)CoreMatchers.nullValue(), "null");
    }

    @Test
    public void testJsonObjectAggAdd() {
        HashMap map = new HashMap();
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("foo", "bar");
        this.assertJsonObjectAggAdd(map, "foo", "bar", SqlJsonConstructorNullClause.NULL_ON_NULL, (Matcher<? super Map>)CoreMatchers.is(expected));
        expected.put("foo1", null);
        this.assertJsonObjectAggAdd(map, "foo1", null, SqlJsonConstructorNullClause.NULL_ON_NULL, (Matcher<? super Map>)CoreMatchers.is(expected));
        this.assertJsonObjectAggAdd(map, "foo2", null, SqlJsonConstructorNullClause.ABSENT_ON_NULL, (Matcher<? super Map>)CoreMatchers.is(expected));
    }

    @Test
    public void testJsonArray() {
        this.assertJsonArray((Matcher<? super String>)CoreMatchers.is((Object)"[]"), SqlJsonConstructorNullClause.NULL_ON_NULL, new Object[0]);
        this.assertJsonArray((Matcher<? super String>)CoreMatchers.is((Object)"[\"foo\"]"), SqlJsonConstructorNullClause.NULL_ON_NULL, "foo");
        this.assertJsonArray((Matcher<? super String>)CoreMatchers.is((Object)"[\"foo\",null]"), SqlJsonConstructorNullClause.NULL_ON_NULL, "foo", null);
        this.assertJsonArray((Matcher<? super String>)CoreMatchers.is((Object)"[\"foo\"]"), SqlJsonConstructorNullClause.ABSENT_ON_NULL, "foo", null);
    }

    @Test
    public void testJsonArrayAggAdd() {
        ArrayList list = new ArrayList();
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("foo");
        this.assertJsonArrayAggAdd(list, "foo", SqlJsonConstructorNullClause.NULL_ON_NULL, (Matcher<? super List>)CoreMatchers.is(expected));
        expected.add(null);
        this.assertJsonArrayAggAdd(list, null, SqlJsonConstructorNullClause.NULL_ON_NULL, (Matcher<? super List>)CoreMatchers.is(expected));
        this.assertJsonArrayAggAdd(list, null, SqlJsonConstructorNullClause.ABSENT_ON_NULL, (Matcher<? super List>)CoreMatchers.is(expected));
    }

    @Test
    public void testJsonPredicate() {
        this.assertIsJsonValue("[]", (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertIsJsonValue("{}", (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertIsJsonValue("100", (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertIsJsonValue("{]", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertIsJsonObject("[]", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertIsJsonObject("{}", (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertIsJsonObject("100", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertIsJsonObject("{]", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertIsJsonArray("[]", (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertIsJsonArray("{}", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertIsJsonArray("100", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertIsJsonArray("{]", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertIsJsonScalar("[]", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertIsJsonScalar("{}", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
        this.assertIsJsonScalar("100", (Matcher<? super Boolean>)CoreMatchers.is((Object)true));
        this.assertIsJsonScalar("{]", (Matcher<? super Boolean>)CoreMatchers.is((Object)false));
    }

    private void assertJsonValueExpression(String input, Matcher<Object> matcher) {
        Assert.assertThat((String)this.invocationDesc(INVOC_DESC_JSON_VALUE_EXPRESSION, input), (Object)SqlFunctions.jsonValueExpression((String)input), matcher);
    }

    private void assertJsonStructuredValueExpression(Object input, Matcher<Object> matcher) {
        Assert.assertThat((String)this.invocationDesc(INVOC_DESC_JSON_STRUCTURED_VALUE_EXPRESSION, input), (Object)SqlFunctions.jsonStructuredValueExpression((Object)input), matcher);
    }

    private void assertJsonApiCommonSyntax(Object input, String pathSpec, Matcher<? super SqlFunctions.PathContext> matcher) {
        Assert.assertThat((String)this.invocationDesc(INVOC_DESC_JSON_API_COMMON_SYNTAX, input, pathSpec), (Object)SqlFunctions.jsonApiCommonSyntax((Object)input, (String)pathSpec), matcher);
    }

    private void assertJsonExists(Object input, SqlJsonExistsErrorBehavior errorBehavior, Matcher<? super Boolean> matcher) {
        Assert.assertThat((String)this.invocationDesc(INVOC_DESC_JSON_EXISTS, input, errorBehavior), (Object)SqlFunctions.jsonExists((Object)input, (SqlJsonExistsErrorBehavior)errorBehavior), matcher);
    }

    private void assertJsonExistsFailed(Object input, SqlJsonExistsErrorBehavior errorBehavior, Matcher<? super Throwable> matcher) {
        this.assertFailed(this.invocationDesc(INVOC_DESC_JSON_EXISTS, input, errorBehavior), () -> SqlFunctions.jsonExists((Object)input, (SqlJsonExistsErrorBehavior)errorBehavior), matcher);
    }

    private void assertJsonValueAny(Object input, SqlJsonValueEmptyOrErrorBehavior emptyBehavior, Object defaultValueOnEmpty, SqlJsonValueEmptyOrErrorBehavior errorBehavior, Object defaultValueOnError, Matcher<Object> matcher) {
        Assert.assertThat((String)this.invocationDesc(INVOC_DESC_JSON_VALUE_ANY, input, emptyBehavior, defaultValueOnEmpty, errorBehavior, defaultValueOnError), (Object)SqlFunctions.jsonValueAny((Object)input, (SqlJsonValueEmptyOrErrorBehavior)emptyBehavior, (Object)defaultValueOnEmpty, (SqlJsonValueEmptyOrErrorBehavior)errorBehavior, (Object)defaultValueOnError), matcher);
    }

    private void assertJsonValueAnyFailed(Object input, SqlJsonValueEmptyOrErrorBehavior emptyBehavior, Object defaultValueOnEmpty, SqlJsonValueEmptyOrErrorBehavior errorBehavior, Object defaultValueOnError, Matcher<? super Throwable> matcher) {
        this.assertFailed(this.invocationDesc(INVOC_DESC_JSON_VALUE_ANY, input, emptyBehavior, defaultValueOnEmpty, errorBehavior, defaultValueOnError), () -> SqlFunctions.jsonValueAny((Object)input, (SqlJsonValueEmptyOrErrorBehavior)emptyBehavior, (Object)defaultValueOnEmpty, (SqlJsonValueEmptyOrErrorBehavior)errorBehavior, (Object)defaultValueOnError), matcher);
    }

    private void assertJsonQuery(Object input, SqlJsonQueryWrapperBehavior wrapperBehavior, SqlJsonQueryEmptyOrErrorBehavior emptyBehavior, SqlJsonQueryEmptyOrErrorBehavior errorBehavior, Matcher<? super String> matcher) {
        Assert.assertThat((String)this.invocationDesc(INVOC_DESC_JSON_QUERY, input, wrapperBehavior, emptyBehavior, errorBehavior), (Object)SqlFunctions.jsonQuery((Object)input, (SqlJsonQueryWrapperBehavior)wrapperBehavior, (SqlJsonQueryEmptyOrErrorBehavior)emptyBehavior, (SqlJsonQueryEmptyOrErrorBehavior)errorBehavior), matcher);
    }

    private void assertJsonQueryFailed(Object input, SqlJsonQueryWrapperBehavior wrapperBehavior, SqlJsonQueryEmptyOrErrorBehavior emptyBehavior, SqlJsonQueryEmptyOrErrorBehavior errorBehavior, Matcher<? super Throwable> matcher) {
        this.assertFailed(this.invocationDesc(INVOC_DESC_JSON_QUERY, input, wrapperBehavior, emptyBehavior, errorBehavior), () -> SqlFunctions.jsonQuery((Object)input, (SqlJsonQueryWrapperBehavior)wrapperBehavior, (SqlJsonQueryEmptyOrErrorBehavior)emptyBehavior, (SqlJsonQueryEmptyOrErrorBehavior)errorBehavior), matcher);
    }

    private void assertJsonize(Object input, Matcher<? super String> matcher) {
        Assert.assertThat((String)this.invocationDesc(INVOC_DESC_JSONIZE, input), (Object)SqlFunctions.jsonize((Object)input), matcher);
    }

    private void assertDejsonize(String input, Matcher<Object> matcher) {
        Assert.assertThat((String)this.invocationDesc(INVOC_DESC_DEJSONIZE, input), (Object)SqlFunctions.dejsonize((String)input), matcher);
    }

    private void assertDejsonizeFailed(String input, Matcher<? super Throwable> matcher) {
        this.assertFailed(this.invocationDesc(INVOC_DESC_DEJSONIZE, input), () -> SqlFunctions.dejsonize((String)input), matcher);
    }

    private void assertJsonObject(Matcher<? super String> matcher, SqlJsonConstructorNullClause nullClause, Object ... kvs) {
        Assert.assertThat((String)this.invocationDesc(INVOC_DESC_JSON_OBJECT, nullClause, kvs), (Object)SqlFunctions.jsonObject((SqlJsonConstructorNullClause)nullClause, (Object[])kvs), matcher);
    }

    private void assertJsonType(Matcher<? super String> matcher, String input) {
        Assert.assertThat((String)this.invocationDesc(INVOC_DESC_JSON_TYPE, input), (Object)SqlFunctions.jsonType((Object)SqlFunctions.dejsonize((String)input)), matcher);
    }

    private void assertJsonDepth(Matcher<? super Integer> matcher, String input) {
        Assert.assertThat((String)this.invocationDesc(INVOC_DESC_JSON_DEPTH, input), (Object)SqlFunctions.jsonDepth((Object)SqlFunctions.dejsonize((String)input)), matcher);
    }

    private void assertJsonObjectAggAdd(Map map, String k, Object v, SqlJsonConstructorNullClause nullClause, Matcher<? super Map> matcher) {
        SqlFunctions.jsonObjectAggAdd((Map)map, (String)k, (Object)v, (SqlJsonConstructorNullClause)nullClause);
        Assert.assertThat((String)this.invocationDesc(INVOC_DESC_JSON_OBJECT_AGG_ADD, map, k, v, nullClause), (Object)map, matcher);
    }

    private void assertJsonArray(Matcher<? super String> matcher, SqlJsonConstructorNullClause nullClause, Object ... elements) {
        Assert.assertThat((String)this.invocationDesc(INVOC_DESC_JSON_ARRAY, nullClause, elements), (Object)SqlFunctions.jsonArray((SqlJsonConstructorNullClause)nullClause, (Object[])elements), matcher);
    }

    private void assertJsonArrayAggAdd(List list, Object element, SqlJsonConstructorNullClause nullClause, Matcher<? super List> matcher) {
        SqlFunctions.jsonArrayAggAdd((List)list, (Object)element, (SqlJsonConstructorNullClause)nullClause);
        Assert.assertThat((String)this.invocationDesc(INVOC_DESC_JSON_ARRAY_AGG_ADD, list, element, nullClause), (Object)list, matcher);
    }

    private void assertIsJsonValue(String input, Matcher<? super Boolean> matcher) {
        Assert.assertThat((String)this.invocationDesc(INVOC_DESC_IS_JSON_VALUE, input), (Object)SqlFunctions.isJsonValue((String)input), matcher);
    }

    private void assertIsJsonScalar(String input, Matcher<? super Boolean> matcher) {
        Assert.assertThat((String)this.invocationDesc(INVOC_DESC_IS_JSON_SCALAR, input), (Object)SqlFunctions.isJsonScalar((String)input), matcher);
    }

    private void assertIsJsonArray(String input, Matcher<? super Boolean> matcher) {
        Assert.assertThat((String)this.invocationDesc(INVOC_DESC_IS_JSON_ARRAY, input), (Object)SqlFunctions.isJsonArray((String)input), matcher);
    }

    private void assertIsJsonObject(String input, Matcher<? super Boolean> matcher) {
        Assert.assertThat((String)this.invocationDesc(INVOC_DESC_IS_JSON_OBJECT, input), (Object)SqlFunctions.isJsonObject((String)input), matcher);
    }

    private String invocationDesc(String methodName, Object ... args) {
        return methodName + "(" + String.join((CharSequence)", ", Arrays.stream(args).map(Objects::toString).collect(Collectors.toList())) + ")";
    }

    private void assertFailed(String invocationDesc, Supplier<?> supplier, Matcher<? super Throwable> matcher) {
        try {
            supplier.get();
            Assert.fail((String)("expect exception, but not: " + invocationDesc));
        }
        catch (Throwable t) {
            Assert.assertThat((String)invocationDesc, (Object)t, matcher);
        }
    }

    private Matcher<? super Throwable> errorMatches(final Throwable expected) {
        return new BaseMatcher<Throwable>(){

            public boolean matches(Object item) {
                if (!(item instanceof Throwable)) {
                    return false;
                }
                Throwable error = (Throwable)item;
                return expected != null && Objects.equals(error.getClass(), expected.getClass()) && Objects.equals(error.getMessage(), expected.getMessage());
            }

            public void describeTo(Description description) {
                description.appendText("is ").appendText(expected.toString());
            }
        };
    }

    @Nonnull
    private BaseMatcher<SqlFunctions.PathContext> contextMatches(final SqlFunctions.PathContext expected) {
        return new BaseMatcher<SqlFunctions.PathContext>(){

            public boolean matches(Object item) {
                if (!(item instanceof SqlFunctions.PathContext)) {
                    return false;
                }
                SqlFunctions.PathContext context = (SqlFunctions.PathContext)item;
                if (Objects.equals(context.mode, expected.mode) && Objects.equals(context.pathReturned, expected.pathReturned)) {
                    if (context.exc == null && expected.exc == null) {
                        return true;
                    }
                    return context.exc != null && expected.exc != null && Objects.equals(context.exc.getClass(), expected.exc.getClass()) && Objects.equals(context.exc.getMessage(), expected.exc.getMessage());
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("is ").appendText(expected.toString());
            }
        };
    }
}

