/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.test;

import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.test.AbstractSqlTester;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.sql.test.SqlTests;
import org.apache.calcite.sql.validate.SqlValidator;
import org.junit.Assert;

public class SqlRuntimeTester
extends AbstractSqlTester {
    public SqlRuntimeTester(SqlTestFactory factory) {
        super(factory);
    }

    @Override
    protected SqlTester with(SqlTestFactory factory) {
        return new SqlRuntimeTester(factory);
    }

    @Override
    public void checkFails(String expression, String expectedError, boolean runtime) {
        String sql = runtime ? this.buildQuery2(expression) : SqlRuntimeTester.buildQuery(expression);
        this.assertExceptionIsThrown(sql, expectedError, runtime);
    }

    @Override
    public void assertExceptionIsThrown(String sql, String expectedMsgPattern) {
        this.assertExceptionIsThrown(sql, expectedMsgPattern, false);
    }

    public void assertExceptionIsThrown(String sql, String expectedMsgPattern, boolean runtime) {
        SqlTests.Stage stage;
        SqlNode sqlNode;
        SqlParserUtil.StringAndPos sap = SqlParserUtil.findPos((String)sql);
        try {
            sqlNode = this.parseQuery(sap.sql);
        }
        catch (Throwable e) {
            this.checkParseEx(e, expectedMsgPattern, sap.sql);
            return;
        }
        Throwable thrown = null;
        SqlValidator validator = this.getValidator();
        if (runtime) {
            stage = SqlTests.Stage.RUNTIME;
            SqlNode validated = validator.validate(sqlNode);
            Assert.assertNotNull((Object)validated);
            try {
                this.check(sap.sql, SqlTests.ANY_TYPE_CHECKER, SqlTests.ANY_PARAMETER_CHECKER, SqlTests.ANY_RESULT_CHECKER);
            }
            catch (Throwable ex) {
                thrown = ex;
            }
        } else {
            stage = SqlTests.Stage.VALIDATE;
            try {
                validator.validate(sqlNode);
            }
            catch (Throwable ex) {
                thrown = ex;
            }
        }
        SqlTests.checkEx(thrown, expectedMsgPattern, sap, stage);
    }
}

