/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.test;

import com.google.common.collect.ImmutableList;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.config.Lex;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.runtime.Utilities;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.sql.test.SqlTests;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.SqlValidatorTestCase;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public abstract class AbstractSqlTester
implements SqlTester,
AutoCloseable {
    protected final SqlTestFactory factory;

    public AbstractSqlTester(SqlTestFactory factory) {
        this.factory = factory;
    }

    @Override
    public final SqlTestFactory getFactory() {
        return this.factory;
    }

    @Override
    public void close() {
    }

    @Override
    public final SqlConformance getConformance() {
        return (SqlConformance)this.factory.get("conformance");
    }

    @Override
    public final SqlValidator getValidator() {
        return this.factory.getValidator();
    }

    @Override
    public void assertExceptionIsThrown(String sql, String expectedMsgPattern) {
        SqlValidator validator;
        SqlNode sqlNode;
        SqlParserUtil.StringAndPos sap = SqlParserUtil.findPos((String)sql);
        try {
            sqlNode = this.parseQuery(sap.sql);
            validator = this.getValidator();
        }
        catch (Throwable e) {
            this.checkParseEx(e, expectedMsgPattern, sap.sql);
            return;
        }
        Throwable thrown = null;
        try {
            validator.validate(sqlNode);
        }
        catch (Throwable ex) {
            thrown = ex;
        }
        SqlValidatorTestCase.checkEx(thrown, expectedMsgPattern, sap);
    }

    protected void checkParseEx(Throwable e, String expectedMsgPattern, String sql) {
        try {
            throw e;
        }
        catch (SqlParseException spe) {
            String errMessage = spe.getMessage();
            if (expectedMsgPattern == null) {
                throw new RuntimeException("Error while parsing query:" + sql, spe);
            }
            if (errMessage == null || !errMessage.matches(expectedMsgPattern)) {
                throw new RuntimeException("Error did not match expected [" + expectedMsgPattern + "] while parsing query [" + sql + "]", spe);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Error while parsing query: " + sql, t);
        }
    }

    @Override
    public RelDataType getColumnType(String sql) {
        RelDataType rowType = this.getResultType(sql);
        List fields = rowType.getFieldList();
        Assert.assertEquals((String)"expected query to return 1 field", (long)1L, (long)fields.size());
        return ((RelDataTypeField)fields.get(0)).getType();
    }

    @Override
    public RelDataType getResultType(String sql) {
        SqlValidator validator = this.getValidator();
        SqlNode n = this.parseAndValidate(validator, sql);
        return validator.getValidatedNodeType(n);
    }

    @Override
    public SqlNode parseAndValidate(SqlValidator validator, String sql) {
        SqlNode sqlNode;
        if (validator == null) {
            validator = this.getValidator();
        }
        try {
            sqlNode = this.parseQuery(sql);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error while parsing query: " + sql, e);
        }
        return validator.validate(sqlNode);
    }

    @Override
    public SqlNode parseQuery(String sql) throws SqlParseException {
        SqlParser parser = this.factory.createParser(sql);
        return parser.parseQuery();
    }

    @Override
    public void checkColumnType(String sql, String expected) {
        RelDataType actualType = this.getColumnType(sql);
        String actual = SqlTests.getTypeString(actualType);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Override
    public void checkFieldOrigin(String sql, String fieldOriginList) {
        SqlValidator validator = this.getValidator();
        SqlNode n = this.parseAndValidate(validator, sql);
        List list = validator.getFieldOrigins(n);
        StringBuilder buf = new StringBuilder("{");
        int i = 0;
        for (List strings : list) {
            if (i++ > 0) {
                buf.append(", ");
            }
            if (strings == null) {
                buf.append("null");
                continue;
            }
            int j = 0;
            for (String s : strings) {
                if (j++ > 0) {
                    buf.append('.');
                }
                buf.append(s);
            }
        }
        buf.append("}");
        Assert.assertEquals((Object)fieldOriginList, (Object)buf.toString());
    }

    @Override
    public void checkResultType(String sql, String expected) {
        RelDataType actualType = this.getResultType(sql);
        String actual = SqlTests.getTypeString(actualType);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Override
    public void checkIntervalConv(String sql, String expected) {
        SqlValidator validator = this.getValidator();
        SqlCall n = (SqlCall)this.parseAndValidate(validator, sql);
        SqlNode node = null;
        for (int i = 0; i < n.operandCount(); ++i) {
            node = SqlUtil.stripAs((SqlNode)n.operand(i));
            if (!(node instanceof SqlCall)) continue;
            node = ((SqlCall)node).operand(0);
            break;
        }
        Assert.assertNotNull(node);
        SqlIntervalLiteral intervalLiteral = (SqlIntervalLiteral)node;
        SqlIntervalLiteral.IntervalValue interval = (SqlIntervalLiteral.IntervalValue)intervalLiteral.getValue();
        long l = interval.getIntervalQualifier().isYearMonth() ? SqlParserUtil.intervalToMonths((SqlIntervalLiteral.IntervalValue)interval) : SqlParserUtil.intervalToMillis((SqlIntervalLiteral.IntervalValue)interval);
        String actual = l + "";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Override
    public void checkType(String expression, String type) {
        for (String sql : this.buildQueries(expression)) {
            this.checkColumnType(sql, type);
        }
    }

    @Override
    public void checkCollation(String expression, String expectedCollationName, SqlCollation.Coercibility expectedCoercibility) {
        for (String sql : this.buildQueries(expression)) {
            RelDataType actualType = this.getColumnType(sql);
            SqlCollation collation = actualType.getCollation();
            Assert.assertEquals((Object)expectedCollationName, (Object)collation.getCollationName());
            Assert.assertEquals((Object)expectedCoercibility, (Object)collation.getCoercibility());
        }
    }

    @Override
    public void checkCharset(String expression, Charset expectedCharset) {
        for (String sql : this.buildQueries(expression)) {
            RelDataType actualType = this.getColumnType(sql);
            Charset actualCharset = actualType.getCharset();
            if (expectedCharset.equals(actualCharset)) continue;
            Assert.fail((String)("\nExpected=" + expectedCharset.name() + "\n  actual=" + actualCharset.name()));
        }
    }

    @Override
    public SqlTester withQuoting(Quoting quoting) {
        return this.with("quoting", quoting);
    }

    @Override
    public SqlTester withQuotedCasing(Casing casing) {
        return this.with("quotedCasing", casing);
    }

    @Override
    public SqlTester withUnquotedCasing(Casing casing) {
        return this.with("unquotedCasing", casing);
    }

    @Override
    public SqlTester withCaseSensitive(boolean sensitive) {
        return this.with("caseSensitive", sensitive);
    }

    @Override
    public SqlTester withLex(Lex lex) {
        return this.withQuoting(lex.quoting).withCaseSensitive(lex.caseSensitive).withQuotedCasing(lex.quotedCasing).withUnquotedCasing(lex.unquotedCasing);
    }

    @Override
    public SqlTester withConformance(SqlConformance conformance) {
        if (conformance == null) {
            conformance = SqlConformanceEnum.DEFAULT;
        }
        SqlTester tester = this.with("conformance", conformance);
        if (conformance instanceof SqlConformanceEnum) {
            return tester.withConnectionFactory(CalciteAssert.EMPTY_CONNECTION_FACTORY.with((ConnectionProperty)CalciteConnectionProperty.CONFORMANCE, (Object)conformance));
        }
        return tester;
    }

    @Override
    public SqlTester withOperatorTable(SqlOperatorTable operatorTable) {
        return this.with("operatorTable", operatorTable);
    }

    @Override
    public SqlTester withConnectionFactory(CalciteAssert.ConnectionFactory connectionFactory) {
        return this.with("connectionFactory", connectionFactory);
    }

    protected final SqlTester with(String name, Object value) {
        return this.with(this.factory.with(name, value));
    }

    protected abstract SqlTester with(SqlTestFactory var1);

    @Override
    public void setFor(SqlOperator operator, SqlTester.VmName ... unimplementedVmNames) {
    }

    @Override
    public void checkAgg(String expr, String[] inputValues, Object result, double delta) {
        String query = SqlTests.generateAggQuery(expr, inputValues);
        this.check(query, SqlTests.ANY_TYPE_CHECKER, result, delta);
    }

    @Override
    public void checkAggWithMultipleArgs(String expr, String[][] inputValues, Object result, double delta) {
        String query = SqlTests.generateAggQueryWithMultipleArgs(expr, inputValues);
        this.check(query, SqlTests.ANY_TYPE_CHECKER, result, delta);
    }

    @Override
    public void checkWinAgg(String expr, String[] inputValues, String windowSpec, String type, Object result, double delta) {
        String query = SqlTests.generateWinAggQuery(expr, windowSpec, inputValues);
        this.check(query, SqlTests.ANY_TYPE_CHECKER, result, delta);
    }

    @Override
    public void checkScalar(String expression, Object result, String resultType) {
        this.checkType(expression, resultType);
        for (String sql : this.buildQueries(expression)) {
            this.check(sql, SqlTests.ANY_TYPE_CHECKER, result, 0.0);
        }
    }

    @Override
    public void checkScalarExact(String expression, String result) {
        for (String sql : this.buildQueries(expression)) {
            this.check(sql, SqlTests.INTEGER_TYPE_CHECKER, result, 0.0);
        }
    }

    @Override
    public void checkScalarExact(String expression, String expectedType, String result) {
        for (String sql : this.buildQueries(expression)) {
            SqlTests.StringTypeChecker typeChecker = new SqlTests.StringTypeChecker(expectedType);
            this.check(sql, (SqlTester.TypeChecker)typeChecker, result, 0.0);
        }
    }

    @Override
    public void checkScalarApprox(String expression, String expectedType, double expectedResult, double delta) {
        for (String sql : this.buildQueries(expression)) {
            SqlTests.StringTypeChecker typeChecker = new SqlTests.StringTypeChecker(expectedType);
            this.check(sql, (SqlTester.TypeChecker)typeChecker, expectedResult, delta);
        }
    }

    @Override
    public void checkBoolean(String expression, Boolean result) {
        for (String sql : this.buildQueries(expression)) {
            if (null == result) {
                this.checkNull(expression);
                continue;
            }
            this.check(sql, SqlTests.BOOLEAN_TYPE_CHECKER, result.toString(), 0.0);
        }
    }

    @Override
    public void checkString(String expression, String result, String expectedType) {
        for (String sql : this.buildQueries(expression)) {
            SqlTests.StringTypeChecker typeChecker = new SqlTests.StringTypeChecker(expectedType);
            this.check(sql, (SqlTester.TypeChecker)typeChecker, result, 0.0);
        }
    }

    @Override
    public void checkNull(String expression) {
        for (String sql : this.buildQueries(expression)) {
            this.check(sql, SqlTests.ANY_TYPE_CHECKER, null, 0.0);
        }
    }

    @Override
    public final void check(String query, SqlTester.TypeChecker typeChecker, Object result, double delta) {
        this.check(query, typeChecker, SqlTests.ANY_PARAMETER_CHECKER, SqlTests.createChecker(result, delta));
    }

    @Override
    public void check(String query, SqlTester.TypeChecker typeChecker, SqlTester.ParameterChecker parameterChecker, SqlTester.ResultChecker resultChecker) {
        if (typeChecker == null) {
            Util.discard((Object)this.getResultType(query));
        } else {
            RelDataType actualType = this.getColumnType(query);
            typeChecker.checkType(actualType);
        }
        SqlValidator validator = this.getValidator();
        SqlNode n = this.parseAndValidate(validator, query);
        RelDataType parameterRowType = validator.getParameterRowType(n);
        parameterChecker.checkParameters(parameterRowType);
    }

    @Override
    public void checkMonotonic(String query, SqlMonotonicity expectedMonotonicity) {
        SqlValidator validator = this.getValidator();
        SqlNode n = this.parseAndValidate(validator, query);
        RelDataType rowType = validator.getValidatedNodeType(n);
        SqlValidatorNamespace selectNamespace = validator.getNamespace(n);
        String field0 = ((RelDataTypeField)rowType.getFieldList().get(0)).getName();
        SqlMonotonicity monotonicity = selectNamespace.getMonotonicity(field0);
        Assert.assertThat((Object)monotonicity, (Matcher)CoreMatchers.equalTo((Object)expectedMonotonicity));
    }

    @Override
    public void checkRewrite(SqlValidator validator, String query, String expectedRewrite) {
        SqlNode rewrittenNode = this.parseAndValidate(validator, query);
        String actualRewrite = rewrittenNode.toSqlString(AnsiSqlDialect.DEFAULT, false).getSql();
        TestUtil.assertEqualsVerbose(expectedRewrite, Util.toLinux((String)actualRewrite));
    }

    @Override
    public void checkFails(String expression, String expectedError, boolean runtime) {
        if (runtime) {
            SqlValidator validator = this.getValidator();
            String sql = AbstractSqlTester.buildQuery(expression);
            SqlNode n = this.parseAndValidate(validator, sql);
            Assert.assertNotNull((Object)n);
        } else {
            this.checkQueryFails(AbstractSqlTester.buildQuery(expression), expectedError);
        }
    }

    @Override
    public void checkQueryFails(String sql, String expectedError) {
        this.assertExceptionIsThrown(sql, expectedError);
    }

    @Override
    public void checkQuery(String sql) {
        this.assertExceptionIsThrown(sql, null);
    }

    @Override
    public SqlMonotonicity getMonotonicity(String sql) {
        SqlValidator validator = this.getValidator();
        SqlNode node = this.parseAndValidate(validator, sql);
        SqlSelect select = (SqlSelect)node;
        SqlNode selectItem0 = select.getSelectList().get(0);
        SqlValidatorScope scope = validator.getSelectScope(select);
        return selectItem0.getMonotonicity(scope);
    }

    public static String buildQuery(String expression) {
        return "values (" + expression + ")";
    }

    public static String buildQueryAgg(String expression) {
        return "select " + expression + " from (values (1)) as t(x) group by x";
    }

    protected String buildQuery2(String expression) {
        SqlNode x;
        String sql = "values (" + expression + ")";
        try {
            x = this.parseQuery(sql);
        }
        catch (SqlParseException e) {
            throw TestUtil.rethrow(e);
        }
        final LinkedHashSet literalSet = new LinkedHashSet();
        x.accept((SqlVisitor)new SqlShuttle(){
            private final List<SqlOperator> ops = ImmutableList.of((Object)SqlStdOperatorTable.LITERAL_CHAIN, (Object)SqlStdOperatorTable.LOCALTIME, (Object)SqlStdOperatorTable.LOCALTIMESTAMP, (Object)SqlStdOperatorTable.CURRENT_TIME, (Object)SqlStdOperatorTable.CURRENT_TIMESTAMP);

            public SqlNode visit(SqlLiteral literal) {
                if (!this.isNull((SqlNode)literal) && literal.getTypeName() != SqlTypeName.SYMBOL) {
                    literalSet.add(literal);
                }
                return literal;
            }

            public SqlNode visit(SqlCall call) {
                SqlOperator operator = call.getOperator();
                if (operator == SqlStdOperatorTable.CAST && this.isNull(call.operand(0))) {
                    literalSet.add(call);
                    return call;
                }
                if (this.ops.contains(operator)) {
                    return call;
                }
                return super.visit(call);
            }

            private boolean isNull(SqlNode sqlNode) {
                return sqlNode instanceof SqlLiteral && ((SqlLiteral)sqlNode).getTypeName() == SqlTypeName.NULL;
            }
        });
        ArrayList nodes = new ArrayList(literalSet);
        nodes.sort((o1, o2) -> {
            SqlParserPos pos0 = o1.getParserPosition();
            SqlParserPos pos1 = o2.getParserPosition();
            int c = -Utilities.compare((int)pos0.getLineNum(), (int)pos1.getLineNum());
            if (c != 0) {
                return c;
            }
            return -Utilities.compare((int)pos0.getColumnNum(), (int)pos1.getColumnNum());
        });
        String sql2 = sql;
        ArrayList<Pair> values = new ArrayList<Pair>();
        int p = 0;
        for (SqlNode literal : nodes) {
            SqlParserPos pos = literal.getParserPosition();
            int start = SqlParserUtil.lineColToIndex((String)sql, (int)pos.getLineNum(), (int)pos.getColumnNum());
            int end = SqlParserUtil.lineColToIndex((String)sql, (int)pos.getEndLineNum(), (int)pos.getEndColumnNum()) + 1;
            String param = "p" + p++;
            values.add(Pair.of((Object)sql2.substring(start, end), (Object)param));
            sql2 = sql2.substring(0, start) + param + sql2.substring(end);
        }
        if (values.isEmpty()) {
            values.add(Pair.of((Object)"1", (Object)"p0"));
        }
        return "select " + sql2.substring("values (".length(), sql2.length() - 1) + " from (values (" + Util.commaList((List)Pair.left(values)) + ")) as t(" + Util.commaList((List)Pair.right(values)) + ")";
    }

    private Iterable<String> buildQueries(final String expression) {
        return () -> new Iterator<String>(){
            int i = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String next() {
                switch (this.i++) {
                    case 0: {
                        return AbstractSqlTester.buildQuery(expression);
                    }
                    case 1: {
                        return AbstractSqlTester.this.buildQuery2(expression);
                    }
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.i < 2;
            }
        };
    }
}

