/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.PlannerTests;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.util.Pair;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class VolcanoPlannerTraitTest {
    private static final Convention PHYS_CALLING_CONVENTION = new Convention.Impl("PHYS", RelNode.class);
    private static final AltTraitDef ALT_TRAIT_DEF = new AltTraitDef();
    private static final AltTrait ALT_EMPTY_TRAIT = new AltTrait(ALT_TRAIT_DEF, "ALT_EMPTY");
    private static final AltTrait ALT_TRAIT = new AltTrait(ALT_TRAIT_DEF, "ALT");
    private static final AltTrait ALT_TRAIT2 = new AltTrait(ALT_TRAIT_DEF, "ALT2");
    private static int altTraitOrdinal = 0;

    @Ignore
    @Test
    public void testDoubleConversion() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRelTraitDef((RelTraitDef)ALT_TRAIT_DEF);
        planner.addRule((RelOptRule)new PhysToIteratorConverterRule());
        planner.addRule((RelOptRule)new AltTraitConverterRule(ALT_TRAIT, ALT_TRAIT2, "AltToAlt2ConverterRule"));
        planner.addRule((RelOptRule)new PhysLeafRule());
        planner.addRule((RelOptRule)new IterSingleRule());
        RelOptCluster cluster = PlannerTests.newCluster(planner);
        NoneLeafRel noneLeafRel = (NoneLeafRel)RelOptUtil.addTrait((RelNode)new NoneLeafRel(cluster, "noneLeafRel"), (RelTrait)ALT_TRAIT);
        NoneSingleRel noneRel = (NoneSingleRel)RelOptUtil.addTrait((RelNode)new NoneSingleRel(cluster, (RelNode)noneLeafRel), (RelTrait)ALT_TRAIT2);
        RelNode convertedRel = planner.changeTraits((RelNode)noneRel, cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replace((RelTrait)ALT_TRAIT2));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof IterSingleRel));
        Assert.assertEquals((Object)EnumerableConvention.INSTANCE, (Object)result.getTraitSet().getTrait((RelTraitDef)ConventionTraitDef.INSTANCE));
        Assert.assertEquals((Object)ALT_TRAIT2, (Object)result.getTraitSet().getTrait((RelTraitDef)ALT_TRAIT_DEF));
        RelNode child = (RelNode)result.getInputs().get(0);
        Assert.assertTrue((child instanceof AltTraitConverter || child instanceof PhysToIteratorConverter ? 1 : 0) != 0);
        child = (RelNode)child.getInputs().get(0);
        Assert.assertTrue((child instanceof AltTraitConverter || child instanceof PhysToIteratorConverter ? 1 : 0) != 0);
        child = (RelNode)child.getInputs().get(0);
        Assert.assertTrue((boolean)(child instanceof PhysLeafRel));
    }

    @Test
    public void testRuleMatchAfterConversion() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRelTraitDef((RelTraitDef)ALT_TRAIT_DEF);
        planner.addRule((RelOptRule)new PhysToIteratorConverterRule());
        planner.addRule((RelOptRule)new PhysLeafRule());
        planner.addRule((RelOptRule)new IterSingleRule());
        planner.addRule((RelOptRule)new IterSinglePhysMergeRule());
        RelOptCluster cluster = PlannerTests.newCluster(planner);
        NoneLeafRel noneLeafRel = (NoneLeafRel)RelOptUtil.addTrait((RelNode)new NoneLeafRel(cluster, "noneLeafRel"), (RelTrait)ALT_TRAIT);
        NoneSingleRel noneRel = (NoneSingleRel)RelOptUtil.addTrait((RelNode)new NoneSingleRel(cluster, (RelNode)noneLeafRel), (RelTrait)ALT_EMPTY_TRAIT);
        RelNode convertedRel = planner.changeTraits((RelNode)noneRel, cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replace((RelTrait)ALT_EMPTY_TRAIT));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof IterMergedRel));
    }

    @Ignore
    @Test
    public void testTraitPropagation() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRelTraitDef((RelTraitDef)ALT_TRAIT_DEF);
        planner.addRule((RelOptRule)new PhysToIteratorConverterRule());
        planner.addRule((RelOptRule)new AltTraitConverterRule(ALT_TRAIT, ALT_TRAIT2, "AltToAlt2ConverterRule"));
        planner.addRule((RelOptRule)new PhysLeafRule());
        planner.addRule((RelOptRule)new IterSingleRule2());
        RelOptCluster cluster = PlannerTests.newCluster(planner);
        NoneLeafRel noneLeafRel = (NoneLeafRel)RelOptUtil.addTrait((RelNode)new NoneLeafRel(cluster, "noneLeafRel"), (RelTrait)ALT_TRAIT);
        NoneSingleRel noneRel = (NoneSingleRel)RelOptUtil.addTrait((RelNode)new NoneSingleRel(cluster, (RelNode)noneLeafRel), (RelTrait)ALT_TRAIT2);
        RelNode convertedRel = planner.changeTraits((RelNode)noneRel, cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replace((RelTrait)ALT_TRAIT2));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof IterSingleRel));
        Assert.assertEquals((Object)EnumerableConvention.INSTANCE, (Object)result.getTraitSet().getTrait((RelTraitDef)ConventionTraitDef.INSTANCE));
        Assert.assertEquals((Object)ALT_TRAIT2, (Object)result.getTraitSet().getTrait((RelTraitDef)ALT_TRAIT_DEF));
        RelNode child = (RelNode)result.getInputs().get(0);
        Assert.assertTrue((boolean)(child instanceof IterSingleRel));
        Assert.assertEquals((Object)EnumerableConvention.INSTANCE, (Object)child.getTraitSet().getTrait((RelTraitDef)ConventionTraitDef.INSTANCE));
        Assert.assertEquals((Object)ALT_TRAIT2, (Object)child.getTraitSet().getTrait((RelTraitDef)ALT_TRAIT_DEF));
        child = (RelNode)child.getInputs().get(0);
        Assert.assertTrue((child instanceof AltTraitConverter || child instanceof PhysToIteratorConverter ? 1 : 0) != 0);
        child = (RelNode)child.getInputs().get(0);
        Assert.assertTrue((child instanceof AltTraitConverter || child instanceof PhysToIteratorConverter ? 1 : 0) != 0);
        child = (RelNode)child.getInputs().get(0);
        Assert.assertTrue((boolean)(child instanceof PhysLeafRel));
    }

    @Test
    public void testPlanWithNoneConvention() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        RelOptCluster cluster = PlannerTests.newCluster(planner);
        NoneTinyLeafRel leaf = new NoneTinyLeafRel(cluster, "noneLeafRel");
        planner.setRoot((RelNode)leaf);
        RelOptCost cost = planner.getCost((RelNode)leaf, RelMetadataQuery.instance());
        Assert.assertTrue((boolean)cost.isInfinite());
        planner.setNoneConventionHasInfiniteCost(false);
        cost = planner.getCost((RelNode)leaf, RelMetadataQuery.instance());
        Assert.assertTrue((!cost.isInfinite() ? 1 : 0) != 0);
    }

    private static class IterMergedRel
    extends TestLeafRel
    implements FooRel {
        IterMergedRel(RelOptCluster cluster, String label) {
            super(cluster, cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE), label);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeZeroCost();
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (traitSet.comprises(new RelTrait[]{EnumerableConvention.INSTANCE}));
            assert (inputs.isEmpty());
            return new IterMergedRel(this.getCluster(), this.getLabel());
        }

        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            return null;
        }
    }

    private static class IterSinglePhysMergeRule
    extends RelOptRule {
        IterSinglePhysMergeRule() {
            super(IterSinglePhysMergeRule.operand(IterSingleRel.class, (RelOptRuleOperand)IterSinglePhysMergeRule.operand(PhysToIteratorConverter.class, (RelOptRuleOperandChildren)IterSinglePhysMergeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        }

        public void onMatch(RelOptRuleCall call) {
            IterSingleRel singleRel = (IterSingleRel)call.rel(0);
            call.transformTo((RelNode)new IterMergedRel(singleRel.getCluster(), null));
        }
    }

    private static class PhysToIteratorConverter
    extends ConverterImpl {
        PhysToIteratorConverter(RelOptCluster cluster, RelNode child) {
            super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, child.getTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE), child);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new PhysToIteratorConverter(this.getCluster(), (RelNode)PhysToIteratorConverter.sole(inputs));
        }
    }

    private static class PhysToIteratorConverterRule
    extends ConverterRule {
        PhysToIteratorConverterRule() {
            super(RelNode.class, (RelTrait)PHYS_CALLING_CONVENTION, (RelTrait)EnumerableConvention.INSTANCE, "PhysToIteratorRule");
        }

        public RelNode convert(RelNode rel) {
            return new PhysToIteratorConverter(rel.getCluster(), rel);
        }
    }

    private static class AltTraitConverter
    extends ConverterImpl {
        private final RelTrait toTrait;

        private AltTraitConverter(RelOptCluster cluster, RelNode child, RelTrait toTrait) {
            super(cluster, toTrait.getTraitDef(), child.getTraitSet().replace(toTrait), child);
            this.toTrait = toTrait;
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new AltTraitConverter(this.getCluster(), (RelNode)AltTraitConverter.sole(inputs), this.toTrait);
        }
    }

    private static class AltTraitConverterRule
    extends ConverterRule {
        private final RelTrait toTrait;

        private AltTraitConverterRule(AltTrait fromTrait, AltTrait toTrait, String description) {
            super(RelNode.class, (RelTrait)fromTrait, (RelTrait)toTrait, description);
            this.toTrait = toTrait;
        }

        public RelNode convert(RelNode rel) {
            return new AltTraitConverter(rel.getCluster(), rel, this.toTrait);
        }

        public boolean isGuaranteed() {
            return true;
        }
    }

    private static class IterSingleRule2
    extends RelOptRule {
        IterSingleRule2() {
            super(IterSingleRule2.operand(NoneSingleRel.class, (RelOptRuleOperandChildren)IterSingleRule2.any()));
        }

        public Convention getOutConvention() {
            return EnumerableConvention.INSTANCE;
        }

        public RelTrait getOutTrait() {
            return this.getOutConvention();
        }

        public void onMatch(RelOptRuleCall call) {
            NoneSingleRel rel = (NoneSingleRel)call.rel(0);
            RelNode converted = IterSingleRule2.convert((RelNode)rel.getInput(0), (RelTraitSet)rel.getTraitSet().replace(this.getOutTrait()));
            IterSingleRel child = new IterSingleRel(rel.getCluster(), converted);
            call.transformTo((RelNode)new IterSingleRel(rel.getCluster(), (RelNode)child));
        }
    }

    private static class IterSingleRule
    extends RelOptRule {
        IterSingleRule() {
            super(IterSingleRule.operand(NoneSingleRel.class, (RelOptRuleOperandChildren)IterSingleRule.any()));
        }

        public Convention getOutConvention() {
            return EnumerableConvention.INSTANCE;
        }

        public RelTrait getOutTrait() {
            return this.getOutConvention();
        }

        public void onMatch(RelOptRuleCall call) {
            NoneSingleRel rel = (NoneSingleRel)call.rel(0);
            RelNode converted = IterSingleRule.convert((RelNode)rel.getInput(0), (RelTraitSet)rel.getTraitSet().replace(this.getOutTrait()));
            call.transformTo((RelNode)new IterSingleRel(rel.getCluster(), converted));
        }
    }

    private static class NoneTinyLeafRel
    extends TestLeafRel {
        protected NoneTinyLeafRel(RelOptCluster cluster, String label) {
            super(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), label);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new NoneTinyLeafRel(this.getCluster(), this.getLabel());
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeTinyCost();
        }
    }

    private static class PhysLeafRule
    extends RelOptRule {
        PhysLeafRule() {
            super(PhysLeafRule.operand(NoneLeafRel.class, (RelOptRuleOperandChildren)PhysLeafRule.any()));
        }

        public Convention getOutConvention() {
            return PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            NoneLeafRel leafRel = (NoneLeafRel)call.rel(0);
            call.transformTo((RelNode)new PhysLeafRel(leafRel.getCluster(), leafRel.getLabel()));
        }
    }

    private static class IterSingleRel
    extends TestSingleRel
    implements FooRel {
        IterSingleRel(RelOptCluster cluster, RelNode child) {
            super(cluster, cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE), child);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeTinyCost();
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (traitSet.comprises(new RelTrait[]{EnumerableConvention.INSTANCE}));
            return new IterSingleRel(this.getCluster(), (RelNode)IterSingleRel.sole(inputs));
        }

        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            return null;
        }
    }

    static interface FooRel
    extends EnumerableRel {
    }

    private static class NoneSingleRel
    extends TestSingleRel {
        protected NoneSingleRel(RelOptCluster cluster, RelNode child) {
            this(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), child);
        }

        protected NoneSingleRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child) {
            super(cluster, traitSet, child);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new NoneSingleRel(this.getCluster(), traitSet, (RelNode)NoneSingleRel.sole(inputs));
        }
    }

    private static abstract class TestSingleRel
    extends SingleRel {
        protected TestSingleRel(RelOptCluster cluster, RelTraitSet traits, RelNode child) {
            super(cluster, traits, child);
        }

        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeInfiniteCost();
        }

        protected RelDataType deriveRowType() {
            return this.getInput().getRowType();
        }
    }

    private static class PhysLeafRel
    extends TestLeafRel {
        PhysLeafRel(RelOptCluster cluster, String label) {
            super(cluster, cluster.traitSetOf((RelTrait)PHYS_CALLING_CONVENTION), label);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeTinyCost();
        }
    }

    private static class NoneLeafRel
    extends TestLeafRel {
        protected NoneLeafRel(RelOptCluster cluster, String label) {
            super(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), label);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new NoneLeafRel(this.getCluster(), this.getLabel());
        }
    }

    private static abstract class TestLeafRel
    extends AbstractRelNode {
        private String label;

        protected TestLeafRel(RelOptCluster cluster, RelTraitSet traits, String label) {
            super(cluster, traits);
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeInfiniteCost();
        }

        protected RelDataType deriveRowType() {
            RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
            return typeFactory.builder().add("this", typeFactory.createJavaType(Void.TYPE)).build();
        }

        public RelWriter explainTerms(RelWriter pw) {
            return super.explainTerms(pw).item("label", (Object)this.label);
        }
    }

    private static class AltTraitDef
    extends RelTraitDef<AltTrait> {
        private Multimap<RelTrait, Pair<RelTrait, ConverterRule>> conversionMap = HashMultimap.create();

        private AltTraitDef() {
        }

        public Class<AltTrait> getTraitClass() {
            return AltTrait.class;
        }

        public String getSimpleName() {
            return "alt_phys";
        }

        public AltTrait getDefault() {
            return ALT_TRAIT;
        }

        public RelNode convert(RelOptPlanner planner, RelNode rel, AltTrait toTrait, boolean allowInfiniteCostConverters) {
            RelTrait fromTrait = rel.getTraitSet().getTrait((RelTraitDef)this);
            if (this.conversionMap.containsKey((Object)fromTrait)) {
                RelMetadataQuery mq = RelMetadataQuery.instance();
                for (Pair traitAndRule : this.conversionMap.get((Object)fromTrait)) {
                    RelNode converted;
                    RelTrait trait = (RelTrait)traitAndRule.left;
                    ConverterRule rule = (ConverterRule)traitAndRule.right;
                    if (trait != toTrait || (converted = rule.convert(rel)) == null || planner.getCost(converted, mq).isInfinite() && !allowInfiniteCostConverters) continue;
                    return converted;
                }
            }
            return null;
        }

        public boolean canConvert(RelOptPlanner planner, AltTrait fromTrait, AltTrait toTrait) {
            if (this.conversionMap.containsKey((Object)fromTrait)) {
                for (Pair traitAndRule : this.conversionMap.get((Object)fromTrait)) {
                    if (traitAndRule.left != toTrait) continue;
                    return true;
                }
            }
            return false;
        }

        public void registerConverterRule(RelOptPlanner planner, ConverterRule converterRule) {
            if (!converterRule.isGuaranteed()) {
                return;
            }
            RelTrait fromTrait = converterRule.getInTrait();
            RelTrait toTrait = converterRule.getOutTrait();
            this.conversionMap.put((Object)fromTrait, (Object)Pair.of((Object)toTrait, (Object)converterRule));
        }
    }

    private static class AltTrait
    implements RelTrait {
        private final AltTraitDef traitDef;
        private final int ordinal;
        private final String description;

        private AltTrait(AltTraitDef traitDef, String description) {
            this.traitDef = traitDef;
            this.description = description;
            this.ordinal = altTraitOrdinal++;
        }

        public void register(RelOptPlanner planner) {
        }

        public RelTraitDef getTraitDef() {
            return this.traitDef;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof AltTrait)) {
                return false;
            }
            AltTrait that = (AltTrait)other;
            return this.ordinal == that.ordinal;
        }

        public int hashCode() {
            return this.ordinal;
        }

        public boolean satisfies(RelTrait trait) {
            return trait.equals((Object)ALT_EMPTY_TRAIT) || this.equals(trait);
        }

        public String toString() {
            return this.description;
        }
    }
}

