/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import org.apache.calcite.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestUtilTest {
    @Test
    public void javaMajorVersionExceeds6() {
        int majorVersion = TestUtil.getJavaMajorVersion();
        Assert.assertTrue((String)("current JavaMajorVersion == " + majorVersion + " is expected to exceed 6"), (majorVersion > 6 ? 1 : 0) != 0);
    }

    @Test
    public void majorVersionFromString() {
        this.testJavaVersion(4, "1.4.2_03");
        this.testJavaVersion(5, "1.5.0_16");
        this.testJavaVersion(6, "1.6.0_22");
        this.testJavaVersion(7, "1.7.0_65-b20");
        this.testJavaVersion(8, "1.8.0_72-internal");
        this.testJavaVersion(8, "1.8.0_151");
        this.testJavaVersion(8, "1.8.0_141");
        this.testJavaVersion(9, "1.9.0_20-b62");
        this.testJavaVersion(9, "1.9.0-ea-b19");
        this.testJavaVersion(9, "9");
        this.testJavaVersion(9, "9.0");
        this.testJavaVersion(9, "9.0.1");
        this.testJavaVersion(9, "9-ea");
        this.testJavaVersion(9, "9.0.1");
        this.testJavaVersion(9, "9.1-ea");
        this.testJavaVersion(9, "9.1.1-ea");
        this.testJavaVersion(9, "9.1.1-ea+123");
        this.testJavaVersion(10, "10");
        this.testJavaVersion(10, "10+456");
        this.testJavaVersion(10, "10-ea");
        this.testJavaVersion(10, "10-ea42");
        this.testJavaVersion(10, "10-ea+555");
        this.testJavaVersion(10, "10-ea42+555");
        this.testJavaVersion(10, "10.0");
        this.testJavaVersion(10, "10.0.0");
        this.testJavaVersion(10, "10.0.0.0.0");
        this.testJavaVersion(10, "10.1.2.3.4.5.6.7.8");
        this.testJavaVersion(10, "10.0.1");
        this.testJavaVersion(10, "10.1.1-foo");
        this.testJavaVersion(11, "11");
        this.testJavaVersion(11, "11+111");
        this.testJavaVersion(11, "11-ea");
        this.testJavaVersion(11, "11.0");
        this.testJavaVersion(12, "12.0");
        this.testJavaVersion(20, "20.0");
        this.testJavaVersion(42, "42");
        this.testJavaVersion(100, "100");
        this.testJavaVersion(100, "100.0");
        this.testJavaVersion(1000, "1000");
        this.testJavaVersion(2000, "2000");
        this.testJavaVersion(205, "205.0");
        this.testJavaVersion(2017, "2017");
        this.testJavaVersion(2017, "2017.0");
        this.testJavaVersion(2017, "2017.12");
        this.testJavaVersion(2017, "2017.12-pre");
        this.testJavaVersion(2017, "2017.12.31");
    }

    private void testJavaVersion(int expectedMajorVersion, String versionString) {
        Assert.assertEquals((String)versionString, (long)expectedMajorVersion, (long)TestUtil.majorVersionFromString(versionString));
    }
}

