/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import org.apache.calcite.test.SqlValidatorTestCase;
import org.junit.Test;

public class SqlValidatorMatchTest
extends SqlValidatorTestCase {
    @Test
    public void testMatchRecognizeInternals() throws Exception {
        this.sql("values ^pattern_exclude(1, 2)^").fails("No match found for function signature .*");
        this.sql("values ^\"|\"(1, 2)^").fails("No match found for function signature .*");
        this.sql("values ^\"FINAL\"(1, 2)^").fails("No match found for function signature FINAL\\(<NUMERIC>, <NUMERIC>\\)");
        this.sql("values ^\"RUNNING\"(1, 2)^").fails("No match found for function signature RUNNING\\(<NUMERIC>, <NUMERIC>\\)");
        this.sql("values ^\"FIRST\"(1, 2)^").fails("Function 'FIRST\\(1, 2\\)' can only be used in MATCH_RECOGNIZE");
        this.sql("values ^\"LAST\"(1, 2)^").fails("Function 'LAST\\(1, 2\\)' can only be used in MATCH_RECOGNIZE");
        this.sql("values ^\"PREV\"(1, 2)^").fails("Function 'PREV\\(1, 2\\)' can only be used in MATCH_RECOGNIZE");
    }

    @Test
    public void testMatchRecognizeDefines() throws Exception {
        String sql = "select *\n  from emp match_recognize (\n    pattern (strt down+ up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > PREV(up.sal)\n  ) mr";
        this.sql("select *\n  from emp match_recognize (\n    pattern (strt down+ up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > PREV(up.sal)\n  ) mr").ok();
    }

    @Test
    public void testMatchRecognizeDefines2() throws Exception {
        String sql = "select *\n  from t match_recognize (\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      ^down as up.price > PREV(up.price)^\n  ) mr";
        this.sql("select *\n  from t match_recognize (\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      ^down as up.price > PREV(up.price)^\n  ) mr").fails("Pattern variable 'DOWN' has already been defined");
    }

    @Test
    public void testMatchRecognizeDefines3() throws Exception {
        String sql = "select *\n  from emp match_recognize (\n    pattern (strt down+up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > PREV(up.sal)\n  ) mr";
        this.sql("select *\n  from emp match_recognize (\n    pattern (strt down+up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > PREV(up.sal)\n  ) mr").ok();
    }

    @Test
    public void testMatchRecognizeDefines4() throws Exception {
        String sql = "select *\n  from emp match_recognize (\n    pattern (strt down+ up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > FIRST(^PREV(up.sal)^)\n  ) mr";
        this.sql("select *\n  from emp match_recognize (\n    pattern (strt down+ up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > FIRST(^PREV(up.sal)^)\n  ) mr").fails("Cannot nest PREV/NEXT under LAST/FIRST 'PREV\\(`UP`\\.`SAL`, 1\\)'");
    }

    @Test
    public void testMatchRecognizeDefines5() throws Exception {
        String sql = "select *\n  from emp match_recognize (\n    pattern (strt down+ up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > FIRST(^FIRST(up.sal)^)\n  ) mr";
        this.sql("select *\n  from emp match_recognize (\n    pattern (strt down+ up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > FIRST(^FIRST(up.sal)^)\n  ) mr").fails("Cannot nest PREV/NEXT under LAST/FIRST 'FIRST\\(`UP`\\.`SAL`, 0\\)'");
    }

    @Test
    public void testMatchRecognizeDefines6() throws Exception {
        String sql = "select *\n  from emp match_recognize (\n    pattern (strt down+ up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > ^COUNT(down.sal, up.sal)^\n  ) mr";
        this.sql("select *\n  from emp match_recognize (\n    pattern (strt down+ up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > ^COUNT(down.sal, up.sal)^\n  ) mr").fails("Invalid number of parameters to COUNT method");
    }

    @Test
    public void testMatchRecognizeMeasures1() throws Exception {
        String sql = "select *\n  from emp match_recognize (\n    measures STRT.sal as start_sal,      ^LAST(null)^ as bottom_sal,      LAST(up.ts) as end_sal    pattern (strt down+ up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > prev(up.sal)\n  ) mr";
        this.sql("select *\n  from emp match_recognize (\n    measures STRT.sal as start_sal,      ^LAST(null)^ as bottom_sal,      LAST(up.ts) as end_sal    pattern (strt down+ up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > prev(up.sal)\n  ) mr").fails("Null parameters in 'LAST\\(NULL, 0\\)'");
    }

    @Test
    public void testMatchRecognizeSkipTo1() throws Exception {
        String sql = "select *\n  from emp match_recognize (\n    after match skip to ^null^\n    measures\n      STRT.sal as start_sal,\n      LAST(up.ts) as end_sal\n    pattern (strt down+ up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > prev(up.sal)\n  ) mr";
        this.sql("select *\n  from emp match_recognize (\n    after match skip to ^null^\n    measures\n      STRT.sal as start_sal,\n      LAST(up.ts) as end_sal\n    pattern (strt down+ up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > prev(up.sal)\n  ) mr").fails("(?s).*Encountered \"to null\" at .*");
    }

    @Test
    public void testMatchRecognizeSkipTo2() throws Exception {
        String sql = "select *\n  from emp match_recognize (\n    after match skip to ^no_exists^\n    measures\n      STRT.sal as start_sal,      LAST(up.ts) as end_sal    pattern (strt down+ up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > prev(up.sal)\n  ) mr";
        this.sql("select *\n  from emp match_recognize (\n    after match skip to ^no_exists^\n    measures\n      STRT.sal as start_sal,      LAST(up.ts) as end_sal    pattern (strt down+ up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > prev(up.sal)\n  ) mr").fails("(?s).*Encountered \"measures\" at .*");
    }

    @Test
    public void testMatchRecognizeSkipTo3() throws Exception {
        String sql = "select *\nfrom emp match_recognize (\n  measures\n    STRT.sal as start_sal,\n    LAST(up.sal) as end_sal\n    after match skip to ^no_exists^\n    pattern (strt down+ up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > prev(up.sal)\n  ) mr";
        this.sql("select *\nfrom emp match_recognize (\n  measures\n    STRT.sal as start_sal,\n    LAST(up.sal) as end_sal\n    after match skip to ^no_exists^\n    pattern (strt down+ up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > prev(up.sal)\n  ) mr").fails("Unknown pattern 'NO_EXISTS'");
    }

    @Test
    public void testMatchRecognizeSkipToCaseInsensitive() throws Exception {
        String sql = "select *\nfrom emp match_recognize (\n  measures\n    STRT.sal as start_sal,\n    LAST(up.sal) as end_sal\n    after match skip to ^\"strt\"^\n    pattern (strt down+ up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > prev(up.sal)\n  ) mr";
        this.sql("select *\nfrom emp match_recognize (\n  measures\n    STRT.sal as start_sal,\n    LAST(up.sal) as end_sal\n    after match skip to ^\"strt\"^\n    pattern (strt down+ up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > prev(up.sal)\n  ) mr").fails("Unknown pattern 'strt'");
        this.sql("select *\nfrom emp match_recognize (\n  measures\n    STRT.sal as start_sal,\n    LAST(up.sal) as end_sal\n    after match skip to ^\"strt\"^\n    pattern (strt down+ up+)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > prev(up.sal)\n  ) mr").tester(this.tester.withCaseSensitive(false)).sansCarets().ok();
    }

    @Test
    public void testMatchRecognizeSubset() throws Exception {
        String sql = "select *\nfrom emp match_recognize (\n    pattern (strt down+ up+)\n    subset stdn = (^strt1^, down)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > prev(up.sal)\n  ) mr";
        this.sql("select *\nfrom emp match_recognize (\n    pattern (strt down+ up+)\n    subset stdn = (^strt1^, down)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > prev(up.sal)\n  ) mr").fails("Unknown pattern 'STRT1'");
    }

    @Test
    public void testMatchRecognizeSubset2() throws Exception {
        String sql = "select *\nfrom emp match_recognize (\n    pattern (strt down+ up+)\n    subset ^strt^ = (strt, down)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > prev(up.sal)\n  ) mr";
        this.sql("select *\nfrom emp match_recognize (\n    pattern (strt down+ up+)\n    subset ^strt^ = (strt, down)\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > prev(up.sal)\n  ) mr").fails("Pattern variable 'STRT' has already been defined");
    }

    @Test
    public void testMatchRecognizeWithin() throws Exception {
        String sql = "select *\nfrom emp match_recognize (\n    pattern (strt down+ up+) within ^interval '3:10' minute to second^\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > prev(up.sal)\n  ) mr";
        this.sql("select *\nfrom emp match_recognize (\n    pattern (strt down+ up+) within ^interval '3:10' minute to second^\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > prev(up.sal)\n  ) mr").fails("Must contain an ORDER BY clause when WITHIN is used");
    }

    @Test
    public void testMatchRecognizeWithin2() throws Exception {
        String sql = "select *\nfrom emp match_recognize (\n    order by sal\n    pattern (strt down+ up+) within ^interval '3:10' minute to second^\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > prev(up.sal)\n  ) mr";
        this.sql("select *\nfrom emp match_recognize (\n    order by sal\n    pattern (strt down+ up+) within ^interval '3:10' minute to second^\n    define\n      down as down.sal < PREV(down.sal),\n      up as up.sal > prev(up.sal)\n  ) mr").fails("First column of ORDER BY must be of type TIMESTAMP");
    }
}

