/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeFixture;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class SqlTypeFactoryTest {
    @Test
    public void testLeastRestrictiveWithAny() {
        SqlTypeFixture f = new SqlTypeFixture();
        RelDataType leastRestrictive = f.typeFactory.leastRestrictive((List)Lists.newArrayList((Object[])new RelDataType[]{f.sqlBigInt, f.sqlAny}));
        Assert.assertThat((Object)leastRestrictive.getSqlTypeName(), (Matcher)Is.is((Object)SqlTypeName.ANY));
    }

    @Test
    public void testLeastRestrictiveWithNumbers() {
        SqlTypeFixture f = new SqlTypeFixture();
        RelDataType leastRestrictive = f.typeFactory.leastRestrictive((List)Lists.newArrayList((Object[])new RelDataType[]{f.sqlBigInt, f.sqlInt}));
        Assert.assertThat((Object)leastRestrictive.getSqlTypeName(), (Matcher)Is.is((Object)SqlTypeName.BIGINT));
    }

    @Test
    public void testLeastRestrictiveWithNullability() {
        SqlTypeFixture f = new SqlTypeFixture();
        RelDataType leastRestrictive = f.typeFactory.leastRestrictive((List)Lists.newArrayList((Object[])new RelDataType[]{f.sqlVarcharNullable, f.sqlAny}));
        Assert.assertThat((Object)leastRestrictive.getSqlTypeName(), (Matcher)Is.is((Object)SqlTypeName.ANY));
        Assert.assertThat((Object)leastRestrictive.isNullable(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testLeastRestrictiveWithNull() {
        SqlTypeFixture f = new SqlTypeFixture();
        RelDataType leastRestrictive = f.typeFactory.leastRestrictive((List)Lists.newArrayList((Object[])new RelDataType[]{f.sqlNull, f.sqlNull}));
        Assert.assertThat((Object)leastRestrictive.getSqlTypeName(), (Matcher)Is.is((Object)SqlTypeName.NULL));
        Assert.assertThat((Object)leastRestrictive.isNullable(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testMaxPrecision() {
        int un = -1;
        this.checkPrecision(1, 1, 1, 0);
        this.checkPrecision(2, 1, 2, 1);
        this.checkPrecision(2, 100, 100, -1);
        this.checkPrecision(2, -1, -1, -1);
        this.checkPrecision(-1, 2, -1, 1);
        this.checkPrecision(-1, -1, -1, 0);
    }

    @Test
    public void testArrayPrecedenceList() {
        SqlTypeFixture f = new SqlTypeFixture();
        Assert.assertThat((Object)this.checkPrecendenceList(f.arrayBigInt, f.arrayBigInt, f.arrayFloat), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.checkPrecendenceList(f.arrayOfArrayBigInt, f.arrayOfArrayBigInt, f.arrayOfArrayFloat), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.checkPrecendenceList(f.sqlBigInt, f.sqlBigInt, f.sqlFloat), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.checkPrecendenceList(f.multisetBigInt, f.multisetBigInt, f.multisetFloat), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.checkPrecendenceList(f.arrayBigInt, f.arrayBigInt, f.arrayBigIntNullable), (Matcher)Is.is((Object)0));
        try {
            int i = this.checkPrecendenceList(f.arrayBigInt, f.sqlBigInt, f.sqlInt);
            Assert.fail((String)("Expected assert, got " + i));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)"must contain type: BIGINT"));
        }
    }

    private int checkPrecendenceList(RelDataType t, RelDataType type1, RelDataType type2) {
        return t.getPrecedenceList().compareTypePrecedence(type1, type2);
    }

    private void checkPrecision(int p0, int p1, int expectedMax, int expectedComparison) {
        Assert.assertThat((Object)SqlTypeUtil.maxPrecision((int)p0, (int)p1), (Matcher)Is.is((Object)expectedMax));
        Assert.assertThat((Object)SqlTypeUtil.maxPrecision((int)p1, (int)p0), (Matcher)Is.is((Object)expectedMax));
        Assert.assertThat((Object)SqlTypeUtil.maxPrecision((int)p0, (int)p0), (Matcher)Is.is((Object)p0));
        Assert.assertThat((Object)SqlTypeUtil.maxPrecision((int)p1, (int)p1), (Matcher)Is.is((Object)p1));
        Assert.assertThat((Object)SqlTypeUtil.comparePrecision((int)p0, (int)p1), (Matcher)Is.is((Object)expectedComparison));
        Assert.assertThat((Object)SqlTypeUtil.comparePrecision((int)p0, (int)p0), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)SqlTypeUtil.comparePrecision((int)p1, (int)p1), (Matcher)Is.is((Object)0));
    }

    @Test
    public void createStructTypeWithNullability() {
        SqlTypeFixture f = new SqlTypeFixture();
        SqlTypeFactoryImpl typeFactory = f.typeFactory;
        ArrayList<RelDataTypeFieldImpl> fields = new ArrayList<RelDataTypeFieldImpl>();
        RelDataTypeFieldImpl field0 = new RelDataTypeFieldImpl("i", 0, typeFactory.createSqlType(SqlTypeName.INTEGER));
        RelDataTypeFieldImpl field1 = new RelDataTypeFieldImpl("s", 1, typeFactory.createSqlType(SqlTypeName.VARCHAR));
        fields.add(field0);
        fields.add(field1);
        RelRecordType recordType = new RelRecordType(fields);
        RelDataType copyRecordType = typeFactory.createTypeWithNullability((RelDataType)recordType, true);
        Assert.assertFalse((boolean)recordType.isNullable());
        Assert.assertTrue((boolean)copyRecordType.isNullable());
    }
}

