/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.test;

import org.apache.calcite.sql.type.SqlTypeName;
import org.junit.Assert;
import org.junit.Test;

public class SqlTypeNameTest {
    @Test
    public void testBit() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)-7);
        Assert.assertEquals((String)"BIT did not map to BOOLEAN", (Object)SqlTypeName.BOOLEAN, (Object)tn);
    }

    @Test
    public void testTinyint() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)-6);
        Assert.assertEquals((String)"TINYINT did not map to TINYINT", (Object)SqlTypeName.TINYINT, (Object)tn);
    }

    @Test
    public void testSmallint() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)5);
        Assert.assertEquals((String)"SMALLINT did not map to SMALLINT", (Object)SqlTypeName.SMALLINT, (Object)tn);
    }

    @Test
    public void testInteger() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)4);
        Assert.assertEquals((String)"INTEGER did not map to INTEGER", (Object)SqlTypeName.INTEGER, (Object)tn);
    }

    @Test
    public void testBigint() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)-5);
        Assert.assertEquals((String)"BIGINT did not map to BIGINT", (Object)SqlTypeName.BIGINT, (Object)tn);
    }

    @Test
    public void testFloat() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)6);
        Assert.assertEquals((String)"FLOAT did not map to FLOAT", (Object)SqlTypeName.FLOAT, (Object)tn);
    }

    @Test
    public void testReal() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)7);
        Assert.assertEquals((String)"REAL did not map to REAL", (Object)SqlTypeName.REAL, (Object)tn);
    }

    @Test
    public void testDouble() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)8);
        Assert.assertEquals((String)"DOUBLE did not map to DOUBLE", (Object)SqlTypeName.DOUBLE, (Object)tn);
    }

    @Test
    public void testNumeric() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)2);
        Assert.assertEquals((String)"NUMERIC did not map to DECIMAL", (Object)SqlTypeName.DECIMAL, (Object)tn);
    }

    @Test
    public void testDecimal() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)3);
        Assert.assertEquals((String)"DECIMAL did not map to DECIMAL", (Object)SqlTypeName.DECIMAL, (Object)tn);
    }

    @Test
    public void testChar() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)1);
        Assert.assertEquals((String)"CHAR did not map to CHAR", (Object)SqlTypeName.CHAR, (Object)tn);
    }

    @Test
    public void testVarchar() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)12);
        Assert.assertEquals((String)"VARCHAR did not map to VARCHAR", (Object)SqlTypeName.VARCHAR, (Object)tn);
    }

    @Test
    public void testLongvarchar() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)-1);
        Assert.assertEquals((String)"LONGVARCHAR did not map to null", null, (Object)tn);
    }

    @Test
    public void testDate() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)91);
        Assert.assertEquals((String)"DATE did not map to DATE", (Object)SqlTypeName.DATE, (Object)tn);
    }

    @Test
    public void testTime() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)92);
        Assert.assertEquals((String)"TIME did not map to TIME", (Object)SqlTypeName.TIME, (Object)tn);
    }

    @Test
    public void testTimestamp() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)93);
        Assert.assertEquals((String)"TIMESTAMP did not map to TIMESTAMP", (Object)SqlTypeName.TIMESTAMP, (Object)tn);
    }

    @Test
    public void testBinary() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)-2);
        Assert.assertEquals((String)"BINARY did not map to BINARY", (Object)SqlTypeName.BINARY, (Object)tn);
    }

    @Test
    public void testVarbinary() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)-3);
        Assert.assertEquals((String)"VARBINARY did not map to VARBINARY", (Object)SqlTypeName.VARBINARY, (Object)tn);
    }

    @Test
    public void testLongvarbinary() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)-4);
        Assert.assertEquals((String)"LONGVARBINARY did not map to null", null, (Object)tn);
    }

    @Test
    public void testNull() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)0);
        Assert.assertEquals((String)"NULL did not map to null", null, (Object)tn);
    }

    @Test
    public void testOther() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)1111);
        Assert.assertEquals((String)"OTHER did not map to null", null, (Object)tn);
    }

    @Test
    public void testJavaobject() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)2000);
        Assert.assertEquals((String)"JAVA_OBJECT did not map to null", null, (Object)tn);
    }

    @Test
    public void testDistinct() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)2001);
        Assert.assertEquals((String)"DISTINCT did not map to DISTINCT", (Object)SqlTypeName.DISTINCT, (Object)tn);
    }

    @Test
    public void testStruct() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)2002);
        Assert.assertEquals((String)"STRUCT did not map to null", (Object)SqlTypeName.STRUCTURED, (Object)tn);
    }

    @Test
    public void testArray() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)2003);
        Assert.assertEquals((String)"ARRAY did not map to ARRAY", (Object)SqlTypeName.ARRAY, (Object)tn);
    }

    @Test
    public void testBlob() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)2004);
        Assert.assertEquals((String)"BLOB did not map to null", null, (Object)tn);
    }

    @Test
    public void testClob() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)2005);
        Assert.assertEquals((String)"CLOB did not map to null", null, (Object)tn);
    }

    @Test
    public void testRef() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)2006);
        Assert.assertEquals((String)"REF did not map to null", null, (Object)tn);
    }

    @Test
    public void testDatalink() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)70);
        Assert.assertEquals((String)"DATALINK did not map to null", null, (Object)tn);
    }

    @Test
    public void testBoolean() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)16);
        Assert.assertEquals((String)"BOOLEAN did not map to BOOLEAN", (Object)SqlTypeName.BOOLEAN, (Object)tn);
    }

    @Test
    public void testRowid() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)-8);
        Assert.assertEquals((String)"ROWID maps to non-null type", null, (Object)tn);
    }

    @Test
    public void testNchar() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)-15);
        Assert.assertEquals((String)"NCHAR did not map to CHAR", (Object)SqlTypeName.CHAR, (Object)tn);
    }

    @Test
    public void testNvarchar() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)-9);
        Assert.assertEquals((String)"NVARCHAR did not map to VARCHAR", (Object)SqlTypeName.VARCHAR, (Object)tn);
    }

    @Test
    public void testLongnvarchar() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)-16);
        Assert.assertEquals((String)"LONGNVARCHAR maps to non-null type", null, (Object)tn);
    }

    @Test
    public void testNclob() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)2011);
        Assert.assertEquals((String)"NCLOB maps to non-null type", null, (Object)tn);
    }

    @Test
    public void testSqlxml() {
        SqlTypeName tn = SqlTypeName.getNameForJdbcType((int)2009);
        Assert.assertEquals((String)"SQLXML maps to non-null type", null, (Object)tn);
    }
}

