/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rel2sql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.calcite.rel.rel2sql.RelToSqlConverterTest;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.SchemaVersion;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.junit.Test;

public class RelToSqlConverterStructsTest {
    private static final Schema SCHEMA = new Schema(){

        public Table getTable(String name) {
            return TABLE;
        }

        public Set<String> getTableNames() {
            return ImmutableSet.of((Object)"myTable");
        }

        public RelProtoDataType getType(String name) {
            return null;
        }

        public Set<String> getTypeNames() {
            return ImmutableSet.of();
        }

        public Collection<Function> getFunctions(String name) {
            return null;
        }

        public Set<String> getFunctionNames() {
            return ImmutableSet.of();
        }

        public Schema getSubSchema(String name) {
            return null;
        }

        public Set<String> getSubSchemaNames() {
            return ImmutableSet.of();
        }

        public Expression getExpression(SchemaPlus parentSchema, String name) {
            return null;
        }

        public boolean isMutable() {
            return false;
        }

        public Schema snapshot(SchemaVersion version) {
            return null;
        }
    };
    private static final Table TABLE = new Table(){

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            RelDataType aType = typeFactory.createSqlType(SqlTypeName.BIGINT);
            RelDataType bType = typeFactory.createSqlType(SqlTypeName.BIGINT);
            RelDataType cType = typeFactory.createSqlType(SqlTypeName.BIGINT);
            RelDataType dType = typeFactory.createSqlType(SqlTypeName.BIGINT);
            RelDataType eType = typeFactory.createSqlType(SqlTypeName.BIGINT);
            RelDataType n11Type = typeFactory.createStructType((List)ImmutableList.of((Object)bType), (List)ImmutableList.of((Object)"b"));
            RelDataType n12Type = typeFactory.createStructType((List)ImmutableList.of((Object)cType), (List)ImmutableList.of((Object)"c"));
            RelDataType n1Type = typeFactory.createStructType((List)ImmutableList.of((Object)n11Type, (Object)n12Type), (List)ImmutableList.of((Object)"n11", (Object)"n12"));
            RelDataType n2Type = typeFactory.createStructType((List)ImmutableList.of((Object)dType), (List)ImmutableList.of((Object)"d"));
            return typeFactory.createStructType((List)ImmutableList.of((Object)aType, (Object)n1Type, (Object)n2Type, (Object)eType), (List)ImmutableList.of((Object)"a", (Object)"n1", (Object)"n2", (Object)"e"));
        }

        public Statistic getStatistic() {
            return STATS;
        }

        public Schema.TableType getJdbcTableType() {
            return null;
        }

        public boolean isRolledUp(String column) {
            return false;
        }

        public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, SqlNode parent, CalciteConnectionConfig config) {
            return false;
        }
    };
    private static final Statistic STATS = new Statistic(){

        public Double getRowCount() {
            return 0.0;
        }

        public boolean isKey(ImmutableBitSet columns) {
            return false;
        }

        public List<RelReferentialConstraint> getReferentialConstraints() {
            return ImmutableList.of();
        }

        public List<RelCollation> getCollations() {
            return ImmutableList.of();
        }

        public RelDistribution getDistribution() {
            return null;
        }
    };
    private static final SchemaPlus ROOT_SCHEMA = CalciteSchema.createRootSchema((boolean)false).add("myDb", SCHEMA).plus();

    private RelToSqlConverterTest.Sql sql(String sql) {
        return new RelToSqlConverterTest.Sql(ROOT_SCHEMA, sql, CalciteSqlDialect.DEFAULT, RelToSqlConverterTest.DEFAULT_REL_CONFIG, (List<java.util.function.Function<RelNode, RelNode>>)ImmutableList.of());
    }

    @Test
    public void testNestedSchemaSelectStar() {
        String query = "SELECT * FROM \"myTable\"";
        String expected = "SELECT \"a\", \"n1\".\"n11\".\"b\" AS \"n1\", \"n1\".\"n12\".\"c\" AS \"n12\", \"n2\".\"d\" AS \"n2\", \"e\"\nFROM \"myDb\".\"myTable\"";
        this.sql(query).ok(expected);
    }

    @Test
    public void testNestedSchemaRootColumns() {
        String query = "SELECT \"a\", \"e\" FROM \"myTable\"";
        String expected = "SELECT \"a\", \"e\"\nFROM \"myDb\".\"myTable\"";
        this.sql(query).ok(expected);
    }

    @Test
    public void testNestedSchemaNestedColumns() {
        String query = "SELECT \"a\", \"e\", \"myTable\".\"n1\".\"n11\".\"b\", \"myTable\".\"n2\".\"d\" FROM \"myTable\"";
        String expected = "SELECT \"a\", \"e\", \"n1\".\"n11\".\"b\", \"n2\".\"d\"\nFROM \"myDb\".\"myTable\"";
        this.sql(query).ok(expected);
    }
}

