/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rel2sql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Match;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.fun.SqlRowOperator;
import org.apache.calcite.sql.fun.SqlSingleValueAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.ReflectiveVisitor;

public class RelToSqlConverter
extends SqlImplementor
implements ReflectiveVisitor {
    private static final SqlRowOperator ANONYMOUS_ROW = new SqlRowOperator(" ");
    private final ReflectUtil.MethodDispatcher<SqlImplementor.Result> dispatcher;
    private final Deque<Frame> stack = new ArrayDeque<Frame>();

    public RelToSqlConverter(SqlDialect dialect) {
        super(dialect);
        this.dispatcher = ReflectUtil.createMethodDispatcher(SqlImplementor.Result.class, this, "visit", RelNode.class, new Class[0]);
    }

    protected SqlImplementor.Result dispatch(RelNode e) {
        return this.dispatcher.invoke(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqlImplementor.Result visitChild(int i, RelNode e) {
        try {
            this.stack.push(new Frame(i, e));
            SqlImplementor.Result result = this.dispatch(e);
            return result;
        }
        finally {
            this.stack.pop();
        }
    }

    public SqlImplementor.Result visit(RelNode e) {
        throw new AssertionError((Object)("Need to implement " + e.getClass().getName()));
    }

    public SqlImplementor.Result visit(Join e) {
        SqlImplementor.Result leftResult = this.visitChild(0, e.getLeft()).resetAlias();
        SqlImplementor.Result rightResult = this.visitChild(1, e.getRight()).resetAlias();
        SqlImplementor.Context leftContext = leftResult.qualifiedContext();
        SqlImplementor.Context rightContext = rightResult.qualifiedContext();
        SqlNode sqlCondition = null;
        SqlLiteral condType = JoinConditionType.ON.symbol(POS);
        JoinType joinType = RelToSqlConverter.joinType(e.getJoinType());
        if (this.isCrossJoin(e)) {
            joinType = this.dialect.emulateJoinTypeForCrossJoin();
            condType = JoinConditionType.NONE.symbol(POS);
        } else {
            sqlCondition = RelToSqlConverter.convertConditionToSqlNode(e.getCondition(), leftContext, rightContext, e.getLeft().getRowType().getFieldCount());
        }
        SqlJoin join = new SqlJoin(POS, leftResult.asFrom(), SqlLiteral.createBoolean(false, POS), joinType.symbol(POS), rightResult.asFrom(), condType, sqlCondition);
        return this.result(join, leftResult, rightResult);
    }

    private boolean isCrossJoin(Join e) {
        return e.getJoinType() == JoinRelType.INNER && e.getCondition().isAlwaysTrue();
    }

    public SqlImplementor.Result visit(Filter e) {
        RelNode input = e.getInput();
        SqlImplementor.Result x = this.visitChild(0, input);
        this.parseCorrelTable(e, x);
        if (input instanceof Aggregate) {
            SqlImplementor.Builder builder;
            if (((Aggregate)input).getInput() instanceof Project) {
                builder = x.builder(e, new SqlImplementor.Clause[0]);
                builder.clauses.add(SqlImplementor.Clause.HAVING);
            } else {
                builder = x.builder(e, SqlImplementor.Clause.HAVING);
            }
            builder.setHaving(builder.context.toSql(null, e.getCondition()));
            return builder.result();
        }
        SqlImplementor.Builder builder = x.builder(e, SqlImplementor.Clause.WHERE);
        builder.setWhere(builder.context.toSql(null, e.getCondition()));
        return builder.result();
    }

    public SqlImplementor.Result visit(Project e) {
        SqlImplementor.Result x = this.visitChild(0, e.getInput());
        this.parseCorrelTable(e, x);
        if (RelToSqlConverter.isStar(e.getChildExps(), e.getInput().getRowType(), e.getRowType())) {
            return x;
        }
        SqlImplementor.Builder builder = x.builder(e, SqlImplementor.Clause.SELECT);
        ArrayList<SqlNode> selectList = new ArrayList<SqlNode>();
        for (RexNode ref : e.getChildExps()) {
            SqlNode sqlExpr = builder.context.toSql(null, ref);
            this.addSelect(selectList, sqlExpr, e.getRowType());
        }
        builder.setSelect(new SqlNodeList(selectList, POS));
        return builder.result();
    }

    public SqlImplementor.Result visit(Aggregate e) {
        SqlImplementor.Builder builder;
        SqlImplementor.Result x = this.visitChild(0, e.getInput());
        if (e.getInput() instanceof Project) {
            builder = x.builder(e, new SqlImplementor.Clause[0]);
            builder.clauses.add(SqlImplementor.Clause.GROUP_BY);
        } else {
            builder = x.builder(e, SqlImplementor.Clause.GROUP_BY);
        }
        Expressions.FluentList groupByList = Expressions.list();
        ArrayList<SqlNode> selectList = new ArrayList<SqlNode>();
        Iterator<Object> iterator = e.getGroupSet().iterator();
        while (iterator.hasNext()) {
            int group = iterator.next();
            SqlNode field = builder.context.field(group);
            this.addSelect(selectList, field, e.getRowType());
            groupByList.add(field);
        }
        for (AggregateCall aggCall : e.getAggCallList()) {
            SqlNode aggCallSqlNode = builder.context.toSql(aggCall);
            if (aggCall.getAggregation() instanceof SqlSingleValueAggFunction) {
                aggCallSqlNode = this.dialect.rewriteSingleValueExpr(aggCallSqlNode);
            }
            this.addSelect(selectList, aggCallSqlNode, e.getRowType());
        }
        builder.setSelect(new SqlNodeList(selectList, POS));
        if (!groupByList.isEmpty() || e.getAggCallList().isEmpty()) {
            builder.setGroupBy(new SqlNodeList((Collection<? extends SqlNode>)groupByList, POS));
        }
        return builder.result();
    }

    public SqlImplementor.Result visit(TableScan e) {
        SqlIdentifier identifier = new SqlIdentifier(e.getTable().getQualifiedName(), SqlParserPos.ZERO);
        return this.result(identifier, (Collection<SqlImplementor.Clause>)ImmutableList.of((Object)((Object)SqlImplementor.Clause.FROM)), e, null);
    }

    public SqlImplementor.Result visit(Union e) {
        return this.setOpToSql(e.all ? SqlStdOperatorTable.UNION_ALL : SqlStdOperatorTable.UNION, e);
    }

    public SqlImplementor.Result visit(Intersect e) {
        return this.setOpToSql(e.all ? SqlStdOperatorTable.INTERSECT_ALL : SqlStdOperatorTable.INTERSECT, e);
    }

    public SqlImplementor.Result visit(Minus e) {
        return this.setOpToSql(e.all ? SqlStdOperatorTable.EXCEPT_ALL : SqlStdOperatorTable.EXCEPT, e);
    }

    public SqlImplementor.Result visit(Calc e) {
        SqlImplementor.Builder builder;
        SqlImplementor.Result x = this.visitChild(0, e.getInput());
        this.parseCorrelTable(e, x);
        RexProgram program = e.getProgram();
        SqlImplementor.Builder builder2 = builder = program.getCondition() != null ? x.builder(e, SqlImplementor.Clause.WHERE) : x.builder(e, new SqlImplementor.Clause[0]);
        if (!RelToSqlConverter.isStar(program)) {
            ArrayList<SqlNode> selectList = new ArrayList<SqlNode>();
            for (RexLocalRef ref : program.getProjectList()) {
                SqlNode sqlExpr = builder.context.toSql(program, ref);
                this.addSelect(selectList, sqlExpr, e.getRowType());
            }
            builder.setSelect(new SqlNodeList(selectList, POS));
        }
        if (program.getCondition() != null) {
            builder.setWhere(builder.context.toSql(program, program.getCondition()));
        }
        return builder.result();
    }

    public SqlImplementor.Result visit(Values e) {
        SqlNode query;
        ImmutableList clauses = ImmutableList.of((Object)((Object)SqlImplementor.Clause.SELECT));
        ImmutableMap pairs = ImmutableMap.of();
        SqlImplementor.Context context = this.aliasContext((Map<String, RelDataType>)pairs, false);
        boolean rename = this.stack.size() <= 1 || !(((Frame)Iterables.get(this.stack, (int)1)).r instanceof TableModify);
        List<String> fieldNames = e.getRowType().getFieldNames();
        if (!this.dialect.supportsAliasedValues() && rename) {
            ArrayList<SqlSelect> list = new ArrayList<SqlSelect>();
            for (List tuple : e.getTuples()) {
                ArrayList<SqlCall> values2 = new ArrayList<SqlCall>();
                SqlNodeList exprList = this.exprList(context, tuple);
                for (Pair<SqlNode, String> value : Pair.zip(exprList, fieldNames)) {
                    values2.add(SqlStdOperatorTable.AS.createCall(POS, (SqlNode)value.left, new SqlIdentifier((String)value.right, POS)));
                }
                list.add(new SqlSelect(POS, null, new SqlNodeList(values2, POS), new SqlIdentifier("DUAL", POS), null, null, null, null, null, null, null));
            }
            query = list.size() == 1 ? (SqlNode)list.get(0) : SqlStdOperatorTable.UNION_ALL.createCall(new SqlNodeList(list, POS));
        } else {
            SqlNodeList selects = new SqlNodeList(POS);
            for (List tuple : e.getTuples()) {
                selects.add(ANONYMOUS_ROW.createCall(this.exprList(context, tuple)));
            }
            query = SqlStdOperatorTable.VALUES.createCall(selects);
            if (rename) {
                ArrayList<SqlNode> list = new ArrayList<SqlNode>();
                list.add(query);
                list.add(new SqlIdentifier("t", POS));
                for (String fieldName : fieldNames) {
                    list.add(new SqlIdentifier(fieldName, POS));
                }
                query = SqlStdOperatorTable.AS.createCall(POS, list);
            }
        }
        return this.result(query, (Collection<SqlImplementor.Clause>)clauses, e, null);
    }

    public SqlImplementor.Result visit(Sort e) {
        SqlImplementor.Result x = this.visitChild(0, e.getInput());
        SqlImplementor.Builder builder = x.builder(e, SqlImplementor.Clause.ORDER_BY);
        Expressions.FluentList orderByList = Expressions.list();
        for (RelFieldCollation field : e.getCollation().getFieldCollations()) {
            builder.addOrderItem((List<SqlNode>)orderByList, field);
        }
        if (!orderByList.isEmpty()) {
            builder.setOrderBy(new SqlNodeList((Collection<? extends SqlNode>)orderByList, POS));
            x = builder.result();
        }
        if (e.fetch != null) {
            builder = x.builder(e, SqlImplementor.Clause.FETCH);
            builder.setFetch(builder.context.toSql(null, e.fetch));
            x = builder.result();
        }
        if (e.offset != null) {
            builder = x.builder(e, SqlImplementor.Clause.OFFSET);
            builder.setOffset(builder.context.toSql(null, e.offset));
            x = builder.result();
        }
        return x;
    }

    public SqlImplementor.Result visit(TableModify modify) {
        ImmutableMap pairs = ImmutableMap.of();
        SqlImplementor.Context context = this.aliasContext((Map<String, RelDataType>)pairs, false);
        SqlIdentifier sqlTargetTable = new SqlIdentifier(modify.getTable().getQualifiedName(), POS);
        switch (modify.getOperation()) {
            case INSERT: {
                SqlNode sqlSource = this.visitChild(0, modify.getInput()).asQueryOrValues();
                SqlInsert sqlInsert = new SqlInsert(POS, SqlNodeList.EMPTY, sqlTargetTable, sqlSource, this.identifierList(modify.getInput().getRowType().getFieldNames()));
                return this.result(sqlInsert, (Collection<SqlImplementor.Clause>)ImmutableList.of(), modify, null);
            }
            case UPDATE: {
                SqlImplementor.Result input = this.visitChild(0, modify.getInput());
                SqlUpdate sqlUpdate = new SqlUpdate(POS, sqlTargetTable, this.identifierList(modify.getUpdateColumnList()), this.exprList(context, modify.getSourceExpressionList()), ((SqlSelect)input.node).getWhere(), input.asSelect(), null);
                return this.result(sqlUpdate, (Collection<SqlImplementor.Clause>)input.clauses, modify, null);
            }
            case DELETE: {
                SqlImplementor.Result input = this.visitChild(0, modify.getInput());
                SqlDelete sqlDelete = new SqlDelete(POS, sqlTargetTable, input.asSelect().getWhere(), input.asSelect(), null);
                return this.result(sqlDelete, (Collection<SqlImplementor.Clause>)input.clauses, modify, null);
            }
        }
        throw new AssertionError((Object)("not implemented: " + modify));
    }

    private SqlNodeList exprList(SqlImplementor.Context context, List<? extends RexNode> exprs) {
        return new SqlNodeList(Lists.transform(exprs, e -> context.toSql(null, (RexNode)e)), POS);
    }

    private SqlNodeList identifierList(List<String> names) {
        return new SqlNodeList(Lists.transform(names, name -> new SqlIdentifier((String)name, POS)), POS);
    }

    public SqlImplementor.Result visit(Match e) {
        SqlNode after;
        SqlLiteral rowsPerMatch;
        RelNode input = e.getInput();
        SqlImplementor.Result x = this.visitChild(0, input);
        SqlImplementor.Context context = this.matchRecognizeContext(x.qualifiedContext());
        SqlNode tableRef = x.asQueryOrValues();
        ArrayList<SqlNode> partitionSqlList = new ArrayList<SqlNode>();
        if (e.getPartitionKeys() != null) {
            for (RexNode rex : e.getPartitionKeys()) {
                SqlNode sqlNode = context.toSql(null, rex);
                partitionSqlList.add(sqlNode);
            }
        }
        SqlNodeList partitionList = new SqlNodeList(partitionSqlList, POS);
        ArrayList<SqlNode> orderBySqlList = new ArrayList<SqlNode>();
        if (e.getOrderKeys() != null) {
            for (RelFieldCollation fc : e.getOrderKeys().getFieldCollations()) {
                if (fc.nullDirection != RelFieldCollation.NullDirection.UNSPECIFIED) {
                    boolean first = fc.nullDirection == RelFieldCollation.NullDirection.FIRST;
                    SqlNode nullDirectionNode = this.dialect.emulateNullDirection(context.field(fc.getFieldIndex()), first, fc.direction.isDescending());
                    if (nullDirectionNode != null) {
                        orderBySqlList.add(nullDirectionNode);
                        fc = new RelFieldCollation(fc.getFieldIndex(), fc.getDirection(), RelFieldCollation.NullDirection.UNSPECIFIED);
                    }
                }
                orderBySqlList.add(context.toSql(fc));
            }
        }
        SqlNodeList orderByList = new SqlNodeList(orderBySqlList, SqlParserPos.ZERO);
        SqlLiteral sqlLiteral = rowsPerMatch = e.isAllRows() ? SqlMatchRecognize.RowsPerMatchOption.ALL_ROWS.symbol(POS) : SqlMatchRecognize.RowsPerMatchOption.ONE_ROW.symbol(POS);
        if (e.getAfter() instanceof RexLiteral) {
            SqlMatchRecognize.AfterOption value = (SqlMatchRecognize.AfterOption)((Object)((RexLiteral)e.getAfter()).getValue2());
            after = SqlLiteral.createSymbol(value, POS);
        } else {
            RexCall call = (RexCall)e.getAfter();
            String operand = RexLiteral.stringValue(call.getOperands().get(0));
            after = call.getOperator().createCall(POS, new SqlIdentifier(operand, POS));
        }
        RexNode rexPattern = e.getPattern();
        SqlNode pattern = context.toSql(null, rexPattern);
        SqlLiteral strictStart = SqlLiteral.createBoolean(e.isStrictStart(), POS);
        SqlLiteral strictEnd = SqlLiteral.createBoolean(e.isStrictEnd(), POS);
        RexLiteral rexInterval = (RexLiteral)e.getInterval();
        SqlIntervalLiteral interval = null;
        if (rexInterval != null) {
            interval = (SqlIntervalLiteral)context.toSql(null, rexInterval);
        }
        SqlNodeList subsetList = new SqlNodeList(POS);
        for (Map.Entry entry : e.getSubsets().entrySet()) {
            SqlIdentifier left = new SqlIdentifier((String)entry.getKey(), POS);
            ArrayList<SqlIdentifier> rhl = new ArrayList<SqlIdentifier>();
            for (String right : (SortedSet)entry.getValue()) {
                rhl.add(new SqlIdentifier(right, POS));
            }
            subsetList.add(SqlStdOperatorTable.EQUALS.createCall(POS, left, new SqlNodeList(rhl, POS)));
        }
        SqlNodeList measureList = new SqlNodeList(POS);
        for (Map.Entry entry : e.getMeasures().entrySet()) {
            String alias = (String)entry.getKey();
            SqlNode sqlNode = context.toSql(null, (RexNode)entry.getValue());
            measureList.add(this.as(sqlNode, alias));
        }
        SqlNodeList patternDefList = new SqlNodeList(POS);
        for (Map.Entry entry : e.getPatternDefinitions().entrySet()) {
            String alias = (String)entry.getKey();
            SqlNode sqlNode = context.toSql(null, (RexNode)entry.getValue());
            patternDefList.add(this.as(sqlNode, alias));
        }
        SqlMatchRecognize matchRecognize = new SqlMatchRecognize(POS, tableRef, pattern, strictStart, strictEnd, patternDefList, measureList, after, subsetList, rowsPerMatch, partitionList, orderByList, interval);
        return this.result(matchRecognize, (Collection<SqlImplementor.Clause>)Expressions.list((Object[])new SqlImplementor.Clause[]{SqlImplementor.Clause.FROM}), e, null);
    }

    private SqlCall as(SqlNode e, String alias) {
        return SqlStdOperatorTable.AS.createCall(POS, e, new SqlIdentifier(alias, POS));
    }

    @Override
    public void addSelect(List<SqlNode> selectList, SqlNode node, RelDataType rowType) {
        String name = rowType.getFieldNames().get(selectList.size());
        String alias = SqlValidatorUtil.getAlias(node, -1);
        String lowerName = name.toLowerCase(Locale.ROOT);
        if (lowerName.startsWith("expr$")) {
            this.ordinalMap.put(lowerName, node);
        } else if (alias == null || !alias.equals(name)) {
            node = this.as(node, name);
        }
        selectList.add(node);
    }

    private void parseCorrelTable(RelNode relNode, SqlImplementor.Result x) {
        for (CorrelationId id : relNode.getVariablesSet()) {
            this.correlTableMap.put(id, x.qualifiedContext());
        }
    }

    private static class Frame {
        private final int ordinalInParent;
        private final RelNode r;

        Frame(int ordinalInParent, RelNode r) {
            this.ordinalInParent = ordinalInParent;
            this.r = r;
        }
    }
}

