/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.SubstitutionVisitor;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.mutable.MutableFilter;
import org.apache.calcite.rel.mutable.MutableProject;
import org.apache.calcite.rel.mutable.MutableRel;
import org.apache.calcite.rel.mutable.MutableRels;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.tools.RelBuilderFactory;

public class MaterializedViewSubstitutionVisitor
extends SubstitutionVisitor {
    private static final ImmutableList<SubstitutionVisitor.UnifyRule> EXTENDED_RULES = ImmutableList.builder().addAll((Iterable)DEFAULT_RULES).add((Object)ProjectToProjectUnifyRule1.INSTANCE).add((Object)FilterToFilterUnifyRule1.INSTANCE).add((Object)FilterToProjectUnifyRule1.INSTANCE).build();

    public MaterializedViewSubstitutionVisitor(RelNode target_, RelNode query_) {
        super(target_, query_, EXTENDED_RULES);
    }

    public MaterializedViewSubstitutionVisitor(RelNode target_, RelNode query_, RelBuilderFactory relBuilderFactory) {
        super(target_, query_, EXTENDED_RULES, relBuilderFactory);
    }

    @Override
    public List<RelNode> go(RelNode replacement_) {
        return super.go(replacement_);
    }

    private static RexNode transformRex(RexNode node, List<RelDataTypeField> oldFields, List<RelDataTypeField> newFields) {
        List<RexNode> nodes = MaterializedViewSubstitutionVisitor.transformRex((List<RexNode>)ImmutableList.of((Object)node), oldFields, newFields);
        return nodes.get(0);
    }

    private static List<RexNode> transformRex(List<RexNode> nodes, final List<RelDataTypeField> oldFields, final List<RelDataTypeField> newFields) {
        RexShuttle shuttle = new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef ref) {
                RelDataTypeField f = (RelDataTypeField)oldFields.get(ref.getIndex());
                for (int index = 0; index < newFields.size(); ++index) {
                    RelDataTypeField newf = (RelDataTypeField)newFields.get(index);
                    if (!((String)f.getKey()).equals(newf.getKey()) || f.getValue() != newf.getValue()) continue;
                    return new RexInputRef(index, (RelDataType)f.getValue());
                }
                throw SubstitutionVisitor.MatchFailed.INSTANCE;
            }
        };
        return shuttle.apply(nodes);
    }

    private static class FilterToProjectUnifyRule1
    extends SubstitutionVisitor.AbstractUnifyRule {
        public static final FilterToProjectUnifyRule1 INSTANCE = new FilterToProjectUnifyRule1();

        private FilterToProjectUnifyRule1() {
            super(FilterToProjectUnifyRule1.operand(MutableFilter.class, FilterToProjectUnifyRule1.query(0)), FilterToProjectUnifyRule1.operand(MutableProject.class, FilterToProjectUnifyRule1.operand(MutableFilter.class, FilterToProjectUnifyRule1.target(0))), 1);
        }

        @Override
        public SubstitutionVisitor.UnifyResult apply(SubstitutionVisitor.UnifyRuleCall call) {
            List newProjects;
            MutableRel query = call.query;
            List<RelDataTypeField> oldFieldList = query.rowType.getFieldList();
            List<RelDataTypeField> newFieldList = call.target.rowType.getFieldList();
            try {
                newProjects = MaterializedViewSubstitutionVisitor.transformRex(call.getCluster().getRexBuilder().identityProjects(query.rowType), (List<RelDataTypeField>)oldFieldList, (List<RelDataTypeField>)newFieldList);
            }
            catch (SubstitutionVisitor.MatchFailed e) {
                return null;
            }
            MutableProject newProject = MutableProject.of(query.rowType, call.target, newProjects);
            MutableRel newProject2 = MutableRels.strip(newProject);
            return call.result(newProject2);
        }

        @Override
        protected SubstitutionVisitor.UnifyRuleCall match(SubstitutionVisitor visitor, MutableRel query, MutableRel target) {
            assert (query instanceof MutableFilter && target instanceof MutableProject);
            if (this.queryOperand.matches(visitor, query) && this.targetOperand.matches(visitor, target) && visitor.isWeaker(query, ((MutableProject)target).getInput())) {
                RexNode newCondition;
                MutableFilter filter = (MutableFilter)query;
                try {
                    newCondition = MaterializedViewSubstitutionVisitor.transformRex(filter.condition, (List<RelDataTypeField>)filter.getInput().rowType.getFieldList(), (List<RelDataTypeField>)target.rowType.getFieldList());
                }
                catch (SubstitutionVisitor.MatchFailed e) {
                    return null;
                }
                MutableFilter newFilter = MutableFilter.of(target, newCondition);
                SubstitutionVisitor substitutionVisitor = visitor;
                substitutionVisitor.getClass();
                return new SubstitutionVisitor.UnifyRuleCall(substitutionVisitor, this, query, newFilter, this.copy(visitor.slots, this.slotCount));
            }
            return null;
        }
    }

    private static class FilterToFilterUnifyRule1
    extends SubstitutionVisitor.AbstractUnifyRule {
        public static final FilterToFilterUnifyRule1 INSTANCE = new FilterToFilterUnifyRule1();

        private FilterToFilterUnifyRule1() {
            super(FilterToFilterUnifyRule1.operand(MutableFilter.class, FilterToFilterUnifyRule1.query(0)), FilterToFilterUnifyRule1.operand(MutableFilter.class, FilterToFilterUnifyRule1.target(0)), 1);
        }

        @Override
        public SubstitutionVisitor.UnifyResult apply(SubstitutionVisitor.UnifyRuleCall call) {
            MutableFilter query = (MutableFilter)call.query;
            MutableFilter target = (MutableFilter)call.target;
            MutableFilter newFilter = MutableFilter.of(target, query.condition);
            return call.result(newFilter);
        }

        @Override
        protected SubstitutionVisitor.UnifyRuleCall match(SubstitutionVisitor visitor, MutableRel query, MutableRel target) {
            if (this.queryOperand.matches(visitor, query) && this.targetOperand.matches(visitor, target) && visitor.isWeaker(query, target)) {
                SubstitutionVisitor substitutionVisitor = visitor;
                substitutionVisitor.getClass();
                return new SubstitutionVisitor.UnifyRuleCall(substitutionVisitor, this, query, target, this.copy(visitor.slots, this.slotCount));
            }
            return null;
        }
    }

    private static class ProjectToProjectUnifyRule1
    extends SubstitutionVisitor.AbstractUnifyRule {
        public static final ProjectToProjectUnifyRule1 INSTANCE = new ProjectToProjectUnifyRule1();

        private ProjectToProjectUnifyRule1() {
            super(ProjectToProjectUnifyRule1.operand(MutableProject.class, ProjectToProjectUnifyRule1.query(0)), ProjectToProjectUnifyRule1.operand(MutableProject.class, ProjectToProjectUnifyRule1.target(0)), 1);
        }

        @Override
        protected SubstitutionVisitor.UnifyResult apply(SubstitutionVisitor.UnifyRuleCall call) {
            List newProjects;
            MutableProject query = (MutableProject)call.query;
            List<RelDataTypeField> oldFieldList = query.getInput().rowType.getFieldList();
            List<RelDataTypeField> newFieldList = call.target.rowType.getFieldList();
            try {
                newProjects = MaterializedViewSubstitutionVisitor.transformRex(query.projects, (List<RelDataTypeField>)oldFieldList, (List<RelDataTypeField>)newFieldList);
            }
            catch (SubstitutionVisitor.MatchFailed e) {
                return null;
            }
            MutableProject newProject = MutableProject.of(query.rowType, call.target, newProjects);
            MutableRel newProject2 = MutableRels.strip(newProject);
            return call.result(newProject2);
        }

        @Override
        protected SubstitutionVisitor.UnifyRuleCall match(SubstitutionVisitor visitor, MutableRel query, MutableRel target) {
            assert (query instanceof MutableProject && target instanceof MutableProject);
            if (this.queryOperand.matches(visitor, query)) {
                MutableProject queryProject;
                if (this.targetOperand.matches(visitor, target)) {
                    return null;
                }
                if (this.targetOperand.isWeaker(visitor, target) && (queryProject = (MutableProject)query).getInput() instanceof MutableFilter) {
                    RexNode newCondition;
                    MutableFilter innerFilter = (MutableFilter)queryProject.getInput();
                    try {
                        newCondition = MaterializedViewSubstitutionVisitor.transformRex(innerFilter.condition, (List<RelDataTypeField>)innerFilter.getInput().rowType.getFieldList(), (List<RelDataTypeField>)target.rowType.getFieldList());
                    }
                    catch (SubstitutionVisitor.MatchFailed e) {
                        return null;
                    }
                    MutableFilter newFilter = MutableFilter.of(target, newCondition);
                    SubstitutionVisitor substitutionVisitor = visitor;
                    substitutionVisitor.getClass();
                    return new SubstitutionVisitor.UnifyRuleCall(substitutionVisitor, this, query, newFilter, this.copy(visitor.slots, this.slotCount));
                }
            }
            return null;
        }
    }
}

