/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.catalog;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.test.catalog.CompoundNameColumn;
import org.apache.calcite.test.catalog.MockCatalogReader;
import org.apache.calcite.util.Pair;

final class CompoundNameColumnResolver
implements MockCatalogReader.ColumnResolver {
    private final Map<String, Integer> nameMap = new HashMap<String, Integer>();
    private final Map<String, Map<String, Integer>> groupMap = new HashMap<String, Map<String, Integer>>();
    private final String defaultColumnGroup;

    CompoundNameColumnResolver(List<CompoundNameColumn> columns, String defaultColumnGroup) {
        this.defaultColumnGroup = defaultColumnGroup;
        for (Ord column : Ord.zip(columns)) {
            this.nameMap.put(((CompoundNameColumn)column.e).getName(), column.i);
            Map subMap = this.groupMap.computeIfAbsent(((CompoundNameColumn)column.e).first, k -> new HashMap());
            subMap.put(((CompoundNameColumn)column.e).second, column.i);
        }
    }

    @Override
    public List<Pair<RelDataTypeField, List<String>>> resolveColumn(RelDataType rowType, RelDataTypeFactory typeFactory, List<String> names) {
        Map<String, Integer> subMap;
        Integer index;
        Map<String, Integer> subMap2;
        ArrayList<Pair<RelDataTypeField, List<String>>> ret = new ArrayList<Pair<RelDataTypeField, List<String>>>();
        if (names.size() >= 2 && (subMap2 = this.groupMap.get(names.get(0))) != null && (index = subMap2.get(names.get(1))) != null) {
            ret.add((Pair<RelDataTypeField, List<String>>)new Pair(rowType.getFieldList().get(index), names.subList(2, names.size())));
        }
        String columnName = names.get(0);
        List<String> remainder = names.subList(1, names.size());
        Integer index2 = this.nameMap.get(columnName);
        if (index2 != null) {
            ret.add(new Pair(rowType.getFieldList().get(index2), remainder));
            return ret;
        }
        List<String> priorityGroups = Arrays.asList("", this.defaultColumnGroup);
        for (String string : priorityGroups) {
            Map<String, Integer> subMap3 = this.groupMap.get(string);
            if (subMap3 == null || (index2 = subMap3.get(columnName)) == null) continue;
            ret.add((Pair<RelDataTypeField, List<String>>)new Pair(rowType.getFieldList().get(index2), remainder));
            return ret;
        }
        for (Map.Entry entry : this.groupMap.entrySet()) {
            if (priorityGroups.contains(entry.getKey()) || (index2 = (Integer)((Map)entry.getValue()).get(columnName)) == null) continue;
            ret.add((Pair<RelDataTypeField, List<String>>)new Pair(rowType.getFieldList().get(index2), remainder));
        }
        if (ret.isEmpty() && names.size() == 1 && (subMap = this.groupMap.get(columnName)) != null) {
            ArrayList<Map.Entry<String, Integer>> arrayList = new ArrayList<Map.Entry<String, Integer>>(subMap.entrySet());
            arrayList.sort((o1, o2) -> (Integer)o1.getValue() - (Integer)o2.getValue());
            ret.add((Pair<RelDataTypeField, List<String>>)new Pair((Object)new RelDataTypeFieldImpl(columnName, -1, CompoundNameColumnResolver.createStructType(rowType, typeFactory, arrayList)), remainder));
        }
        return ret;
    }

    private static RelDataType createStructType(final RelDataType rowType, RelDataTypeFactory typeFactory, final List<Map.Entry<String, Integer>> entries) {
        return typeFactory.createStructType(StructKind.PEEK_FIELDS, (List)new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                int i = (Integer)((Map.Entry)entries.get(index)).getValue();
                return ((RelDataTypeField)rowType.getFieldList().get(i)).getType();
            }

            @Override
            public int size() {
                return entries.size();
            }
        }, (List)new AbstractList<String>(){

            @Override
            public String get(int index) {
                return (String)((Map.Entry)entries.get(index)).getKey();
            }

            @Override
            public int size() {
                return entries.size();
            }
        });
    }
}

