/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.runtime.Utilities;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AnyOf;
import org.junit.Assert;
import org.junit.Test;

public class SqlFunctionsTest {
    @Test
    public void testCharLength() {
        Assert.assertEquals((long)3L, (long)SqlFunctions.charLength((String)"xyz"));
    }

    @Test
    public void testConcat() {
        Assert.assertEquals((Object)"a bcd", (Object)SqlFunctions.concat((String)"a b", (String)"cd"));
        Assert.assertEquals((Object)"anull", (Object)SqlFunctions.concat((String)"a", null));
        Assert.assertEquals((Object)"nullnull", (Object)SqlFunctions.concat((String)null, null));
        Assert.assertEquals((Object)"nullb", (Object)SqlFunctions.concat(null, (String)"b"));
    }

    @Test
    public void testLower() {
        Assert.assertEquals((Object)"a bcd iijk", (Object)SqlFunctions.lower((String)"A bCd Iijk"));
    }

    @Test
    public void testUpper() {
        Assert.assertEquals((Object)"A BCD IIJK", (Object)SqlFunctions.upper((String)"A bCd iIjk"));
    }

    @Test
    public void testInitcap() {
        Assert.assertEquals((Object)"Aa", (Object)SqlFunctions.initcap((String)"aA"));
        Assert.assertEquals((Object)"Zz", (Object)SqlFunctions.initcap((String)"zz"));
        Assert.assertEquals((Object)"Az", (Object)SqlFunctions.initcap((String)"AZ"));
        Assert.assertEquals((Object)"Try A Little  ", (Object)SqlFunctions.initcap((String)"tRy a littlE  "));
        Assert.assertEquals((Object)"Won'T It?No", (Object)SqlFunctions.initcap((String)"won't it?no"));
        Assert.assertEquals((Object)"1a", (Object)SqlFunctions.initcap((String)"1A"));
        Assert.assertEquals((Object)" B0123b", (Object)SqlFunctions.initcap((String)" b0123B"));
    }

    @Test
    public void testLesser() {
        Assert.assertEquals((Object)"a", (Object)SqlFunctions.lesser((Comparable)((Object)"a"), (Comparable)((Object)"bc")));
        Assert.assertEquals((Object)"ac", (Object)SqlFunctions.lesser((Comparable)((Object)"bc"), (Comparable)((Object)"ac")));
        try {
            Comparable o = SqlFunctions.lesser((Comparable)((Object)"a"), null);
            Assert.fail((String)("Expected NPE, got " + o));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"a", (Object)SqlFunctions.lesser(null, (Comparable)((Object)"a")));
        Assert.assertNull((Object)SqlFunctions.lesser((Comparable)((Object)((String)null)), null));
    }

    @Test
    public void testGreater() {
        Assert.assertEquals((Object)"bc", (Object)SqlFunctions.greater((Comparable)((Object)"a"), (Comparable)((Object)"bc")));
        Assert.assertEquals((Object)"bc", (Object)SqlFunctions.greater((Comparable)((Object)"bc"), (Comparable)((Object)"ac")));
        try {
            Comparable o = SqlFunctions.greater((Comparable)((Object)"a"), null);
            Assert.fail((String)("Expected NPE, got " + o));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"a", (Object)SqlFunctions.greater(null, (Comparable)((Object)"a")));
        Assert.assertNull((Object)SqlFunctions.greater((Comparable)((Object)((String)null)), null));
    }

    @Test
    public void testRtrim() {
        Assert.assertEquals((Object)"", (Object)SqlFunctions.rtrim((String)""));
        Assert.assertEquals((Object)"", (Object)SqlFunctions.rtrim((String)"    "));
        Assert.assertEquals((Object)"   x", (Object)SqlFunctions.rtrim((String)"   x  "));
        Assert.assertEquals((Object)"   x", (Object)SqlFunctions.rtrim((String)"   x "));
        Assert.assertEquals((Object)"   x y", (Object)SqlFunctions.rtrim((String)"   x y "));
        Assert.assertEquals((Object)"   x", (Object)SqlFunctions.rtrim((String)"   x"));
        Assert.assertEquals((Object)"x", (Object)SqlFunctions.rtrim((String)"x"));
    }

    @Test
    public void testLtrim() {
        Assert.assertEquals((Object)"", (Object)SqlFunctions.ltrim((String)""));
        Assert.assertEquals((Object)"", (Object)SqlFunctions.ltrim((String)"    "));
        Assert.assertEquals((Object)"x  ", (Object)SqlFunctions.ltrim((String)"   x  "));
        Assert.assertEquals((Object)"x ", (Object)SqlFunctions.ltrim((String)"   x "));
        Assert.assertEquals((Object)"x y ", (Object)SqlFunctions.ltrim((String)"x y "));
        Assert.assertEquals((Object)"x", (Object)SqlFunctions.ltrim((String)"   x"));
        Assert.assertEquals((Object)"x", (Object)SqlFunctions.ltrim((String)"x"));
    }

    @Test
    public void testTrim() {
        Assert.assertEquals((Object)"", (Object)SqlFunctionsTest.trimSpacesBoth(""));
        Assert.assertEquals((Object)"", (Object)SqlFunctionsTest.trimSpacesBoth("    "));
        Assert.assertEquals((Object)"x", (Object)SqlFunctionsTest.trimSpacesBoth("   x  "));
        Assert.assertEquals((Object)"x", (Object)SqlFunctionsTest.trimSpacesBoth("   x "));
        Assert.assertEquals((Object)"x y", (Object)SqlFunctionsTest.trimSpacesBoth("   x y "));
        Assert.assertEquals((Object)"x", (Object)SqlFunctionsTest.trimSpacesBoth("   x"));
        Assert.assertEquals((Object)"x", (Object)SqlFunctionsTest.trimSpacesBoth("x"));
    }

    static String trimSpacesBoth(String s) {
        return SqlFunctions.trim((boolean)true, (boolean)true, (String)" ", (String)s);
    }

    @Test
    public void testAddMonths() {
        this.checkAddMonths(2016, 1, 1, 2016, 2, 1, 1);
        this.checkAddMonths(2016, 1, 1, 2017, 1, 1, 12);
        this.checkAddMonths(2016, 1, 1, 2017, 2, 1, 13);
        this.checkAddMonths(2016, 1, 1, 2015, 1, 1, -12);
        this.checkAddMonths(2016, 1, 1, 2018, 10, 1, 33);
        this.checkAddMonths(2016, 1, 31, 2016, 4, 30, 3);
        this.checkAddMonths(2016, 4, 30, 2016, 7, 30, 3);
        this.checkAddMonths(2016, 1, 31, 2016, 2, 29, 1);
        this.checkAddMonths(2016, 3, 31, 2016, 2, 29, -1);
        this.checkAddMonths(2016, 3, 31, 2116, 3, 31, 1200);
        this.checkAddMonths(2016, 2, 28, 2116, 2, 28, 1200);
    }

    private void checkAddMonths(int y0, int m0, int d0, int y1, int m1, int d1, int months) {
        int date0 = DateTimeUtils.ymdToUnixDate((int)y0, (int)m0, (int)d0);
        long date = SqlFunctions.addMonths((int)date0, (int)months);
        int date1 = DateTimeUtils.ymdToUnixDate((int)y1, (int)m1, (int)d1);
        Assert.assertThat((Object)((int)date), (Matcher)CoreMatchers.is((Object)date1));
        Assert.assertThat((Object)SqlFunctions.subtractMonths((int)date1, (int)date0), (Matcher)AnyOf.anyOf((Matcher)CoreMatchers.is((Object)months), (Matcher)CoreMatchers.is((Object)(months + 1))));
        Assert.assertThat((Object)SqlFunctions.subtractMonths((int)(date1 + 1), (int)date0), (Matcher)AnyOf.anyOf((Matcher)CoreMatchers.is((Object)months), (Matcher)CoreMatchers.is((Object)(months + 1))));
        Assert.assertThat((Object)SqlFunctions.subtractMonths((int)date1, (int)(date0 + 1)), (Matcher)AnyOf.anyOf((Matcher)CoreMatchers.is((Object)months), (Matcher)CoreMatchers.is((Object)(months - 1))));
        Assert.assertThat((Object)SqlFunctions.subtractMonths((long)this.d2ts(date1, 1), (long)this.d2ts(date0, 0)), (Matcher)AnyOf.anyOf((Matcher)CoreMatchers.is((Object)months), (Matcher)CoreMatchers.is((Object)(months + 1))));
        Assert.assertThat((Object)SqlFunctions.subtractMonths((long)this.d2ts(date1, 0), (long)this.d2ts(date0, 1)), (Matcher)AnyOf.anyOf((Matcher)CoreMatchers.is((Object)(months - 1)), (Matcher)CoreMatchers.is((Object)months), (Matcher)CoreMatchers.is((Object)(months + 1))));
    }

    private long d2ts(int date, int millis) {
        return (long)date * 86400000L + (long)millis;
    }

    @Test
    public void testFloor() {
        this.checkFloor(0, 10, 0);
        this.checkFloor(27, 10, 20);
        this.checkFloor(30, 10, 30);
        this.checkFloor(-30, 10, -30);
        this.checkFloor(-27, 10, -30);
    }

    private void checkFloor(int x, int y, int result) {
        Assert.assertThat((Object)SqlFunctions.floor((int)x, (int)y), (Matcher)CoreMatchers.is((Object)result));
        Assert.assertThat((Object)SqlFunctions.floor((long)x, (long)y), (Matcher)CoreMatchers.is((Object)result));
        Assert.assertThat((Object)SqlFunctions.floor((short)((short)x), (short)((short)y)), (Matcher)CoreMatchers.is((Object)((short)result)));
        Assert.assertThat((Object)SqlFunctions.floor((byte)((byte)x), (byte)((byte)y)), (Matcher)CoreMatchers.is((Object)((byte)result)));
        Assert.assertThat((Object)SqlFunctions.floor((BigDecimal)BigDecimal.valueOf(x), (BigDecimal)BigDecimal.valueOf(y)), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(result)));
    }

    @Test
    public void testCeil() {
        this.checkCeil(0, 10, 0);
        this.checkCeil(27, 10, 30);
        this.checkCeil(30, 10, 30);
        this.checkCeil(-30, 10, -30);
        this.checkCeil(-27, 10, -20);
        this.checkCeil(-27, 1, -27);
    }

    private void checkCeil(int x, int y, int result) {
        Assert.assertThat((Object)SqlFunctions.ceil((int)x, (int)y), (Matcher)CoreMatchers.is((Object)result));
        Assert.assertThat((Object)SqlFunctions.ceil((long)x, (long)y), (Matcher)CoreMatchers.is((Object)result));
        Assert.assertThat((Object)SqlFunctions.ceil((short)((short)x), (short)((short)y)), (Matcher)CoreMatchers.is((Object)((short)result)));
        Assert.assertThat((Object)SqlFunctions.ceil((byte)((byte)x), (byte)((byte)y)), (Matcher)CoreMatchers.is((Object)((byte)result)));
        Assert.assertThat((Object)SqlFunctions.ceil((BigDecimal)BigDecimal.valueOf(x), (BigDecimal)BigDecimal.valueOf(y)), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(result)));
    }

    @Test
    public void testCompare() {
        List<String> ac = Arrays.asList("a", "c");
        List<String> abc = Arrays.asList("a", "b", "c");
        List<String> a = Collections.singletonList("a");
        List empty = Collections.emptyList();
        Assert.assertEquals((long)0L, (long)Utilities.compare(ac, ac));
        Assert.assertEquals((long)0L, (long)Utilities.compare(ac, new ArrayList<String>(ac)));
        Assert.assertEquals((long)-1L, (long)Utilities.compare(a, ac));
        Assert.assertEquals((long)-1L, (long)Utilities.compare(empty, ac));
        Assert.assertEquals((long)1L, (long)Utilities.compare(ac, a));
        Assert.assertEquals((long)1L, (long)Utilities.compare(ac, abc));
        Assert.assertEquals((long)1L, (long)Utilities.compare(ac, empty));
        Assert.assertEquals((long)0L, (long)Utilities.compare(empty, empty));
    }

    @Test
    public void testTruncateLong() {
        Assert.assertEquals((long)12000L, (long)SqlFunctions.truncate((long)12345L, (long)1000L));
        Assert.assertEquals((long)12000L, (long)SqlFunctions.truncate((long)12000L, (long)1000L));
        Assert.assertEquals((long)12000L, (long)SqlFunctions.truncate((long)12001L, (long)1000L));
        Assert.assertEquals((long)11000L, (long)SqlFunctions.truncate((long)11999L, (long)1000L));
        Assert.assertEquals((long)-13000L, (long)SqlFunctions.truncate((long)-12345L, (long)1000L));
        Assert.assertEquals((long)-12000L, (long)SqlFunctions.truncate((long)-12000L, (long)1000L));
        Assert.assertEquals((long)-13000L, (long)SqlFunctions.truncate((long)-12001L, (long)1000L));
        Assert.assertEquals((long)-12000L, (long)SqlFunctions.truncate((long)-11999L, (long)1000L));
    }

    @Test
    public void testTruncateInt() {
        Assert.assertEquals((long)12000L, (long)SqlFunctions.truncate((int)12345, (int)1000));
        Assert.assertEquals((long)12000L, (long)SqlFunctions.truncate((int)12000, (int)1000));
        Assert.assertEquals((long)12000L, (long)SqlFunctions.truncate((int)12001, (int)1000));
        Assert.assertEquals((long)11000L, (long)SqlFunctions.truncate((int)11999, (int)1000));
        Assert.assertEquals((long)-13000L, (long)SqlFunctions.truncate((int)-12345, (int)1000));
        Assert.assertEquals((long)-12000L, (long)SqlFunctions.truncate((int)-12000, (int)1000));
        Assert.assertEquals((long)-13000L, (long)SqlFunctions.truncate((int)-12001, (int)1000));
        Assert.assertEquals((long)-12000L, (long)SqlFunctions.truncate((int)-11999, (int)1000));
        Assert.assertEquals((long)12000L, (long)SqlFunctions.round((int)12345, (int)1000));
        Assert.assertEquals((long)13000L, (long)SqlFunctions.round((int)12845, (int)1000));
        Assert.assertEquals((long)-12000L, (long)SqlFunctions.round((int)-12345, (int)1000));
        Assert.assertEquals((long)-13000L, (long)SqlFunctions.round((int)-12845, (int)1000));
    }

    @Test
    public void testSTruncateDouble() {
        Assert.assertEquals((double)12.345, (double)SqlFunctions.struncate((double)12.345, (int)3), (double)0.001);
        Assert.assertEquals((double)12.34, (double)SqlFunctions.struncate((double)12.345, (int)2), (double)0.001);
        Assert.assertEquals((double)12.3, (double)SqlFunctions.struncate((double)12.345, (int)1), (double)0.001);
        Assert.assertEquals((double)12.0, (double)SqlFunctions.struncate((double)12.999, (int)0), (double)0.001);
        Assert.assertEquals((double)-12.345, (double)SqlFunctions.struncate((double)-12.345, (int)3), (double)0.001);
        Assert.assertEquals((double)-12.34, (double)SqlFunctions.struncate((double)-12.345, (int)2), (double)0.001);
        Assert.assertEquals((double)-12.3, (double)SqlFunctions.struncate((double)-12.345, (int)1), (double)0.001);
        Assert.assertEquals((double)-12.0, (double)SqlFunctions.struncate((double)-12.999, (int)0), (double)0.001);
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.struncate((double)12345.0, (int)-3), (double)0.001);
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.struncate((double)12000.0, (int)-3), (double)0.001);
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.struncate((double)12001.0, (int)-3), (double)0.001);
        Assert.assertEquals((double)10000.0, (double)SqlFunctions.struncate((double)12000.0, (int)-4), (double)0.001);
        Assert.assertEquals((double)0.0, (double)SqlFunctions.struncate((double)12000.0, (int)-5), (double)0.001);
        Assert.assertEquals((double)11000.0, (double)SqlFunctions.struncate((double)11999.0, (int)-3), (double)0.001);
        Assert.assertEquals((double)-12000.0, (double)SqlFunctions.struncate((double)-12345.0, (int)-3), (double)0.001);
        Assert.assertEquals((double)-12000.0, (double)SqlFunctions.struncate((double)-12000.0, (int)-3), (double)0.001);
        Assert.assertEquals((double)-11000.0, (double)SqlFunctions.struncate((double)-11999.0, (int)-3), (double)0.001);
        Assert.assertEquals((double)-10000.0, (double)SqlFunctions.struncate((double)-12000.0, (int)-4), (double)0.001);
        Assert.assertEquals((double)0.0, (double)SqlFunctions.struncate((double)-12000.0, (int)-5), (double)0.001);
    }

    @Test
    public void testSTruncateLong() {
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.struncate((long)12345L, (int)-3), (double)0.001);
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.struncate((long)12000L, (int)-3), (double)0.001);
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.struncate((long)12001L, (int)-3), (double)0.001);
        Assert.assertEquals((double)10000.0, (double)SqlFunctions.struncate((long)12000L, (int)-4), (double)0.001);
        Assert.assertEquals((double)0.0, (double)SqlFunctions.struncate((long)12000L, (int)-5), (double)0.001);
        Assert.assertEquals((double)11000.0, (double)SqlFunctions.struncate((long)11999L, (int)-3), (double)0.001);
        Assert.assertEquals((double)-12000.0, (double)SqlFunctions.struncate((long)-12345L, (int)-3), (double)0.001);
        Assert.assertEquals((double)-12000.0, (double)SqlFunctions.struncate((long)-12000L, (int)-3), (double)0.001);
        Assert.assertEquals((double)-11000.0, (double)SqlFunctions.struncate((long)-11999L, (int)-3), (double)0.001);
        Assert.assertEquals((double)-10000.0, (double)SqlFunctions.struncate((long)-12000L, (int)-4), (double)0.001);
        Assert.assertEquals((double)0.0, (double)SqlFunctions.struncate((long)-12000L, (int)-5), (double)0.001);
    }

    @Test
    public void testSTruncateInt() {
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.struncate((int)12345, (int)-3), (double)0.001);
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.struncate((int)12000, (int)-3), (double)0.001);
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.struncate((int)12001, (int)-3), (double)0.001);
        Assert.assertEquals((double)10000.0, (double)SqlFunctions.struncate((int)12000, (int)-4), (double)0.001);
        Assert.assertEquals((double)0.0, (double)SqlFunctions.struncate((int)12000, (int)-5), (double)0.001);
        Assert.assertEquals((double)11000.0, (double)SqlFunctions.struncate((int)11999, (int)-3), (double)0.001);
        Assert.assertEquals((double)-12000.0, (double)SqlFunctions.struncate((int)-12345, (int)-3), (double)0.001);
        Assert.assertEquals((double)-12000.0, (double)SqlFunctions.struncate((int)-12000, (int)-3), (double)0.001);
        Assert.assertEquals((double)-11000.0, (double)SqlFunctions.struncate((int)-11999, (int)-3), (double)0.001);
        Assert.assertEquals((double)-10000.0, (double)SqlFunctions.struncate((int)-12000, (int)-4), (double)0.001);
        Assert.assertEquals((double)0.0, (double)SqlFunctions.struncate((int)-12000, (int)-5), (double)0.001);
    }

    @Test
    public void testSRoundDouble() {
        Assert.assertEquals((double)12.345, (double)SqlFunctions.sround((double)12.345, (int)3), (double)0.001);
        Assert.assertEquals((double)12.35, (double)SqlFunctions.sround((double)12.345, (int)2), (double)0.001);
        Assert.assertEquals((double)12.3, (double)SqlFunctions.sround((double)12.345, (int)1), (double)0.001);
        Assert.assertEquals((double)13.0, (double)SqlFunctions.sround((double)12.999, (int)2), (double)0.001);
        Assert.assertEquals((double)13.0, (double)SqlFunctions.sround((double)12.999, (int)1), (double)0.001);
        Assert.assertEquals((double)13.0, (double)SqlFunctions.sround((double)12.999, (int)0), (double)0.001);
        Assert.assertEquals((double)-12.345, (double)SqlFunctions.sround((double)-12.345, (int)3), (double)0.001);
        Assert.assertEquals((double)-12.35, (double)SqlFunctions.sround((double)-12.345, (int)2), (double)0.001);
        Assert.assertEquals((double)-12.3, (double)SqlFunctions.sround((double)-12.345, (int)1), (double)0.001);
        Assert.assertEquals((double)-13.0, (double)SqlFunctions.sround((double)-12.999, (int)2), (double)0.001);
        Assert.assertEquals((double)-13.0, (double)SqlFunctions.sround((double)-12.999, (int)1), (double)0.001);
        Assert.assertEquals((double)-13.0, (double)SqlFunctions.sround((double)-12.999, (int)0), (double)0.001);
        Assert.assertEquals((double)12350.0, (double)SqlFunctions.sround((double)12345.0, (int)-1), (double)0.001);
        Assert.assertEquals((double)12300.0, (double)SqlFunctions.sround((double)12345.0, (int)-2), (double)0.001);
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.sround((double)12345.0, (int)-3), (double)0.001);
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.sround((double)12000.0, (int)-3), (double)0.001);
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.sround((double)12001.0, (int)-3), (double)0.001);
        Assert.assertEquals((double)10000.0, (double)SqlFunctions.sround((double)12000.0, (int)-4), (double)0.001);
        Assert.assertEquals((double)0.0, (double)SqlFunctions.sround((double)12000.0, (int)-5), (double)0.001);
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.sround((double)11999.0, (int)-3), (double)0.001);
        Assert.assertEquals((double)-12350.0, (double)SqlFunctions.sround((double)-12345.0, (int)-1), (double)0.001);
        Assert.assertEquals((double)-12300.0, (double)SqlFunctions.sround((double)-12345.0, (int)-2), (double)0.001);
        Assert.assertEquals((double)-12000.0, (double)SqlFunctions.sround((double)-12345.0, (int)-3), (double)0.001);
        Assert.assertEquals((double)-12000.0, (double)SqlFunctions.sround((double)-12000.0, (int)-3), (double)0.001);
        Assert.assertEquals((double)-12000.0, (double)SqlFunctions.sround((double)-11999.0, (int)-3), (double)0.001);
        Assert.assertEquals((double)-10000.0, (double)SqlFunctions.sround((double)-12000.0, (int)-4), (double)0.001);
        Assert.assertEquals((double)0.0, (double)SqlFunctions.sround((double)-12000.0, (int)-5), (double)0.001);
    }

    @Test
    public void testSRoundLong() {
        Assert.assertEquals((double)12350.0, (double)SqlFunctions.sround((long)12345L, (int)-1), (double)0.001);
        Assert.assertEquals((double)12300.0, (double)SqlFunctions.sround((long)12345L, (int)-2), (double)0.001);
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.sround((long)12345L, (int)-3), (double)0.001);
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.sround((long)12000L, (int)-3), (double)0.001);
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.sround((long)12001L, (int)-3), (double)0.001);
        Assert.assertEquals((double)10000.0, (double)SqlFunctions.sround((long)12000L, (int)-4), (double)0.001);
        Assert.assertEquals((double)0.0, (double)SqlFunctions.sround((long)12000L, (int)-5), (double)0.001);
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.sround((long)11999L, (int)-3), (double)0.001);
        Assert.assertEquals((double)-12350.0, (double)SqlFunctions.sround((long)-12345L, (int)-1), (double)0.001);
        Assert.assertEquals((double)-12300.0, (double)SqlFunctions.sround((long)-12345L, (int)-2), (double)0.001);
        Assert.assertEquals((double)-12000.0, (double)SqlFunctions.sround((long)-12345L, (int)-3), (double)0.001);
        Assert.assertEquals((double)-12000.0, (double)SqlFunctions.sround((long)-12000L, (int)-3), (double)0.001);
        Assert.assertEquals((double)-12000.0, (double)SqlFunctions.sround((long)-11999L, (int)-3), (double)0.001);
        Assert.assertEquals((double)-10000.0, (double)SqlFunctions.sround((long)-12000L, (int)-4), (double)0.001);
        Assert.assertEquals((double)0.0, (double)SqlFunctions.sround((long)-12000L, (int)-5), (double)0.001);
    }

    @Test
    public void testSRoundInt() {
        Assert.assertEquals((double)12350.0, (double)SqlFunctions.sround((int)12345, (int)-1), (double)0.001);
        Assert.assertEquals((double)12300.0, (double)SqlFunctions.sround((int)12345, (int)-2), (double)0.001);
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.sround((int)12345, (int)-3), (double)0.001);
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.sround((int)12000, (int)-3), (double)0.001);
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.sround((int)12001, (int)-3), (double)0.001);
        Assert.assertEquals((double)10000.0, (double)SqlFunctions.sround((int)12000, (int)-4), (double)0.001);
        Assert.assertEquals((double)0.0, (double)SqlFunctions.sround((int)12000, (int)-5), (double)0.001);
        Assert.assertEquals((double)12000.0, (double)SqlFunctions.sround((int)11999, (int)-3), (double)0.001);
        Assert.assertEquals((double)-12350.0, (double)SqlFunctions.sround((int)-12345, (int)-1), (double)0.001);
        Assert.assertEquals((double)-12300.0, (double)SqlFunctions.sround((int)-12345, (int)-2), (double)0.001);
        Assert.assertEquals((double)-12000.0, (double)SqlFunctions.sround((int)-12345, (int)-3), (double)0.001);
        Assert.assertEquals((double)-12000.0, (double)SqlFunctions.sround((int)-12000, (int)-3), (double)0.001);
        Assert.assertEquals((double)-12000.0, (double)SqlFunctions.sround((int)-11999, (int)-3), (double)0.001);
        Assert.assertEquals((double)-10000.0, (double)SqlFunctions.sround((int)-12000, (int)-4), (double)0.001);
        Assert.assertEquals((double)0.0, (double)SqlFunctions.sround((int)-12000, (int)-5), (double)0.001);
    }

    @Test
    public void testByteString() {
        ByteString x;
        byte[] bytes = new byte[]{-85, -1};
        ByteString byteString = new ByteString(bytes);
        Assert.assertEquals((long)2L, (long)byteString.length());
        Assert.assertEquals((Object)"abff", (Object)byteString.toString());
        Assert.assertEquals((Object)"abff", (Object)byteString.toString(16));
        Assert.assertEquals((Object)"1010101111111111", (Object)byteString.toString(2));
        ByteString emptyByteString = new ByteString(new byte[0]);
        Assert.assertEquals((long)0L, (long)emptyByteString.length());
        Assert.assertEquals((Object)"", (Object)emptyByteString.toString());
        Assert.assertEquals((Object)"", (Object)emptyByteString.toString(16));
        Assert.assertEquals((Object)"", (Object)emptyByteString.toString(2));
        Assert.assertEquals((Object)emptyByteString, (Object)ByteString.EMPTY);
        Assert.assertEquals((Object)"ff", (Object)byteString.substring(1, 2).toString());
        Assert.assertEquals((Object)"abff", (Object)byteString.substring(0, 2).toString());
        Assert.assertEquals((Object)"", (Object)byteString.substring(2, 2).toString());
        Assert.assertSame((Object)byteString.concat(emptyByteString), (Object)byteString);
        ByteString byteString1 = new ByteString(new byte[]{12});
        Assert.assertEquals((Object)"abff0c", (Object)byteString.concat(byteString1).toString());
        byte[] bytes3 = new byte[]{-1};
        ByteString byteString3 = new ByteString(bytes3);
        Assert.assertEquals((long)0L, (long)byteString.indexOf(emptyByteString));
        Assert.assertEquals((long)-1L, (long)byteString.indexOf(byteString1));
        Assert.assertEquals((long)1L, (long)byteString.indexOf(byteString3));
        Assert.assertEquals((long)-1L, (long)byteString3.indexOf(byteString));
        this.thereAndBack(bytes);
        this.thereAndBack(emptyByteString.getBytes());
        this.thereAndBack(new byte[]{10, 0, 29, -80});
        Assert.assertThat((Object)ByteString.of((String)"ab12", (int)16).toString(16), (Matcher)CoreMatchers.equalTo((Object)"ab12"));
        Assert.assertThat((Object)ByteString.of((String)"AB0001DdeAD3", (int)16).toString(16), (Matcher)CoreMatchers.equalTo((Object)"ab0001ddead3"));
        Assert.assertThat((Object)ByteString.of((String)"", (int)16), (Matcher)CoreMatchers.equalTo((Object)emptyByteString));
        try {
            x = ByteString.of((String)"ABg0", (int)16);
            Assert.fail((String)("expected error, got " + x));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"invalid hex character: g"));
        }
        try {
            x = ByteString.of((String)"ABC", (int)16);
            Assert.fail((String)("expected error, got " + x));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"hex string has odd length"));
        }
        byte[] bytes4 = new byte[]{10, 0, 1, -80};
        ByteString byteString4 = new ByteString(bytes4);
        byte[] bytes5 = new byte[]{10, 0, 1, 127};
        ByteString byteString5 = new ByteString(bytes5);
        ByteString byteString6 = new ByteString(bytes4);
        Assert.assertThat((Object)(byteString4.compareTo(byteString5) > 0 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)(byteString4.compareTo(byteString6) == 0 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)(byteString5.compareTo(byteString4) < 0 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }

    private void thereAndBack(byte[] bytes) {
        ByteString byteString = new ByteString(bytes);
        byte[] bytes2 = byteString.getBytes();
        Assert.assertThat((Object)bytes, (Matcher)CoreMatchers.equalTo((Object)bytes2));
        String base64String = byteString.toBase64String();
        ByteString byteString1 = ByteString.ofBase64((String)base64String);
        Assert.assertThat((Object)byteString, (Matcher)CoreMatchers.equalTo((Object)byteString1));
    }

    @Test
    public void testEqWithAny() {
        Assert.assertThat((Object)SqlFunctions.eqAny((Object)"hello", (Object)"hello"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.eqAny((Object)1, (Object)1L), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.eqAny((Object)1, (Object)1.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.eqAny((Object)1L, (Object)1.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.eqAny((Object)new BigDecimal(1L), (Object)1), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.eqAny((Object)new BigDecimal(1L), (Object)1L), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.eqAny((Object)new BigDecimal(1L), (Object)1.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.eqAny((Object)new BigDecimal(1L), (Object)new BigDecimal(1.0)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.eqAny((Object)"2", (Object)2), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testNeWithAny() {
        Assert.assertThat((Object)SqlFunctions.neAny((Object)"hello", (Object)"world"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.neAny((Object)1, (Object)2L), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.neAny((Object)1, (Object)2.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.neAny((Object)1L, (Object)2.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.neAny((Object)new BigDecimal(2L), (Object)1), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.neAny((Object)new BigDecimal(2L), (Object)1L), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.neAny((Object)new BigDecimal(2L), (Object)1.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.neAny((Object)new BigDecimal(2L), (Object)new BigDecimal(1.0)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.neAny((Object)"2", (Object)2), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testLtWithAny() {
        Assert.assertThat((Object)SqlFunctions.ltAny((Object)"apple", (Object)"banana"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.ltAny((Object)1, (Object)2L), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.ltAny((Object)1, (Object)2.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.ltAny((Object)1L, (Object)2.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.ltAny((Object)new BigDecimal(1L), (Object)2), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.ltAny((Object)new BigDecimal(1L), (Object)2L), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.ltAny((Object)new BigDecimal(1L), (Object)2.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.ltAny((Object)new BigDecimal(1L), (Object)new BigDecimal(2.0)), (Matcher)CoreMatchers.is((Object)true));
        try {
            Assert.assertThat((Object)SqlFunctions.ltAny((Object)"1", (Object)2L), (Matcher)CoreMatchers.is((Object)false));
            Assert.fail((String)"'lt' on non-numeric different type is not possible");
        }
        catch (CalciteException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Invalid types for comparison: class java.lang.String < class java.lang.Long"));
        }
    }

    @Test
    public void testLeWithAny() {
        Assert.assertThat((Object)SqlFunctions.leAny((Object)"apple", (Object)"banana"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.leAny((Object)"apple", (Object)"apple"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.leAny((Object)1, (Object)2L), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.leAny((Object)1, (Object)1L), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.leAny((Object)1, (Object)2.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.leAny((Object)1, (Object)1.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.leAny((Object)1L, (Object)2.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.leAny((Object)1L, (Object)1.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.leAny((Object)new BigDecimal(1L), (Object)2), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.leAny((Object)new BigDecimal(1L), (Object)1), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.leAny((Object)new BigDecimal(1L), (Object)2L), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.leAny((Object)new BigDecimal(1L), (Object)1L), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.leAny((Object)new BigDecimal(1L), (Object)2.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.leAny((Object)new BigDecimal(1L), (Object)1.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.leAny((Object)new BigDecimal(1L), (Object)new BigDecimal(2.0)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.leAny((Object)new BigDecimal(1L), (Object)new BigDecimal(1.0)), (Matcher)CoreMatchers.is((Object)true));
        try {
            Assert.assertThat((Object)SqlFunctions.leAny((Object)"2", (Object)2L), (Matcher)CoreMatchers.is((Object)false));
            Assert.fail((String)"'le' on non-numeric different type is not possible");
        }
        catch (CalciteException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Invalid types for comparison: class java.lang.String <= class java.lang.Long"));
        }
    }

    @Test
    public void testGtWithAny() {
        Assert.assertThat((Object)SqlFunctions.gtAny((Object)"banana", (Object)"apple"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.gtAny((Object)2, (Object)1L), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.gtAny((Object)2, (Object)1.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.gtAny((Object)2L, (Object)1.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.gtAny((Object)new BigDecimal(2L), (Object)1), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.gtAny((Object)new BigDecimal(2L), (Object)1L), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.gtAny((Object)new BigDecimal(2L), (Object)1.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.gtAny((Object)new BigDecimal(2L), (Object)new BigDecimal(1.0)), (Matcher)CoreMatchers.is((Object)true));
        try {
            Assert.assertThat((Object)SqlFunctions.gtAny((Object)"2", (Object)1L), (Matcher)CoreMatchers.is((Object)false));
            Assert.fail((String)"'gt' on non-numeric different type is not possible");
        }
        catch (CalciteException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Invalid types for comparison: class java.lang.String > class java.lang.Long"));
        }
    }

    @Test
    public void testGeWithAny() {
        Assert.assertThat((Object)SqlFunctions.geAny((Object)"banana", (Object)"apple"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.geAny((Object)"apple", (Object)"apple"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.geAny((Object)2, (Object)1L), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.geAny((Object)1, (Object)1L), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.geAny((Object)2, (Object)1.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.geAny((Object)1, (Object)1.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.geAny((Object)2L, (Object)1.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.geAny((Object)1L, (Object)1.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.geAny((Object)new BigDecimal(2L), (Object)1), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.geAny((Object)new BigDecimal(1L), (Object)1), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.geAny((Object)new BigDecimal(2L), (Object)1L), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.geAny((Object)new BigDecimal(1L), (Object)1L), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.geAny((Object)new BigDecimal(2L), (Object)1.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.geAny((Object)new BigDecimal(1L), (Object)1.0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.geAny((Object)new BigDecimal(2L), (Object)new BigDecimal(1.0)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlFunctions.geAny((Object)new BigDecimal(1L), (Object)new BigDecimal(1.0)), (Matcher)CoreMatchers.is((Object)true));
        try {
            Assert.assertThat((Object)SqlFunctions.geAny((Object)"2", (Object)2L), (Matcher)CoreMatchers.is((Object)false));
            Assert.fail((String)"'ge' on non-numeric different type is not possible");
        }
        catch (CalciteException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Invalid types for comparison: class java.lang.String >= class java.lang.Long"));
        }
    }

    @Test
    public void testPlusAny() {
        Assert.assertNull((Object)SqlFunctions.plusAny(null, null));
        Assert.assertNull((Object)SqlFunctions.plusAny(null, (Object)1));
        Assert.assertNull((Object)SqlFunctions.plusAny((Object)1, null));
        Assert.assertThat((Object)SqlFunctions.plusAny((Object)2, (Object)1L), (Matcher)CoreMatchers.is((Object)new BigDecimal(3)));
        Assert.assertThat((Object)SqlFunctions.plusAny((Object)2, (Object)1.0), (Matcher)CoreMatchers.is((Object)new BigDecimal(3)));
        Assert.assertThat((Object)SqlFunctions.plusAny((Object)2L, (Object)1.0), (Matcher)CoreMatchers.is((Object)new BigDecimal(3)));
        Assert.assertThat((Object)SqlFunctions.plusAny((Object)new BigDecimal(2L), (Object)1), (Matcher)CoreMatchers.is((Object)new BigDecimal(3)));
        Assert.assertThat((Object)SqlFunctions.plusAny((Object)new BigDecimal(2L), (Object)1L), (Matcher)CoreMatchers.is((Object)new BigDecimal(3)));
        Assert.assertThat((Object)SqlFunctions.plusAny((Object)new BigDecimal(2L), (Object)1.0), (Matcher)CoreMatchers.is((Object)new BigDecimal(3)));
        Assert.assertThat((Object)SqlFunctions.plusAny((Object)new BigDecimal(2L), (Object)new BigDecimal(1.0)), (Matcher)CoreMatchers.is((Object)new BigDecimal(3)));
        try {
            SqlFunctions.plusAny((Object)"2", (Object)2L);
            Assert.fail((String)"'plus' on non-numeric type is not possible");
        }
        catch (CalciteException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Invalid types for arithmetic: class java.lang.String + class java.lang.Long"));
        }
    }

    @Test
    public void testMinusAny() {
        Assert.assertNull((Object)SqlFunctions.minusAny(null, null));
        Assert.assertNull((Object)SqlFunctions.minusAny(null, (Object)1));
        Assert.assertNull((Object)SqlFunctions.minusAny((Object)1, null));
        Assert.assertThat((Object)SqlFunctions.minusAny((Object)2, (Object)1L), (Matcher)CoreMatchers.is((Object)new BigDecimal(1)));
        Assert.assertThat((Object)SqlFunctions.minusAny((Object)2, (Object)1.0), (Matcher)CoreMatchers.is((Object)new BigDecimal(1)));
        Assert.assertThat((Object)SqlFunctions.minusAny((Object)2L, (Object)1.0), (Matcher)CoreMatchers.is((Object)new BigDecimal(1)));
        Assert.assertThat((Object)SqlFunctions.minusAny((Object)new BigDecimal(2L), (Object)1), (Matcher)CoreMatchers.is((Object)new BigDecimal(1)));
        Assert.assertThat((Object)SqlFunctions.minusAny((Object)new BigDecimal(2L), (Object)1L), (Matcher)CoreMatchers.is((Object)new BigDecimal(1)));
        Assert.assertThat((Object)SqlFunctions.minusAny((Object)new BigDecimal(2L), (Object)1.0), (Matcher)CoreMatchers.is((Object)new BigDecimal(1)));
        Assert.assertThat((Object)SqlFunctions.minusAny((Object)new BigDecimal(2L), (Object)new BigDecimal(1.0)), (Matcher)CoreMatchers.is((Object)new BigDecimal(1)));
        try {
            SqlFunctions.minusAny((Object)"2", (Object)2L);
            Assert.fail((String)"'minus' on non-numeric type is not possible");
        }
        catch (CalciteException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Invalid types for arithmetic: class java.lang.String - class java.lang.Long"));
        }
    }

    @Test
    public void testMultiplyAny() {
        Assert.assertNull((Object)SqlFunctions.multiplyAny(null, null));
        Assert.assertNull((Object)SqlFunctions.multiplyAny(null, (Object)1));
        Assert.assertNull((Object)SqlFunctions.multiplyAny((Object)1, null));
        Assert.assertThat((Object)SqlFunctions.multiplyAny((Object)2, (Object)1L), (Matcher)CoreMatchers.is((Object)new BigDecimal(2)));
        Assert.assertThat((Object)SqlFunctions.multiplyAny((Object)2, (Object)1.0), (Matcher)CoreMatchers.is((Object)new BigDecimal(2)));
        Assert.assertThat((Object)SqlFunctions.multiplyAny((Object)2L, (Object)1.0), (Matcher)CoreMatchers.is((Object)new BigDecimal(2)));
        Assert.assertThat((Object)SqlFunctions.multiplyAny((Object)new BigDecimal(2L), (Object)1), (Matcher)CoreMatchers.is((Object)new BigDecimal(2)));
        Assert.assertThat((Object)SqlFunctions.multiplyAny((Object)new BigDecimal(2L), (Object)1L), (Matcher)CoreMatchers.is((Object)new BigDecimal(2)));
        Assert.assertThat((Object)SqlFunctions.multiplyAny((Object)new BigDecimal(2L), (Object)1.0), (Matcher)CoreMatchers.is((Object)new BigDecimal(2)));
        Assert.assertThat((Object)SqlFunctions.multiplyAny((Object)new BigDecimal(2L), (Object)new BigDecimal(1.0)), (Matcher)CoreMatchers.is((Object)new BigDecimal(2)));
        try {
            SqlFunctions.multiplyAny((Object)"2", (Object)2L);
            Assert.fail((String)"'multiply' on non-numeric type is not possible");
        }
        catch (CalciteException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Invalid types for arithmetic: class java.lang.String * class java.lang.Long"));
        }
    }

    @Test
    public void testDivideAny() {
        Assert.assertNull((Object)SqlFunctions.divideAny(null, null));
        Assert.assertNull((Object)SqlFunctions.divideAny(null, (Object)1));
        Assert.assertNull((Object)SqlFunctions.divideAny((Object)1, null));
        Assert.assertThat((Object)SqlFunctions.divideAny((Object)5, (Object)2L), (Matcher)CoreMatchers.is((Object)new BigDecimal("2.5")));
        Assert.assertThat((Object)SqlFunctions.divideAny((Object)5, (Object)2.0), (Matcher)CoreMatchers.is((Object)new BigDecimal("2.5")));
        Assert.assertThat((Object)SqlFunctions.divideAny((Object)5L, (Object)2.0), (Matcher)CoreMatchers.is((Object)new BigDecimal("2.5")));
        Assert.assertThat((Object)SqlFunctions.divideAny((Object)new BigDecimal(5L), (Object)2), (Matcher)CoreMatchers.is((Object)new BigDecimal(2.5)));
        Assert.assertThat((Object)SqlFunctions.divideAny((Object)new BigDecimal(5L), (Object)2L), (Matcher)CoreMatchers.is((Object)new BigDecimal(2.5)));
        Assert.assertThat((Object)SqlFunctions.divideAny((Object)new BigDecimal(5L), (Object)2.0), (Matcher)CoreMatchers.is((Object)new BigDecimal(2.5)));
        Assert.assertThat((Object)SqlFunctions.divideAny((Object)new BigDecimal(5L), (Object)new BigDecimal(2.0)), (Matcher)CoreMatchers.is((Object)new BigDecimal(2.5)));
        try {
            SqlFunctions.divideAny((Object)"5", (Object)2L);
            Assert.fail((String)"'divide' on non-numeric type is not possible");
        }
        catch (CalciteException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Invalid types for arithmetic: class java.lang.String / class java.lang.Long"));
        }
    }

    @Test
    public void testMultiset() {
        List<String> abacee = Arrays.asList("a", "b", "a", "c", "e", "e");
        List<String> adaa = Arrays.asList("a", "d", "a", "a");
        List<String> addc = Arrays.asList("a", "d", "c", "d", "c");
        List z = Collections.emptyList();
        Assert.assertThat((Object)SqlFunctions.multisetExceptAll(abacee, addc), (Matcher)CoreMatchers.is(Arrays.asList("b", "a", "e", "e")));
        Assert.assertThat((Object)SqlFunctions.multisetExceptAll(abacee, z), (Matcher)CoreMatchers.is(abacee));
        Assert.assertThat((Object)SqlFunctions.multisetExceptAll(z, z), (Matcher)CoreMatchers.is(z));
        Assert.assertThat((Object)SqlFunctions.multisetExceptAll(z, addc), (Matcher)CoreMatchers.is(z));
        Assert.assertThat((Object)SqlFunctions.multisetExceptDistinct(abacee, addc), (Matcher)CoreMatchers.is(Arrays.asList("b", "e")));
        Assert.assertThat((Object)SqlFunctions.multisetExceptDistinct(abacee, z), (Matcher)CoreMatchers.is(Arrays.asList("a", "b", "c", "e")));
        Assert.assertThat((Object)SqlFunctions.multisetExceptDistinct(z, z), (Matcher)CoreMatchers.is(z));
        Assert.assertThat((Object)SqlFunctions.multisetExceptDistinct(z, addc), (Matcher)CoreMatchers.is(z));
        Assert.assertThat((Object)SqlFunctions.multisetIntersectAll(abacee, addc), (Matcher)CoreMatchers.is(Arrays.asList("a", "c")));
        Assert.assertThat((Object)SqlFunctions.multisetIntersectAll(abacee, adaa), (Matcher)CoreMatchers.is(Arrays.asList("a", "a")));
        Assert.assertThat((Object)SqlFunctions.multisetIntersectAll(adaa, abacee), (Matcher)CoreMatchers.is(Arrays.asList("a", "a")));
        Assert.assertThat((Object)SqlFunctions.multisetIntersectAll(abacee, z), (Matcher)CoreMatchers.is(z));
        Assert.assertThat((Object)SqlFunctions.multisetIntersectAll(z, z), (Matcher)CoreMatchers.is(z));
        Assert.assertThat((Object)SqlFunctions.multisetIntersectAll(z, addc), (Matcher)CoreMatchers.is(z));
        Assert.assertThat((Object)SqlFunctions.multisetIntersectDistinct(abacee, addc), (Matcher)CoreMatchers.is(Arrays.asList("a", "c")));
        Assert.assertThat((Object)SqlFunctions.multisetIntersectDistinct(abacee, adaa), (Matcher)CoreMatchers.is(Collections.singletonList("a")));
        Assert.assertThat((Object)SqlFunctions.multisetIntersectDistinct(adaa, abacee), (Matcher)CoreMatchers.is(Collections.singletonList("a")));
        Assert.assertThat((Object)SqlFunctions.multisetIntersectDistinct(abacee, z), (Matcher)CoreMatchers.is(z));
        Assert.assertThat((Object)SqlFunctions.multisetIntersectDistinct(z, z), (Matcher)CoreMatchers.is(z));
        Assert.assertThat((Object)SqlFunctions.multisetIntersectDistinct(z, addc), (Matcher)CoreMatchers.is(z));
        Assert.assertThat((Object)SqlFunctions.multisetUnionAll(abacee, addc), (Matcher)CoreMatchers.is(Arrays.asList("a", "b", "a", "c", "e", "e", "a", "d", "c", "d", "c")));
        Assert.assertThat((Object)SqlFunctions.multisetUnionAll(abacee, z), (Matcher)CoreMatchers.is(abacee));
        Assert.assertThat((Object)SqlFunctions.multisetUnionAll(z, z), (Matcher)CoreMatchers.is(z));
        Assert.assertThat((Object)SqlFunctions.multisetUnionAll(z, addc), (Matcher)CoreMatchers.is(addc));
        Assert.assertThat((Object)SqlFunctions.multisetUnionDistinct(abacee, addc), (Matcher)CoreMatchers.is(Arrays.asList("a", "b", "c", "d", "e")));
        Assert.assertThat((Object)SqlFunctions.multisetUnionDistinct(abacee, z), (Matcher)CoreMatchers.is(Arrays.asList("a", "b", "c", "e")));
        Assert.assertThat((Object)SqlFunctions.multisetUnionDistinct(z, z), (Matcher)CoreMatchers.is(z));
        Assert.assertThat((Object)SqlFunctions.multisetUnionDistinct(z, addc), (Matcher)CoreMatchers.is(Arrays.asList("a", "c", "d")));
    }
}

