/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schemas;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.util.ImmutableBitSet;

public final class HrClusteredSchema
extends AbstractSchema {
    private final ImmutableMap<String, Table> tables = ImmutableMap.builder().put((Object)"emps", (Object)new PkClusteredTable(factory -> new RelDataTypeFactory.Builder(factory).add("empid", factory.createJavaType(Integer.TYPE)).add("deptno", factory.createJavaType(Integer.TYPE)).add("name", factory.createJavaType(String.class)).add("salary", factory.createJavaType(Integer.TYPE)).add("commission", factory.createJavaType(Integer.class)).build(), ImmutableBitSet.of((int[])new int[]{0}), Arrays.asList({100, 10, "Bill", 10000, 1000}, {110, 10, "Theodore", 11500, 250}, {150, 10, "Sebastian", 7000, null}, {200, 20, "Eric", 8000, 500}))).put((Object)"depts", (Object)new PkClusteredTable(factory -> new RelDataTypeFactory.Builder(factory).add("deptno", factory.createJavaType(Integer.TYPE)).add("name", factory.createJavaType(String.class)).build(), ImmutableBitSet.of((int[])new int[]{0}), Arrays.asList({10, "Sales"}, {30, "Marketing"}, {40, "HR"}))).build();

    protected Map<String, Table> getTableMap() {
        return this.tables;
    }

    private static class PkClusteredTable
    extends AbstractTable
    implements ScannableTable {
        private final ImmutableBitSet pkColumns;
        private final List<Object[]> data;
        private final Function<RelDataTypeFactory, RelDataType> typeBuilder;

        PkClusteredTable(Function<RelDataTypeFactory, RelDataType> dataTypeBuilder, ImmutableBitSet pkColumns, List<Object[]> data) {
            this.data = data;
            this.typeBuilder = dataTypeBuilder;
            this.pkColumns = pkColumns;
        }

        public Statistic getStatistic() {
            ArrayList<RelFieldCollation> collationFields = new ArrayList<RelFieldCollation>();
            for (Integer key : this.pkColumns) {
                collationFields.add(new RelFieldCollation(key.intValue(), RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.LAST));
            }
            return Statistics.of((double)this.data.size(), (List)ImmutableList.of((Object)this.pkColumns), (List)ImmutableList.of((Object)RelCollations.of(collationFields)));
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return this.typeBuilder.apply(typeFactory);
        }

        public Enumerable<Object[]> scan(DataContext root) {
            return Linq4j.asEnumerable(this.data);
        }
    }
}

